/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.shell;

import jline.Terminal;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiRenderer;

class AnsiString {
    private final Terminal terminal;
    private final StringBuilder value = new StringBuilder();

    AnsiString(Terminal terminal) {
        this.terminal = terminal;
    }

    AnsiString append(String text, AnsiRenderer.Code ... codes) {
        if (codes.length == 0 || !this.isAnsiSupported()) {
            this.value.append(text);
            return this;
        }
        Ansi ansi = Ansi.ansi();
        for (AnsiRenderer.Code code : codes) {
            ansi = this.applyCode(ansi, code);
        }
        this.value.append(ansi.a(text).reset().toString());
        return this;
    }

    private Ansi applyCode(Ansi ansi, AnsiRenderer.Code code) {
        if (code.isColor()) {
            if (code.isBackground()) {
                return ansi.bg(code.getColor());
            }
            return ansi.fg(code.getColor());
        }
        return ansi.a(code.getAttribute());
    }

    private boolean isAnsiSupported() {
        return this.terminal.isAnsiSupported();
    }

    public String toString() {
        return this.value.toString();
    }
}

