/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiMember;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaMember;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaModifierListOwnerImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

public abstract class JavaMemberImpl<Psi extends PsiMember>
extends JavaElementImpl<Psi>
implements JavaMember,
JavaAnnotationOwnerImpl,
JavaModifierListOwnerImpl {
    protected JavaMemberImpl(@NotNull Psi psiMember) {
        super(psiMember);
    }

    @Override
    @Nullable
    public PsiAnnotationOwner getAnnotationOwnerPsi() {
        return ((PsiMember)this.getPsi()).getModifierList();
    }

    @Override
    @NotNull
    public Name getName() {
        String name = ((PsiMember)this.getPsi()).getName();
        assert (name != null && Name.isValidIdentifier(name)) : "Member must have a name: " + ((PsiMember)this.getPsi()).getText();
        return Name.identifier(name);
    }

    @Override
    @NotNull
    public JavaClass getContainingClass() {
        PsiClass psiClass = ((PsiMember)this.getPsi()).getContainingClass();
        assert (psiClass != null) : "Member must have a containing class: " + this.getPsi();
        return new JavaClassImpl(psiClass);
    }

    @Override
    public boolean isAbstract() {
        return JavaElementUtil.isAbstract(this);
    }

    @Override
    public boolean isStatic() {
        return JavaElementUtil.isStatic(this);
    }

    @Override
    public boolean isFinal() {
        return JavaElementUtil.isFinal(this);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return JavaElementUtil.getVisibility(this);
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> getAnnotations() {
        return JavaElementUtil.getAnnotations(this);
    }

    @Override
    @Nullable
    public JavaAnnotation findAnnotation(@NotNull FqName fqName2) {
        return JavaElementUtil.findAnnotation(this, fqName2);
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        PsiMember psi = (PsiMember)this.getPsi();
        return psi instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)psi).isDeprecated();
    }
}

