/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.tokenizers.WordTokenizer;

public class WordTokenizerTest {
    private final WordTokenizer wordTokenizer = new WordTokenizer();

    @Test
    public void testTokenize() {
        WordTokenizer wordTokenizer = new WordTokenizer();
        List tokens = wordTokenizer.tokenize("This is\u00a0a test");
        Assert.assertEquals((long)tokens.size(), (long)7L);
        Assert.assertEquals((Object)"[This,  , is, \u00a0, a,  , test]", (Object)tokens.toString());
        tokens = wordTokenizer.tokenize("This\rbreaks");
        Assert.assertEquals((long)3L, (long)tokens.size());
        Assert.assertEquals((Object)"[This, \r, breaks]", (Object)tokens.toString());
        tokens = wordTokenizer.tokenize("dev.all@languagetool.org");
        Assert.assertEquals((long)1L, (long)tokens.size());
        tokens = wordTokenizer.tokenize("dev.all@languagetool.org.");
        Assert.assertEquals((long)2L, (long)tokens.size());
        tokens = wordTokenizer.tokenize("dev.all@languagetool.org:");
        Assert.assertEquals((long)2L, (long)tokens.size());
        tokens = wordTokenizer.tokenize("Schreiben Sie Hr. Meier (meier@mail.com).");
        Assert.assertEquals((long)tokens.size(), (long)13L);
    }

    @Test
    public void testIsUrl() {
        Assert.assertTrue((boolean)WordTokenizer.isUrl((String)"www.languagetool.org"));
        Assert.assertTrue((boolean)WordTokenizer.isUrl((String)"http://www.languagetool.org"));
        Assert.assertTrue((boolean)WordTokenizer.isUrl((String)"https://www.languagetool.org"));
        Assert.assertFalse((boolean)WordTokenizer.isUrl((String)"languagetool.org"));
        Assert.assertFalse((boolean)WordTokenizer.isUrl((String)"something-else"));
    }

    @Test
    public void testIsEMail() {
        Assert.assertTrue((boolean)WordTokenizer.isEMail((String)"martin.mustermann@test.de"));
        Assert.assertTrue((boolean)WordTokenizer.isEMail((String)"martin.mustermann@test.languagetool.de"));
        Assert.assertTrue((boolean)WordTokenizer.isEMail((String)"martin-mustermann@test.com"));
        Assert.assertFalse((boolean)WordTokenizer.isEMail((String)"@test.de"));
        Assert.assertFalse((boolean)WordTokenizer.isEMail((String)"f.test@test"));
        Assert.assertFalse((boolean)WordTokenizer.isEMail((String)"f@t.t"));
    }

    @Test
    public void testUrlTokenize() {
        Assert.assertEquals((Object)"\"|This| |http://foo.org|.|\"", (Object)this.tokenize("\"This http://foo.org.\""));
        Assert.assertEquals((Object)"\u00ab|This| |http://foo.org|.|\u00bb", (Object)this.tokenize("\u00abThis http://foo.org.\u00bb"));
        Assert.assertEquals((Object)"This| |http://foo.org|.|.|.", (Object)this.tokenize("This http://foo.org..."));
        Assert.assertEquals((Object)"This| |http://foo.org|.", (Object)this.tokenize("This http://foo.org."));
        Assert.assertEquals((Object)"This| |http://foo.org| |blah", (Object)this.tokenize("This http://foo.org blah"));
        Assert.assertEquals((Object)"This| |http://foo.org| |and| |ftp://bla.com| |blah", (Object)this.tokenize("This http://foo.org and ftp://bla.com blah"));
        Assert.assertEquals((Object)"foo| |http://localhost:32000/?ch=1| |bar", (Object)this.tokenize("foo http://localhost:32000/?ch=1 bar"));
        Assert.assertEquals((Object)"foo| |ftp://localhost:32000/| |bar", (Object)this.tokenize("foo ftp://localhost:32000/ bar"));
        Assert.assertEquals((Object)"foo| |http://google.de/?aaa| |bar", (Object)this.tokenize("foo http://google.de/?aaa bar"));
        Assert.assertEquals((Object)"foo| |http://www.flickr.com/123@N04/hallo#test| |bar", (Object)this.tokenize("foo http://www.flickr.com/123@N04/hallo#test bar"));
        Assert.assertEquals((Object)"foo| |http://www.youtube.com/watch?v=wDN_EYUvUq0| |bar", (Object)this.tokenize("foo http://www.youtube.com/watch?v=wDN_EYUvUq0 bar"));
        Assert.assertEquals((Object)"foo| |http://example.net/index.html?s=A54C6FE2%23info| |bar", (Object)this.tokenize("foo http://example.net/index.html?s=A54C6FE2%23info bar"));
        Assert.assertEquals((Object)"foo| |https://joe:passwd@example.net:8080/index.html?action=x&session=A54C6FE2#info| |bar", (Object)this.tokenize("foo https://joe:passwd@example.net:8080/index.html?action=x&session=A54C6FE2#info bar"));
    }

    @Test
    public void testUrlTokenizeWithQuote() {
        Assert.assertEquals((Object)"This| |'|http://foo.org|'| |blah", (Object)this.tokenize("This 'http://foo.org' blah"));
        Assert.assertEquals((Object)"This| |\"|http://foo.org|\"| |blah", (Object)this.tokenize("This \"http://foo.org\" blah"));
        Assert.assertEquals((Object)"This| |(|\"|http://foo.org|\"|)| |blah", (Object)this.tokenize("This (\"http://foo.org\") blah"));
    }

    @Test
    public void testUrlTokenizeWithAppendedCharacter() {
        Assert.assertEquals((Object)"foo| |(|http://ex.net/p?a=x#i|)| |bar", (Object)this.tokenize("foo (http://ex.net/p?a=x#i) bar"));
        Assert.assertEquals((Object)"foo| |http://ex.net/p?a=x#i|,| |bar", (Object)this.tokenize("foo http://ex.net/p?a=x#i, bar"));
        Assert.assertEquals((Object)"foo| |http://ex.net/p?a=x#i|.| |bar", (Object)this.tokenize("foo http://ex.net/p?a=x#i. bar"));
        Assert.assertEquals((Object)"foo| |http://ex.net/p?a=x#i|:| |bar", (Object)this.tokenize("foo http://ex.net/p?a=x#i: bar"));
        Assert.assertEquals((Object)"foo| |http://ex.net/p?a=x#i|?| |bar", (Object)this.tokenize("foo http://ex.net/p?a=x#i? bar"));
        Assert.assertEquals((Object)"foo| |http://ex.net/p?a=x#i|!| |bar", (Object)this.tokenize("foo http://ex.net/p?a=x#i! bar"));
    }

    @Test
    public void testIncompleteUrlTokenize() {
        Assert.assertEquals((Object)"http|:|/", (Object)this.tokenize("http:/"));
        Assert.assertEquals((Object)"http://", (Object)this.tokenize("http://"));
        Assert.assertEquals((Object)"http://a", (Object)this.tokenize("http://a"));
        Assert.assertEquals((Object)"foo| |http| |bar", (Object)this.tokenize("foo http bar"));
        Assert.assertEquals((Object)"foo| |http|:| |bar", (Object)this.tokenize("foo http: bar"));
        Assert.assertEquals((Object)"foo| |http|:|/| |bar", (Object)this.tokenize("foo http:/ bar"));
        Assert.assertEquals((Object)"foo| |http://| |bar", (Object)this.tokenize("foo http:// bar"));
        Assert.assertEquals((Object)"foo| |http://a| |bar", (Object)this.tokenize("foo http://a bar"));
        Assert.assertEquals((Object)"foo| |http://|?| |bar", (Object)this.tokenize("foo http://? bar"));
    }

    private String tokenize(String text) {
        List tokens = this.wordTokenizer.tokenize(text);
        return String.join((CharSequence)"|", tokens);
    }
}

