/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.prism.BufferedImageTools;
import com.sun.prism.Image;

public class ExternalImageTools {
    static boolean isBufferedImage(Class clazz) {
        return "java.awt.image.BufferedImage".equals(clazz.getName());
    }

    public static boolean isFormatSupported(Class clazz) {
        return ExternalImageTools.isBufferedImage(clazz);
    }

    public static IExporter getExporter(Object object) {
        assert (object != null);
        boolean bl = object instanceof Class;
        Class<?> clazz = bl ? (Class<?>)object : object.getClass();
        return ExternalImageTools.isBufferedImage(clazz) ? new BufferedImageExporter() : null;
    }

    public static IImporter getImporter(Object object) {
        return ExternalImageTools.isBufferedImage(object.getClass()) ? new BufferedImageImporter() : null;
    }

    private static class BufferedImageExporter
    implements IExporter {
        private BufferedImageExporter() {
        }

        @Override
        public Object exportPrismImage(Image image, Object object) {
            return BufferedImageTools.exportBufferedImage(image, object);
        }
    }

    private static class BufferedImageImporter
    implements IImporter {
        private BufferedImageImporter() {
        }

        @Override
        public Image loadExternalImage(Object object) {
            return BufferedImageTools.importBufferedImage(object);
        }
    }

    public static interface IExporter {
        public Object exportPrismImage(Image var1, Object var2);
    }

    public static interface IImporter {
        public Image loadExternalImage(Object var1);
    }
}

