/*
 * Decompiled with CFR 0.152.
 */
package bt747.j2se_view;

import bt747.sys.Generic;
import bt747.sys.interfaces.BT747Path;
import gps.log.out.GPSFileInterface;
import gps.log.out.GPSKMLFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.bt747.j2se.system.J2SEHashtable;

public final class GPSKMZFile
extends GPSKMLFile
implements GPSFileInterface {
    private ZipOutputStream currentZipStream;
    private J2SEHashtable zips;

    public final void initialiseFile(BT747Path bT747Path, String string, int n) {
        super.initialiseFile(bT747Path, string, n);
        this.zips = new J2SEHashtable(10);
    }

    public final void finaliseFile() {
        super.finaliseFile();
        if (this.currentZipStream != null) {
            try {
                this.zips.remove(this.currentZipStream);
            }
            catch (Exception exception) {
                Generic.debug("zip stream removal", exception);
            }
            try {
                this.currentZipStream.closeEntry();
                this.currentZipStream.close();
            }
            catch (Exception exception) {
                Generic.debug("finaliseFile", exception);
            }
            this.currentZipStream = null;
        }
    }

    protected final int createFile(int n, String object, boolean bl) {
        this.setTrackName((String)object);
        String string = this.filenameBuilder.getOutputFileName(this.basename, n, ".kmz", (String)object).getPath();
        object = this.basename + (String)object + ".kml";
        int n2 = ((String)object).lastIndexOf(47);
        if (n2 > 0) {
            object = ((String)object).substring(n2 + 1);
        }
        if ((n2 = ((String)object).lastIndexOf(92)) > 0) {
            object = ((String)object).substring(n2 + 1);
        }
        if ((n2 = ((String)object).lastIndexOf(58)) > 0) {
            object = ((String)object).substring(n2 + 1);
        }
        try {
            File file;
            if (bl && (file = new File(string)).exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            Generic.debug("File deletion", exception);
        }
        try {
            this.currentZipStream = null;
            if (bl) {
                FileOutputStream fileOutputStream = new FileOutputStream(string, false);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                this.currentZipStream = new ZipOutputStream(bufferedOutputStream);
                object = new ZipEntry((String)object);
                this.currentZipStream.putNextEntry((ZipEntry)object);
                this.zips.put(string, this.currentZipStream);
            } else if (this.zips == null) {
                Generic.debug("Zip name is null ");
            } else {
                this.currentZipStream = (ZipOutputStream)this.zips.get(string);
                if (this.currentZipStream == null) {
                    Generic.debug("Could not find " + string + " zip stream.");
                }
            }
        }
        catch (Exception exception) {
            Generic.debug("Zip Entry Creation", exception);
        }
        return 0;
    }

    protected final void writeTxt(String string) {
        try {
            if (this.currentZipStream != null) {
                this.currentZipStream.write(string.getBytes(), 0, string.length());
                return;
            }
            Generic.debug("Write to closed file", null);
            return;
        }
        catch (Exception exception) {
            Generic.debug("writeTxt", exception);
            return;
        }
    }

    protected final boolean isOpen() {
        return this.currentZipStream != null;
    }
}

