/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ModifierFormat;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Specification;

public class ResourcesDetailPanel
extends ColopediaGameObjectTypePanel<ResourceType> {
    public ResourcesDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.RESOURCES.getKey());
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        super.addSubTrees(root, this.getSpecification().getResourceTypeList());
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        ResourceType type = this.getSpecification().getResourceType(id);
        panel.setLayout(new MigLayout("wrap 2", "[]20[]"));
        JLabel name = Utility.localizedHeaderLabel(type, FontLibrary.FontSize.SMALL);
        panel.add((Component)name, "span, align center, wrap 40");
        panel.add(Utility.localizedLabel("colopedia.resource.bonusProduction"));
        JPanel goodsPanel = new JPanel();
        goodsPanel.setOpaque(false);
        for (Modifier modifier : type.getModifiers()) {
            String text = ModifierFormat.getModifierAsString(modifier);
            if (modifier.hasScope()) {
                Specification spec = this.getSpecification();
                String scopeStrings = modifier.getScopes().stream().filter(s -> s.getType() != null).map(s -> Messages.getName(spec.findType(s.getType()))).collect(Collectors.joining(", "));
                if (!scopeStrings.isEmpty()) {
                    text = text + " (" + scopeStrings + ")";
                }
            }
            GoodsType goodsType = this.getSpecification().getGoodsType(modifier.getId());
            JButton goodsButton = this.getGoodsButton(goodsType, text);
            goodsPanel.add(goodsButton);
        }
        panel.add(goodsPanel);
        panel.add((Component)Utility.localizedLabel("colopedia.resource.description"), "newline 20");
        panel.add((Component)Utility.localizedTextArea(Messages.descriptionKey(type), 30), "growx");
    }
}

