/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import java.lang.ref.SoftReference;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.BshMethod;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.gui.BeanShellErrorDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class BeanShellAction
extends EditAction {
    private boolean noRepeat;
    private boolean noRecord;
    private boolean noRememberLast;
    private CachedBshMethod code;
    private CachedBshMethod isSelected;

    public BeanShellAction(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        super(string);
        String string4 = string.replace('.', '_').replace('-', '_');
        this.code = new CachedBshMethod("action_" + string4, string2);
        if (string3 != null) {
            this.isSelected = new CachedBshMethod("selected_" + string4, string3);
        }
        this.noRepeat = bl;
        this.noRecord = bl2;
        this.noRememberLast = bl3;
        jEdit.setTemporaryProperty(string + ".toggle", string3 != null ? "true" : "false");
    }

    @Override
    public void invoke(View view) {
        try {
            BeanShell.runCachedBlock(this.code.get(), view, new NameSpace(BeanShell.getNameSpace(), "BeanShellAction.invoke()"));
        }
        catch (Throwable throwable) {
            Log.log(9, this, throwable);
            new BeanShellErrorDialog(view, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSelected(Component component) {
        if (this.isSelected == null) {
            return false;
        }
        NameSpace nameSpace = BeanShell.getNameSpace();
        try {
            View view = GUIUtilities.getView(component);
            if (view == null) {
                view = jEdit.getActiveView();
            }
            nameSpace.setVariable("_comp", component);
            boolean bl = Boolean.TRUE.equals(BeanShell.runCachedBlock(this.isSelected.get(), view, new NameSpace(BeanShell.getNameSpace(), "BeanShellAction.isSelected()")));
            return bl;
        }
        catch (Throwable throwable) {
            Log.log(9, this, throwable);
            this.isSelected = null;
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                nameSpace.setVariable("_comp", null);
            }
            catch (UtilEvalError utilEvalError) {
                Log.log(9, this, utilEvalError);
            }
        }
    }

    @Override
    public boolean noRepeat() {
        return this.noRepeat;
    }

    @Override
    public boolean noRecord() {
        return this.noRecord;
    }

    @Override
    public boolean noRememberLast() {
        return this.noRememberLast;
    }

    @Override
    public String getCode() {
        return this.code.getSource().trim();
    }

    private static class CachedBshMethod {
        private final String name;
        private final String source;
        private SoftReference<BshMethod> cache;

        public CachedBshMethod(String string, String string2) {
            this.name = string;
            this.source = string2;
            this.cache = null;
        }

        public BshMethod get() throws Exception {
            BshMethod bshMethod;
            if (this.cache != null && (bshMethod = this.cache.get()) != null) {
                return bshMethod;
            }
            bshMethod = BeanShell.cacheBlock(this.name, this.source, true);
            this.cache = new SoftReference<BshMethod>(bshMethod);
            return bshMethod;
        }

        public String getSource() {
            return this.source;
        }
    }
}

