/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.MutableListModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;

public class PasteFromListDialog
extends EnhancedDialog {
    private View view;
    private MutableListModel<String> listModel;
    private JList<String> clips;
    private JTextArea clipText;
    private JButton insert;
    private JButton cancel;

    public PasteFromListDialog(String string, View view, MutableListModel<String> mutableListModel) {
        super(view, jEdit.getProperty(string + ".title"), true);
        this.view = view;
        this.listModel = mutableListModel;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 2, 12));
        int n = jEdit.getIntegerProperty("paste-from-list.max-item-length", 1000);
        this.clips = new JList<String>(mutableListModel);
        this.clips.setCellRenderer(new Renderer(n));
        this.clips.setVisibleRowCount(12);
        this.clips.addMouseListener(new MouseHandler());
        this.clips.addListSelectionListener(new ListHandler());
        this.insert = new JButton(jEdit.getProperty("common.insert"));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        JLabel jLabel = new JLabel(jEdit.getProperty(string + ".caption"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        jPanel.add("North", jLabel);
        JScrollPane jScrollPane = new JScrollPane(this.clips);
        jScrollPane.setPreferredSize(new Dimension(500, 150));
        jPanel2.add(jScrollPane);
        this.clipText = new JTextArea();
        this.clipText.setEditable(false);
        jScrollPane = new JScrollPane(this.clipText);
        jScrollPane.setPreferredSize(new Dimension(500, 150));
        jPanel2.add(jScrollPane);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(new EmptyBorder(17, 0, 0, 0));
        jPanel3.add(Box.createGlue());
        jPanel3.add(this.insert);
        jPanel3.add(Box.createHorizontalStrut(6));
        jPanel3.add(this.cancel);
        GenericGUIUtilities.makeSameSize(this.insert, this.cancel);
        jPanel.add((Component)jPanel3, "South");
        if (mutableListModel.getSize() >= 1) {
            this.clips.setSelectedIndex(0);
        }
        this.updateButtons();
        this.getRootPane().setDefaultButton(this.insert);
        this.insert.addActionListener(new ActionHandler());
        this.cancel.addActionListener(new ActionHandler());
        GenericGUIUtilities.requestFocus(this, this.clips);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        List<String> list = this.clips.getSelectedValuesList();
        if (list == null || list.isEmpty()) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        String string = this.getSelectedClipText();
        for (String string2 : list) {
            this.listModel.removeElement(string2);
            this.listModel.insertElementAt(string2, 0);
        }
        this.view.getTextArea().setSelectedText(string);
        this.cleanup();
    }

    @Override
    public void cancel() {
        this.cleanup();
    }

    private void cleanup() {
        String[] stringArray = new String[]{};
        this.clips.setListData((String[])stringArray);
        this.dispose();
    }

    private String getSelectedClipText() {
        List<String> list = this.clips.getSelectedValuesList();
        if (list == null || list.isEmpty()) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0).toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append((Object)list.get(i));
        }
        return stringBuilder.toString();
    }

    private void updateButtons() {
        int n = this.clips.getSelectedIndex();
        this.insert.setEnabled(n != -1);
    }

    private void showClipText() {
        List<String> list = this.clips.getSelectedValuesList();
        if (list == null || list.isEmpty()) {
            this.clipText.setText("");
        } else {
            String string = this.getSelectedClipText();
            int n = jEdit.getIntegerProperty("paste-from-list.max-preview-length", 100000);
            if (string.length() > n) {
                StringBuilder stringBuilder = new StringBuilder(string.substring(0, n));
                stringBuilder.append('<').append(string.length() - n).append(" more bytes>");
                this.clipText.setText(stringBuilder.toString());
            } else {
                this.clipText.setText(string);
            }
        }
        this.clipText.setCaretPosition(0);
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                PasteFromListDialog.this.ok();
            }
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            PasteFromListDialog.this.showClipText();
            PasteFromListDialog.this.updateButtons();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == PasteFromListDialog.this.insert) {
                PasteFromListDialog.this.ok();
            } else if (object == PasteFromListDialog.this.cancel) {
                PasteFromListDialog.this.cancel();
            }
        }
    }

    static class Renderer
    extends DefaultListCellRenderer {
        private int maxItemLength;

        public Renderer(int n) {
            this.maxItemLength = n;
        }

        String shorten(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            if (string.toLowerCase().startsWith("<html>")) {
                stringBuilder.append(' ');
            }
            boolean bl = true;
            for (int i = 0; i < string.length(); ++i) {
                if (stringBuilder.length() == this.maxItemLength) {
                    stringBuilder.append("...");
                    break;
                }
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (bl) continue;
                    stringBuilder.append(' ');
                    bl = true;
                    continue;
                }
                bl = false;
                stringBuilder.append(c);
            }
            if (stringBuilder.length() == 0) {
                return jEdit.getProperty("paste-from-list.whitespace");
            }
            return stringBuilder.toString();
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.setText(this.shorten(object.toString()));
            return this;
        }
    }
}

