/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Map;
import java.util.Random;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.quantum.MOCalculation;
import org.jmol.quantum.NciCalculation;
import org.jmol.quantum.QS;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.quantum.QuantumPlaneCalculation;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class IsoMOReader
extends AtomDataReader {
    private Random random;
    private P3[] points;
    private V3 vTemp;
    private QuantumCalculation q;
    private Lst<Map<String, Object>> mos;
    private boolean isNci;
    private float[] coef;
    private int[][] dfCoefMaps;
    private float[] linearCombination;
    private float[][] coefs;
    private boolean isElectronDensityCalc;
    private Map<String, Object> mo;
    private final float[] vDist = new float[3];
    private boolean qSetupDone;

    IsoMOReader() {
    }

    @Override
    void init(SurfaceGenerator surfaceGenerator) {
        this.initADR(surfaceGenerator);
        boolean bl = this.isNci = this.params.qmOrbitalType == 3;
        if (this.isNci) {
            this.hasColorData = true;
            this.isXLowToHigh = true;
            this.precalculateVoxelData = false;
            this.params.insideOut = !this.params.insideOut;
        }
    }

    @Override
    protected void setup(boolean bl) {
        String string;
        this.mos = (Lst)this.params.moData.get("mos");
        this.linearCombination = this.params.qm_moLinearCombination;
        this.mo = this.mos != null && this.linearCombination == null ? (Map)this.mos.get(this.params.qm_moNumber - 1) : null;
        boolean bl2 = this.params.moData.containsKey("haveVolumeData");
        if (bl2 && this.mo != null) {
            this.params.volumeData = (VolumeData)this.mo.get("volumeData");
        }
        this.setup2();
        this.doAddHydrogens = false;
        this.getAtoms(this.params.bsSelected, this.doAddHydrogens, !this.isNci, this.isNci, this.isNci, false, false, this.params.qm_marginAngstroms, this.isNci ? null : this.params.modelInvRotation);
        if (this.isNci) {
            string = "quantum.NciCalculation";
            this.setHeader("NCI (promolecular)", "see NCIPLOT: A Program for Plotting Noncovalent Interaction Regions, Julia Contreras-Garcia, et al., J. of Chemical Theory and Computation, 2011, 7, 625-632");
        } else {
            string = "quantum.MOCalculation";
            this.setHeader("MO", "calculation type: " + this.params.moData.get("calculationType"));
        }
        this.setRanges(this.params.qm_ptsPerAngstrom, this.params.qm_gridMax, 0.0f);
        if (bl2) {
            int n = this.params.title.length;
            while (--n >= 0) {
                this.fixTitleLine(n, this.mo);
            }
        } else {
            this.q = (QuantumCalculation)Interface.getOption(string, (Viewer)this.sg.atomDataServer, "file");
            if (this.isNci) {
                this.qpc = (QuantumPlaneCalculation)this.q;
            } else if (this.linearCombination == null) {
                int n = this.params.title.length;
                while (--n >= 0) {
                    this.fixTitleLine(n, this.mo);
                }
                this.coef = (float[])this.mo.get("coefficients");
                this.dfCoefMaps = (int[][])this.mo.get("dfCoefMaps");
            } else {
                this.coefs = AU.newFloat2(this.mos.size());
                int n = 1;
                while (n < this.linearCombination.length) {
                    int n2 = (int)this.linearCombination[n];
                    if (n2 > this.mos.size() || n2 < 1) {
                        return;
                    }
                    this.coefs[n2 - 1] = (float[])((Map)this.mos.get(n2 - 1)).get("coefficients");
                    n += 2;
                }
                n = this.params.title.length;
                while (--n >= 0) {
                    this.fixTitleLine(n, null);
                }
            }
            this.isElectronDensityCalc = this.coef == null && this.linearCombination == null && !this.isNci;
        }
        this.volumeData.sr = null;
        if (bl && !this.isElectronDensityCalc && !bl2) {
            this.volumeData.doIterate = false;
            this.voxelData = new float[1][1][1];
            this.volumeData.setVoxelDataAsArray(this.voxelData);
            this.volumeData.sr = this;
            this.points = new P3[1];
            this.points[0] = new P3();
            if (!this.setupCalculation()) {
                this.q = null;
            }
        } else if (this.params.psi_monteCarloCount > 0) {
            this.vertexDataOnly = true;
            this.random = new Random(this.params.randomSeed);
        }
    }

    @Override
    protected boolean readVolumeParameters(boolean bl) {
        this.setup(bl);
        if (this.volumeData.sr == null) {
            this.initializeVolumetricData();
        }
        return true;
    }

    private void fixTitleLine(int n, Map<String, Object> map) {
        String string;
        if (this.params.title == null) {
            return;
        }
        String string2 = this.params.title[n];
        if (string2.indexOf(" MO ") >= 0 && (string = (String)this.params.moData.get("nboType")) != null) {
            string2 = PT.rep(string2, " MO ", " " + string + " ");
        }
        if (string2.indexOf("%M") >= 0) {
            string2 = this.params.title[n] = PT.formatStringS(string2, "M", this.atomData.modelName);
        }
        if (string2.indexOf("%F") >= 0) {
            string2 = this.params.title[n] = PT.formatStringS(string2, "F", PT.rep(this.params.fileName, "DROP_", ""));
        }
        int n2 = string2.indexOf("%");
        if (string2.length() == 0 || n2 < 0) {
            return;
        }
        int n3 = 0;
        if (string2.indexOf("%I") >= 0) {
            string2 = PT.formatStringS(string2, "I", this.params.qm_moLinearCombination == null ? "" + this.params.qm_moNumber : QS.getMOString(this.params.qm_moLinearCombination));
        }
        if (string2.indexOf("%N") >= 0) {
            string2 = PT.formatStringS(string2, "N", "" + this.params.qmOrbitalCount);
        }
        Float f = null;
        if (map == null) {
            int n4 = 0;
            while (n4 < this.linearCombination.length) {
                if (this.linearCombination[n4] != 0.0f) {
                    map = (Map)this.mos.get((int)this.linearCombination[n4 + 1] - 1);
                    Float f2 = (Float)map.get("energy");
                    if (f == null) {
                        if (f2 == null) break;
                        f = f2;
                    } else if (!f.equals(f2)) {
                        f = null;
                        break;
                    }
                }
                n4 += 2;
            }
        } else if (map.containsKey("energy")) {
            f = (Float)map.get("energy");
        }
        if (string2.indexOf("%E") >= 0) {
            string2 = PT.formatStringS(string2, "E", f != null && ++n3 != 0 ? "" + f : "");
        }
        if (string2.indexOf("%U") >= 0) {
            string2 = PT.formatStringS(string2, "U", f != null && this.params.moData.containsKey("energyUnits") && ++n3 != 0 ? (String)this.params.moData.get("energyUnits") : "");
        }
        if (string2.indexOf("%S") >= 0) {
            string2 = PT.formatStringS(string2, "S", map != null && map.containsKey("symmetry") && ++n3 != 0 ? "" + map.get("symmetry") : "");
        }
        if (string2.indexOf("%O") >= 0) {
            float f3;
            Float f4 = map == null ? null : (Float)map.get("occupancy");
            float f5 = f3 = f4 == null ? 0.0f : f4.floatValue();
            string2 = PT.formatStringS(string2, "O", f4 != null && ++n3 != 0 ? (f3 == (float)((int)f3) ? "" + (int)f3 : PT.formatF(f3, 0, 4, false, false)) : "");
        }
        if (string2.indexOf("%T") >= 0) {
            string2 = PT.formatStringS(string2, "T", map != null && map.containsKey("type") && ++n3 != 0 ? "" + map.get("type") : "");
        }
        if (string2.equals("string")) {
            this.params.title[n] = "";
            return;
        }
        boolean bl = string2.indexOf("?") == 0;
        this.params.title[n] = !bl ? string2 : (n3 > 0 && !string2.trim().endsWith("=") ? string2.substring(1) : "");
    }

    @Override
    protected void readSurfaceData(boolean bl) throws Exception {
        if (this.volumeData.sr != null) {
            return;
        }
        if (this.params.psi_monteCarloCount <= 0) {
            this.readSurfaceDataVDR(bl);
            return;
        }
        if (this.points != null) {
            return;
        }
        this.points = new P3[1000];
        int n = 0;
        while (n < 1000) {
            this.points[n] = new P3();
            ++n;
        }
        if (this.params.thePlane != null) {
            this.vTemp = new V3();
        }
        n = 0;
        while (n < 3) {
            this.vDist[n] = this.volumeData.volumetricVectorLengths[n] * (float)this.volumeData.voxelCounts[n];
            ++n;
        }
        this.voxelData = new float[1000][1][1];
        this.volumeData.setVoxelDataAsArray(this.voxelData);
        this.getValues();
        float f = 0.0f;
        int n2 = 0;
        while (n2 < 1000) {
            float f2;
            float f3 = Math.abs(this.voxelData[n2][0][0]);
            if (f2 > f) {
                f = f3;
            }
            ++n2;
        }
        if (f < 1.0E-4f) {
            return;
        }
        n2 = 0;
        block3: while (n2 < this.params.psi_monteCarloCount) {
            this.getValues();
            int n3 = 0;
            while (n3 < 1000) {
                float f4 = this.voxelData[n3][0][0];
                float f5 = Math.abs(f4);
                if (!(f5 <= this.getRnd(f))) {
                    this.addVC(this.points[n3], f4, 0, false);
                    if (++n2 == this.params.psi_monteCarloCount) continue block3;
                }
                ++n3;
            }
        }
    }

    @Override
    protected void postProcessVertices() {
    }

    private void getValues() {
        int n = 0;
        while (n < 1000) {
            this.voxelData[n][0][0] = 0.0f;
            this.points[n].set(this.volumeData.volumetricOrigin.x + this.getRnd(this.vDist[0]), this.volumeData.volumetricOrigin.y + this.getRnd(this.vDist[1]), this.volumeData.volumetricOrigin.z + this.getRnd(this.vDist[2]));
            if (this.params.thePlane != null) {
                Measure.getPlaneProjection(this.points[n], this.params.thePlane, this.points[n], this.vTemp);
            }
            ++n;
        }
        this.createOrbital();
    }

    @Override
    public float getValueAtPoint(T3 t3, boolean bl) {
        return this.q == null ? 0.0f : this.q.processPt(t3);
    }

    private float getRnd(float f) {
        return this.random.nextFloat() * f;
    }

    @Override
    protected void generateCube() {
        if (this.params.volumeData != null) {
            return;
        }
        this.newVoxelDataCube();
        this.createOrbital();
    }

    protected void createOrbital() {
        boolean bl;
        boolean bl2 = bl = this.params.psi_monteCarloCount > 0;
        if (this.isElectronDensityCalc) {
            if (this.mos == null || bl) {
                return;
            }
            System.out.println("createOrbital " + this.params.qm_moNumber);
            int n = this.params.qm_moNumber;
            while (--n >= 0) {
                Logger.info(" generating isosurface data for MO " + (n + 1));
                Map map = (Map)this.mos.get(n);
                this.coef = (float[])map.get("coefficients");
                this.dfCoefMaps = (int[][])map.get("dfCoefMaps");
                if (!this.setupCalculation()) {
                    return;
                }
                this.q.createCube();
            }
        } else {
            if (!bl) {
                Logger.info("generating isosurface data for MO using cutoff " + this.params.cutoff);
            }
            if (!this.setupCalculation()) {
                return;
            }
            this.q.createCube();
            this.jvxlData.integration = this.q.getIntegration();
            if (this.mo != null) {
                this.mo.put("integration", Float.valueOf(this.jvxlData.integration));
            }
        }
    }

    @Override
    public float[] getPlane(int n) {
        if (!this.qSetupDone) {
            this.setupCalculation();
        }
        return this.getPlaneSR(n);
    }

    private boolean setupCalculation() {
        this.qSetupDone = true;
        switch (this.params.qmOrbitalType) {
            case 5: {
                break;
            }
            case 1: 
            case 2: {
                return ((MOCalculation)this.q).setupCalculation(this.params.moData, this.params.qmOrbitalType == 2, this.volumeData, this.bsMySelected, this.atomData.xyz, this.atomData.atoms, this.atomData.firstAtomIndex, this.dfCoefMaps, this.coef, this.linearCombination, this.params.isSquaredLinear, this.coefs, this.points);
            }
            case 3: {
                return ((NciCalculation)this.q).setupCalculation(this.volumeData, this.bsMySelected, this.params.bsSolvent, this.atomData.bsMolecules, this.atomData.atoms, this.atomData.firstAtomIndex, true, this.points, this.params.parameters, this.params.testFlags);
            }
        }
        return false;
    }

    @Override
    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, T3 t3, V3 v3, int n, int n2, int n3, int n4, int n5, float[] fArray, T3 t32) {
        float f4 = this.getSPF(f, bl, f2, f3, t3, v3, n, n2, n3, n4, n5, fArray, t32);
        if (this.q != null && !Float.isNaN(f4)) {
            f4 = this.q.processPt(t32);
            if (this.params.isSquared) {
                f4 *= f4;
            }
        }
        return f4;
    }
}

