/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import junit.framework.TestCase;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMatcher;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.SmilesStereo;

public class TestSmilesParser
extends TestCase {
    public TestSmilesParser(String string) {
        super(string);
    }

    public void testChapter1_01() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setCharge(1);
        smilesAtom.setSymbol("H");
        TestSmilesParser.checkMolecule("[H+]", smilesSearch);
    }

    public void testChapter1_02() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        TestSmilesParser.checkMolecule("C", smilesSearch);
    }

    public void testChapter1_03() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("O");
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        TestSmilesParser.checkMolecule("O", smilesSearch);
    }

    public void testChapter1_04() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setCharge(1);
        smilesAtom.setSymbol("O");
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        TestSmilesParser.checkMolecule("[OH3+]", smilesSearch);
    }

    public void testChapter1_05() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setAtomicMass(2);
        smilesAtom.setSymbol("H");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("O");
        this.createBond(smilesAtom, smilesAtom2, 1, false);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setAtomicMass(2);
        smilesAtom3.setSymbol("H");
        this.createBond(smilesAtom2, smilesAtom3, 1, false);
        TestSmilesParser.checkMolecule("[2H]O[2H]", smilesSearch);
    }

    public void testChapter1_06() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("Au");
        TestSmilesParser.checkMolecule("[Au]", smilesSearch);
    }

    public void testChapter1_07() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("O");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        TestSmilesParser.checkMolecule("CCO", smilesSearch);
    }

    public void testChapter1_08() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("O");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 2, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("O");
        this.createBond(smilesAtom2, smilesAtom3, 2, true);
        TestSmilesParser.checkMolecule("O=C=O", smilesSearch);
    }

    public void testChapter1_09() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("N");
        this.createBond(smilesAtom, smilesAtom2, 3, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        TestSmilesParser.checkMolecule("C#N", smilesSearch);
    }

    public void testChapter1_10() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("O");
        this.createBond(smilesAtom2, smilesAtom3, 2, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("O");
        this.createBond(smilesAtom2, smilesAtom4, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom4);
        TestSmilesParser.checkMolecule("CC(=O)O", smilesSearch);
    }

    public void testChapter1_11() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("C");
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        this.createBond(smilesAtom3, smilesAtom4, 1, true);
        this.createBond(smilesAtom4, smilesAtom5, 1, true);
        this.createBond(smilesAtom5, smilesAtom6, 1, true);
        this.createBond(smilesAtom, smilesAtom6, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom6);
        TestSmilesParser.checkMolecule("C1CCCCC1", smilesSearch);
    }

    public void testChapter1_12() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("C");
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("C");
        SmilesAtom smilesAtom7 = smilesSearch.addAtom();
        smilesAtom7.setSymbol("C");
        SmilesAtom smilesAtom8 = smilesSearch.addAtom();
        smilesAtom8.setSymbol("C");
        SmilesAtom smilesAtom9 = smilesSearch.addAtom();
        smilesAtom9.setSymbol("C");
        SmilesAtom smilesAtom10 = smilesSearch.addAtom();
        smilesAtom10.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom10, 1, true);
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        this.createBond(smilesAtom3, smilesAtom8, 1, true);
        this.createBond(smilesAtom3, smilesAtom4, 1, true);
        this.createBond(smilesAtom4, smilesAtom5, 1, true);
        this.createBond(smilesAtom5, smilesAtom6, 1, true);
        this.createBond(smilesAtom6, smilesAtom7, 1, true);
        this.createBond(smilesAtom7, smilesAtom8, 1, true);
        this.createBond(smilesAtom8, smilesAtom9, 1, true);
        this.createBond(smilesAtom9, smilesAtom10, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom7);
        this.addHydrogen(smilesSearch, smilesAtom7);
        this.addHydrogen(smilesSearch, smilesAtom8);
        this.addHydrogen(smilesSearch, smilesAtom9);
        this.addHydrogen(smilesSearch, smilesAtom9);
        this.addHydrogen(smilesSearch, smilesAtom10);
        this.addHydrogen(smilesSearch, smilesAtom10);
        TestSmilesParser.checkMolecule("C1CC2CCCCC2CC1", smilesSearch);
    }

    public void testChapter1_13() {
    }

    public void testChapter1_14() {
    }

    public void testChapter1_15() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1025, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 2, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        this.createBond(smilesAtom3, smilesAtom4, 1025, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom4);
        TestSmilesParser.checkMolecule("C/C=C/C", smilesSearch);
    }

    public void testChapter1_16() throws InvalidSmilesException {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("N");
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.stereo = new SmilesStereo(4, 2, 0, null, null);
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom2);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom4, 1, true);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("O");
        this.createBond(smilesAtom4, smilesAtom5, 2, true);
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("O");
        this.createBond(smilesAtom4, smilesAtom6, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom6);
        TestSmilesParser.checkMolecule("N[C@@H](C)C(=O)O", smilesSearch);
    }

    public void testChapter1_17() throws InvalidSmilesException {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("O");
        this.addHydrogen(smilesSearch, smilesAtom);
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.stereo = new SmilesStereo(4, 1, 0, null, null);
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom2);
        SmilesBond smilesBond = this.createBond(smilesAtom2, null, 1, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        this.createBond(smilesAtom3, smilesAtom4, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom4);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("C");
        this.createBond(smilesAtom4, smilesAtom5, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom5);
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("C");
        this.createBond(smilesAtom5, smilesAtom6, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom6);
        SmilesAtom smilesAtom7 = smilesSearch.addAtom();
        smilesAtom7.stereo = new SmilesStereo(4, 1, 0, null, null);
        smilesAtom7.setSymbol("C");
        this.createBond(smilesAtom6, smilesAtom7, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom7);
        smilesBond.setAtom2(smilesAtom7, smilesSearch);
        SmilesAtom smilesAtom8 = smilesSearch.addAtom();
        smilesAtom8.setSymbol("O");
        this.createBond(smilesAtom7, smilesAtom8, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom8);
        TestSmilesParser.checkMolecule("O[C@H]1CCCC[C@H]1O", smilesSearch);
    }

    public void testChapter2_01() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("S");
        TestSmilesParser.checkMolecule("[S]", smilesSearch);
    }

    public void testChapter2_02() {
        this.testChapter1_06();
    }

    public void testChapter2_03() {
        this.testChapter1_02();
    }

    public void testChapter2_04() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("P");
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        TestSmilesParser.checkMolecule("P", smilesSearch);
    }

    public void testChapter2_05() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("S");
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        TestSmilesParser.checkMolecule("S", smilesSearch);
    }

    public void testChapter2_06() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("Cl");
        this.addHydrogen(smilesSearch, smilesAtom);
        TestSmilesParser.checkMolecule("Cl", smilesSearch);
    }

    public void testChapter2_07() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setCharge(-1);
        smilesAtom.setSymbol("O");
        this.addHydrogen(smilesSearch, smilesAtom);
        TestSmilesParser.checkMolecule("[OH-]", smilesSearch);
    }

    public void testChapter2_08() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setCharge(-1);
        smilesAtom.setSymbol("O");
        this.addHydrogen(smilesSearch, smilesAtom);
        TestSmilesParser.checkMolecule("[OH-1]", smilesSearch);
    }

    public void testChapter2_09() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setCharge(2);
        smilesAtom.setSymbol("Fe");
        TestSmilesParser.checkMolecule("[Fe+2]", smilesSearch);
    }

    public void testChapter2_10() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setCharge(2);
        smilesAtom.setSymbol("Fe");
        TestSmilesParser.checkMolecule("[Fe++]", smilesSearch);
    }

    public void testChapter2_11() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setAtomicMass(235);
        smilesAtom.setSymbol("U");
        TestSmilesParser.checkMolecule("[235U]", smilesSearch);
    }

    public void testChapter2_12() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setCharge(2);
        smilesAtom.setSymbol("*");
        TestSmilesParser.checkMolecule("[*+2]", smilesSearch);
    }

    public void testChapter3_01() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        TestSmilesParser.checkMolecule("CC", smilesSearch);
    }

    public void testChapter3_02() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        TestSmilesParser.checkMolecule("C-C", smilesSearch);
    }

    public void testChapter3_03() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        TestSmilesParser.checkMolecule("[CH3]-[CH3]", smilesSearch);
    }

    public void testChapter3_04() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("O");
        this.createBond(smilesAtom, smilesAtom2, 2, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        TestSmilesParser.checkMolecule("C=O", smilesSearch);
    }

    public void testChapter3_05() {
        this.testChapter1_09();
    }

    public void testChapter3_06() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 2, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        TestSmilesParser.checkMolecule("C=C", smilesSearch);
    }

    public void testChapter3_07() {
    }

    public void testChapter3_08() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 2, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        this.createBond(smilesAtom3, smilesAtom4, 2, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom4);
        TestSmilesParser.checkMolecule("C=CC=C", smilesSearch);
    }

    public void testChapter3_09() {
    }

    public void testChapter4_01() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom4, 1, true);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("O");
        this.createBond(smilesAtom4, smilesAtom5, 2, true);
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("O");
        this.createBond(smilesAtom4, smilesAtom6, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom6);
        TestSmilesParser.checkMolecule("CC(C)C(=O)O", smilesSearch);
    }

    public void testChapter4_02() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("F");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("F");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("F");
        this.createBond(smilesAtom2, smilesAtom4, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom2);
        TestSmilesParser.checkMolecule("FC(F)F", smilesSearch);
    }

    public void testChapter4_03() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("F");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("F");
        this.createBond(smilesAtom, smilesAtom3, 1, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("F");
        this.createBond(smilesAtom, smilesAtom4, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        TestSmilesParser.checkMolecule("C(F)(F)F", smilesSearch);
    }

    public void testChapter4_04() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("O");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("Cl");
        this.createBond(smilesAtom, smilesAtom2, 2, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("O");
        this.createBond(smilesAtom2, smilesAtom3, 2, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("O");
        this.createBond(smilesAtom2, smilesAtom4, 2, true);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setCharge(-1);
        smilesAtom5.setSymbol("O");
        this.createBond(smilesAtom2, smilesAtom5, 1, true);
        TestSmilesParser.checkMolecule("O=Cl(=O)(=O)[O-]", smilesSearch);
    }

    public void testChapter4_05() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("Cl");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("O");
        this.createBond(smilesAtom, smilesAtom2, 2, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("O");
        this.createBond(smilesAtom, smilesAtom3, 2, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("O");
        this.createBond(smilesAtom, smilesAtom4, 2, true);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setCharge(-1);
        smilesAtom5.setSymbol("O");
        this.createBond(smilesAtom, smilesAtom5, 1, true);
        TestSmilesParser.checkMolecule("Cl(=O)(=O)(=O)[O-]", smilesSearch);
    }

    public void testChapter4_06() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        this.createBond(smilesAtom3, smilesAtom4, 1, true);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("C");
        this.createBond(smilesAtom4, smilesAtom5, 1, true);
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("O");
        this.createBond(smilesAtom5, smilesAtom6, 2, true);
        SmilesAtom smilesAtom7 = smilesSearch.addAtom();
        smilesAtom7.setSymbol("O");
        this.createBond(smilesAtom5, smilesAtom7, 1, true);
        SmilesAtom smilesAtom8 = smilesSearch.addAtom();
        smilesAtom8.setSymbol("C");
        this.createBond(smilesAtom4, smilesAtom8, 1, true);
        SmilesAtom smilesAtom9 = smilesSearch.addAtom();
        smilesAtom9.setSymbol("C");
        this.createBond(smilesAtom8, smilesAtom9, 1, true);
        SmilesAtom smilesAtom10 = smilesSearch.addAtom();
        smilesAtom10.setSymbol("C");
        this.createBond(smilesAtom9, smilesAtom10, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom7);
        this.addHydrogen(smilesSearch, smilesAtom8);
        this.addHydrogen(smilesSearch, smilesAtom8);
        this.addHydrogen(smilesSearch, smilesAtom9);
        this.addHydrogen(smilesSearch, smilesAtom9);
        this.addHydrogen(smilesSearch, smilesAtom10);
        this.addHydrogen(smilesSearch, smilesAtom10);
        this.addHydrogen(smilesSearch, smilesAtom10);
        TestSmilesParser.checkMolecule("CCCC(C(=O)O)CCC", smilesSearch);
    }

    public void testChapter5_01() {
        this.testChapter1_11();
    }

    public void testChapter5_02() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("C");
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom6, 1, true);
        this.createBond(smilesAtom, smilesAtom2, 2, true);
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        this.createBond(smilesAtom3, smilesAtom4, 1, true);
        this.createBond(smilesAtom4, smilesAtom5, 1, true);
        this.createBond(smilesAtom5, smilesAtom6, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom6);
        TestSmilesParser.checkMolecule("C1=CCCCC1", smilesSearch);
    }

    public void testChapter5_03() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("C");
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom6, 2, true);
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        this.createBond(smilesAtom3, smilesAtom4, 1, true);
        this.createBond(smilesAtom4, smilesAtom5, 1, true);
        this.createBond(smilesAtom5, smilesAtom6, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom6);
        TestSmilesParser.checkMolecule("C=1CCCCC1", smilesSearch);
    }

    public void testChapter5_04() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("C");
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom6, 2, true);
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        this.createBond(smilesAtom3, smilesAtom4, 1, true);
        this.createBond(smilesAtom4, smilesAtom5, 1, true);
        this.createBond(smilesAtom5, smilesAtom6, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom6);
        TestSmilesParser.checkMolecule("C1CCCCC=1", smilesSearch);
    }

    public void testChapter5_05() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("C");
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom6, 2, true);
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        this.createBond(smilesAtom3, smilesAtom4, 1, true);
        this.createBond(smilesAtom4, smilesAtom5, 1, true);
        this.createBond(smilesAtom5, smilesAtom6, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom6);
        TestSmilesParser.checkMolecule("C=1CCCCC=1", smilesSearch);
    }

    public void testChapter5_06() {
    }

    public void testChapter5_07() {
    }

    public void testChapter5_08() {
    }

    public void testChapter5_09() {
    }

    public void testChapter6_01() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setCharge(1);
        smilesAtom.setSymbol("Na");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setCharge(-1);
        smilesAtom2.setSymbol("Cl");
    }

    public void testChapter6_02() {
    }

    public void testChapter6_03() {
    }

    public void testChapter6_04() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("O");
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom3, 1, true);
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
    }

    public void testChapter6_05() {
        this.testChapter1_07();
    }

    public void testChapter7_01() {
        this.testChapter1_02();
    }

    public void testChapter7_02() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        TestSmilesParser.checkMolecule("[C]", smilesSearch);
    }

    public void testChapter7_03() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setAtomicMass(12);
        smilesAtom.setSymbol("C");
        TestSmilesParser.checkMolecule("[12C]", smilesSearch);
    }

    public void testChapter7_04() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setAtomicMass(13);
        smilesAtom.setSymbol("C");
        TestSmilesParser.checkMolecule("[13C]", smilesSearch);
    }

    public void testChapter7_05() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setAtomicMass(13);
        smilesAtom.setSymbol("C");
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        TestSmilesParser.checkMolecule("[13CH4]", smilesSearch);
    }

    public void testChapter7_06() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("F");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1025, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 2, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("F");
        this.createBond(smilesAtom3, smilesAtom4, 1025, true);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        TestSmilesParser.checkMolecule("F/C=C/F", smilesSearch);
    }

    public void testChapter7_07() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("F");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1041, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 2, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("F");
        this.createBond(smilesAtom3, smilesAtom4, 1041, true);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        TestSmilesParser.checkMolecule("F\\C=C\\F", smilesSearch);
    }

    public void testChapter7_08() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("F");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1025, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 2, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("F");
        this.createBond(smilesAtom3, smilesAtom4, 1041, true);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        TestSmilesParser.checkMolecule("F/C=C\\F", smilesSearch);
    }

    public void testChapter7_09() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("F");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1041, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 2, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("F");
        this.createBond(smilesAtom3, smilesAtom4, 1025, true);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        TestSmilesParser.checkMolecule("F\\C=C/F", smilesSearch);
    }

    public void testChapter7_10() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("F");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1025, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 2, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        this.createBond(smilesAtom3, smilesAtom4, 1025, true);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("C");
        this.createBond(smilesAtom4, smilesAtom5, 2, true);
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("C");
        this.createBond(smilesAtom5, smilesAtom6, 1025, true);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom6);
        TestSmilesParser.checkMolecule("F/C=C/C=C/C", smilesSearch);
    }

    public void testChapter7_11() {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("F");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1025, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 2, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        this.createBond(smilesAtom3, smilesAtom4, 1025, true);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("C");
        this.createBond(smilesAtom4, smilesAtom5, 2, true);
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("C");
        this.createBond(smilesAtom5, smilesAtom6, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom6);
        TestSmilesParser.checkMolecule("F/C=C/C=CC", smilesSearch);
    }

    public void testChapter7_12() throws InvalidSmilesException {
        this.testChapter1_16();
    }

    public void testChapter7_13() throws InvalidSmilesException {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("N");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.stereo = new SmilesStereo(4, 1, 0, null, null);
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom2);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom4, 1, true);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("O");
        this.createBond(smilesAtom4, smilesAtom5, 2, true);
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("O");
        this.createBond(smilesAtom4, smilesAtom6, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom3);
        this.addHydrogen(smilesSearch, smilesAtom6);
        TestSmilesParser.checkMolecule("N[C@H](C)C(=O)O", smilesSearch);
    }

    public void testChapter7_14() throws InvalidSmilesException {
        this.testChapter1_17();
    }

    public void testChapter7_15() throws InvalidSmilesException {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("C");
        this.addHydrogen(smilesSearch, smilesAtom);
        this.addHydrogen(smilesSearch, smilesAtom);
        SmilesBond smilesBond = this.createBond(smilesAtom, null, 1, true);
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        smilesAtom2.setSymbol("C");
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom2);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.stereo = new SmilesStereo(4, 1, 0, null, null);
        smilesAtom3.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom3);
        SmilesBond smilesBond2 = this.createBond(smilesAtom3, null, 1, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("C");
        this.createBond(smilesAtom3, smilesAtom4, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom4);
        this.addHydrogen(smilesSearch, smilesAtom4);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("C");
        this.createBond(smilesAtom4, smilesAtom5, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom5);
        this.addHydrogen(smilesSearch, smilesAtom5);
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("C");
        this.createBond(smilesAtom5, smilesAtom6, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom6);
        SmilesAtom smilesAtom7 = smilesSearch.addAtom();
        smilesAtom7.setSymbol("C");
        this.addHydrogen(smilesSearch, smilesAtom7);
        this.addHydrogen(smilesSearch, smilesAtom7);
        this.createBond(smilesAtom6, smilesAtom7, 1, true);
        SmilesAtom smilesAtom8 = smilesSearch.addAtom();
        smilesAtom8.stereo = new SmilesStereo(4, 1, 0, null, null);
        smilesAtom8.setSymbol("C");
        this.createBond(smilesAtom7, smilesAtom8, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom8);
        smilesBond2.setAtom2(smilesAtom8, smilesSearch);
        SmilesAtom smilesAtom9 = smilesSearch.addAtom();
        smilesAtom9.setSymbol("C");
        this.createBond(smilesAtom8, smilesAtom9, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom9);
        this.addHydrogen(smilesSearch, smilesAtom9);
        SmilesAtom smilesAtom10 = smilesSearch.addAtom();
        smilesAtom10.setSymbol("C");
        this.createBond(smilesAtom9, smilesAtom10, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom10);
        this.addHydrogen(smilesSearch, smilesAtom10);
        smilesBond.setAtom2(smilesAtom10, smilesSearch);
        TestSmilesParser.checkMolecule("C1C[C@H]2CCCC[C@H]2CC1", smilesSearch);
    }

    public void testChapter7_16() throws InvalidSmilesException {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("O");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        this.addHydrogen(smilesSearch, smilesAtom);
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("Cl");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.stereo = new SmilesStereo(2, 1, 0, null, null);
        smilesAtom4.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom4, 2, true);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("C");
        this.createBond(smilesAtom4, smilesAtom5, 2, true);
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("C");
        this.createBond(smilesAtom5, smilesAtom6, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom6);
        SmilesAtom smilesAtom7 = smilesSearch.addAtom();
        smilesAtom7.setSymbol("F");
        this.createBond(smilesAtom5, smilesAtom7, 1, true);
        TestSmilesParser.checkMolecule("OC(Cl)=[C@]=C(C)F", smilesSearch);
    }

    public void testChapter7_17() throws InvalidSmilesException {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("O");
        this.addHydrogen(smilesSearch, smilesAtom);
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("Cl");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.stereo = new SmilesStereo(2, 1, 0, null, null);
        smilesAtom4.setSymbol("C");
        this.createBond(smilesAtom2, smilesAtom4, 2, true);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("C");
        this.createBond(smilesAtom4, smilesAtom5, 2, true);
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("C");
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.addHydrogen(smilesSearch, smilesAtom6);
        this.createBond(smilesAtom5, smilesAtom6, 1, true);
        SmilesAtom smilesAtom7 = smilesSearch.addAtom();
        smilesAtom7.setSymbol("F");
        this.createBond(smilesAtom5, smilesAtom7, 1, true);
        TestSmilesParser.checkMolecule("OC(Cl)=[C@AL1]=C(C)F", smilesSearch);
    }

    public void testChapter7_18() throws InvalidSmilesException {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("F");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.stereo = new SmilesStereo(7, 1, 0, null, null);
        smilesAtom2.setSymbol("Po");
        this.createBond(smilesAtom, smilesAtom2, 1, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.setSymbol("Cl");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("Br");
        this.createBond(smilesAtom2, smilesAtom4, 1, true);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("I");
        this.createBond(smilesAtom2, smilesAtom5, 1, true);
        TestSmilesParser.checkMolecule("F[Po@SP1](Cl)(Br)I", smilesSearch);
    }

    public void testChapter7_19() throws InvalidSmilesException {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("O");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 2, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.stereo = new SmilesStereo(5, 1, 0, null, null);
        smilesAtom3.setSymbol("As");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("F");
        this.createBond(smilesAtom3, smilesAtom4, 1, true);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("Cl");
        this.createBond(smilesAtom3, smilesAtom5, 1, true);
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("Br");
        this.createBond(smilesAtom3, smilesAtom6, 1, true);
        SmilesAtom smilesAtom7 = smilesSearch.addAtom();
        smilesAtom7.setSymbol("S");
        this.createBond(smilesAtom3, smilesAtom7, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom7);
        TestSmilesParser.checkMolecule("O=C[As@](F)(Cl)(Br)S", smilesSearch);
    }

    public void testChapter7_20() throws InvalidSmilesException {
        SmilesSearch smilesSearch = new SmilesSearch();
        SmilesAtom smilesAtom = smilesSearch.addAtom();
        smilesAtom.setSymbol("O");
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("C");
        this.createBond(smilesAtom, smilesAtom2, 2, true);
        SmilesAtom smilesAtom3 = smilesSearch.addAtom();
        smilesAtom3.stereo = new SmilesStereo(6, 1, 0, null, null);
        smilesAtom3.setSymbol("Co");
        this.createBond(smilesAtom2, smilesAtom3, 1, true);
        SmilesAtom smilesAtom4 = smilesSearch.addAtom();
        smilesAtom4.setSymbol("F");
        this.createBond(smilesAtom3, smilesAtom4, 1, true);
        SmilesAtom smilesAtom5 = smilesSearch.addAtom();
        smilesAtom5.setSymbol("Cl");
        this.createBond(smilesAtom3, smilesAtom5, 1, true);
        SmilesAtom smilesAtom6 = smilesSearch.addAtom();
        smilesAtom6.setSymbol("Br");
        this.createBond(smilesAtom3, smilesAtom6, 1, true);
        SmilesAtom smilesAtom7 = smilesSearch.addAtom();
        smilesAtom7.setSymbol("I");
        this.createBond(smilesAtom3, smilesAtom7, 1, true);
        SmilesAtom smilesAtom8 = smilesSearch.addAtom();
        smilesAtom8.setSymbol("S");
        this.createBond(smilesAtom3, smilesAtom8, 1, true);
        this.addHydrogen(smilesSearch, smilesAtom2);
        this.addHydrogen(smilesSearch, smilesAtom8);
        TestSmilesParser.checkMolecule("O=C[Co@](F)(Cl)(Br)(I)S", smilesSearch);
    }

    private static void checkMolecule(String string, SmilesSearch smilesSearch) {
        System.out.print("Checking " + string + "...");
        try {
            TestSmilesParser.assertTrue((boolean)new SmilesMatcher().areEqualTest(string, smilesSearch));
            System.out.println("OK");
        }
        catch (Exception exception) {
            TestSmilesParser.assertTrue((boolean)false);
        }
    }

    public SmilesBond createBond(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, int n, boolean bl) {
        SmilesBond smilesBond = new SmilesBond(smilesAtom, smilesAtom2, n, false);
        if (!bl || smilesAtom2 == null) {
            return smilesBond;
        }
        if (smilesAtom.getElementNumber() == 1) {
            this.addExplicitH(smilesAtom2);
        }
        if (smilesAtom2.getElementNumber() == 1) {
            this.addExplicitH(smilesAtom);
        }
        return smilesBond;
    }

    private void addExplicitH(SmilesAtom smilesAtom) {
        int n = smilesAtom.getExplicitHydrogenCount();
        if (n < 0) {
            n = 0;
        }
        smilesAtom.setExplicitHydrogenCount(n + 1);
    }

    private void addHydrogen(SmilesSearch smilesSearch, SmilesAtom smilesAtom) {
        SmilesAtom smilesAtom2 = smilesSearch.addAtom();
        smilesAtom2.setSymbol("H");
        if (smilesAtom != null) {
            this.createBond(smilesAtom, smilesAtom2, 1, false);
        }
    }
}

