/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.symmetry.CIPData;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.SimpleEdge;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.JC;

public class CIPChirality {
    static final String RULE_2_nXX_EQ_XX = ";9Be;19F;23Na;27Al;31P;45Sc;55Mn;59Co;75As;89Y;93Nb;98Tc;103Rh;127I;133Cs;141Pr;145Pm;159Tb;165Ho;169Tm;197Au;209Bi;209Po;210At;222Rn;223Fr;226Ra;227Ac;231Pa;232Th;and all > U (atomno > 92)";
    static final String RULE_2_REDUCE_ISOTOPE_MASS_NUMBER = ";16O;52Cr;96Mo;175Lu;";
    static final int NO_CHIRALITY = 0;
    static final int TIED = 0;
    static final int A_WINS = -1;
    static final int B_WINS = 1;
    static final int IGNORE = Integer.MIN_VALUE;
    static final int UNDETERMINED = -1;
    static final int STEREO_R = 1;
    static final int STEREO_S = 2;
    static final int STEREO_M = 17;
    static final int STEREO_P = 18;
    static final int STEREO_Z = 13;
    static final int STEREO_E = 14;
    static final int STEREO_BOTH_RS = 3;
    static final int STEREO_BOTH_EZ = 15;
    static final int RULE_1a = 1;
    static final int RULE_1b = 2;
    static final int RULE_2 = 3;
    static final int RULE_3 = 4;
    static final int RULE_4a = 5;
    static final int RULE_4b = 6;
    static final int RULE_4c = 7;
    static final int RULE_5 = 8;
    static final int RULE_6 = 9;
    static final String[] ruleNames = new String[]{"", "1a", "1b", "2", "3", "4a", "4b", "4c", "5", "6"};
    static final int MAX_PATH = 50;
    static final int SMALL_RING_MAX = 7;
    int currentRule = 1;
    CIPAtom root;
    CIPData data;
    boolean doTrack;
    boolean isAux;
    BS bsNeedRule = new BS();
    boolean havePseudoAuxiliary;
    int ptIDLogger;

    public String getRuleName(int n) {
        return ruleNames[n];
    }

    public void getChiralityForAtoms(CIPData cIPData) {
        if (cIPData.bsAtoms.cardinality() == 0) {
            return;
        }
        this.data = cIPData;
        this.doTrack = cIPData.isTracker();
        this.ptIDLogger = 0;
        BS bS = (BS)cIPData.bsMolecule.clone();
        boolean bl = this.preFilterAtomList(cIPData.atoms, bS, cIPData.bsEnes);
        if (!cIPData.bsEnes.isEmpty()) {
            cIPData.getEneKekule();
        }
        Logger.info("bsKekule:" + cIPData.bsKekuleAmbiguous);
        bS = (BS)cIPData.bsAtoms.clone();
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            SimpleNode simpleNode = cIPData.atoms[n];
            simpleNode.setCIPChirality(0);
            this.ptIDLogger = 0;
            int n2 = this.getAtomChiralityLimited(simpleNode, null, null);
            simpleNode.setCIPChirality(n2 == 0 ? 3 : n2 | this.currentRule - 1 << 5);
            if (this.doTrack && n2 != 0) {
                cIPData.getRootTrackerResult(this.root);
            }
            n = bS.nextSetBit(n + 1);
        }
        if (bl) {
            Lst<int[]> lst = new Lst<int[]>();
            int n3 = bS.nextSetBit(0);
            while (n3 >= 0) {
                this.getAtomBondChirality(cIPData.atoms[n3], lst, bS);
                n3 = bS.nextSetBit(n3 + 1);
            }
            if (cIPData.lstSmallRings.length > 0 && lst.size() > 0) {
                this.clearSmallRingEZ(cIPData.atoms, lst);
            }
            this.setStereoFromSmiles(cIPData.bsHelixM, 17, cIPData.atoms);
            this.setStereoFromSmiles(cIPData.bsHelixP, 18, cIPData.atoms);
        }
        if (Logger.debugging) {
            Logger.info("Kekule ambiguous = " + cIPData.bsKekuleAmbiguous);
            Logger.info("small rings = " + PT.toJSON(null, cIPData.lstSmallRings));
        }
    }

    private void setStereoFromSmiles(BS bS, int n, SimpleNode[] simpleNodeArray) {
        if (bS != null) {
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                simpleNodeArray[n2].setCIPChirality(n);
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
    }

    private boolean preFilterAtomList(SimpleNode[] simpleNodeArray, BS bS, BS bS2) {
        boolean bl = false;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (!this.data.couldBeChiralAtom(simpleNodeArray[n])) {
                bS.clear(n);
            } else {
                switch (this.data.couldBeChiralAlkene(simpleNodeArray[n], null)) {
                    case -1: {
                        break;
                    }
                    case 13: {
                        bS2.set(n);
                    }
                    case 17: {
                        bl = true;
                    }
                }
            }
            n = bS.nextSetBit(n + 1);
        }
        return bl;
    }

    static boolean isFirstRow(SimpleNode simpleNode) {
        int n = simpleNode.getElementNumber();
        return n > 2 && n <= 10;
    }

    private void clearSmallRingEZ(SimpleNode[] simpleNodeArray, Lst<int[]> lst) {
        int n = this.data.lstSmallRings.length;
        while (--n >= 0) {
            this.data.lstSmallRings[n].andNot(this.data.bsAtropisomeric);
        }
        n = lst.size();
        while (--n >= 0) {
            int[] nArray = (int[])lst.get(n);
            int n2 = this.data.lstSmallRings.length;
            while (--n2 >= 0) {
                BS bS = this.data.lstSmallRings[n2];
                if (!bS.get(nArray[0]) || !bS.get(nArray[1])) continue;
                simpleNodeArray[nArray[0]].setCIPChirality(3);
                simpleNodeArray[nArray[1]].setCIPChirality(3);
            }
        }
    }

    private void getAtomBondChirality(SimpleNode simpleNode, Lst<int[]> lst, BS bS) {
        int n = simpleNode.getIndex();
        SimpleEdge[] simpleEdgeArray = simpleNode.getEdges();
        int n2 = 0;
        boolean bl = this.data.bsAtropisomeric.get(n);
        int n3 = simpleEdgeArray.length;
        while (--n3 >= 0) {
            int n4;
            SimpleNode simpleNode2;
            SimpleEdge simpleEdge = simpleEdgeArray[n3];
            if (bl) {
                simpleNode2 = simpleEdgeArray[n3].getOtherNode(simpleNode);
                n4 = simpleNode2.getIndex();
                if (!this.data.bsAtropisomeric.get(n4)) continue;
                n2 = this.setBondChirality(simpleNode, simpleNode2, simpleNode, simpleNode2, true);
            } else {
                if (this.data.getBondOrder(simpleEdge) != 2 || (n4 = (simpleNode2 = this.getLastCumuleneAtom(simpleEdge, simpleNode, null, null)).getIndex()) < n) continue;
                n2 = this.getBondChiralityLimited(simpleEdge, simpleNode);
            }
            if (n2 != 0) {
                if (!bl) {
                    lst.addLast(new int[]{n, n4});
                }
                bS.clear(n);
                bS.clear(n4);
            }
            if (bl) break;
        }
    }

    private SimpleNode getLastCumuleneAtom(SimpleEdge simpleEdge, SimpleNode simpleNode, int[] nArray, SimpleNode[] simpleNodeArray) {
        SimpleNode simpleNode2 = simpleEdge.getOtherNode(simpleNode);
        if (simpleNodeArray != null) {
            simpleNodeArray[0] = simpleNode2;
            simpleNodeArray[1] = simpleNode;
        }
        if (nArray != null) {
            nArray[0] = 2;
        }
        boolean bl = false;
        block0: while (simpleNode2.getCovalentBondCount() == 2) {
            SimpleNode simpleNode3;
            SimpleEdge[] simpleEdgeArray = simpleNode2.getEdges();
            int n = simpleEdgeArray.length;
            do {
                if (--n < 0) continue block0;
            } while ((simpleNode3 = (simpleEdge = simpleEdgeArray[n]).getOtherNode(simpleNode2)) == simpleNode);
            if (this.data.getBondOrder(simpleEdge) != 2) {
                return simpleNode2;
            }
            if (simpleNodeArray != null) {
                if (!bl) {
                    simpleNodeArray[0] = simpleNode2;
                    bl = true;
                }
                simpleNodeArray[1] = simpleNode2;
            }
            if (nArray != null) {
                nArray[0] = nArray[0] + 1;
            }
            simpleNode = simpleNode2;
            simpleNode2 = simpleNode3;
        }
        return simpleNode2;
    }

    /*
     * Unable to fully structure code
     */
    int getAtomChiralityLimited(SimpleNode var1_1, CIPAtom var2_2, SimpleNode var3_3) {
        block25: {
            block24: {
                var4_4 = 0;
                this.bsNeedRule.clearAll();
                this.bsNeedRule.set(1);
                v0 = var5_5 = var1_1 == null;
                if (var5_5) {
                    this.root = var2_2;
                    var1_1 = this.root.atom;
                    var2_2.parent = new CIPAtom().create(var3_3, null, true, false, false);
                    var2_2.htPathPoints = var2_2.parent.htPathPoints;
                    break block24;
                }
                var2_2 = var2_2 == null ? new CIPAtom().create(var1_1, null, false, false, false) : var2_2;
                this.root = var2_2;
                if (var2_2.isSP3) break block24;
                return 0;
            }
            try {
                if (!var2_2.setNode()) break block25;
                this.currentRule = 1;
                while (this.currentRule <= 9) {
                    var6_7 = var2_2.nPriorities;
                    switch (this.currentRule) {
                        case 3: {
                            if (var2_2.rule6refIndex >= 0) {
                                this.bsNeedRule.set(3);
                            }
                            ** GOTO lbl54
                        }
                        case 4: {
                            this.isAux = true;
                            this.doTrack = false;
                            this.havePseudoAuxiliary = false;
                            var2_2.createAuxiliaryDescriptors(null, null);
                            this.doTrack = this.data.isTracker();
                            this.isAux = false;
                            ** GOTO lbl54
                        }
                        case 5: {
                            if (!this.bsNeedRule.get(5)) {
                                this.currentRule = 8;
                                break;
                            }
                        }
                        case 6: 
                        case 7: {
                            var2_2.sortSubstituents(-2147483648);
                            this.bsNeedRule.set(this.currentRule);
                            ** GOTO lbl54
                        }
                        case 8: {
                            if (this.havePseudoAuxiliary) {
                                var2_2.clearRule4Lists();
                            }
                            var2_2.sortSubstituents(-2147483648);
                            this.bsNeedRule.set(this.currentRule);
                            ** GOTO lbl54
                        }
                        case 9: {
                            this.bsNeedRule.setBitTo(9, var2_2.rule6refIndex < 0 && (var4_4 = var2_2.getRule6Descriptor(false)) != 0);
                        }
lbl54:
                        // 6 sources

                        default: {
                            if (!this.bsNeedRule.get(this.currentRule) || var4_4 != 0 || !var2_2.sortSubstituents(0)) break;
                            if (Logger.debuggingHigh && var2_2.h1Count < 2) {
                                var7_8 = 0;
                                while (var7_8 < var2_2.bondCount) {
                                    if (var2_2.atoms[var7_8] != null) {
                                        Logger.info(var2_2.atoms[var7_8] + " " + var2_2.priorities[var7_8]);
                                    }
                                    ++var7_8;
                                }
                            }
                            if (var5_5) {
                                return var2_2.getEneTop();
                            }
                            var4_4 = this.data.checkHandedness(var2_2);
                            if (this.currentRule == 8) {
                                if (var2_2.nPriorities == 4 && var6_7 == 2) {
                                    v1 = var2_2.isRule5Pseudo = var2_2.isRule5Pseudo == false;
                                }
                                if (var2_2.isRule5Pseudo) {
                                    var4_4 |= 8;
                                }
                            }
                            if (Logger.debugging) {
                                Logger.info(var1_1 + " " + JC.getCIPChiralityName(var4_4) + " by Rule " + this.getRuleName(this.currentRule) + "\n----------------------------------");
                            }
                            return var4_4;
                        }
                    }
                    ++this.currentRule;
                }
            }
            catch (Throwable var5_6) {
                System.out.println(var5_6 + " in CIPChirality " + this.currentRule);
                var5_6.printStackTrace();
                return 3;
            }
        }
        return var4_4;
    }

    private int getBondChiralityLimited(SimpleEdge simpleEdge, SimpleNode simpleNode) {
        boolean bl;
        if (simpleNode == null) {
            simpleNode = simpleEdge.getOtherNode(null);
        }
        if (this.data.couldBeChiralAlkene(simpleNode, simpleEdge) == -1) {
            return 0;
        }
        int[] nArray = new int[1];
        SimpleNode[] simpleNodeArray = new SimpleNode[2];
        SimpleNode simpleNode2 = this.getLastCumuleneAtom(simpleEdge, simpleNode, nArray, simpleNodeArray);
        boolean bl2 = bl = nArray[0] % 2 == 1;
        if (!bl && this.data.bsAromatic.get(simpleNode.getIndex())) {
            return -1;
        }
        int n = this.setBondChirality(simpleNode, simpleNodeArray[0], simpleNodeArray[1], simpleNode2, bl);
        if (Logger.debugging) {
            Logger.info("get Bond Chirality " + JC.getCIPChiralityName(n) + " " + simpleEdge);
        }
        return n;
    }

    private int setBondChirality(SimpleNode simpleNode, SimpleNode simpleNode2, SimpleNode simpleNode3, SimpleNode simpleNode4, boolean bl) {
        int n;
        CIPAtom cIPAtom = new CIPAtom().create(simpleNode, null, true, false, false);
        CIPAtom cIPAtom2 = new CIPAtom().create(simpleNode4, null, true, false, false);
        int n2 = this.getAtomChiralityLimited(null, cIPAtom, simpleNode2) - 1;
        int n3 = this.currentRule;
        int n4 = this.getAtomChiralityLimited(null, cIPAtom2, simpleNode3) - 1;
        int n5 = this.currentRule;
        if (bl && cIPAtom.nRootDuplicates > 3 && n2 < 0 && n4 < 0) {
            this.currentRule = 9;
            n5 = 9;
            n3 = 9;
            n2 = cIPAtom.getEneTop() - 1;
            cIPAtom2.rule6refIndex = cIPAtom.atoms[n2].atomIndex;
            if (cIPAtom2.sortSubstituents(0)) {
                n4 = cIPAtom2.getEneTop() - 1;
            }
        }
        int n6 = n = n2 >= 0 && n4 >= 0 ? this.getEneChirality(cIPAtom2.atoms[n4], cIPAtom2, cIPAtom, cIPAtom.atoms[n2], bl, true) : 0;
        if (n != 0 && (bl || !this.data.bsAtropisomeric.get(simpleNode.getIndex()) && !this.data.bsAtropisomeric.get(simpleNode4.getIndex()))) {
            n = bl == (n3 == 8) == (n5 == 8) ? (n &= 0xFFFFFFF7) : (n |= 8);
            simpleNode.setCIPChirality(n | n3 - 1 << 5);
            simpleNode4.setCIPChirality(n | n5 - 1 << 5);
            if (Logger.debugging) {
                Logger.info(simpleNode + "-" + simpleNode4 + " " + JC.getCIPChiralityName(n));
            }
        }
        return n;
    }

    int getEneChirality(CIPAtom cIPAtom, CIPAtom cIPAtom2, CIPAtom cIPAtom3, CIPAtom cIPAtom4, boolean bl, boolean bl2) {
        return cIPAtom == null || cIPAtom4 == null || cIPAtom.atom == null || cIPAtom4.atom == null ? 0 : (bl ? this.data.isPositiveTorsion(cIPAtom, cIPAtom2, cIPAtom3, cIPAtom4) : this.data.isCis(cIPAtom, cIPAtom2, cIPAtom3, cIPAtom4));
    }

    class CIPAtom
    implements Comparable<CIPAtom>,
    Cloneable {
        boolean isRule5Pseudo = true;
        private int id;
        private int sphere;
        private int rootDistance;
        private boolean isSet;
        boolean isDuplicate = true;
        boolean isTerminal;
        private boolean isAlkene;
        SimpleNode atom;
        int atomIndex = -1;
        int bondCount;
        float elemNo;
        private float mass = -1.0f;
        CIPAtom parent;
        CIPAtom rootSubstituent;
        int h1Count;
        CIPAtom[] atoms = new CIPAtom[4];
        private int nAtoms;
        private BS bsPath;
        String myPath = "";
        int[] oldPriorities;
        int[] priorities = new int[4];
        int oldNPriorities;
        int nPriorities;
        int priority;
        private String chiralPath;
        int nRootDuplicates;
        Map<Integer, Integer> htPathPoints;
        int rule6refIndex = -1;
        private BS bsRule6Subs;
        private CIPAtom alkeneParent;
        private CIPAtom alkeneChild;
        private boolean isAlkeneAtom2;
        private boolean isKekuleAmbiguous;
        private CIPAtom nextSP2;
        private boolean multipleBondDuplicate;
        private boolean isEvenEne = true;
        private int auxEZ = -1;
        boolean isSP3 = true;
        private char auxChirality = (char)126;
        private CIPAtom nextChiralBranch;
        private boolean isChiralPath;
        int rule4Type;
        private BS bsTemp = new BS();
        private int rule4Ref;
        BS[] listRS;

        CIPAtom() {
        }

        CIPAtom create(SimpleNode simpleNode, CIPAtom cIPAtom, boolean bl, boolean bl2, boolean bl3) {
            this.id = ++CIPChirality.this.ptIDLogger;
            this.parent = cIPAtom;
            if (simpleNode == null) {
                return this;
            }
            this.isAlkene = bl;
            this.atom = simpleNode;
            this.atomIndex = simpleNode.getIndex();
            if (simpleNode.getIsotopeNumber() > 0) {
                CIPChirality.this.bsNeedRule.set(3);
            }
            this.isDuplicate = this.multipleBondDuplicate = bl2;
            this.isKekuleAmbiguous = CIPChirality.this.data.bsKekuleAmbiguous != null && CIPChirality.this.data.bsKekuleAmbiguous.get(this.atomIndex);
            this.elemNo = bl2 && this.isKekuleAmbiguous ? cIPAtom.getKekuleElementNumber() : (float)simpleNode.getElementNumber();
            this.bondCount = simpleNode.getCovalentBondCount();
            boolean bl4 = this.isSP3 = this.bondCount == 4 || this.bondCount == 3 && !bl && (this.elemNo > 10.0f || CIPChirality.this.data.bsAzacyclic != null && CIPChirality.this.data.bsAzacyclic.get(this.atomIndex));
            if (cIPAtom != null) {
                this.sphere = cIPAtom.sphere + 1;
            }
            if (this.sphere == 1) {
                this.rootSubstituent = this;
                this.htPathPoints = new Hashtable<Integer, Integer>();
            } else if (cIPAtom != null) {
                this.rootSubstituent = cIPAtom.rootSubstituent;
                this.htPathPoints = (Map)((Hashtable)cIPAtom.htPathPoints).clone();
            }
            BS bS = this.bsPath = cIPAtom == null ? new BS() : (BS)cIPAtom.bsPath.clone();
            if (bl2) {
                CIPChirality.this.bsNeedRule.set(4);
            }
            this.rootDistance = this.sphere;
            if (cIPAtom == null) {
                this.bsPath.set(this.atomIndex);
            } else if (this.multipleBondDuplicate) {
                --this.rootDistance;
            } else if (this.bsPath.get(this.atomIndex)) {
                this.isDuplicate = true;
                CIPChirality.this.bsNeedRule.setBitTo(2, true);
                if ((simpleNode == CIPChirality.this.root.atom ? 0 : (this.rootDistance = bl3 ? cIPAtom.sphere : this.htPathPoints.get(this.atomIndex))) == 0) {
                    ++CIPChirality.this.root.nRootDuplicates;
                }
            } else {
                this.bsPath.set(this.atomIndex);
                this.htPathPoints.put(this.atomIndex, this.rootDistance);
            }
            if (CIPChirality.this.doTrack) {
                if (this.sphere < 50) {
                    this.myPath = String.valueOf(cIPAtom != null ? String.valueOf(cIPAtom.myPath) + "-" : "") + this;
                }
                if (Logger.debuggingHigh) {
                    Logger.info("new CIPAtom " + this.myPath);
                }
            }
            return this;
        }

        int getEneTop() {
            return this.atoms[0].isDuplicate ? 2 : 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        int getRule6Descriptor(boolean bl) {
            if (this.nPriorities > 2 || (bl ? this.countAuxDuplicates(this.atomIndex) : this.nRootDuplicates) <= 2) {
                return 0;
            }
            int n = this.priorities[0] == this.priorities[1] ? 0 : 1;
            int n2 = this.priorities[2] != this.priorities[3] ? 3 : 4;
            int n3 = this.priorities[2] == this.priorities[1] ? 1 : 2;
            int n4 = 0;
            int n5 = 0;
            BS bS = new BS();
            int n6 = n;
            while (n6 < n2) {
                bS.set(this.atoms[n6].atomIndex);
                ++n6;
            }
            if (this.nPriorities == 1) {
                n2 = 2;
            }
            CIPAtom cIPAtom = null;
            int n7 = n;
            while (n7 < n2) {
                int n8;
                if (CIPChirality.this.data.testRule6Full) {
                    cIPAtom = new CIPAtom().create(this.atom, null, false, false, false);
                    cIPAtom.rule6refIndex = this.atoms[n7].atomIndex;
                    cIPAtom.setNode();
                    int n9 = 0;
                    while (n9 < 4) {
                        cIPAtom.atoms[n9] = (CIPAtom)this.atoms[n9].clone();
                        cIPAtom.priorities[n9] = this.priorities[n9];
                        ++n9;
                    }
                    cIPAtom.bsRule6Subs = bS;
                    n8 = CIPChirality.this.getAtomChiralityLimited(this.atom, cIPAtom, null);
                    CIPChirality.this.currentRule = 9;
                    if (n8 == 0) {
                        return 0;
                    }
                } else {
                    CIPChirality.this.root.bsRule6Subs = new BS();
                    CIPChirality.this.root.rule6refIndex = this.atoms[n7].atomIndex;
                    this.saveRestorePriorities(false);
                    this.sortSubstituents(Integer.MIN_VALUE);
                    if (!this.sortSubstituents(0)) {
                        return 0;
                    }
                    n8 = CIPChirality.this.data.checkHandedness(this);
                    this.saveRestorePriorities(true);
                }
                if ((n8 & 8) != 0) return n8;
                if (n8 == 1 || n8 == 17) {
                    if (n4 != 0) return n8;
                    n4 = n8;
                } else {
                    if (n5 != 0) return n8;
                    n5 = n8;
                }
                n7 += n3;
            }
            return 0;
        }

        private void saveRestorePriorities(boolean bl) {
            if (bl) {
                this.priorities = this.oldPriorities;
                this.nPriorities = this.oldNPriorities;
            } else {
                this.oldPriorities = Arrays.copyOf(this.priorities, 4);
                this.oldNPriorities = this.nPriorities;
            }
            int n = 0;
            while (n < this.nAtoms) {
                this.atoms[n].saveRestorePriorities(bl);
                ++n;
            }
        }

        private int countAuxDuplicates(int n) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < 4) {
                if (this.atoms[n3] != null) {
                    if (this.atoms[n3].isDuplicate) {
                        if (this.atoms[n3].atomIndex == n) {
                            ++n2;
                        }
                    } else {
                        n2 += this.atoms[n3].countAuxDuplicates(n);
                    }
                }
                ++n3;
            }
            return n2;
        }

        private float getMass() {
            if (this.isDuplicate) {
                return 0.0f;
            }
            if (this.mass == -1.0f) {
                if (this.isDuplicate || (this.mass = this.atom.getMass()) != (float)((int)this.mass) || this.isType(CIPChirality.RULE_2_nXX_EQ_XX)) {
                    return this.mass == -1.0f ? (this.mass = Elements.getAtomicMass((int)this.elemNo)) : this.mass;
                }
                if (this.isType(CIPChirality.RULE_2_REDUCE_ISOTOPE_MASS_NUMBER)) {
                    this.mass -= 0.1f;
                }
            }
            return this.mass;
        }

        private boolean isType(String string) {
            return PT.isOneOf(String.valueOf((int)this.mass) + Elements.elementSymbolFromNumber((int)this.elemNo), string);
        }

        private float getKekuleElementNumber() {
            SimpleEdge[] simpleEdgeArray = this.atom.getEdges();
            float f = 0.0f;
            int n = 0;
            int n2 = simpleEdgeArray.length;
            while (--n2 >= 0) {
                SimpleNode simpleNode;
                SimpleEdge simpleEdge = simpleEdgeArray[n2];
                if (!simpleEdge.isCovalent() || !CIPChirality.this.data.bsKekuleAmbiguous.get((simpleNode = simpleEdge.getOtherNode(this.atom)).getIndex())) continue;
                ++n;
                f += (float)simpleNode.getElementNumber();
            }
            return f / (float)n;
        }

        boolean setNode() {
            block26: {
                block25: {
                    if (this.isSet) break block25;
                    this.isSet = true;
                    if (!true || !this.isDuplicate) break block26;
                }
                return true;
            }
            int n = this.atom.getIndex();
            SimpleEdge[] simpleEdgeArray = this.atom.getEdges();
            int n2 = simpleEdgeArray.length;
            if (Logger.debuggingHigh) {
                Logger.info("set " + this);
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                SimpleEdge simpleEdge = simpleEdgeArray[n4];
                if (simpleEdge.isCovalent()) {
                    SimpleNode simpleNode = simpleEdge.getOtherNode(this.atom);
                    boolean bl = this.parent != null && this.parent.atom == simpleNode;
                    int n5 = CIPChirality.this.data.getBondOrder(simpleEdge);
                    if (n5 == 2) {
                        if (this.elemNo > 10.0f || !CIPChirality.isFirstRow(simpleNode)) {
                            n5 = 1;
                        } else {
                            this.isAlkene = true;
                            if (bl) {
                                this.setEne();
                            }
                        }
                    }
                    if (n2 == 1 && n5 == 1 && bl) {
                        this.isTerminal = true;
                        return true;
                    }
                    switch (n5) {
                        case 3: {
                            if (this.addAtom(n3++, simpleNode, bl, false, bl) == null) {
                                this.isTerminal = true;
                                return !true;
                            }
                        }
                        case 2: {
                            if (this.addAtom(n3++, simpleNode, n5 != 2 || bl, n5 == 2, bl) == null) {
                                this.isTerminal = true;
                                return !true;
                            }
                        }
                        case 1: {
                            if (bl || this.addAtom(n3++, simpleNode, n5 != 1 && this.elemNo <= 10.0f, false, false) != null) break;
                        }
                        default: {
                            this.isTerminal = true;
                            return !true;
                        }
                    }
                }
                ++n4;
            }
            this.nAtoms = n3;
            switch (n3) {
                case 2: 
                case 3: {
                    if ((this.elemNo != 6.0f || !CIPChirality.this.data.bsNegativeAromatic.get(n)) && !CIPChirality.this.data.bsXAromatic.get(n)) break;
                    ++this.nAtoms;
                    this.addAtom(n3++, this.atom, true, false, false);
                }
            }
            if (n3 < 4) {
                while (n3 < this.atoms.length) {
                    this.atoms[n3] = new CIPAtom().create(null, this, false, true, false);
                    ++n3;
                }
            }
            try {
                Arrays.sort(this.atoms);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }

        private void setEne() {
            this.parent.alkeneChild = null;
            this.alkeneParent = this.parent.alkeneParent == null ? this.parent : this.parent.alkeneParent;
            this.alkeneParent.alkeneChild = this;
            this.nextSP2 = this.parent;
            if (this.parent.alkeneParent == null) {
                this.parent.nextSP2 = this;
            }
            if (this.atom.getCovalentBondCount() == 2 && this.atom.getValence() == 4) {
                this.parent.isAlkeneAtom2 = false;
                this.alkeneParent.isEvenEne = !this.alkeneParent.isEvenEne;
            } else {
                this.isAlkeneAtom2 = true;
            }
        }

        private CIPAtom addAtom(int n, SimpleNode simpleNode, boolean bl, boolean bl2, boolean bl3) {
            if (n >= this.atoms.length) {
                if (Logger.debugging) {
                    Logger.info(" too many bonds on " + this.atom);
                }
                return null;
            }
            if (simpleNode.getElementNumber() == 1 && simpleNode.getIsotopeNumber() == 0 && ++this.h1Count > 1 && this.parent == null) {
                if (Logger.debuggingHigh) {
                    Logger.info(" second H atom found on " + this.atom);
                }
                return null;
            }
            this.atoms[n] = new CIPAtom().create(simpleNode, this, bl2, bl, bl3);
            return this.atoms[n];
        }

        boolean sortSubstituents(int n) {
            int n2;
            int n3;
            boolean bl;
            if (this.nPriorities == (n < 1 ? 4 : 3)) {
                return true;
            }
            boolean bl2 = bl = n == Integer.MIN_VALUE;
            if (bl) {
                if (this.isTerminal) {
                    return false;
                }
                switch (CIPChirality.this.currentRule) {
                    case 5: 
                    case 7: {
                        int n4 = 0;
                        while (n4 < 4) {
                            if (this.atoms[n4] != null && (this.atoms[n4].isChiralPath || this.atoms[n4].nextChiralBranch != null)) {
                                this.atoms[n4].sortSubstituents(Integer.MIN_VALUE);
                            }
                            ++n4;
                        }
                        if (!this.isAlkene) break;
                        return false;
                    }
                    case 9: {
                        int n4 = 0;
                        while (n4 < 4) {
                            if (this.atoms[n4] != null && !this.atoms[n4].isDuplicate && this.atoms[n4].atom != null && this.atoms[n4].setNode()) {
                                this.atoms[n4].sortSubstituents(Integer.MIN_VALUE);
                            }
                            ++n4;
                        }
                        break;
                    }
                }
            }
            bl |= CIPChirality.this.currentRule == 6 || CIPChirality.this.currentRule == 8;
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            if (Logger.debuggingHigh && this.h1Count < 2) {
                Logger.info(CIPChirality.this.root + "---sortSubstituents---" + this);
                n3 = 0;
                while (n3 < 4) {
                    Logger.info(String.valueOf(CIPChirality.this.getRuleName(CIPChirality.this.currentRule)) + ": " + this + "[" + n3 + "]=" + this.atoms[n3].myPath + " " + Integer.toHexString(this.priorities[n3]));
                    ++n3;
                }
                Logger.info("---" + this.nPriorities);
            }
            int n5 = 0;
            while (n5 < 3) {
                CIPAtom cIPAtom = this.atoms[n5];
                n2 = cIPAtom.isDuplicate && CIPChirality.this.currentRule > 2 ? 1 : 0;
                int n6 = n5 + 1;
                while (n6 < 4) {
                    n3 = n6;
                    CIPAtom cIPAtom2 = this.atoms[n3];
                    int n7 = 0;
                    switch (cIPAtom2.atom == null || this.priorities[n5] < this.priorities[n6] ? -1 : (n2 != 0 || cIPAtom.atom == null || this.priorities[n6] < this.priorities[n5] ? 1 : ((n7 = cIPAtom.checkCurrentRule(cIPAtom2)) != 0 && n7 != Integer.MIN_VALUE || bl ? n7 : this.sign(cIPAtom.breakTie(cIPAtom2, n + 1))))) {
                        case 1: {
                            n3 = n5;
                        }
                        case -1: {
                            int n8 = n3;
                            nArray2[n8] = nArray2[n8] + 1;
                            if (CIPChirality.this.doTrack && n7 != 0 && (n == 0 || bl)) {
                                CIPChirality.this.data.track(CIPChirality.this, cIPAtom, cIPAtom2, 1, n7, false);
                            }
                        }
                        case -2147483648: 
                        case 0: {
                            int n9 = n3;
                            nArray[n9] = nArray[n9] + 1;
                        }
                    }
                    ++n6;
                }
                ++n5;
            }
            this.bsTemp.clearAll();
            CIPAtom[] cIPAtomArray = new CIPAtom[4];
            int n10 = 0;
            while (n10 < 4) {
                n2 = nArray[n10];
                CIPAtom cIPAtom = cIPAtomArray[n2] = this.atoms[n10];
                int n11 = nArray2[n10];
                if (cIPAtom.atom != null) {
                    this.bsTemp.set(n11);
                }
                cIPAtom.priority = this.priorities[n2] = n11;
                ++n10;
            }
            this.atoms = cIPAtomArray;
            this.nPriorities = this.bsTemp.cardinality();
            if (Logger.debuggingHigh && this.atoms[2].atom != null && this.atoms[2].elemNo != 1.0f) {
                Logger.info(String.valueOf(this.dots()) + this.atom + " nPriorities = " + this.nPriorities);
                n10 = 0;
                while (n10 < 4) {
                    Logger.info(String.valueOf(this.dots()) + this.myPath + "[" + n10 + "]=" + this.atoms[n10] + " " + this.priorities[n10] + " " + Integer.toHexString(this.priorities[n10]));
                    ++n10;
                }
                Logger.info(String.valueOf(this.dots()) + "-------" + this.nPriorities);
            }
            return this.nPriorities == this.bondCount;
        }

        private String dots() {
            return ".....................".substring(0, Math.min(20, this.sphere));
        }

        private int breakTie(CIPAtom cIPAtom, int n) {
            int n2 = 0;
            if (!(this.isDuplicate && (CIPChirality.this.currentRule > 2 || cIPAtom.isDuplicate && this.atom == cIPAtom.atom && this.rootDistance == cIPAtom.rootDistance) || !this.setNode() || !cIPAtom.setNode() || this.isTerminal && cIPAtom.isTerminal || this.isDuplicate && cIPAtom.isDuplicate)) {
                if (this.isTerminal != cIPAtom.isTerminal) {
                    n2 = (this.isTerminal ? 1 : -1) * (n + (cIPAtom.isDuplicate || this.isDuplicate ? 0 : 1));
                    if (CIPChirality.this.doTrack) {
                        CIPChirality.this.data.track(CIPChirality.this, this, cIPAtom, n, n2, true);
                    }
                } else {
                    int n3;
                    int n4 = n3 = CIPChirality.this.currentRule > 2 ? 0 : this.unlikeDuplicates(cIPAtom);
                    if (n3 != 0) {
                        n2 = n3 * (n + 1);
                        if (CIPChirality.this.doTrack) {
                            CIPChirality.this.data.track(CIPChirality.this, this, cIPAtom, n, n2, false);
                        }
                    } else {
                        int n5 = 0;
                        while (n5 < this.nAtoms) {
                            n3 = this.atoms[n5].checkCurrentRule(cIPAtom.atoms[n5]);
                            if (n3 != 0) {
                                n2 = n3 * (n + 1);
                                if (!CIPChirality.this.doTrack) break;
                                CIPChirality.this.data.track(CIPChirality.this, this.atoms[n5], cIPAtom.atoms[n5], n, n2, false);
                                break;
                            }
                            ++n5;
                        }
                        if (n2 == 0) {
                            this.sortSubstituents(n);
                            cIPAtom.sortSubstituents(n);
                            n5 = 0;
                            int n6 = Integer.MAX_VALUE;
                            while (n5 < this.nAtoms) {
                                int n7;
                                n3 = this.atoms[n5].breakTie(cIPAtom.atoms[n5], n + 1);
                                if (n3 != 0 && (n7 = Math.abs(n3)) < n6) {
                                    n6 = n7;
                                    n2 = n3;
                                }
                                ++n5;
                            }
                        }
                    }
                }
            }
            return n2;
        }

        @Override
        public int compareTo(CIPAtom cIPAtom) {
            int n;
            return CIPChirality.this.root.rule4Ref == 0 ? (cIPAtom == null ? -1 : (this.atom == null != (cIPAtom.atom == null) ? (this.atom == null ? 1 : -1) : ((n = this.compareRule1a(cIPAtom)) != 0 ? n : ((n = this.unlikeDuplicates(cIPAtom)) != 0 ? n : (this.isDuplicate ? this.compareRule1b(cIPAtom) : this.compareRule2(cIPAtom)))))) : (this.sphere < cIPAtom.sphere ? -1 : (this.sphere > cIPAtom.sphere ? 1 : this.chiralPath.compareTo(cIPAtom.chiralPath)));
        }

        private int checkCurrentRule(CIPAtom cIPAtom) {
            switch (CIPChirality.this.currentRule) {
                default: {
                    return this.compareRule1a(cIPAtom);
                }
                case 2: {
                    return this.compareRule1b(cIPAtom);
                }
                case 3: {
                    return this.compareRule2(cIPAtom);
                }
                case 4: {
                    return this.compareRule3(cIPAtom);
                }
                case 5: {
                    return this.compareRules4ac(cIPAtom, " sr SR PM");
                }
                case 6: 
                case 8: {
                    return this.isTerminal || cIPAtom.isTerminal ? 0 : this.compareRule4b5(cIPAtom);
                }
                case 7: {
                    return this.compareRules4ac(cIPAtom, " s r p m");
                }
                case 9: 
            }
            return this.compareRule6(cIPAtom);
        }

        private int unlikeDuplicates(CIPAtom cIPAtom) {
            return cIPAtom.isDuplicate == this.isDuplicate ? 0 : (this.isDuplicate ? 1 : -1);
        }

        private int compareRule1a(CIPAtom cIPAtom) {
            return cIPAtom.atom == null ? -1 : (this.atom == null ? 1 : (cIPAtom.elemNo < this.elemNo ? -1 : (cIPAtom.elemNo > this.elemNo ? 1 : 0)));
        }

        private int compareRule1b(CIPAtom cIPAtom) {
            return Integer.compare(this.rootDistance, cIPAtom.rootDistance);
        }

        private int compareRule2(CIPAtom cIPAtom) {
            return this.atomIndex == cIPAtom.atomIndex ? 0 : (this.getMass() > cIPAtom.getMass() ? -1 : (this.mass < cIPAtom.mass ? 1 : (CIPChirality.this.root.rule6refIndex < 0 ? 0 : (!CIPChirality.this.root.bsRule6Subs.get(this.atomIndex) || !CIPChirality.this.root.bsRule6Subs.get(cIPAtom.atomIndex) ? 0 : (CIPChirality.this.root.rule6refIndex == this.atomIndex ? -1 : (CIPChirality.this.root.rule6refIndex == cIPAtom.atomIndex ? 1 : 0))))));
        }

        private int compareRule3(CIPAtom cIPAtom) {
            return this.isDuplicate || cIPAtom.isDuplicate || !this.parent.isAlkeneAtom2 || !cIPAtom.parent.isAlkeneAtom2 || !this.parent.alkeneParent.isEvenEne || !cIPAtom.parent.alkeneParent.isEvenEne || this.parent == cIPAtom.parent ? 0 : Integer.compare(this.parent.auxEZ, cIPAtom.parent.auxEZ);
        }

        private int compareRules4ac(CIPAtom cIPAtom, String string) {
            int n;
            if (this.isTerminal || this.isDuplicate) {
                return 0;
            }
            int n2 = string.indexOf(this.auxChirality);
            return n2 > (n = string.indexOf(cIPAtom.auxChirality)) + 1 ? -1 : (n > n2 + 1 ? 1 : 0);
        }

        private int compareRule4b5(CIPAtom cIPAtom) {
            int n;
            BS bS;
            BS bS2 = this.getBetter4bList();
            BS bS3 = this.compareLikeUnlike(bS2, bS = cIPAtom.getBetter4bList());
            int n2 = bS3 == null ? Integer.MIN_VALUE : (n = bS3 == bS2 ? -1 : 1);
            if (bS3 != null) {
                if (CIPChirality.this.currentRule == 8 && this.compareLikeUnlike(this.listRS[2], cIPAtom.listRS[2]) == this.listRS[2] == (bS3 == bS2)) {
                    boolean bl = this.parent.isRule5Pseudo = !this.parent.isRule5Pseudo;
                }
                if (CIPChirality.this.doTrack) {
                    CIPChirality.this.data.track(CIPChirality.this, this, cIPAtom, 1, n, false);
                }
            }
            return n;
        }

        private int compareRule6(CIPAtom cIPAtom) {
            return this.atomIndex == CIPChirality.this.root.rule6refIndex == (cIPAtom.atomIndex == CIPChirality.this.root.rule6refIndex) ? 0 : (this.atomIndex == CIPChirality.this.root.rule6refIndex ? -1 : 1);
        }

        void clearRule4Lists() {
            this.listRS = null;
            int n = 0;
            while (n < 4 && this.atoms[n] != null) {
                this.atoms[n].clearRule4Lists();
                ++n;
            }
        }

        private BS getBetter4bList() {
            BS bS;
            if (this.listRS != null) {
                return this.listRS[CIPChirality.this.currentRule == 8 ? 1 : 0];
            }
            BS[] bSArray = new BS[3];
            bSArray[1] = bS = this.rank4bAndRead(null);
            bSArray[2] = this.rank4bAndRead(bS);
            this.listRS = bSArray;
            Logger.info("getBest " + CIPChirality.this.currentRule + " " + this + " " + this.listRS[1] + this.listRS[2] + " " + this.myPath);
            bS = this.compareLikeUnlike(this.listRS[1], this.listRS[2]);
            this.listRS[0] = CIPChirality.this.currentRule == 8 || bS == null ? this.listRS[1] : bS;
            return this.listRS[0];
        }

        private BS rank4bAndRead(BS bS) {
            boolean bl = bS != null;
            int n = bl ? 2 : 1;
            BS bS2 = new BS();
            Lst<CIPAtom> lst = new Lst<CIPAtom>();
            CIPChirality.this.root.rule4Ref = n;
            this.addChiralAtoms(lst, n);
            Collections.sort(lst);
            CIPChirality.this.root.rule4Ref = 0;
            int n2 = 0;
            int n3 = lst.size();
            while (n2 < n3) {
                if (Logger.debugging) {
                    Logger.info(n + " " + this + " " + ((CIPAtom)lst.get((int)n2)).chiralPath);
                }
                if (((CIPAtom)lst.get((int)n2)).rule4Type == n) {
                    bS2.set(n2);
                }
                ++n2;
            }
            return bS2;
        }

        private void addChiralAtoms(Lst<CIPAtom> lst, int n) {
            if (this.atom == null || this.isTerminal || this.isDuplicate) {
                return;
            }
            if (this.rule4Type != 0) {
                String string = "";
                CIPAtom cIPAtom = this;
                while (cIPAtom != null) {
                    string = String.valueOf((char)(64 + (cIPAtom.priority << 2) + (cIPAtom.rule4Type == 0 ? 0 : (cIPAtom.rule4Type == n ? 1 : 2)))) + string;
                    cIPAtom = cIPAtom.parent;
                    if (cIPAtom == null || cIPAtom.chiralPath == null) continue;
                    string = String.valueOf(cIPAtom.chiralPath) + string;
                    break;
                }
                this.chiralPath = string;
                lst.addLast(this);
            }
            int n2 = 0;
            while (n2 < 4) {
                if (this.atoms[n2] != null) {
                    this.atoms[n2].addChiralAtoms(lst, n);
                }
                ++n2;
            }
        }

        private BS compareLikeUnlike(BS bS, BS bS2) {
            BS bS3 = (BS)bS2.clone();
            bS3.xor(bS);
            int n = bS3.nextSetBit(0);
            return n < 0 ? null : (bS.get(n) ? bS : bS2);
        }

        /*
         * WARNING - void declaration
         */
        boolean createAuxiliaryDescriptors(CIPAtom cIPAtom, CIPAtom[] cIPAtomArray) {
            Object object;
            boolean n2 = false;
            int n3 = 126;
            if (this.atom == null) {
                return false;
            }
            this.setNode();
            int n4 = -1;
            int n5 = 0;
            CIPAtom[] cIPAtomArray2 = new CIPAtom[1];
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = !this.isAlkene && this.nPriorities <= (cIPAtom == null ? 2 : 1);
            int n6 = 0;
            while (n6 < 4) {
                object = this.atoms[n6];
                if (object != null && !((CIPAtom)object).isDuplicate && !((CIPAtom)object).isTerminal) {
                    cIPAtomArray2[0] = null;
                    boolean n = ((CIPAtom)object).createAuxiliaryDescriptors((CIPAtom)(cIPAtom == null ? object : cIPAtom), cIPAtomArray2);
                    if (cIPAtomArray2[0] != null && cIPAtomArray != null) {
                        cIPAtomArray[0] = this.nextChiralBranch = ((CIPAtom)object).nextChiralBranch;
                    }
                    if (((CIPAtom)object).nextChiralBranch != null || n) {
                        ++n5;
                        n2 = n;
                        bl2 = true;
                    } else {
                        if (!bl3 && !bl2 && this.priorities[n6] == this.priorities[n6 - 1]) {
                            return false;
                        }
                        bl2 = false;
                    }
                }
                ++n6;
            }
            n6 = n5 >= 2 ? 1 : 0;
            switch (n5) {
                case 0: {
                    n2 = false;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = false;
                    if (cIPAtomArray == null) break;
                    cIPAtomArray[0] = this.nextChiralBranch = this;
                }
            }
            if (this.isAlkene) {
                if (!(this.alkeneChild == null || this.isEvenEne && (this.auxEZ != 15 && this.auxEZ != -1 || this.isKekuleAmbiguous || this.alkeneChild.bondCount < 2))) {
                    n4 = this.getAuxEneWinnerChirality(this, this.alkeneChild, !this.isEvenEne, (int[])(object = (Object)(this.isEvenEne ? new int[1] : null)));
                    if (n4 == 0) {
                        this.alkeneChild.auxEZ = 15;
                        this.auxEZ = 15;
                    } else {
                        n2 = true;
                        if (object != null && object[0] != 8) {
                            this.auxEZ = this.alkeneChild.auxEZ = n4;
                            if (Logger.debuggingHigh) {
                                Logger.info("alkene type " + this + " " + (this.auxEZ == 14 ? "E" : "Z"));
                            }
                        } else if (n6 == 0) {
                            switch (n4) {
                                case 13: 
                                case 17: {
                                    n4 = 1;
                                    n3 = 82;
                                    n2 = true;
                                    break;
                                }
                                case 14: 
                                case 18: {
                                    n4 = 2;
                                    n3 = 83;
                                    n2 = true;
                                }
                            }
                            this.auxChirality = (char)n3;
                            this.rule4Type = n4;
                        }
                    }
                }
            } else if (this.isSP3 && cIPAtomArray != null) {
                object = (CIPAtom)this.clone();
                if (((CIPAtom)object).setNode()) {
                    void var13_15;
                    super.addReturnPath(null, this);
                    boolean bl4 = true;
                    while (var13_15 <= 9) {
                        if ((!bl || var13_15 < 5 || var13_15 > 8) && super.auxSort((int)var13_15)) break;
                        ++var13_15;
                    }
                    if (var13_15 > 9) {
                        n3 = 126;
                    } else {
                        n4 = CIPChirality.this.data.checkHandedness((CIPAtom)object);
                        n2 |= n4 != 0;
                        int n = n4 == 1 ? 82 : (n3 = n4 == 2 ? 83 : 126);
                        if (var13_15 == 8) {
                            int n7 = n3 == 82 ? 114 : (n3 = n3 == 83 ? 115 : 126);
                            if (n4 != 0) {
                                CIPChirality.this.havePseudoAuxiliary = true;
                            }
                        } else {
                            this.rule4Type = n4;
                        }
                    }
                }
                this.auxChirality = n3;
            }
            if (cIPAtom == null) {
                CIPChirality.this.bsNeedRule.setBitTo(5, n5 > 0);
            }
            if (n3 != 126) {
                Logger.info("creating aux " + (char)n3 + " for " + this + (this.myPath.length() == 0 ? "" : " = " + this.myPath));
            }
            this.isChiralPath = n2;
            return this.isChiralPath;
        }

        private boolean auxSort(int n) {
            int n2 = CIPChirality.this.currentRule;
            CIPChirality.this.currentRule = n;
            int n3 = CIPChirality.this.root.rule6refIndex;
            int n4 = CIPChirality.this.root.nRootDuplicates;
            boolean bl = n == 9 ? this.getRule6Descriptor(true) != 0 : this.sortSubstituents(0);
            CIPChirality.this.root.nRootDuplicates = n4;
            CIPChirality.this.root.rule6refIndex = n3;
            CIPChirality.this.currentRule = n2;
            return bl;
        }

        private int getAuxEneWinnerChirality(CIPAtom cIPAtom, CIPAtom cIPAtom2, boolean bl, int[] nArray) {
            CIPAtom cIPAtom3;
            if (bl && cIPAtom.nextSP2 == cIPAtom2) {
                return 0;
            }
            CIPAtom cIPAtom4 = this.getAuxEneEndWinner(cIPAtom, cIPAtom.nextSP2, null);
            CIPAtom cIPAtom5 = cIPAtom3 = cIPAtom4 == null || cIPAtom4.atom == null ? null : this.getAuxEneEndWinner(cIPAtom2, cIPAtom2.nextSP2, nArray);
            if (Logger.debuggingHigh) {
                Logger.info(this + " alkene end winners " + cIPAtom4 + cIPAtom3);
            }
            return CIPChirality.this.getEneChirality(cIPAtom4, cIPAtom, cIPAtom2, cIPAtom3, bl, false);
        }

        private CIPAtom getAuxEneEndWinner(CIPAtom cIPAtom, CIPAtom cIPAtom2, int[] nArray) {
            CIPAtom cIPAtom3 = (CIPAtom)cIPAtom.clone();
            if (cIPAtom3.parent != cIPAtom2) {
                cIPAtom3.addReturnPath(cIPAtom2, cIPAtom);
            }
            int n = 1;
            while (n <= 9) {
                if (cIPAtom3.auxSort(n)) {
                    int n2 = 0;
                    while (n2 < 4) {
                        CIPAtom cIPAtom4 = cIPAtom3.atoms[n2];
                        if (!cIPAtom4.multipleBondDuplicate && cIPAtom3.priorities[n2] != cIPAtom3.priorities[n2 + 1]) {
                            if (nArray != null) {
                                nArray[0] = n;
                            }
                            return cIPAtom4.atom == null ? null : cIPAtom4;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            return null;
        }

        private void addReturnPath(CIPAtom cIPAtom, CIPAtom cIPAtom2) {
            Lst<CIPAtom> lst = new Lst<CIPAtom>();
            CIPAtom cIPAtom3 = this;
            CIPAtom cIPAtom4 = cIPAtom2;
            CIPAtom cIPAtom5 = cIPAtom;
            while (cIPAtom4.parent != null && cIPAtom4.parent.atoms[0] != null) {
                if (Logger.debuggingHigh) {
                    Logger.info("path:" + cIPAtom4.parent + "->" + cIPAtom4);
                }
                cIPAtom4 = cIPAtom4.parent;
                lst.addLast(cIPAtom4);
            }
            lst.addLast(null);
            int n = 0;
            int n2 = lst.size();
            while (n < n2) {
                cIPAtom4 = (CIPAtom)lst.get(n);
                CIPAtom cIPAtom6 = cIPAtom4 == null ? new CIPAtom().create(null, this, this.isAlkene, true, false) : (CIPAtom)cIPAtom4.clone();
                cIPAtom6.nPriorities = 0;
                cIPAtom6.sphere = cIPAtom3.sphere + 1;
                cIPAtom3.replaceParentSubstituent(cIPAtom5, cIPAtom, cIPAtom6);
                if (n > 0 && cIPAtom3.isAlkene && !cIPAtom3.isAlkeneAtom2) {
                    if (cIPAtom.isAlkeneAtom2) {
                        cIPAtom.isAlkeneAtom2 = false;
                        cIPAtom3.alkeneParent = cIPAtom;
                    }
                    cIPAtom3.setEne();
                }
                cIPAtom = cIPAtom3;
                cIPAtom3 = cIPAtom6;
                cIPAtom5 = cIPAtom2;
                cIPAtom2 = cIPAtom4;
                ++n;
            }
        }

        private void replaceParentSubstituent(CIPAtom cIPAtom, CIPAtom cIPAtom2, CIPAtom cIPAtom3) {
            int n = 0;
            while (n < 4) {
                if (this.atoms[n] == cIPAtom || cIPAtom2 == null && this.atoms[n].atom == null) {
                    if (Logger.debuggingHigh) {
                        Logger.info("reversed: " + cIPAtom2 + "->" + this + "->" + cIPAtom3);
                    }
                    this.parent = cIPAtom2;
                    this.atoms[n] = cIPAtom3;
                    Arrays.sort(this.atoms);
                    break;
                }
                ++n;
            }
        }

        private int sign(int n) {
            return n < 0 ? -1 : (n > 0 ? 1 : 0);
        }

        public Object clone() {
            CIPAtom cIPAtom = null;
            try {
                cIPAtom = (CIPAtom)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            cIPAtom.id = CIPChirality.this.ptIDLogger++;
            cIPAtom.atoms = new CIPAtom[4];
            int n = 0;
            while (n < 4) {
                cIPAtom.atoms[n] = this.atoms[n];
                ++n;
            }
            cIPAtom.priorities = new int[4];
            cIPAtom.htPathPoints = this.htPathPoints;
            cIPAtom.alkeneParent = null;
            cIPAtom.auxEZ = -1;
            cIPAtom.rule4Type = 0;
            cIPAtom.listRS = null;
            if (Logger.debuggingHigh) {
                cIPAtom.myPath = cIPAtom.toString();
            }
            return cIPAtom;
        }

        public String toString() {
            if (this.atom == null) {
                return "<null>";
            }
            if (Logger.debuggingHigh) {
                return "[" + CIPChirality.this.currentRule + "." + this.sphere + "," + this.id + "." + (this.isDuplicate ? this.parent.atom : this.atom).getAtomName() + (this.isDuplicate ? "*(" + this.rootDistance + ")" : "") + (this.auxChirality == '~' ? "" : "" + this.auxChirality) + " " + this.elemNo + "]";
            }
            return this.isDuplicate ? "(" + this.atom.getAtomName() + "." + this.rootDistance + ")" : this.atom.getAtomName();
        }
    }
}

