/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.analyser.ImageReader;

public class GIFReader
implements ImageReader {
    private static final int GIF_SIG_LENGTH = 10;

    public FopImage.ImageInfo verifySignature(String uri, InputStream bis, FOUserAgent ua) throws IOException {
        boolean supported;
        byte[] header = this.getDefaultHeader(bis);
        boolean bl = supported = header[0] == 71 && header[1] == 73 && header[2] == 70 && header[3] == 56 && (header[4] == 55 || header[4] == 57) && header[5] == 97;
        if (supported) {
            FopImage.ImageInfo info = new FopImage.ImageInfo();
            info.dpiVertical = info.dpiHorizontal = (double)ua.getFactory().getSourceResolution();
            this.getDimension(header, info);
            info.originalURI = uri;
            info.mimeType = this.getMimeType();
            info.inputStream = bis;
            return info;
        }
        return null;
    }

    public String getMimeType() {
        return "image/gif";
    }

    private void getDimension(byte[] header, FopImage.ImageInfo info) {
        int byte1 = header[6] & 0xFF;
        int byte2 = header[7] & 0xFF;
        info.width = (byte2 << 8 | byte1) & 0xFFFF;
        byte1 = header[8] & 0xFF;
        byte2 = header[9] & 0xFF;
        info.height = (byte2 << 8 | byte1) & 0xFFFF;
    }

    private byte[] getDefaultHeader(InputStream imageStream) throws IOException {
        byte[] header = new byte[10];
        try {
            imageStream.mark(11);
            imageStream.read(header);
            imageStream.reset();
        }
        catch (IOException ex) {
            try {
                imageStream.reset();
            }
            catch (IOException exbis) {
                // empty catch block
            }
            throw ex;
        }
        return header;
    }
}

