/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.regex.PatternSyntaxException;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IRelationMember;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.ConditionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.Subpart;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public interface Selector {
    public boolean matches(Environment var1);

    public Subpart getSubpart();

    public Range getRange();

    public Selector optimizedBaseCheck();

    public static class OptimizedGeneralSelector
    extends AbstractSelector {
        public final String base;
        public final Range range;
        public final Subpart subpart;

        public OptimizedGeneralSelector(String base, Pair<Integer, Integer> zoom, List<Condition> conds, Subpart subpart) {
            super(conds);
            this.base = base;
            if (zoom != null) {
                int b;
                int a = zoom.a == null ? 0 : (Integer)zoom.a;
                int n = b = zoom.b == null ? Integer.MAX_VALUE : (Integer)zoom.b;
                this.range = a <= b ? OptimizedGeneralSelector.fromLevel(a, b) : Range.ZERO_TO_INFINITY;
            } else {
                this.range = Range.ZERO_TO_INFINITY;
            }
            this.subpart = subpart != null ? subpart : Subpart.DEFAULT_SUBPART;
        }

        public OptimizedGeneralSelector(String base, Range range, List<Condition> conds, Subpart subpart) {
            super(conds);
            this.base = base;
            this.range = range;
            this.subpart = subpart != null ? subpart : Subpart.DEFAULT_SUBPART;
        }

        public OptimizedGeneralSelector(GeneralSelector s) {
            this(s.base, s.range, (List<Condition>)s.conds, s.subpart);
        }

        @Override
        public Subpart getSubpart() {
            return this.subpart;
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        public String getBase() {
            return this.base;
        }

        public boolean matchesBase(OsmPrimitiveType type) {
            if ("*".equals(this.base)) {
                return true;
            }
            if (OsmPrimitiveType.NODE == type) {
                return "node".equals(this.base);
            }
            if (OsmPrimitiveType.WAY == type) {
                return "way".equals(this.base) || "area".equals(this.base);
            }
            if (OsmPrimitiveType.RELATION == type) {
                return "area".equals(this.base) || "relation".equals(this.base) || "canvas".equals(this.base);
            }
            return false;
        }

        public boolean matchesBase(IPrimitive p) {
            if (!this.matchesBase(p.getType())) {
                return false;
            }
            if (p instanceof IRelation) {
                if ("area".equals(this.base)) {
                    return ((IRelation)p).isMultipolygon();
                }
                if ("canvas".equals(this.base)) {
                    return p.get("#canvas") != null;
                }
            }
            return true;
        }

        public boolean matchesBase(Environment e) {
            return this.matchesBase(e.osm);
        }

        @Override
        public Selector optimizedBaseCheck() {
            throw new UnsupportedOperationException();
        }

        public static Range fromLevel(int a, int b) {
            if (a > b) {
                throw new AssertionError();
            }
            double lower = 0.0;
            double upper = Double.POSITIVE_INFINITY;
            if (b != Integer.MAX_VALUE) {
                lower = OptimizedGeneralSelector.level2scale(b + 1);
            }
            if (a != 0) {
                upper = OptimizedGeneralSelector.level2scale(a);
            }
            return new Range(lower, upper);
        }

        public static double level2scale(int lvl) {
            if (lvl < 0) {
                throw new IllegalArgumentException("lvl must be >= 0 but is " + lvl);
            }
            return Math.PI * 2 * Ellipsoid.WGS84.a / Math.pow(2.0, lvl) / 2.56;
        }

        public static int scale2level(double scale) {
            if (scale < 0.0) {
                throw new IllegalArgumentException("scale must be >= 0 but is " + scale);
            }
            return (int)Math.floor(Math.log(Math.PI * 2 * Ellipsoid.WGS84.a / 2.56 / scale) / Math.log(2.0));
        }

        public String toString() {
            return this.base + (Range.ZERO_TO_INFINITY.equals(this.range) ? "" : this.range) + Utils.join("", this.conds) + (this.subpart != null && this.subpart != Subpart.DEFAULT_SUBPART ? "::" + this.subpart : "");
        }
    }

    public static class GeneralSelector
    extends OptimizedGeneralSelector {
        public GeneralSelector(String base, Pair<Integer, Integer> zoom, List<Condition> conds, Subpart subpart) {
            super(base, zoom, conds, subpart);
        }

        public boolean matchesConditions(Environment e) {
            return super.matches(e);
        }

        @Override
        public Selector optimizedBaseCheck() {
            return new OptimizedGeneralSelector(this);
        }

        @Override
        public boolean matches(Environment e) {
            return this.matchesBase(e) && super.matches(e);
        }
    }

    public static class LinkSelector
    extends AbstractSelector {
        public LinkSelector(List<Condition> conditions) {
            super(conditions);
        }

        @Override
        public boolean matches(Environment env) {
            Utils.ensure(env.isLinkContext(), "Requires LINK context in environment, got ''{0}''", new Object[]{env.getContext()});
            return super.matches(env);
        }

        @Override
        public Subpart getSubpart() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Range getRange() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Selector optimizedBaseCheck() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "LinkSelector{conditions=" + this.conds + '}';
        }
    }

    public static abstract class AbstractSelector
    implements Selector {
        protected final List<Condition> conds;

        protected AbstractSelector(List<Condition> conditions) {
            this.conds = conditions == null || conditions.isEmpty() ? null : conditions;
        }

        @Override
        public boolean matches(Environment env) {
            CheckParameterUtil.ensureParameterNotNull(env, "env");
            if (this.conds == null) {
                return true;
            }
            for (Condition c : this.conds) {
                try {
                    if (c.applies(env)) continue;
                    return false;
                }
                catch (PatternSyntaxException e) {
                    Logging.log(Logging.LEVEL_ERROR, "PatternSyntaxException while applying condition" + c + ':', e);
                    return false;
                }
            }
            return true;
        }

        public List<Condition> getConditions() {
            if (this.conds == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.conds);
        }
    }

    public static class ChildOrParentSelector
    implements Selector {
        public final Selector left;
        public final LinkSelector link;
        public final Selector right;
        public final ChildOrParentSelectorType type;

        public ChildOrParentSelector(Selector a, LinkSelector link, Selector b, ChildOrParentSelectorType type) {
            CheckParameterUtil.ensureParameterNotNull(a, "a");
            CheckParameterUtil.ensureParameterNotNull(b, "b");
            CheckParameterUtil.ensureParameterNotNull(link, "link");
            CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
            this.left = a;
            this.link = link;
            this.right = b;
            this.type = type;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(Environment e) {
            block29: {
                block28: {
                    if (!this.right.matches(e)) {
                        return false;
                    }
                    if (ChildOrParentSelectorType.ELEMENT_OF == this.type) {
                        ContainsFinder containsFinder;
                        if (e.osm instanceof INode || e.osm.getDataSet() == null) {
                            return false;
                        }
                        try {
                            if (!(e.osm instanceof IWay) || this.right instanceof OptimizedGeneralSelector && !((OptimizedGeneralSelector)this.right).matchesBase(OsmPrimitiveType.RELATION)) {
                                throw new NoSuchElementException();
                            }
                            SubclassFilteredCollection subclassFilteredCollection = Utils.filteredCollection(SubclassFilteredCollection.filter(e.osm.getReferrers(), p -> p.hasTag("type", "multipolygon")), Relation.class);
                            Relation multipolygon = (Relation)subclassFilteredCollection.iterator().next();
                            if (multipolygon == null) {
                                throw new NoSuchElementException();
                            }
                            final Set<OsmPrimitive> members = multipolygon.getMemberPrimitives();
                            containsFinder = new ContainsFinder(new Environment(multipolygon)){

                                @Override
                                public boolean isPrimitiveUsable(IPrimitive p) {
                                    return super.isPrimitiveUsable(p) && !members.contains(p);
                                }
                            };
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            Logging.trace(noSuchElementException);
                            containsFinder = new ContainsFinder(e);
                        }
                        e.parent = e.osm;
                        if (this.left instanceof OptimizedGeneralSelector) {
                            if (((OptimizedGeneralSelector)this.left).matchesBase(OsmPrimitiveType.NODE)) {
                                ((AbstractFinder)containsFinder).visit(e.osm.getDataSet().searchNodes(e.osm.getBBox()));
                            }
                            if (((OptimizedGeneralSelector)this.left).matchesBase(OsmPrimitiveType.WAY)) {
                                ((AbstractFinder)containsFinder).visit(e.osm.getDataSet().searchWays(e.osm.getBBox()));
                            }
                        } else {
                            ((AbstractFinder)containsFinder).visit(e.osm.getDataSet().allPrimitives());
                        }
                        return e.child != null;
                    }
                    if (ChildOrParentSelectorType.CROSSING == this.type && e.osm instanceof IWay) {
                        e.parent = e.osm;
                        CrossingFinder crossingFinder = new CrossingFinder(e);
                        if (this.right instanceof OptimizedGeneralSelector && ((OptimizedGeneralSelector)this.right).matchesBase(OsmPrimitiveType.WAY)) {
                            ((AbstractFinder)crossingFinder).visit(e.osm.getDataSet().searchWays(e.osm.getBBox()));
                        }
                        return e.child != null;
                    }
                    if (ChildOrParentSelectorType.SIBLING != this.type) break block28;
                    if (!(e.osm instanceof INode)) break block29;
                    for (IPrimitive iPrimitive : e.osm.getReferrers(true)) {
                        Object n;
                        Environment e2;
                        IWay w;
                        int i;
                        if (!(iPrimitive instanceof IWay) || (i = (w = (IWay)iPrimitive).getNodes().indexOf(e.osm)) - 1 < 0 || !this.left.matches(e2 = e.withPrimitive((IPrimitive)(n = w.getNode(i - 1))).withParent(w).withChild(e.osm)) || !this.link.matches(e2.withLinkContext())) continue;
                        e.child = n;
                        e.index = i;
                        e.count = w.getNodesCount();
                        e.parent = w;
                        return true;
                    }
                    break block29;
                }
                if (ChildOrParentSelectorType.CHILD == this.type && this.link.conds != null && !this.link.conds.isEmpty() && this.link.conds.get(0) instanceof ConditionFactory.OpenEndPseudoClassCondition) {
                    if (e.osm instanceof INode) {
                        e.osm.visitReferrers(new MultipolygonOpenEndFinder(e));
                        return e.parent != null;
                    }
                } else if (ChildOrParentSelectorType.CHILD == this.type) {
                    MatchingReferrerFinder collector = new MatchingReferrerFinder(e);
                    e.osm.visitReferrers(collector);
                    if (e.parent != null) {
                        return true;
                    }
                } else if (ChildOrParentSelectorType.PARENT == this.type) {
                    if (e.osm instanceof IWay) {
                        void var3_6;
                        List wayNodes = ((IWay)e.osm).getNodes();
                        boolean bl = false;
                        while (var3_6 < wayNodes.size()) {
                            INode n = (INode)wayNodes.get((int)var3_6);
                            if (this.left.matches(e.withPrimitive(n)) && this.link.matches(e.withChildAndIndexAndLinkContext(n, (int)var3_6, wayNodes.size()))) {
                                e.child = n;
                                e.index = (int)var3_6;
                                e.count = wayNodes.size();
                                return true;
                            }
                            ++var3_6;
                        }
                    } else if (e.osm instanceof IRelation) {
                        void var3_8;
                        List members = ((IRelation)e.osm).getMembers();
                        boolean bl = false;
                        while (var3_8 < members.size()) {
                            Object member = ((IRelationMember)members.get((int)var3_8)).getMember();
                            if (this.left.matches(e.withPrimitive((IPrimitive)member)) && this.link.matches(e.withChildAndIndexAndLinkContext((IPrimitive)member, (int)var3_8, members.size()))) {
                                e.child = member;
                                e.index = (int)var3_8;
                                e.count = members.size();
                                return true;
                            }
                            ++var3_8;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public Subpart getSubpart() {
            return this.right.getSubpart();
        }

        @Override
        public Range getRange() {
            return this.right.getRange();
        }

        @Override
        public Selector optimizedBaseCheck() {
            return new ChildOrParentSelector(this.left, this.link, this.right.optimizedBaseCheck(), this.type);
        }

        public String toString() {
            return this.left.toString() + ' ' + (ChildOrParentSelectorType.PARENT == this.type ? (char)'<' : '>') + this.link + ' ' + this.right;
        }

        private class ContainsFinder
        extends AbstractFinder {
            protected ContainsFinder(Environment e) {
                super(e);
                CheckParameterUtil.ensureThat(!(e.osm instanceof INode), "Nodes not supported");
            }

            @Override
            public void visit(INode n) {
                if (this.e.child == null && ChildOrParentSelector.this.left.matches(new Environment(n).withParent(this.e.osm)) && (this.e.osm instanceof IWay && Geometry.nodeInsidePolygon(n, ((IWay)this.e.osm).getNodes()) || this.e.osm instanceof Relation && ((Relation)this.e.osm).isMultipolygon() && Geometry.isNodeInsideMultiPolygon(n, (Relation)this.e.osm, null))) {
                    this.e.child = n;
                }
            }

            @Override
            public void visit(IWay<?> w) {
                if (this.e.child == null && ChildOrParentSelector.this.left.matches(new Environment(w).withParent(this.e.osm)) && (this.e.osm instanceof IWay && Geometry.PolygonIntersection.FIRST_INSIDE_SECOND.equals((Object)Geometry.polygonIntersection(w.getNodes(), ((IWay)this.e.osm).getNodes())) || this.e.osm instanceof Relation && ((Relation)this.e.osm).isMultipolygon() && Geometry.isPolygonInsideMultiPolygon(w.getNodes(), (Relation)this.e.osm, null))) {
                    this.e.child = w;
                }
            }
        }

        private final class CrossingFinder
        extends AbstractFinder {
            private final String layer;

            private CrossingFinder(Environment e) {
                super(e);
                CheckParameterUtil.ensureThat(e.osm instanceof IWay, "Only ways are supported");
                this.layer = OsmUtils.getLayer(e.osm);
            }

            @Override
            public void visit(IWay<?> w) {
                if (this.e.child == null && Objects.equals(this.layer, OsmUtils.getLayer(w)) && ChildOrParentSelector.this.left.matches(new Environment(w).withParent(this.e.osm)) && this.e.osm instanceof IWay && Geometry.PolygonIntersection.CROSSING.equals((Object)Geometry.polygonIntersection(w.getNodes(), ((IWay)this.e.osm).getNodes()))) {
                    this.e.child = w;
                }
            }
        }

        private class MultipolygonOpenEndFinder
        extends AbstractFinder {
            private final PrimitiveVisitor innerVisitor;

            @Override
            public void visit(IWay<?> w) {
                w.visitReferrers(this.innerVisitor);
            }

            MultipolygonOpenEndFinder(Environment e) {
                super(e);
                this.innerVisitor = new AbstractFinder(this.e){

                    @Override
                    public void visit(IRelation<?> r) {
                        List<Node> openEnds;
                        int openEndIndex;
                        if (r instanceof Relation && ChildOrParentSelector.this.left.matches(this.e.withPrimitive(r)) && (openEndIndex = (openEnds = MultipolygonCache.getInstance().get((Relation)r).getOpenEnds()).indexOf(this.e.osm)) >= 0) {
                            this.e.parent = r;
                            this.e.index = openEndIndex;
                            this.e.count = openEnds.size();
                        }
                    }
                };
            }
        }

        private static abstract class AbstractFinder
        implements PrimitiveVisitor {
            protected final Environment e;

            protected AbstractFinder(Environment e) {
                this.e = e;
            }

            @Override
            public void visit(INode n) {
            }

            @Override
            public void visit(IWay<?> w) {
            }

            @Override
            public void visit(IRelation<?> r) {
            }

            public void visit(Collection<? extends IPrimitive> primitives) {
                for (IPrimitive iPrimitive : primitives) {
                    if (this.e.child != null) break;
                    if (!this.isPrimitiveUsable(iPrimitive)) continue;
                    iPrimitive.accept(this);
                }
            }

            public boolean isPrimitiveUsable(IPrimitive p) {
                return !this.e.osm.equals(p) && p.isUsable();
            }
        }

        private class MatchingReferrerFinder
        implements PrimitiveVisitor {
            private final Environment e;

            MatchingReferrerFinder(Environment e) {
                this.e = e;
            }

            @Override
            public void visit(INode n) {
                throw new AssertionError();
            }

            private <T extends IPrimitive> void doVisit(T parent, IntSupplier counter, IntFunction<IPrimitive> getter) {
                if (this.e.parent != null) {
                    return;
                }
                if (!ChildOrParentSelector.this.left.matches(this.e.withPrimitive(parent))) {
                    return;
                }
                int count = counter.getAsInt();
                if (ChildOrParentSelector.this.link.conds == null) {
                    this.e.parent = parent;
                    this.e.count = count;
                    return;
                }
                for (int i = 0; i < count; ++i) {
                    if (!getter.apply(i).equals(this.e.osm) || !ChildOrParentSelector.this.link.matches(this.e.withParentAndIndexAndLinkContext(parent, i, count))) continue;
                    this.e.parent = parent;
                    this.e.index = i;
                    this.e.count = count;
                    return;
                }
            }

            @Override
            public void visit(IWay<?> w) {
                this.doVisit(w, w::getNodesCount, w::getNode);
            }

            @Override
            public void visit(IRelation<?> r) {
                this.doVisit(r, r::getMembersCount, i -> r.getMember(i).getMember());
            }
        }
    }

    public static enum ChildOrParentSelectorType {
        CHILD,
        PARENT,
        ELEMENT_OF,
        CROSSING,
        SIBLING;

    }
}

