/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubySymbol;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class NonlocalReturnInstr
extends ReturnBase
implements FixedArityInstr {
    public final RubySymbol methodName;

    public NonlocalReturnInstr(Operand returnValue, RubySymbol methodName) {
        super(Operation.NONLOCAL_RETURN, returnValue);
        this.methodName = methodName;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.methodName};
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        scope.getFlags().add(IRFlags.HAS_NONLOCAL_RETURNS);
        return true;
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new NonlocalReturnInstr(this.getReturnValue().cloneForInlining(info), this.methodName);
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.isClosure()) {
            if (ii.getHostScope() instanceof IRMethod) {
                if (((InlineCloneInfo)info).getScopeBeingInlined().isScopeContainedBy(ii.getHostScope())) {
                    return new ReturnInstr(this.getReturnValue().cloneForInlining(ii));
                }
                Variable v = ii.getCallResultVariable();
                return v == null ? null : new CopyInstr(v, this.getReturnValue().cloneForInlining(ii));
            }
            return new NonlocalReturnInstr(this.getReturnValue().cloneForInlining(ii), this.methodName);
        }
        throw new UnsupportedOperationException("Nonlocal returns shouldn't show up outside closures.");
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getReturnValue());
        e.encode(this.methodName);
    }

    public static NonlocalReturnInstr decode(IRReaderDecoder d) {
        return new NonlocalReturnInstr(d.decodeOperand(), d.decodeSymbol());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.NonlocalReturnInstr(this);
    }
}

