/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.io.File;
import java.io.RandomAccessFile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.server.generator.MapLoader;

public class ColonizationMapLoader
implements MapLoader {
    public static final int WIDTH = 0;
    public static final int HEIGHT = 2;
    public static final int OCEAN = 25;
    public static final int HIGH_SEAS = 26;
    private static final String[] tiletypes = new String[]{"tundra", "desert", "plains", "prairie", "grassland", "savannah", "marsh", "swamp", "borealForest", "scrubForest", "mixedForest", "broadleafForest", "coniferForest", "tropicalForest", "wetlandForest", "rainForest", "borealForest", "scrubForest", "mixedForest", "broadleafForest", "coniferForest", "tropicalForest", "wetlandForest", "rainForest", "arctic", "ocean", "highSeas"};
    private static final byte[] header = new byte[]{58, 0, 72, 0, 4, 0};
    private static byte[] layer1;

    public ColonizationMapLoader(File file) throws Exception {
        RandomAccessFile reader = new RandomAccessFile(file, "r");
        reader.read(header);
        int size = header[0] * header[2];
        layer1 = new byte[size];
        reader.read(layer1);
    }

    @Override
    public Map.Layer loadMap(Game game, Map.Layer layer) {
        Specification spec = game.getSpecification();
        Tile[][] tiles = new Tile[header[0]][header[2]];
        Map.Layer highestLayer = layer.compareTo(this.getHighestLayer()) < 0 ? layer : this.getHighestLayer();
        int index = 0;
        TileType tileType = null;
        if (highestLayer == Map.Layer.LAND) {
            for (int y = 0; y < header[2]; ++y) {
                for (int x = 0; x < header[0]; ++x) {
                    int decimal = layer1[index] & 0xFF;
                    int terrain = decimal & 0x1F;
                    tileType = terrain == 25 || terrain == 26 ? TileType.WATER : TileType.LAND;
                    ++index;
                }
            }
        } else {
            TileImprovementType riverType = spec.getTileImprovementType("model.improvement.river");
            for (int y = 0; y < header[2]; ++y) {
                for (int x = 0; x < header[0]; ++x) {
                    int decimal = layer1[index] & 0xFF;
                    int terrain = decimal & 0x1F;
                    int overlay = decimal >> 5;
                    if (terrain < tiletypes.length) {
                        tileType = spec.getTileType("model.tile." + tiletypes[terrain]);
                    } else if (overlay == 1 || overlay == 3) {
                        tileType = spec.getTileType("model.tile.hills");
                    } else if (overlay == 5 || overlay == 7) {
                        tileType = spec.getTileType("model.tile.mountains");
                    }
                    tiles[x][y] = new Tile(game, tileType, x, y);
                    if (highestLayer == Map.Layer.RIVERS && (overlay == 2 || overlay == 3 || overlay == 6 || overlay == 7)) {
                        TileItemContainer container = new TileItemContainer(game, tiles[x][y]);
                        TileImprovement river = new TileImprovement(game, tiles[x][y], riverType);
                        river.setMagnitude(overlay <= 3 ? 1 : 2);
                        container.addTileItem(river);
                        tiles[x][y].setTileItemContainer(container);
                    }
                    ++index;
                }
            }
        }
        return highestLayer;
    }

    @Override
    public Map.Layer getHighestLayer() {
        return Map.Layer.RIVERS;
    }
}

