/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComboBox;
import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.BoundariesPanel;
import com.lightdev.app.shtm.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;

class ListPanel
extends JPanel
implements AttributeComponent {
    private final AttributeComboBox listType;
    private final AttributeComboBox listPosition;
    private final BoundariesPanel bndPanel;
    private String listTag;

    public ListPanel() {
        this.setLayout(new BorderLayout());
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel formatPanel = new JPanel(g);
        Util.addGridBagComponent(formatPanel, new JLabel(Util.getResourceString("listTypeLabel")), g, c, 0, 0, 13);
        String[] items = new String[]{Util.getResourceString("listTypeNone"), Util.getResourceString("listTypeDecimal"), Util.getResourceString("listTypeLowerRoman"), Util.getResourceString("listTypeUpperRoman"), Util.getResourceString("listTypeLowerAlpha"), Util.getResourceString("listTypeUpperAlpha"), Util.getResourceString("listTypeDisc"), Util.getResourceString("listTypeCircle"), Util.getResourceString("listTypeSquare")};
        String[] names = new String[]{"none", "decimal", "lower-roman", "upper-roman", "lower-alpha", "upper-alpha", "disc", "circle", "square"};
        this.listType = new AttributeComboBox(items, names, CSS.Attribute.LIST_STYLE_TYPE, null);
        Util.addGridBagComponent(formatPanel, this.listType, g, c, 1, 0, 17);
        Util.addGridBagComponent(formatPanel, new JLabel(Util.getResourceString("listPositionLabel")), g, c, 0, 1, 13);
        items = new String[]{Util.getResourceString("listPosInside"), Util.getResourceString("listPosOutside")};
        names = new String[]{"inside", "outside"};
        this.listPosition = new AttributeComboBox(items, names, CSS.Attribute.LIST_STYLE_POSITION, null);
        Util.addGridBagComponent(formatPanel, this.listPosition, g, c, 1, 1, 17);
        this.bndPanel = new BoundariesPanel(CSS.Attribute.MARGIN);
        this.bndPanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("listIndentTitle")));
        this.add((Component)formatPanel, "Center");
        this.add((Component)this.bndPanel, "South");
    }

    public String getListTag() {
        return this.listTag;
    }

    private void setTagFromType() {
        int index = this.listType.getSelectedIndex();
        this.listTag = index > 5 ? HTML.Tag.UL.toString() : (index > 0 ? HTML.Tag.OL.toString() : null);
    }

    public boolean setValue(AttributeSet a) {
        Object name = a.getAttribute(StyleConstants.NameAttribute);
        if (name != null) {
            this.listTag = name.toString();
        }
        this.listType.setValue(a);
        this.listPosition.setValue(a);
        this.bndPanel.setValue(a);
        return true;
    }

    public AttributeSet getValue() {
        this.setTagFromType();
        SimpleAttributeSet set = new SimpleAttributeSet();
        set.addAttributes(this.listType.getValue());
        set.addAttributes(this.listPosition.getValue());
        set.addAttributes(this.bndPanel.getValue());
        return set;
    }

    public AttributeSet getValue(boolean includeUnchanged) {
        if (includeUnchanged) {
            this.setTagFromType();
            SimpleAttributeSet set = new SimpleAttributeSet();
            set.addAttributes(this.listType.getValue(includeUnchanged));
            set.addAttributes(this.listPosition.getValue(includeUnchanged));
            set.addAttributes(this.bndPanel.getValue(includeUnchanged));
            return set;
        }
        return this.getValue();
    }
}

