/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileFilter;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.DeepListener;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;

final class FileChangeImpl
extends WeakReference<FileChangeListener>
implements FileChangeListener,
Runnable {
    private static final Map<FileChangeListener, Map<File, FileChangeImpl>> holders = new WeakHashMap<FileChangeListener, Map<File, FileChangeImpl>>();
    private final File path;
    private FileObject current;
    private File currentF;
    private boolean isOnTarget = false;

    public FileChangeImpl(FileChangeListener listener, File path) {
        super(listener, BaseUtilities.activeReferenceQueue());
        assert (path != null);
        this.path = path;
    }

    void locateCurrent() {
        FileObject oldCurrent;
        block4: {
            oldCurrent = this.current;
            this.currentF = FileUtil.normalizeFile(this.path);
            do {
                this.current = FileUtil.toFileObject(this.currentF);
                if (this.current != null) break block4;
                this.currentF = this.currentF.getParentFile();
            } while (this.currentF != null);
            return;
        }
        this.isOnTarget = this.path.equals(this.currentF);
        assert (this.current != null);
        if (this.current != oldCurrent) {
            if (oldCurrent != null) {
                oldCurrent.removeFileChangeListener(this);
            }
            this.current.addFileChangeListener(this);
            this.current.getChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void someChange() {
        FileObject currentNew;
        boolean wasOnTarget;
        FileChangeListener listener;
        FileChangeImpl fileChangeImpl = this;
        synchronized (fileChangeImpl) {
            if (this.current == null) {
                return;
            }
            listener = (FileChangeListener)this.get();
            if (listener == null) {
                return;
            }
            wasOnTarget = this.isOnTarget;
            this.locateCurrent();
            currentNew = this.current;
        }
        if (this.isOnTarget && !wasOnTarget) {
            if (currentNew.isFolder()) {
                listener.fileFolderCreated(new FileEvent(currentNew));
            } else {
                listener.fileDataCreated(new FileEvent(currentNew));
            }
        }
    }

    @Override
    public void fileChanged(FileEvent fe) {
        if (fe.getSource() == this.current) {
            if (this.isOnTarget) {
                FileChangeListener listener = (FileChangeListener)this.get();
                if (listener instanceof DeepListener) {
                    ((DeepListener)listener).fileChanged(fe, true);
                } else if (listener != null) {
                    listener.fileChanged(fe);
                }
            } else {
                this.someChange();
            }
        }
    }

    @Override
    public void fileDeleted(FileEvent fe) {
        if (fe.getSource() == this.current) {
            if (this.isOnTarget) {
                FileChangeListener listener = (FileChangeListener)this.get();
                if (listener instanceof DeepListener) {
                    ((DeepListener)listener).fileDeleted(fe, true);
                } else if (listener != null) {
                    listener.fileDeleted(fe);
                }
            }
            this.someChange();
        }
    }

    @Override
    public void fileDataCreated(FileEvent fe) {
        if (fe.getSource() == this.current) {
            if (this.isOnTarget) {
                FileChangeListener listener = (FileChangeListener)this.get();
                if (listener instanceof DeepListener) {
                    ((DeepListener)listener).fileDataCreated(fe, true);
                } else if (listener != null) {
                    listener.fileDataCreated(fe);
                }
            } else {
                this.someChange();
            }
        }
    }

    @Override
    public void fileFolderCreated(FileEvent fe) {
        if (fe.getSource() == this.current) {
            if (this.isOnTarget) {
                FileChangeListener listener = (FileChangeListener)this.get();
                if (listener instanceof DeepListener) {
                    ((DeepListener)listener).fileFolderCreated(fe, true);
                } else if (listener != null) {
                    listener.fileFolderCreated(fe);
                }
            } else {
                this.someChange();
            }
        }
    }

    @Override
    public void fileRenamed(FileRenameEvent fe) {
        if (fe.getSource() == this.current) {
            if (this.isOnTarget) {
                FileChangeListener listener = (FileChangeListener)this.get();
                if (listener instanceof DeepListener) {
                    ((DeepListener)listener).fileRenamed(fe, true);
                } else if (listener != null) {
                    listener.fileRenamed(fe);
                }
            }
            this.someChange();
        }
    }

    @Override
    public void fileAttributeChanged(FileAttributeEvent fe) {
        FileChangeListener listener;
        if (fe.getSource() == this.current && this.isOnTarget && (listener = (FileChangeListener)this.get()) != null) {
            listener.fileAttributeChanged(fe);
        }
    }

    @Override
    public synchronized void run() {
        if (this.current != null) {
            this.current.removeFileChangeListener(this);
            this.current = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addFileChangeListenerImpl(Logger logger, FileChangeListener listener, File path) {
        FileChangeImpl holder;
        assert (FileUtil.assertNormalized(path));
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addFileChangeListener {0} @ {1}", new Object[]{listener, path});
        }
        Map<FileChangeListener, Map<File, FileChangeImpl>> map = holders;
        synchronized (map) {
            FileChangeImpl prev;
            Map<File, FileChangeImpl> f2H = holders.get(listener);
            if (f2H == null) {
                f2H = new HashMap<File, FileChangeImpl>();
                holders.put(listener, f2H);
            }
            if ((prev = f2H.get(path)) != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("Already listening to ").append(path);
                sb.append("\nnew listener   : ").append(listener);
                sb.append("\nholder listener: ").append(prev.get());
                throw new IllegalArgumentException(sb.toString());
            }
            holder = new FileChangeImpl(listener, path);
            f2H.put(path, holder);
        }
        holder.locateCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileChangeListener removeFileChangeListenerImpl(Logger logger, FileChangeListener listener, File path) {
        assert (FileUtil.assertNormalized(path, BaseUtilities.isMac()));
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "removeFileChangeListener {0} @ {1}", new Object[]{listener, path});
        }
        Map<FileChangeListener, Map<File, FileChangeImpl>> map = holders;
        synchronized (map) {
            Map<File, FileChangeImpl> f2H = holders.get(listener);
            if (f2H == null) {
                throw new IllegalArgumentException("Was not listening to " + path);
            }
            if (!f2H.containsKey(path)) {
                throw new IllegalArgumentException(listener + " was not listening to " + path + "; only to " + f2H.keySet());
            }
            FileChangeImpl h = f2H.remove(path);
            if (f2H.isEmpty()) {
                holders.remove(listener);
            }
            h.run();
            return (FileChangeListener)h.get();
        }
    }

    static DeepListener addRecursiveListener(FileChangeListener listener, File path, FileFilter recurseInto, Callable<Boolean> stop) {
        DeepListener deep = new DeepListener(listener, path, recurseInto, stop);
        deep.init();
        FileChangeImpl.addFileChangeListenerImpl(DeepListener.LOG, deep, path);
        return deep;
    }

    static void removeRecursiveListener(FileChangeListener listener, File path) {
        DeepListener deep = new DeepListener(listener, path, null, null);
        DeepListener dl = (DeepListener)FileChangeImpl.removeFileChangeListenerImpl(DeepListener.LOG, deep, path);
        dl.run();
    }
}

