/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils;

import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;

public class Attributes {
    public static boolean isTypeAvailable(Class<?> type, TimeRepresentation timeRepresentation) {
        if (AttributeUtils.isDynamicType(type)) {
            switch (timeRepresentation) {
                case INTERVAL: {
                    return Attributes.isIntervalType(type);
                }
                case TIMESTAMP: {
                    return Attributes.isTimestampType(type);
                }
            }
            throw new IllegalArgumentException("Unknown timeRepresentation");
        }
        return true;
    }

    public static boolean isTimestampType(Class<?> type) {
        return TimestampSet.class.isAssignableFrom(type) || TimestampMap.class.isAssignableFrom(type);
    }

    public static boolean isIntervalType(Class<?> type) {
        return IntervalSet.class.isAssignableFrom(type) || IntervalMap.class.isAssignableFrom(type);
    }
}

