/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.datatransfer.OsmTransferHandler;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class AbstractPasteAction
extends JosmAction
implements FlavorListener {
    protected final OsmTransferHandler transferHandler = new OsmTransferHandler();

    public AbstractPasteAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar) {
        this(name, iconName, tooltip, shortcut, registerInToolbar, null);
    }

    public AbstractPasteAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar, String toolbarId) {
        super(name, iconName, tooltip, shortcut, registerInToolbar, toolbarId, true);
        ClipboardUtils.getClipboard().addFlavorListener(this);
    }

    protected EastNorth computePastePosition(ActionEvent e) {
        MapView mapView = MainApplication.getMap().mapView;
        EastNorth mPosition = mapView.getCenter();
        if (e != null && !this.getValue("Name").equals(e.getActionCommand())) {
            try {
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                if (pointerInfo != null) {
                    Point mp = pointerInfo.getLocation();
                    Point tl = mapView.getLocationOnScreen();
                    Point pos = new Point(mp.x - tl.x, mp.y - tl.y);
                    if (mapView.contains(pos)) {
                        mPosition = mapView.getEastNorth(pos.x, pos.y);
                    }
                }
            }
            catch (SecurityException ex) {
                Logging.log(Logging.LEVEL_ERROR, "Unable to get mouse pointer info", ex);
            }
        }
        return mPosition;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doPaste(e, ClipboardUtils.getClipboardContent());
    }

    protected void doPaste(ActionEvent e, Transferable contents) {
        this.transferHandler.pasteOn(this.getLayerManager().getEditLayer(), this.computePastePosition(e), contents);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditDataSet() != null && this.transferHandler != null && this.transferHandler.isDataAvailable());
    }

    @Override
    public void flavorsChanged(FlavorEvent e) {
        this.updateEnabledState();
    }
}

