"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var IO_KEY = Symbol.for('@pm2/io');
var Entrypoint = (function () {
    function Entrypoint() {
        var _this = this;
        try {
            this.io = global[IO_KEY].init(this.conf());
            this.onStart(function (err) {
                if (err) {
                    console.error(err);
                    process.exit(1);
                }
                _this.sensors();
                _this.events();
                _this.actuators();
                _this.io.onExit(function (code, signal) {
                    _this.onStop(err, function () {
                        _this.io.destroy();
                    }, code, signal);
                });
                if (process && process.send)
                    process.send('ready');
            });
        }
        catch (e) {
            if (this.io) {
                this.io.destroy();
            }
            throw (e);
        }
    }
    Entrypoint.prototype.events = function () {
        return;
    };
    Entrypoint.prototype.sensors = function () {
        return;
    };
    Entrypoint.prototype.actuators = function () {
        return;
    };
    Entrypoint.prototype.onStart = function (cb) {
        throw new Error('Entrypoint onStart() not specified');
    };
    Entrypoint.prototype.onStop = function (err, cb, code, signal) {
        return cb();
    };
    Entrypoint.prototype.conf = function () {
        return undefined;
    };
    return Entrypoint;
}());
exports.Entrypoint = Entrypoint;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW50cnlwb2ludC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9mZWF0dXJlcy9lbnRyeXBvaW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBRUEsSUFBTSxNQUFNLEdBQUcsTUFBTSxDQUFDLEdBQUcsQ0FBQyxTQUFTLENBQUMsQ0FBQTtBQUVwQztJQUdFO1FBQUEsaUJBOEJDO1FBN0JDLElBQUk7WUFDRixJQUFJLENBQUMsRUFBRSxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDLENBQUE7WUFFMUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxVQUFBLEdBQUc7Z0JBQ2QsSUFBSSxHQUFHLEVBQUU7b0JBQ1AsT0FBTyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQTtvQkFDbEIsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQTtpQkFDaEI7Z0JBRUQsS0FBSSxDQUFDLE9BQU8sRUFBRSxDQUFBO2dCQUNkLEtBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQTtnQkFDYixLQUFJLENBQUMsU0FBUyxFQUFFLENBQUE7Z0JBRWhCLEtBQUksQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLFVBQUMsSUFBSSxFQUFFLE1BQU07b0JBQzFCLEtBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxFQUFFO3dCQUNmLEtBQUksQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLENBQUE7b0JBQ25CLENBQUMsRUFBRSxJQUFJLEVBQUUsTUFBTSxDQUFDLENBQUE7Z0JBQ2xCLENBQUMsQ0FBQyxDQUFBO2dCQUVGLElBQUksT0FBTyxJQUFJLE9BQU8sQ0FBQyxJQUFJO29CQUFFLE9BQU8sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUE7WUFDcEQsQ0FBQyxDQUFDLENBQUE7U0FDSDtRQUFDLE9BQU8sQ0FBQyxFQUFFO1lBRVYsSUFBSSxJQUFJLENBQUMsRUFBRSxFQUFFO2dCQUNYLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLENBQUE7YUFDbEI7WUFFRCxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUE7U0FDVjtJQUNILENBQUM7SUFFRCwyQkFBTSxHQUFOO1FBQ0UsT0FBTTtJQUNSLENBQUM7SUFFRCw0QkFBTyxHQUFQO1FBQ0UsT0FBTTtJQUNSLENBQUM7SUFFRCw4QkFBUyxHQUFUO1FBQ0UsT0FBTTtJQUNSLENBQUM7SUFFRCw0QkFBTyxHQUFQLFVBQVMsRUFBWTtRQUNuQixNQUFNLElBQUksS0FBSyxDQUFDLG9DQUFvQyxDQUFDLENBQUE7SUFDdkQsQ0FBQztJQUVELDJCQUFNLEdBQU4sVUFBUSxHQUFVLEVBQUUsRUFBWSxFQUFFLElBQVksRUFBRSxNQUFjO1FBQzVELE9BQU8sRUFBRSxFQUFFLENBQUE7SUFDYixDQUFDO0lBRUQseUJBQUksR0FBSjtRQUNFLE9BQU8sU0FBUyxDQUFBO0lBQ2xCLENBQUM7SUFDSCxpQkFBQztBQUFELENBQUMsQUExREQsSUEwREM7QUExRFksZ0NBQVUifQ==