"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var serviceManager_1 = require("../serviceManager");
var Debug = require("debug");
var EventsFeature = (function () {
    function EventsFeature() {
        this.logger = Debug('axm:features:events');
    }
    EventsFeature.prototype.init = function () {
        this.transport = serviceManager_1.ServiceManager.get('transport');
        this.logger('init');
    };
    EventsFeature.prototype.emit = function (name, data) {
        if (typeof name !== 'string') {
            console.error('event name must be a string');
            return console.trace();
        }
        if (typeof data !== 'object') {
            console.error('event data must be an object');
            return console.trace();
        }
        if (data instanceof Array) {
            console.error("event data cannot be an array");
            return console.trace();
        }
        var inflightObj = {};
        try {
            inflightObj = JSON.parse(JSON.stringify(data));
        }
        catch (err) {
            return console.log('Failed to serialize the event data', err.message);
        }
        inflightObj.__name = name;
        if (this.transport === undefined) {
            return this.logger('Failed to send event as transporter isnt available');
        }
        this.transport.send('human:event', inflightObj);
    };
    EventsFeature.prototype.destroy = function () {
        this.logger('destroy');
    };
    return EventsFeature;
}());
exports.EventsFeature = EventsFeature;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXZlbnRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2ZlYXR1cmVzL2V2ZW50cy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLG9EQUFrRDtBQUdsRCw2QkFBOEI7QUFFOUI7SUFBQTtRQUdVLFdBQU0sR0FBYSxLQUFLLENBQUMscUJBQXFCLENBQUMsQ0FBQTtJQXNDekQsQ0FBQztJQXBDQyw0QkFBSSxHQUFKO1FBQ0UsSUFBSSxDQUFDLFNBQVMsR0FBRywrQkFBYyxDQUFDLEdBQUcsQ0FBQyxXQUFXLENBQUMsQ0FBQTtRQUNoRCxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFBO0lBQ3JCLENBQUM7SUFFRCw0QkFBSSxHQUFKLFVBQU0sSUFBYSxFQUFFLElBQVU7UUFDN0IsSUFBSSxPQUFPLElBQUksS0FBSyxRQUFRLEVBQUU7WUFDNUIsT0FBTyxDQUFDLEtBQUssQ0FBQyw2QkFBNkIsQ0FBQyxDQUFBO1lBQzVDLE9BQU8sT0FBTyxDQUFDLEtBQUssRUFBRSxDQUFBO1NBQ3ZCO1FBQ0QsSUFBSSxPQUFPLElBQUksS0FBSyxRQUFRLEVBQUU7WUFDNUIsT0FBTyxDQUFDLEtBQUssQ0FBQyw4QkFBOEIsQ0FBQyxDQUFBO1lBQzdDLE9BQU8sT0FBTyxDQUFDLEtBQUssRUFBRSxDQUFBO1NBQ3ZCO1FBQ0QsSUFBSSxJQUFJLFlBQVksS0FBSyxFQUFFO1lBQ3pCLE9BQU8sQ0FBQyxLQUFLLENBQUMsK0JBQStCLENBQUMsQ0FBQTtZQUM5QyxPQUFPLE9BQU8sQ0FBQyxLQUFLLEVBQUUsQ0FBQTtTQUN2QjtRQUVELElBQUksV0FBVyxHQUFpQixFQUFFLENBQUE7UUFDbEMsSUFBSTtZQUNGLFdBQVcsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQTtTQUMvQztRQUFDLE9BQU8sR0FBRyxFQUFFO1lBQ1osT0FBTyxPQUFPLENBQUMsR0FBRyxDQUFDLG9DQUFvQyxFQUFFLEdBQUcsQ0FBQyxPQUFPLENBQUMsQ0FBQTtTQUN0RTtRQUVELFdBQVcsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFBO1FBQ3pCLElBQUksSUFBSSxDQUFDLFNBQVMsS0FBSyxTQUFTLEVBQUU7WUFDaEMsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLG9EQUFvRCxDQUFDLENBQUE7U0FDekU7UUFDRCxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxhQUFhLEVBQUUsV0FBVyxDQUFDLENBQUE7SUFDakQsQ0FBQztJQUVELCtCQUFPLEdBQVA7UUFDRSxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxDQUFBO0lBQ3hCLENBQUM7SUFDSCxvQkFBQztBQUFELENBQUMsQUF6Q0QsSUF5Q0M7QUF6Q1ksc0NBQWEifQ==