"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var v8 = require("v8");
var debug_1 = require("debug");
var serviceManager_1 = require("../serviceManager");
var V8MetricsConfig = (function () {
    function V8MetricsConfig() {
    }
    return V8MetricsConfig;
}());
exports.V8MetricsConfig = V8MetricsConfig;
var defaultOptions = {
    new_space: false,
    old_space: false,
    map_space: false,
    code_space: false,
    large_object_space: false,
    heap_total_size: true,
    heap_used_size: true,
    heap_used_percent: true
};
var V8Metric = (function () {
    function V8Metric() {
        this.TIME_INTERVAL = 800;
        this.logger = debug_1.default('axm:features:metrics:v8');
        this.metricStore = new Map();
        this.unitKB = 'MiB';
        this.metricsDefinitions = {
            total_heap_size: {
                name: 'Heap Size',
                id: 'internal/v8/heap/total',
                unit: this.unitKB,
                historic: true
            },
            heap_used_percent: {
                name: 'Heap Usage',
                id: 'internal/v8/heap/usage',
                unit: '%',
                historic: true
            },
            used_heap_size: {
                name: 'Used Heap Size',
                id: 'internal/v8/heap/used',
                unit: this.unitKB,
                historic: true
            }
        };
    }
    V8Metric.prototype.init = function (config) {
        var _this = this;
        if (config === false)
            return;
        if (config === undefined) {
            config = defaultOptions;
        }
        if (config === true) {
            config = defaultOptions;
        }
        this.metricService = serviceManager_1.ServiceManager.get('metrics');
        if (this.metricService === undefined)
            return this.logger('Failed to load metric service');
        this.logger('init');
        if (!v8.hasOwnProperty('getHeapStatistics')) {
            return this.logger("V8.getHeapStatistics is not available, aborting");
        }
        for (var metricName in this.metricsDefinitions) {
            if (config[metricName] === false)
                continue;
            var isEnabled = config[metricName];
            if (isEnabled === false)
                continue;
            var metric = this.metricsDefinitions[metricName];
            this.metricStore.set(metricName, this.metricService.metric(metric));
        }
        this.timer = setInterval(function () {
            var stats = v8.getHeapStatistics();
            for (var metricName in _this.metricsDefinitions) {
                if (typeof stats[metricName] !== 'number')
                    continue;
                var gauge = _this.metricStore.get(metricName);
                if (gauge === undefined)
                    continue;
                gauge.set(_this.formatMiBytes(stats[metricName]));
            }
            var usage = (stats.used_heap_size / stats.total_heap_size * 100).toFixed(2);
            var usageMetric = _this.metricStore.get('heap_used_percent');
            if (usageMetric !== undefined) {
                usageMetric.set(parseFloat(usage));
            }
        }, this.TIME_INTERVAL);
        this.timer.unref();
    };
    V8Metric.prototype.destroy = function () {
        if (this.timer !== undefined) {
            clearInterval(this.timer);
        }
        this.logger('destroy');
    };
    V8Metric.prototype.formatMiBytes = function (val) {
        return (val / 1024 / 1024).toFixed(2);
    };
    return V8Metric;
}());
exports.default = V8Metric;
//# sourceMappingURL=data:application/json;base64,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