"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var inspector = require("inspector");
var debug_1 = require("debug");
var InspectorService = (function () {
    function InspectorService() {
        this.session = null;
        this.logger = debug_1.default('axm:services:inspector');
    }
    InspectorService.prototype.init = function () {
        this.logger("Creating new inspector session");
        this.session = new inspector.Session();
        this.session.connect();
        this.logger('Connected to inspector');
        this.session.post('Profiler.enable');
        this.session.post('HeapProfiler.enable');
        return this.session;
    };
    InspectorService.prototype.getSession = function () {
        if (this.session === null) {
            this.session = this.init();
            return this.session;
        }
        else {
            return this.session;
        }
    };
    InspectorService.prototype.destroy = function () {
        if (this.session !== null) {
            this.session.post('Profiler.disable');
            this.session.post('HeapProfiler.disable');
            this.session.disconnect();
            this.session = null;
        }
        else {
            this.logger('No open session');
        }
    };
    return InspectorService;
}());
exports.InspectorService = InspectorService;
module.exports = InspectorService;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5zcGVjdG9yLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3NlcnZpY2VzL2luc3BlY3Rvci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHFDQUFzQztBQUN0QywrQkFBeUI7QUFFekI7SUFBQTtRQUVVLFlBQU8sR0FBNkIsSUFBSSxDQUFBO1FBQ3hDLFdBQU0sR0FBYSxlQUFLLENBQUMsd0JBQXdCLENBQUMsQ0FBQTtJQStCNUQsQ0FBQztJQTdCQywrQkFBSSxHQUFKO1FBQ0UsSUFBSSxDQUFDLE1BQU0sQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFBO1FBQzdDLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxTQUFTLENBQUMsT0FBTyxFQUFFLENBQUE7UUFDdEMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUUsQ0FBQTtRQUN0QixJQUFJLENBQUMsTUFBTSxDQUFDLHdCQUF3QixDQUFDLENBQUE7UUFDckMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsQ0FBQTtRQUNwQyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxDQUFBO1FBQ3hDLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQTtJQUNyQixDQUFDO0lBRUQscUNBQVUsR0FBVjtRQUNFLElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxJQUFJLEVBQUU7WUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUE7WUFDMUIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFBO1NBQ3BCO2FBQU07WUFDTCxPQUFPLElBQUksQ0FBQyxPQUFPLENBQUE7U0FDcEI7SUFDSCxDQUFDO0lBRUQsa0NBQU8sR0FBUDtRQUNFLElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxJQUFJLEVBQUU7WUFDekIsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQTtZQUNyQyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxDQUFBO1lBQ3pDLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxFQUFFLENBQUE7WUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUE7U0FDcEI7YUFBTTtZQUNMLElBQUksQ0FBQyxNQUFNLENBQUMsaUJBQWlCLENBQUMsQ0FBQTtTQUMvQjtJQUNILENBQUM7SUFDSCx1QkFBQztBQUFELENBQUMsQUFsQ0QsSUFrQ0M7QUFsQ1ksNENBQWdCO0FBb0M3QixNQUFNLENBQUMsT0FBTyxHQUFHLGdCQUFnQixDQUFBIn0=