"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var IPCTransport_1 = require("../transports/IPCTransport");
var WebsocketTransport_1 = require("../transports/WebsocketTransport");
var TransportConfig = (function () {
    function TransportConfig() {
    }
    return TransportConfig;
}());
exports.TransportConfig = TransportConfig;
function createTransport(name, config) {
    switch (name) {
        case 'ipc': {
            var transport = new IPCTransport_1.IPCTransport();
            transport.init(config);
            return transport;
        }
        case 'websocket': {
            var transport = new WebsocketTransport_1.WebsocketTransport();
            transport.init(config);
            return transport;
        }
    }
    console.error("Failed to find transport implementation: " + name);
    return process.exit(1);
}
exports.createTransport = createTransport;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJhbnNwb3J0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3NlcnZpY2VzL3RyYW5zcG9ydC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUdBLDJEQUF5RDtBQUN6RCx1RUFBcUU7QUFHckU7SUFBQTtJQW9DQSxDQUFDO0lBQUQsc0JBQUM7QUFBRCxDQUFDLEFBcENELElBb0NDO0FBcENZLDBDQUFlO0FBb0U1QixTQUFnQixlQUFlLENBQUUsSUFBWSxFQUFFLE1BQXVCO0lBQ3BFLFFBQVEsSUFBSSxFQUFFO1FBQ1osS0FBSyxLQUFLLENBQUMsQ0FBQztZQUNWLElBQU0sU0FBUyxHQUFHLElBQUksMkJBQVksRUFBRSxDQUFBO1lBQ3BDLFNBQVMsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUE7WUFDdEIsT0FBTyxTQUFTLENBQUE7U0FDakI7UUFDRCxLQUFLLFdBQVcsQ0FBQyxDQUFDO1lBQ2hCLElBQU0sU0FBUyxHQUFHLElBQUksdUNBQWtCLEVBQUUsQ0FBQTtZQUMxQyxTQUFTLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFBO1lBQ3RCLE9BQU8sU0FBUyxDQUFBO1NBQ2pCO0tBQ0Y7SUFDRCxPQUFPLENBQUMsS0FBSyxDQUFDLDhDQUE0QyxJQUFNLENBQUMsQ0FBQTtJQUNqRSxPQUFPLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUE7QUFDeEIsQ0FBQztBQWZELDBDQWVDIn0=