"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var units_1 = require("./units");
var ExponentiallyWeightedMovingAverage = (function () {
    function ExponentiallyWeightedMovingAverage(timePeriod, tickInterval) {
        this._count = 0;
        this._rate = 0;
        this.TICK_INTERVAL = 5 * units_1.default.SECONDS;
        this._timePeriod = timePeriod || 1 * units_1.default.MINUTES;
        this._tickInterval = tickInterval || this.TICK_INTERVAL;
        this._alpha = 1 - Math.exp(-this._tickInterval / this._timePeriod);
    }
    ExponentiallyWeightedMovingAverage.prototype.update = function (n) {
        this._count += n;
    };
    ExponentiallyWeightedMovingAverage.prototype.tick = function () {
        var instantRate = this._count / this._tickInterval;
        this._count = 0;
        this._rate += (this._alpha * (instantRate - this._rate));
    };
    ExponentiallyWeightedMovingAverage.prototype.rate = function (timeUnit) {
        return (this._rate || 0) * timeUnit;
    };
    return ExponentiallyWeightedMovingAverage;
}());
exports.default = ExponentiallyWeightedMovingAverage;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRVdNQS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy91dGlscy9FV01BLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsaUNBQTJCO0FBRTNCO0lBU0UsNENBQWEsVUFBbUIsRUFBRSxZQUFxQjtRQUwvQyxXQUFNLEdBQVcsQ0FBQyxDQUFBO1FBQ2xCLFVBQUssR0FBVyxDQUFDLENBQUE7UUFFakIsa0JBQWEsR0FBVyxDQUFDLEdBQUcsZUFBSyxDQUFDLE9BQU8sQ0FBQTtRQUcvQyxJQUFJLENBQUMsV0FBVyxHQUFHLFVBQVUsSUFBSSxDQUFDLEdBQUcsZUFBSyxDQUFDLE9BQU8sQ0FBQTtRQUNsRCxJQUFJLENBQUMsYUFBYSxHQUFHLFlBQVksSUFBSSxJQUFJLENBQUMsYUFBYSxDQUFBO1FBQ3ZELElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQTtJQUNwRSxDQUFDO0lBRUQsbURBQU0sR0FBTixVQUFRLENBQUM7UUFDUCxJQUFJLENBQUMsTUFBTSxJQUFJLENBQUMsQ0FBQTtJQUNsQixDQUFDO0lBRUQsaURBQUksR0FBSjtRQUNFLElBQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQTtRQUNwRCxJQUFJLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQTtRQUVmLElBQUksQ0FBQyxLQUFLLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxHQUFHLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFBO0lBQzFELENBQUM7SUFFRCxpREFBSSxHQUFKLFVBQU0sUUFBUTtRQUNaLE9BQU8sQ0FBQyxJQUFJLENBQUMsS0FBSyxJQUFJLENBQUMsQ0FBQyxHQUFHLFFBQVEsQ0FBQTtJQUNyQyxDQUFDO0lBQ0gseUNBQUM7QUFBRCxDQUFDLEFBN0JELElBNkJDIn0=