"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Counter = (function () {
    function Counter(opts) {
        this.used = false;
        opts = opts || {};
        this._count = opts.count || 0;
    }
    Counter.prototype.val = function () {
        return this._count;
    };
    Counter.prototype.inc = function (n) {
        this.used = true;
        this._count += (n || 1);
    };
    Counter.prototype.dec = function (n) {
        this.used = true;
        this._count -= (n || 1);
    };
    Counter.prototype.reset = function (count) {
        this._count = count || 0;
    };
    Counter.prototype.isUsed = function () {
        return this.used;
    };
    return Counter;
}());
exports.default = Counter;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY291bnRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy91dGlscy9tZXRyaWNzL2NvdW50ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTtJQUlFLGlCQUFhLElBQUs7UUFGVixTQUFJLEdBQVksS0FBSyxDQUFBO1FBRzNCLElBQUksR0FBRyxJQUFJLElBQUksRUFBRSxDQUFBO1FBQ2pCLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLEtBQUssSUFBSSxDQUFDLENBQUE7SUFDL0IsQ0FBQztJQUVELHFCQUFHLEdBQUg7UUFDRSxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUE7SUFDcEIsQ0FBQztJQUVELHFCQUFHLEdBQUgsVUFBSyxDQUFVO1FBQ2IsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUE7UUFDaEIsSUFBSSxDQUFDLE1BQU0sSUFBSSxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQTtJQUN6QixDQUFDO0lBRUQscUJBQUcsR0FBSCxVQUFLLENBQVU7UUFDYixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQTtRQUNoQixJQUFJLENBQUMsTUFBTSxJQUFJLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFBO0lBQ3pCLENBQUM7SUFFRCx1QkFBSyxHQUFMLFVBQU8sS0FBYztRQUNuQixJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssSUFBSSxDQUFDLENBQUE7SUFDMUIsQ0FBQztJQUVELHdCQUFNLEdBQU47UUFDRSxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUE7SUFDbEIsQ0FBQztJQUNILGNBQUM7QUFBRCxDQUFDLEFBOUJELElBOEJDIn0=