/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.text.View;

public class SynthLabelUI
extends BasicLabelUI
implements SynthUI {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent c) {
        return new SynthLabelUI();
    }

    @Override
    protected void installDefaults(JLabel c) {
        this.updateStyle(c);
    }

    void updateStyle(JLabel c) {
        SynthContext context = this.getContext(c, 1);
        this.style = SynthLookAndFeel.updateStyle(context, this);
        context.dispose();
    }

    @Override
    protected void uninstallDefaults(JLabel c) {
        SynthContext context = this.getContext(c, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        int state = SynthLookAndFeel.getComponentState(c);
        if (SynthLookAndFeel.getSelectedUI() == this && state == 1) {
            state = SynthLookAndFeel.getSelectedUIState() | 1;
        }
        return state;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        int baseline;
        if (c == null) {
            throw new NullPointerException("Component must be non-null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Width and height must be >= 0");
        }
        JLabel label = (JLabel)c;
        String text = label.getText();
        if (text == null || "".equals(text)) {
            return -1;
        }
        Insets i = label.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = width - (i.right + viewRect.x);
        viewRect.height = height - (i.bottom + viewRect.y);
        SynthContext context = this.getContext(label);
        FontMetrics fm = context.getComponent().getFontMetrics(context.getStyle().getFont(context));
        context.getStyle().getGraphicsUtils(context).layoutText(context, fm, label.getText(), label.getIcon(), label.getHorizontalAlignment(), label.getVerticalAlignment(), label.getHorizontalTextPosition(), label.getVerticalTextPosition(), viewRect, iconRect, textRect, label.getIconTextGap());
        View view = (View)label.getClientProperty("html");
        if (view != null) {
            baseline = BasicHTML.getHTMLBaseline(view, textRect.width, textRect.height);
            if (baseline >= 0) {
                baseline += textRect.y;
            }
        } else {
            baseline = textRect.y + fm.getAscent();
        }
        context.dispose();
        return baseline;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintLabelBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        JLabel label = (JLabel)context.getComponent();
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        g.setColor(context.getStyle().getColor(context, ColorType.TEXT_FOREGROUND));
        g.setFont(this.style.getFont(context));
        context.getStyle().getGraphicsUtils(context).paintText(context, g, label.getText(), icon, label.getHorizontalAlignment(), label.getVerticalAlignment(), label.getHorizontalTextPosition(), label.getVerticalTextPosition(), label.getIconTextGap(), label.getDisplayedMnemonicIndex(), 0);
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintLabelBorder(context, g, x, y, w, h);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        JLabel label = (JLabel)c;
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        SynthContext context = this.getContext(c);
        Dimension size = context.getStyle().getGraphicsUtils(context).getPreferredSize(context, context.getStyle().getFont(context), label.getText(), icon, label.getHorizontalAlignment(), label.getVerticalAlignment(), label.getHorizontalTextPosition(), label.getVerticalTextPosition(), label.getIconTextGap(), label.getDisplayedMnemonicIndex());
        context.dispose();
        return size;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        JLabel label = (JLabel)c;
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        SynthContext context = this.getContext(c);
        Dimension size = context.getStyle().getGraphicsUtils(context).getMinimumSize(context, context.getStyle().getFont(context), label.getText(), icon, label.getHorizontalAlignment(), label.getVerticalAlignment(), label.getHorizontalTextPosition(), label.getVerticalTextPosition(), label.getIconTextGap(), label.getDisplayedMnemonicIndex());
        context.dispose();
        return size;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        JLabel label = (JLabel)c;
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        SynthContext context = this.getContext(c);
        Dimension size = context.getStyle().getGraphicsUtils(context).getMaximumSize(context, context.getStyle().getFont(context), label.getText(), icon, label.getHorizontalAlignment(), label.getVerticalAlignment(), label.getHorizontalTextPosition(), label.getVerticalTextPosition(), label.getIconTextGap(), label.getDisplayedMnemonicIndex());
        context.dispose();
        return size;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JLabel)e.getSource());
        }
    }
}

