/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.ISCII91;

public class ByteToCharISCII91
extends ByteToCharConverter {
    private static final char[] directMapTable = ISCII91.getDirectMapTable();
    private static final char NUKTA_CHAR = '\u093c';
    private static final char HALANT_CHAR = '\u094d';
    private static final char ZWNJ_CHAR = '\u200c';
    private static final char ZWJ_CHAR = '\u200d';
    private static final char INVALID_CHAR = '\uffff';
    private char contextChar = (char)65535;
    private boolean needFlushing = false;

    public int convert(byte[] input, int inStart, int inEnd, char[] output, int outStart, int outEnd) throws ConversionBufferFullException, UnknownCharacterException {
        this.charOff = outStart;
        this.byteOff = inStart;
        block17: while (this.byteOff < inEnd) {
            int index;
            if (this.charOff >= outEnd) {
                throw new ConversionBufferFullException();
            }
            index = (index = input[this.byteOff++]) < 0 ? index + 255 : index;
            char currentChar = directMapTable[index];
            if (this.contextChar == '\ufffd') {
                output[this.charOff++] = 65533;
                this.contextChar = (char)65535;
                this.needFlushing = false;
                continue;
            }
            block0 : switch (currentChar) {
                case '\u0901': 
                case '\u0907': 
                case '\u0908': 
                case '\u090b': 
                case '\u093f': 
                case '\u0940': 
                case '\u0943': 
                case '\u0964': {
                    if (this.needFlushing) {
                        output[this.charOff++] = this.contextChar;
                        this.contextChar = currentChar;
                        continue block17;
                    }
                    this.contextChar = currentChar;
                    this.needFlushing = true;
                    continue block17;
                }
                case '\u093c': {
                    switch (this.contextChar) {
                        case '\u0901': {
                            output[this.charOff] = 2384;
                            break block0;
                        }
                        case '\u0907': {
                            output[this.charOff] = 2316;
                            break block0;
                        }
                        case '\u0908': {
                            output[this.charOff] = 2401;
                            break block0;
                        }
                        case '\u090b': {
                            output[this.charOff] = 2400;
                            break block0;
                        }
                        case '\u093f': {
                            output[this.charOff] = 2402;
                            break block0;
                        }
                        case '\u0940': {
                            output[this.charOff] = 2403;
                            break block0;
                        }
                        case '\u0943': {
                            output[this.charOff] = 2372;
                            break block0;
                        }
                        case '\u0964': {
                            output[this.charOff] = 2365;
                            break block0;
                        }
                        case '\u094d': {
                            if (this.needFlushing) {
                                output[this.charOff++] = this.contextChar;
                                this.contextChar = currentChar;
                                continue block17;
                            }
                            output[this.charOff] = 8205;
                            break block0;
                        }
                    }
                    if (this.needFlushing) {
                        output[this.charOff++] = this.contextChar;
                        this.contextChar = currentChar;
                        continue block17;
                    }
                    output[this.charOff] = 2364;
                    break;
                }
                case '\u094d': {
                    if (this.needFlushing) {
                        output[this.charOff++] = this.contextChar;
                        this.contextChar = currentChar;
                        continue block17;
                    }
                    if (this.contextChar == '\u094d') {
                        output[this.charOff] = 8204;
                        break;
                    }
                    output[this.charOff] = 2381;
                    break;
                }
                case '\uffff': {
                    if (this.needFlushing) {
                        output[this.charOff++] = this.contextChar;
                        this.contextChar = currentChar;
                        continue block17;
                    }
                    if (this.subMode) {
                        output[this.charOff] = this.subChars[0];
                        break;
                    }
                    this.contextChar = (char)65535;
                    throw new UnknownCharacterException();
                }
                default: {
                    if (this.needFlushing) {
                        output[this.charOff++] = this.contextChar;
                        this.contextChar = currentChar;
                        continue block17;
                    }
                    output[this.charOff] = currentChar;
                }
            }
            this.contextChar = currentChar;
            this.needFlushing = false;
            ++this.charOff;
        }
        return this.charOff - outStart;
    }

    public int flush(char[] output, int outStart, int outEnd) throws MalformedInputException, ConversionBufferFullException {
        int charsWritten = 0;
        if (this.needFlushing) {
            output[outStart] = this.contextChar;
            charsWritten = 1;
        }
        this.contextChar = (char)65535;
        this.needFlushing = false;
        this.charOff = 0;
        this.byteOff = 0;
        return charsWritten;
    }

    public String getCharacterEncoding() {
        return "ISCII91";
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
    }
}

