/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import java.io.IOException;

public class FillUnit
extends TeXUnit {
    private int strength = 1;

    public FillUnit(int n) {
        this.setStrength(n);
    }

    public FillUnit(String string) {
        if (string.equals("fil")) {
            this.strength = 1;
        } else if (string.equals("fill")) {
            this.strength = 2;
        } else if (string.equals("filll")) {
            this.strength = 3;
        } else {
            throw new IllegalArgumentException("Illegal fill unit " + string);
        }
    }

    private void setStrength(int n) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Illegal fill strength " + n);
        }
        this.strength = n;
    }

    public int getStrength() {
        return this.strength;
    }

    @Override
    public Object clone() {
        return new FillUnit(this.strength);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FillUnit)) {
            return false;
        }
        return this.strength == ((FillUnit)object).getStrength();
    }

    @Override
    public float toUnit(TeXParser teXParser, float f, TeXUnit teXUnit) throws TeXSyntaxException {
        return f;
    }

    @Override
    public float fromUnit(TeXParser teXParser, float f, TeXUnit teXUnit) throws TeXSyntaxException {
        return f;
    }

    @Override
    public float toPt(TeXParser teXParser, float f) throws TeXSyntaxException {
        return f;
    }

    @Override
    public float fromPt(TeXParser teXParser, float f) throws TeXSyntaxException {
        return f;
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.string(this.toString());
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.toString();
    }

    @Override
    public String format() {
        String string = "fi";
        for (int i = 1; i <= this.strength; ++i) {
            string = string + "l";
        }
        return string;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.getListener().getWriteable().write(this.toString());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }
}

