/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFSubSetFile;
import org.apache.fop.fonts.type1.PFBData;
import org.apache.fop.fonts.type1.PFBParser;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFCIDFont;
import org.apache.fop.pdf.PDFCIDFontDescriptor;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDestination;
import org.apache.fop.pdf.PDFDests;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEncoding;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFFontDescriptor;
import org.apache.fop.pdf.PDFFontNonBase14;
import org.apache.fop.pdf.PDFFontType0;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFGoTo;
import org.apache.fop.pdf.PDFGoToRemote;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFInternalLink;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFMetadata;
import org.apache.fop.pdf.PDFNameTreeNode;
import org.apache.fop.pdf.PDFNames;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFOutputIntent;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFRectangle;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFT1Stream;
import org.apache.fop.pdf.PDFTTFStream;
import org.apache.fop.pdf.PDFToUnicodeCMap;
import org.apache.fop.pdf.PDFUri;
import org.apache.fop.pdf.PDFWArray;
import org.apache.xmlgraphics.xmp.Metadata;

public class PDFFactory {
    private PDFDocument document;
    private Log log = LogFactory.getLog(class$org$apache$fop$pdf$PDFFactory == null ? (class$org$apache$fop$pdf$PDFFactory = PDFFactory.class$("org.apache.fop.pdf.PDFFactory")) : class$org$apache$fop$pdf$PDFFactory);
    static /* synthetic */ Class class$org$apache$fop$pdf$PDFFactory;

    public PDFFactory(PDFDocument document) {
        this.document = document;
    }

    public final PDFDocument getDocument() {
        return this.document;
    }

    public PDFRoot makeRoot(PDFPages pages) {
        PDFRoot pdfRoot = new PDFRoot(++this.document.objectcount, pages);
        pdfRoot.setDocument(this.getDocument());
        this.getDocument().addTrailerObject(pdfRoot);
        return pdfRoot;
    }

    public PDFPages makePages() {
        PDFPages pdfPages = new PDFPages(++this.document.objectcount);
        pdfPages.setDocument(this.getDocument());
        this.getDocument().addTrailerObject(pdfPages);
        return pdfPages;
    }

    public PDFResources makeResources() {
        PDFResources pdfResources = new PDFResources(++this.document.objectcount);
        pdfResources.setDocument(this.getDocument());
        this.getDocument().addTrailerObject(pdfResources);
        return pdfResources;
    }

    protected PDFInfo makeInfo(String prod) {
        PDFInfo pdfInfo = new PDFInfo();
        pdfInfo.setProducer(prod);
        this.getDocument().registerObject(pdfInfo);
        return pdfInfo;
    }

    public PDFMetadata makeMetadata(Metadata meta, boolean readOnly) {
        PDFMetadata pdfMetadata = new PDFMetadata(meta, readOnly);
        this.getDocument().registerObject(pdfMetadata);
        return pdfMetadata;
    }

    public PDFOutputIntent makeOutputIntent() {
        PDFOutputIntent outputIntent = new PDFOutputIntent();
        this.getDocument().registerObject(outputIntent);
        return outputIntent;
    }

    public PDFPage makePage(PDFResources resources, int pageWidth, int pageHeight, int pageIndex) {
        PDFPage page = new PDFPage(resources, pageWidth, pageHeight, pageIndex);
        this.getDocument().assignObjectNumber(page);
        this.getDocument().getPages().addPage(page);
        return page;
    }

    public PDFPage makePage(PDFResources resources, int pageWidth, int pageHeight) {
        return this.makePage(resources, pageWidth, pageHeight, -1);
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theSize, int theBitsPerSample, int theOrder, List theEncode, List theDecode, StringBuffer theFunctionDataStream, List theFilter) {
        PDFFunction function = new PDFFunction(theFunctionType, theDomain, theRange, theSize, theBitsPerSample, theOrder, theEncode, theDecode, theFunctionDataStream, theFilter);
        PDFFunction oldfunc = this.getDocument().findFunction(function);
        if (oldfunc == null) {
            this.getDocument().registerObject(function);
        } else {
            function = oldfunc;
        }
        return function;
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theCZero, List theCOne, double theInterpolationExponentN) {
        PDFFunction function = new PDFFunction(theFunctionType, theDomain, theRange, theCZero, theCOne, theInterpolationExponentN);
        PDFFunction oldfunc = this.getDocument().findFunction(function);
        if (oldfunc == null) {
            this.getDocument().registerObject(function);
        } else {
            function = oldfunc;
        }
        return function;
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theFunctions, List theBounds, List theEncode) {
        PDFFunction function = new PDFFunction(theFunctionType, theDomain, theRange, theFunctions, theBounds, theEncode);
        PDFFunction oldfunc = this.getDocument().findFunction(function);
        if (oldfunc == null) {
            this.getDocument().registerObject(function);
        } else {
            function = oldfunc;
        }
        return function;
    }

    public PDFFunction makeFunction(int theNumber, int theFunctionType, List theDomain, List theRange, StringBuffer theFunctionDataStream) {
        PDFFunction function = new PDFFunction(theFunctionType, theDomain, theRange, theFunctionDataStream);
        PDFFunction oldfunc = this.getDocument().findFunction(function);
        if (oldfunc == null) {
            this.getDocument().registerObject(function);
        } else {
            function = oldfunc;
        }
        return function;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFDeviceColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, List theDomain, List theMatrix, PDFFunction theFunction) {
        PDFShading shading = new PDFShading(theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theDomain, theMatrix, theFunction);
        PDFShading oldshad = this.getDocument().findShading(shading);
        if (oldshad == null) {
            this.getDocument().registerObject(shading);
        } else {
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.getDocument().getResources().addShading(shading);
        }
        return shading;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFDeviceColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, List theCoords, List theDomain, PDFFunction theFunction, List theExtend) {
        PDFShading shading = new PDFShading(theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theCoords, theDomain, theFunction, theExtend);
        PDFShading oldshad = this.getDocument().findShading(shading);
        if (oldshad == null) {
            this.getDocument().registerObject(shading);
        } else {
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.getDocument().getResources().addShading(shading);
        }
        return shading;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFDeviceColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, int theBitsPerCoordinate, int theBitsPerComponent, int theBitsPerFlag, List theDecode, PDFFunction theFunction) {
        PDFShading shading = new PDFShading(theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theBitsPerCoordinate, theBitsPerComponent, theBitsPerFlag, theDecode, theFunction);
        PDFShading oldshad = this.getDocument().findShading(shading);
        if (oldshad == null) {
            this.getDocument().registerObject(shading);
        } else {
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.getDocument().getResources().addShading(shading);
        }
        return shading;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFDeviceColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, int theBitsPerCoordinate, int theBitsPerComponent, List theDecode, int theVerticesPerRow, PDFFunction theFunction) {
        PDFShading shading = new PDFShading(theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theBitsPerCoordinate, theBitsPerComponent, theDecode, theVerticesPerRow, theFunction);
        PDFShading oldshad = this.getDocument().findShading(shading);
        if (oldshad == null) {
            this.getDocument().registerObject(shading);
        } else {
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.getDocument().getResources().addShading(shading);
        }
        return shading;
    }

    public PDFPattern makePattern(PDFResourceContext res, int thePatternType, PDFResources theResources, int thePaintType, int theTilingType, List theBBox, double theXStep, double theYStep, List theMatrix, List theXUID, StringBuffer thePatternDataStream) {
        PDFPattern pattern = new PDFPattern(theResources, 1, thePaintType, theTilingType, theBBox, theXStep, theYStep, theMatrix, theXUID, thePatternDataStream);
        PDFPattern oldpatt = this.getDocument().findPattern(pattern);
        if (oldpatt == null) {
            this.getDocument().registerObject(pattern);
        } else {
            pattern = oldpatt;
        }
        if (res != null) {
            res.getPDFResources().addPattern(pattern);
        } else {
            this.getDocument().getResources().addPattern(pattern);
        }
        return pattern;
    }

    public PDFPattern makePattern(PDFResourceContext res, int thePatternType, PDFShading theShading, List theXUID, StringBuffer theExtGState, List theMatrix) {
        PDFPattern pattern = new PDFPattern(2, theShading, theXUID, theExtGState, theMatrix);
        PDFPattern oldpatt = this.getDocument().findPattern(pattern);
        if (oldpatt == null) {
            this.getDocument().registerObject(pattern);
        } else {
            pattern = oldpatt;
        }
        if (res != null) {
            res.getPDFResources().addPattern(pattern);
        } else {
            this.getDocument().getResources().addPattern(pattern);
        }
        return pattern;
    }

    public PDFPattern makeGradient(PDFResourceContext res, boolean radial, PDFDeviceColorSpace theColorspace, List theColors, List theBounds, List theCoords, List theMatrix) {
        PDFShading myShad;
        double interpolation = 1.0;
        ArrayList<PDFFunction> theFunctions = new ArrayList<PDFFunction>();
        int lastPosition = theColors.size() - 1;
        int currentPosition = 0;
        while (currentPosition < lastPosition) {
            PDFColor currentColor = (PDFColor)theColors.get(currentPosition);
            PDFColor nextColor = (PDFColor)theColors.get(currentPosition + 1);
            if (this.getDocument().getColorSpace() != currentColor.getColorSpace()) {
                currentColor.setColorSpace(this.getDocument().getColorSpace());
            }
            if (this.getDocument().getColorSpace() != nextColor.getColorSpace()) {
                nextColor.setColorSpace(this.getDocument().getColorSpace());
            }
            List theCzero = currentColor.getVector();
            List theCone = nextColor.getVector();
            PDFFunction myfunc = this.makeFunction(2, null, null, theCzero, theCone, interpolation);
            theFunctions.add(myfunc);
            ++currentPosition;
        }
        PDFFunction myfunky = this.makeFunction(3, null, null, theFunctions, theBounds, null);
        if (radial) {
            if (theCoords.size() == 6) {
                myShad = this.makeShading(res, 3, this.getDocument().getPDFColorSpace(), null, null, false, theCoords, null, myfunky, null);
            } else {
                ArrayList newCoords = new ArrayList();
                newCoords.add(theCoords.get(0));
                newCoords.add(theCoords.get(1));
                newCoords.add(theCoords.get(2));
                newCoords.add(theCoords.get(0));
                newCoords.add(theCoords.get(1));
                newCoords.add(new Double(0.0));
                myShad = this.makeShading(res, 3, this.getDocument().getPDFColorSpace(), null, null, false, newCoords, null, myfunky, null);
            }
        } else {
            myShad = this.makeShading(res, 2, this.getDocument().getPDFColorSpace(), null, null, false, theCoords, null, myfunky, null);
        }
        PDFPattern myPattern = this.makePattern(res, 2, myShad, null, null, theMatrix);
        return myPattern;
    }

    protected PDFDestination getUniqueDestination(PDFDestination newdest) {
        PDFDestination existing = this.getDocument().findDestination(newdest);
        if (existing != null) {
            return existing;
        }
        this.getDocument().addDestination(newdest);
        return newdest;
    }

    public PDFDestination makeDestination(String idRef, Object goToRef) {
        PDFDestination destination = new PDFDestination(idRef, goToRef);
        return this.getUniqueDestination(destination);
    }

    public PDFNames makeNames() {
        PDFNames names = new PDFNames();
        this.getDocument().registerObject(names);
        return names;
    }

    public PDFDests makeDests(List destinationList) {
        boolean deep = true;
        PDFDests dests = new PDFDests();
        PDFArray kids = new PDFArray();
        Iterator iter = destinationList.iterator();
        while (iter.hasNext()) {
            PDFDestination dest = (PDFDestination)iter.next();
            PDFNameTreeNode node = new PDFNameTreeNode();
            this.getDocument().registerObject(node);
            node.setLowerLimit(dest.getIDRef());
            node.setUpperLimit(dest.getIDRef());
            node.setNames(new PDFArray());
            node.getNames().add(dest);
            kids.add(node);
        }
        dests.setLowerLimit(((PDFNameTreeNode)kids.get(0)).getLowerLimit());
        dests.setUpperLimit(((PDFNameTreeNode)kids.get(kids.length() - 1)).getUpperLimit());
        dests.setKids(kids);
        this.getDocument().registerObject(dests);
        return dests;
    }

    public PDFNameTreeNode makeNameTreeNode() {
        PDFNameTreeNode node = new PDFNameTreeNode();
        this.getDocument().registerObject(node);
        return node;
    }

    public PDFLink makeLink(Rectangle2D rect, PDFAction pdfAction) {
        if (rect == null || pdfAction == null) {
            return null;
        }
        PDFLink link = new PDFLink(rect);
        link.setAction(pdfAction);
        this.getDocument().registerObject(link);
        return link;
    }

    public PDFLink makeLink(Rectangle2D rect, String page, String dest) {
        PDFLink link = new PDFLink(rect);
        this.getDocument().registerObject(link);
        PDFGoTo gt = new PDFGoTo(page);
        gt.setDestination(dest);
        this.getDocument().addTrailerObject(gt);
        PDFInternalLink internalLink = new PDFInternalLink(gt.referencePDF());
        link.setAction(internalLink);
        return link;
    }

    public PDFLink makeLink(Rectangle2D rect, String destination, int linkType, float yoffset) {
        PDFLink link = new PDFLink(rect);
        if (linkType == 0) {
            link.setAction(this.getExternalAction(destination));
        } else {
            String goToReference = this.getGoToReference(destination, yoffset);
            PDFInternalLink internalLink = new PDFInternalLink(goToReference);
            link.setAction(internalLink);
        }
        PDFLink oldlink = this.getDocument().findLink(link);
        if (oldlink == null) {
            this.getDocument().registerObject(link);
        } else {
            link = oldlink;
        }
        return link;
    }

    public PDFAction getExternalAction(String target) {
        String targetLo = target.toLowerCase();
        if (targetLo.startsWith("http://")) {
            return new PDFUri(target);
        }
        if (targetLo.endsWith(".pdf")) {
            return this.getGoToPDFAction(target, null, -1);
        }
        int index = targetLo.indexOf(".pdf#page=");
        if (index > 0) {
            String filename = target.substring(0, index + 4);
            int page = Integer.parseInt(target.substring(index + 10));
            return this.getGoToPDFAction(filename, null, page);
        }
        index = targetLo.indexOf(".pdf#dest=");
        if (index > 0) {
            String filename = target.substring(0, index + 4);
            String dest = target.substring(index + 10);
            return this.getGoToPDFAction(filename, dest, -1);
        }
        return new PDFUri(target);
    }

    public String getGoToReference(String pdfPageRef, float yoffset) {
        return this.getPDFGoTo(pdfPageRef, new Point2D.Float(0.0f, yoffset)).referencePDF();
    }

    public PDFGoTo getPDFGoTo(String pdfPageRef, Point2D position) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFGoTo gt = new PDFGoTo(pdfPageRef, position);
        PDFGoTo oldgt = this.getDocument().findGoTo(gt);
        if (oldgt == null) {
            this.getDocument().assignObjectNumber(gt);
            this.getDocument().addTrailerObject(gt);
        } else {
            gt = oldgt;
        }
        return gt;
    }

    private PDFGoToRemote getGoToPDFAction(String file, String dest, int page) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFFileSpec fileSpec = new PDFFileSpec(file);
        PDFFileSpec oldspec = this.getDocument().findFileSpec(fileSpec);
        if (oldspec == null) {
            this.getDocument().registerObject(fileSpec);
        } else {
            fileSpec = oldspec;
        }
        PDFGoToRemote remote = dest == null && page == -1 ? new PDFGoToRemote(fileSpec) : (dest != null ? new PDFGoToRemote(fileSpec, dest) : new PDFGoToRemote(fileSpec, page));
        PDFGoToRemote oldremote = this.getDocument().findGoToRemote(remote);
        if (oldremote == null) {
            this.getDocument().registerObject(remote);
        } else {
            remote = oldremote;
        }
        return remote;
    }

    public PDFOutline makeOutline(PDFOutline parent, String label, String actionRef, boolean showSubItems) {
        PDFOutline pdfOutline = new PDFOutline(label, actionRef, showSubItems);
        if (parent != null) {
            parent.addOutline(pdfOutline);
        }
        this.getDocument().registerObject(pdfOutline);
        return pdfOutline;
    }

    public PDFOutline makeOutline(PDFOutline parent, String label, PDFAction pdfAction, boolean showSubItems) {
        return pdfAction == null ? null : this.makeOutline(parent, label, pdfAction.getAction(), showSubItems);
    }

    public PDFOutline makeOutline(PDFOutline parent, String label, String destination, float yoffset, boolean showSubItems) {
        String goToRef = this.getGoToReference(destination, yoffset);
        return this.makeOutline(parent, label, goToRef, showSubItems);
    }

    public PDFEncoding makeEncoding(String encodingName) {
        PDFEncoding encoding = new PDFEncoding(encodingName);
        this.getDocument().registerObject(encoding);
        return encoding;
    }

    public PDFFont makeFont(String fontname, String basefont, String encoding, FontMetrics metrics, FontDescriptor descriptor) {
        PDFFont preRegisteredfont = this.getDocument().findFont(fontname);
        if (preRegisteredfont != null) {
            return preRegisteredfont;
        }
        if (descriptor == null) {
            PDFFont font = new PDFFont(fontname, FontType.TYPE1, basefont, encoding);
            this.getDocument().registerObject(font);
            return font;
        }
        FontType fonttype = metrics.getFontType();
        PDFFontDescriptor pdfdesc = this.makeFontDescriptor(descriptor);
        PDFFontNonBase14 font = null;
        font = fonttype == FontType.TYPE0 ? (PDFFontNonBase14)PDFFont.createFont(fontname, fonttype, basefont, "Identity-H") : (PDFFontNonBase14)PDFFont.createFont(fontname, fonttype, basefont, encoding);
        this.getDocument().registerObject(font);
        font.setDescriptor(pdfdesc);
        if (fonttype == FontType.TYPE0) {
            CIDFont cidMetrics = metrics instanceof LazyFont ? (CIDFont)((LazyFont)metrics).getRealFont() : (CIDFont)metrics;
            PDFCIDSystemInfo sysInfo = new PDFCIDSystemInfo(cidMetrics.getRegistry(), cidMetrics.getOrdering(), cidMetrics.getSupplement());
            PDFCIDFont cidFont = new PDFCIDFont(basefont, cidMetrics.getCIDType(), cidMetrics.getDefaultWidth(), this.getSubsetWidths(cidMetrics), sysInfo, (PDFCIDFontDescriptor)pdfdesc);
            this.getDocument().registerObject(cidFont);
            PDFToUnicodeCMap cmap = new PDFToUnicodeCMap(cidMetrics, "fop-ucs-H", new PDFCIDSystemInfo("Adobe", "Identity", 0));
            this.getDocument().registerObject(cmap);
            ((PDFFontType0)font).setCMAP(cmap);
            ((PDFFontType0)font).setDescendantFonts(cidFont);
        } else {
            int firstChar = 0;
            int lastChar = 255;
            if (metrics instanceof CustomFont) {
                CustomFont cf = (CustomFont)metrics;
                firstChar = cf.getFirstChar();
                lastChar = cf.getLastChar();
            }
            font.setWidthMetrics(firstChar, lastChar, this.makeArray(metrics.getWidths()));
        }
        return font;
    }

    public PDFWArray getSubsetWidths(CIDFont cidFont) {
        PDFWArray warray = new PDFWArray();
        int[] tmpWidth = new int[cidFont.usedGlyphsCount];
        int i = 0;
        while (i < cidFont.usedGlyphsCount) {
            Integer nw = (Integer)cidFont.usedGlyphsIndex.get(new Integer(i));
            int nwx = nw == null ? 0 : nw;
            tmpWidth[i] = cidFont.width[nwx];
            ++i;
        }
        warray.addEntry(0, tmpWidth);
        return warray;
    }

    public PDFFontDescriptor makeFontDescriptor(FontDescriptor desc) {
        PDFFontDescriptor descriptor = null;
        descriptor = desc.getFontType() == FontType.TYPE0 ? new PDFCIDFontDescriptor(desc.getFontName(), desc.getFontBBox(), desc.getCapHeight(), desc.getFlags(), desc.getItalicAngle(), desc.getStemV(), null) : new PDFFontDescriptor(desc.getFontName(), desc.getAscender(), desc.getDescender(), desc.getCapHeight(), desc.getFlags(), new PDFRectangle(desc.getFontBBox()), desc.getItalicAngle(), desc.getStemV());
        this.getDocument().registerObject(descriptor);
        if (desc.isEmbeddable()) {
            CustomFont font;
            AbstractPDFStream stream = this.makeFontFile(desc);
            if (stream != null) {
                descriptor.setFontFile(desc.getFontType(), stream);
                this.getDocument().registerObject(stream);
            }
            if ((font = this.getCustomFont(desc)) instanceof CIDFont) {
                CIDFont cidFont = (CIDFont)font;
                this.buildCIDSet(descriptor, cidFont);
            }
        }
        return descriptor;
    }

    private void buildCIDSet(PDFFontDescriptor descriptor, CIDFont cidFont) {
        BitSet cidSubset = new BitSet();
        Iterator iter = cidFont.usedGlyphs.keySet().iterator();
        while (iter.hasNext()) {
            Integer cid = (Integer)iter.next();
            cidSubset.set(cid);
        }
        PDFStream cidSet = this.makeStream(null, true);
        ByteArrayOutputStream baout = new ByteArrayOutputStream(cidSubset.length() / 8 + 1);
        int value = 0;
        int i = 0;
        int c = cidSubset.length();
        while (i < c) {
            int shift = i % 8;
            boolean b = cidSubset.get(i);
            if (b) {
                value |= 1 << 7 - shift;
            }
            if (shift == 7) {
                baout.write(value);
                value = 0;
            }
            ++i;
        }
        baout.write(value);
        try {
            cidSet.setData(baout.toByteArray());
            descriptor.setCIDSet(cidSet);
        }
        catch (IOException ioe) {
            this.log.error("Failed to write CIDSet [" + cidFont + "] " + cidFont.getFontName(), ioe);
        }
    }

    public AbstractPDFStream makeFontFile(FontDescriptor desc) {
        if (desc.getFontType() == FontType.OTHER) {
            throw new IllegalArgumentException("Trying to embed unsupported font type: " + desc.getFontType());
        }
        CustomFont font = this.getCustomFont(desc);
        InputStream in = null;
        try {
            AbstractPDFStream abstractPDFStream;
            Source source = font.getEmbedFileSource();
            if (source == null && font.getEmbedResourceName() != null) {
                source = new StreamSource(this.getClass().getResourceAsStream(font.getEmbedResourceName()));
            }
            if (source == null) {
                return null;
            }
            if (source instanceof StreamSource) {
                in = ((StreamSource)source).getInputStream();
            }
            if (in == null && source.getSystemId() != null) {
                try {
                    in = new URL(source.getSystemId()).openStream();
                }
                catch (MalformedURLException e) {
                    new FileNotFoundException("File not found. URL could not be resolved: " + e.getMessage());
                }
            }
            if (in == null) {
                return null;
            }
            if (!(in instanceof BufferedInputStream)) {
                in = new BufferedInputStream(in);
            }
            if (in == null) {
                return null;
            }
            try {
                AbstractPDFStream embeddedFont;
                if (desc.getFontType() == FontType.TYPE0) {
                    MultiByteFont mbfont = (MultiByteFont)font;
                    FontFileReader reader = new FontFileReader(in);
                    TTFSubSetFile subset = new TTFSubSetFile();
                    byte[] subsetFont = subset.readFont(reader, mbfont.getTTCName(), mbfont.getUsedGlyphs());
                    embeddedFont = new PDFTTFStream(subsetFont.length);
                    ((PDFTTFStream)embeddedFont).setData(subsetFont, subsetFont.length);
                } else if (desc.getFontType() == FontType.TYPE1) {
                    PFBParser parser = new PFBParser();
                    PFBData pfb = parser.parsePFB(in);
                    embeddedFont = new PDFT1Stream();
                    ((PDFT1Stream)embeddedFont).setData(pfb);
                } else {
                    byte[] file = IOUtils.toByteArray(in);
                    embeddedFont = new PDFTTFStream(file.length);
                    ((PDFTTFStream)embeddedFont).setData(file, file.length);
                }
                abstractPDFStream = embeddedFont;
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return abstractPDFStream;
        }
        catch (IOException ioe) {
            this.log.error("Failed to embed font [" + desc + "] " + desc.getFontName(), ioe);
            return null;
        }
    }

    private CustomFont getCustomFont(FontDescriptor desc) {
        Typeface tempFont = desc instanceof LazyFont ? ((LazyFont)desc).getRealFont() : (Typeface)((Object)desc);
        if (!(tempFont instanceof CustomFont)) {
            throw new IllegalArgumentException("FontDescriptor must be instance of CustomFont, but is a " + desc.getClass().getName());
        }
        return (CustomFont)tempFont;
    }

    public PDFStream makeStream(String type, boolean add) {
        PDFStream obj = new PDFStream();
        obj.setDocument(this.getDocument());
        obj.getFilterList().addDefaultFilters(this.getDocument().getFilterMap(), type);
        if (add) {
            this.getDocument().registerObject(obj);
        }
        return obj;
    }

    public PDFICCStream makePDFICCStream() {
        PDFICCStream iccStream = new PDFICCStream();
        iccStream.getFilterList().addDefaultFilters(this.getDocument().getFilterMap(), "content");
        this.getDocument().registerObject(iccStream);
        return iccStream;
    }

    public PDFICCBasedColorSpace makeICCBasedColorSpace(PDFResourceContext res, String explicitName, PDFICCStream iccStream) {
        PDFICCBasedColorSpace cs = new PDFICCBasedColorSpace(explicitName, iccStream);
        this.getDocument().registerObject(cs);
        if (res != null) {
            res.getPDFResources().addColorSpace(cs);
        } else {
            this.getDocument().getResources().addColorSpace(cs);
        }
        return cs;
    }

    public PDFArray makeArray(int[] values) {
        PDFArray array = new PDFArray(values);
        this.getDocument().registerObject(array);
        return array;
    }

    public PDFGState makeGState(Map settings, PDFGState current) {
        PDFGState wanted = new PDFGState();
        wanted.addValues(PDFGState.DEFAULT);
        wanted.addValues(settings);
        PDFGState existing = this.getDocument().findGState(wanted, current);
        if (existing != null) {
            return existing;
        }
        PDFGState gstate = new PDFGState();
        gstate.addValues(settings);
        this.getDocument().registerObject(gstate);
        return gstate;
    }

    public PDFAnnotList makeAnnotList() {
        PDFAnnotList obj = new PDFAnnotList();
        this.getDocument().assignObjectNumber(obj);
        return obj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

