#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: lens
version: 4.17
id: lens-4.17-8h7k4T9w40mJobS2zuaMS4
key: lens-4.17-8h7k4T9w40mJobS2zuaMS4
license: BSD-2-Clause
copyright: Copyright (C) 2012-2016 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
author: Edward A. Kmett
stability: provisional
homepage: http://github.com/ekmett/lens/
synopsis: Lenses, Folds and Traversals
description:
    This package comes \"Batteries Included\" with many useful lenses for the types
    commonly used from the Haskell Platform, and with tools for automatically
    generating lenses and isomorphisms for user-supplied data types.
    .
    The combinators in @Control.Lens@ provide a highly generic toolbox for composing
    families of getters, folds, isomorphisms, traversals, setters and lenses and their
    indexed variants.
    .
    An overview, with a large number of examples can be found in the <https://github.com/ekmett/lens#lens-lenses-folds-and-traversals README>.
    .
    An introductory video on the style of code used in this library by Simon Peyton Jones is available from <http://skillsmatter.com/podcast/scala/lenses-compositional-data-access-and-manipulation Skills Matter>.
    .
    A video on how to use lenses and how they are constructed is available on <http://youtu.be/cefnmjtAolY?hd=1 youtube>.
    .
    Slides for that second talk can be obtained from <http://comonad.com/haskell/Lenses-Folds-and-Traversals-NYC.pdf comonad.com>.
    .
    More information on the care and feeding of lenses, including a brief tutorial and motivation
    for their types can be found on the <https://github.com/ekmett/lens/wiki lens wiki>.
    .
    A small game of @pong@ and other more complex examples that manage their state using lenses can be found in the <https://github.com/ekmett/lens/blob/master/examples/ example folder>.
    .
    /Lenses, Folds and Traversals/
    .
    With some signatures simplified, the core of the hierarchy of lens-like constructions looks like:
    .
    .
    <<http://i.imgur.com/ALlbPRa.png>>
    .
    <Hierarchy.png (Local Copy)>
    .
    You can compose any two elements of the hierarchy above using @(.)@ from the @Prelude@, and you can
    use any element of the hierarchy as any type it linked to above it.
    .
    The result is their lowest upper bound in the hierarchy (or an error if that bound doesn'\''t exist).
    .
    For instance:
    .
    * You can use any '\''Traversal'\'' as a '\''Fold'\'' or as a '\''Setter'\''.
    .
    * The composition of a '\''Traversal'\'' and a '\''Getter'\'' yields a '\''Fold'\''.
    .
    /Minimizing Dependencies/
    .
    If you want to provide lenses and traversals for your own types in your own libraries, then you
    can do so without incurring a dependency on this (or any other) lens package at all.
    .
    /e.g./ for a data type:
    .
    > data Foo a = Foo Int Int a
    .
    You can define lenses such as
    .
    > -- bar :: Lens'\'' (Foo a) Int
    > bar :: Functor f => (Int -> f Int) -> Foo a -> f (Foo a)
    > bar f (Foo a b c) = fmap (\a'\'' -> Foo a'\'' b c) (f a)
    .
    > -- quux :: Lens (Foo a) (Foo b) a b
    > quux :: Functor f => (a -> f b) -> Foo a -> f (Foo b)
    > quux f (Foo a b c) = fmap (Foo a b) (f c)
    .
    without the need to use any type that isn'\''t already defined in the @Prelude@.
    .
    And you can define a traversal of multiple fields with '\''Control.Applicative.Applicative'\'':
    .
    > -- traverseBarAndBaz :: Traversal'\'' (Foo a) Int
    > traverseBarAndBaz :: Applicative f => (Int -> f Int) -> Foo a -> f (Foo a)
    > traverseBarAndBaz f (Foo a b c) = Foo <$> f a <*> f b <*> pure c
    .
    What is provided in this library is a number of stock lenses and traversals for
    common haskell types, a wide array of combinators for working them, and more
    exotic functionality, (/e.g./ getters, setters, indexed folds, isomorphisms).
category: Data, Lenses, Generics
abi: 2232a6a99f368d45b6701b75bc771f2b
exposed: True
exposed-modules:
    Control.Exception.Lens Control.Lens Control.Lens.At
    Control.Lens.Combinators Control.Lens.Cons Control.Lens.Each
    Control.Lens.Empty Control.Lens.Equality Control.Lens.Extras
    Control.Lens.Fold Control.Lens.Getter Control.Lens.Indexed
    Control.Lens.Internal Control.Lens.Internal.Bazaar
    Control.Lens.Internal.ByteString Control.Lens.Internal.CTypes
    Control.Lens.Internal.Coerce Control.Lens.Internal.Context
    Control.Lens.Internal.Deque Control.Lens.Internal.Exception
    Control.Lens.Internal.FieldTH Control.Lens.Internal.Fold
    Control.Lens.Internal.Getter Control.Lens.Internal.Indexed
    Control.Lens.Internal.Instances Control.Lens.Internal.Iso
    Control.Lens.Internal.Level Control.Lens.Internal.List
    Control.Lens.Internal.Magma Control.Lens.Internal.Prism
    Control.Lens.Internal.PrismTH Control.Lens.Internal.Review
    Control.Lens.Internal.Setter Control.Lens.Internal.TH
    Control.Lens.Internal.Zoom Control.Lens.Iso Control.Lens.Lens
    Control.Lens.Level Control.Lens.Operators Control.Lens.Plated
    Control.Lens.Prism Control.Lens.Reified Control.Lens.Review
    Control.Lens.Setter Control.Lens.TH Control.Lens.Traversal
    Control.Lens.Tuple Control.Lens.Type Control.Lens.Unsound
    Control.Lens.Wrapped Control.Lens.Zoom Control.Monad.Error.Lens
    Control.Parallel.Strategies.Lens Control.Seq.Lens Data.Array.Lens
    Data.Bits.Lens Data.ByteString.Lazy.Lens Data.ByteString.Lens
    Data.ByteString.Strict.Lens Data.Complex.Lens Data.Data.Lens
    Data.Dynamic.Lens Data.HashSet.Lens Data.IntSet.Lens Data.List.Lens
    Data.Map.Lens Data.Sequence.Lens Data.Set.Lens Data.Text.Lazy.Lens
    Data.Text.Lens Data.Text.Strict.Lens Data.Tree.Lens
    Data.Typeable.Lens Data.Vector.Generic.Lens Data.Vector.Lens
    GHC.Generics.Lens Language.Haskell.TH.Lens Numeric.Lens
    Numeric.Natural.Lens System.Exit.Lens System.FilePath.Lens
    System.IO.Error.Lens
hidden-modules: Paths_lens
import-dirs: /usr/lib/ghc-8.6.1/site-local/lens-4.17
library-dirs: /usr/lib/ghc-8.6.1/site-local/lens-4.17
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.6.1/lens-4.17
hs-libraries: HSlens-4.17-8h7k4T9w40mJobS2zuaMS4
depends:
    array-0.5.2.0 base-4.12.0.0 base-orphans-0.8-MvDA9MxK5e7YBvQaNB0jM
    bifunctors-5.5.3-JOCZ6gpIic7H4mHnWNJbdd bytestring-0.10.8.2
    call-stack-0.1.0-J1eWgTNOnM4IGVyeW0v2YZ
    comonad-5.0.4-HRLmz868PXZ5L5mXj8jipp containers-0.6.0.1
    contravariant-1.5-4tjvhiNPMk29NhGPKE1GIF
    distributive-0.6-DtS7Cohs8dm4iMWvChMD9B
    exceptions-0.10.0-6rXXyfyq3lH6yULL2y1jk1 filepath-1.4.2.1
    free-5.1-HBkqjGoz8WgDKVtCe8zPGF ghc-prim-0.5.3
    hashable-1.2.7.0-KHvCgUH7dIl7mI8fl4akIo
    kan-extensions-5.2-9Md24I5hdO9GNjJdBb3TXj mtl-2.2.2
    parallel-3.2.2.0-BGtJixj8tYyBHs92byBvWM
    profunctors-5.3-8jSlhTxWDNkEHiRDjiAQ7G
    reflection-2.1.4-D3IaixAKGmk6dzEKDGsgtn
    semigroupoids-5.3.1-6XYi8Zh0RJZGpeabZDZF5r
    tagged-0.8.6-FABECvKnqYbBCttH1EeJvB template-haskell-2.14.0.0
    text-1.2.3.1 th-abstraction-0.2.8.0-2MRzEHawWMWAqBCMqgM9a
    transformers-0.5.5.0
    transformers-compat-0.6.2-JV1ddSnlm3mL2xw4J4K8Kw
    unordered-containers-0.2.9.0-LB7iMl6A8usDj0EAzhnafU
    vector-0.12.0.1-BKWaeB2IPwRDyZEP11mv5m
    void-0.7.2-1ijpCmwDTXMGDRdU43YY14
haddock-interfaces: /usr/share/doc/haskell-lens/html/lens.haddock
haddock-html: /usr/share/doc/haskell-lens/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

