/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinObject;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.Minimizer;
import org.jmol.minimize.forcefield.AtomType;
import org.jmol.minimize.forcefield.CalculationsMMFF;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolAsyncException;

public class ForceFieldMMFF
extends ForceField {
    private static final int A4_VDW = 122;
    private static final int A4_BNDK = 123;
    private static final int A4_CHRG = 124;
    private static final int A4_SB = 125;
    private static final int A4_SBDEF = 126;
    private static final int KEY_SBDEF = 0;
    private static final int KEY_PBCI = 0;
    private static final int KEY_VDW = 0;
    private static final int KEY_BNDK = 0;
    private static final int KEY_OOP = 6;
    private static final int TYPE_PBCI = 1;
    private static final int TYPE_VDW = 17;
    private static final int TYPE_BNDK = 546;
    private static final int TYPE_CHRG = 34;
    private static final int TYPE_BOND = 3;
    private static final int TYPE_ANGLE = 5;
    private static final int TYPE_SB = 21;
    private static final int TYPE_SBDEF = 37;
    private static final int TYPE_TORSION = 9;
    private static final int TYPE_OOP = 13;
    private static Lst<AtomType> atomTypes;
    private static Map<Object, Object> ffParams;
    private int[] rawAtomTypes;
    private int[] rawBondTypes;
    private float[] rawMMFF94Charges;
    private Lst<BS>[] vRings;
    private static final String names = "END.BCI.CHG.ANG.NDK.OND.OOP.TBN.FSB.TOR.VDW.";
    private static final int[] types;
    private String line;
    private static final int[] sbMap;
    private int[] typeData = new int[4];
    private static final int[] equivalentTypes;

    static {
        int[] nArray = new int[11];
        nArray[1] = 1;
        nArray[2] = 34;
        nArray[3] = 5;
        nArray[4] = 546;
        nArray[5] = 3;
        nArray[6] = 13;
        nArray[7] = 21;
        nArray[8] = 37;
        nArray[9] = 9;
        nArray[10] = 17;
        types = nArray;
        int[] nArray2 = new int[9];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 5;
        nArray2[4] = 4;
        nArray2[5] = 6;
        nArray2[6] = 8;
        nArray2[7] = 9;
        nArray2[8] = 11;
        sbMap = nArray2;
        equivalentTypes = new int[]{1, 1, 2, 1, 3, 1, 4, 1, 5, 5, 6, 6, 7, 6, 8, 8, 9, 8, 10, 8, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 15, 17, 15, 18, 15, 19, 19, 1, 1, 21, 5, 22, 1, 23, 5, 24, 5, 25, 25, 26, 25, 28, 5, 28, 5, 29, 5, 2, 1, 31, 31, 7, 6, 21, 5, 8, 8, 6, 6, 36, 5, 2, 1, 9, 8, 10, 8, 10, 8, 3, 1, 42, 8, 10, 8, 16, 15, 10, 8, 9, 8, 42, 8, 9, 8, 6, 6, 21, 5, 7, 6, 21, 5, 42, 8, 9, 8, 10, 8, 10, 8, 2, 1, 10, 8, 6, 6, 4, 1, 42, 8, 10, 8, 2, 1, 2, 1, 9, 8, 9, 8, 9, 8, 8, 8, 9, 8, 70, 70, 5, 5, 16, 15, 18, 15, 17, 15, 26, 25, 9, 8, 12, 12, 2, 1, 9, 8, 2, 1, 10, 8, 9, 8};
    }

    public String[] getAtomTypeDescriptions() {
        return ForceFieldMMFF.getAtomTypeDescs(this.rawAtomTypes);
    }

    public float[] getPartialCharges() {
        return this.rawMMFF94Charges;
    }

    public ForceFieldMMFF(Minimizer minimizer) throws JmolAsyncException {
        this.minimizer = minimizer;
        this.name = "MMFF";
        this.getParameters();
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean setModel(BS bS, int n) {
        Minimizer minimizer = this.minimizer;
        if (!this.setArrays(minimizer.atoms, minimizer.bsAtoms, minimizer.bonds, minimizer.rawBondCount, false, false)) {
            return false;
        }
        this.setModelFields();
        if (!this.fixTypes()) {
            return false;
        }
        this.calc = new CalculationsMMFF(this, ffParams, this.minAtoms, this.minBonds, this.minAngles, this.minTorsions, this.minPositions, this.minimizer.constraints);
        this.calc.setLoggingEnabled(true);
        return this.calc.setupCalculations();
    }

    public boolean setArrays(Atom[] atomArray, BS bS, Bond[] bondArray, int n, boolean bl, boolean bl2) {
        Minimizer minimizer = this.minimizer;
        this.vRings = AU.createArrayOfArrayList(4);
        this.rawAtomTypes = ForceFieldMMFF.setAtomTypes(atomArray, bS, minimizer.vwr.getSmilesMatcher(), this.vRings, bl2);
        if (this.rawAtomTypes == null) {
            return false;
        }
        this.rawBondTypes = this.setBondTypes(bondArray, n, bS);
        this.rawMMFF94Charges = ForceFieldMMFF.calculatePartialCharges(bondArray, this.rawBondTypes, atomArray, this.rawAtomTypes, bS, bl);
        return true;
    }

    private void getParameters() throws JmolAsyncException {
        Hashtable<Object, Object> hashtable;
        block16: {
            if (ffParams != null) {
                return;
            }
            this.getAtomTypes();
            hashtable = new Hashtable<Object, Object>();
            String string = "mmff94.par.txt";
            if (Logger.debugging) {
                Logger.debug("reading data from " + string);
            }
            BufferedReader bufferedReader = null;
            String string2 = null;
            try {
                try {
                    bufferedReader = this.getBufferedReader(string);
                    int n = 0;
                    int n2 = 0;
                    while (true) {
                        if ((n = (string2 = bufferedReader.readLine()).indexOf(".PAR")) < 0) {
                            continue;
                        }
                        n2 = types[names.indexOf(string2.substring(n - 3, n + 1)) / 4];
                        if (n2 < 1) break;
                        this.readParams(bufferedReader, n2, hashtable);
                    }
                    bufferedReader.close();
                }
                catch (JmolAsyncException jmolAsyncException) {
                    throw new JmolAsyncException(jmolAsyncException.getFileName());
                }
                catch (Exception exception) {
                    System.err.println("Exception " + exception.toString() + " in getResource " + string + " line=" + string2);
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception2) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ffParams = hashtable;
    }

    /*
     * Unable to fully structure code
     */
    private void readParams(BufferedReader var1_1, int var2_2, Map<Object, Object> var3_3) throws Exception {
        var4_4 = null;
        var5_5 = 0;
        var6_6 = 127;
        var7_7 = 127;
        var8_8 = 127;
        var9_9 = 0;
        switch (var2_2) {
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 34: {
                var8_8 = 124;
                break;
            }
            case 21: {
                var8_8 = 125;
                break;
            }
            case 546: {
                var8_8 = 123;
                var9_9 = 0;
                break;
            }
            case 13: {
                var9_9 = 6;
                break;
            }
            case 1: {
                var9_9 = 0;
                break;
            }
            case 37: {
                var8_8 = 126;
                var9_9 = 0;
                break;
            }
            case 17: {
                var8_8 = 122;
                var9_9 = 0;
            }
        }
lbl33:
        // 10 sources

        if (!var1_1.readLine().startsWith("*")) ** GOTO lbl33
        while ((this.line = var1_1.readLine()).startsWith("*")) {
        }
        block35: do {
            switch (var2_2) {
                case 1: 
                case 13: 
                case 37: 
                case 546: {
                    ** GOTO lbl48
                }
                case 17: {
                    if (this.line.charAt(5) != ' ') {
                        break;
                    }
                    ** GOTO lbl48
                }
                case 34: {
                    if (this.line.charAt(0) == '4') continue block35;
                }
                case 3: 
                case 5: 
                case 9: 
                case 21: {
                    var9_9 = this.line.charAt(0) - 48;
                }
lbl48:
                // 4 sources

                default: {
                    switch (var2_2) {
                        case 9: 
                        case 13: {
                            var8_8 = this.ival(18, 20);
                        }
                        case 5: 
                        case 21: 
                        case 37: {
                            var7_7 = this.ival(13, 15);
                        }
                        case 3: 
                        case 34: 
                        case 546: {
                            var6_6 = this.ival(8, 10);
                        }
                        case 1: 
                        case 17: {
                            var5_5 = this.ival(3, 5);
                        }
                    }
                    switch (var2_2) {
                        case 546: {
                            var4_4 = new double[]{this.dval(19, 25), this.dval(13, 18)};
                            break;
                        }
                        case 3: {
                            var4_4 = new double[]{this.dval(14, 20), this.dval(25, 31)};
                            break;
                        }
                        case 5: 
                        case 21: {
                            var4_4 = new double[]{this.dval(19, 25), this.dval(28, 35)};
                            break;
                        }
                        case 34: {
                            var4_4 = Float.valueOf(this.fval(10, 20));
                            break;
                        }
                        case 13: {
                            var4_4 = new double[]{this.dval(24, 30)};
                            break;
                        }
                        case 1: {
                            var4_4 = Float.valueOf(this.fval(5, 15));
                            break;
                        }
                        case 37: {
                            var10_11 = this.dval(19, 25);
                            var12_12 = this.dval(28, 35);
                            var4_4 = new double[]{var10_11, var12_12};
                            var14_13 = MinObject.getKey(var9_9, var5_5, var6_6, var7_7, var8_8);
                            var3_3.put(var14_13, var4_4);
                            var4_4 = new double[]{var12_12, var10_11};
                            var15_14 = var5_5;
                            var5_5 = var7_7;
                            var7_7 = var15_14;
                            break;
                        }
                        case 9: {
                            var4_4 = new double[]{this.dval(22, 28), this.dval(30, 36), this.dval(38, 44)};
                            break;
                        }
                        case 17: {
                            var4_4 = new double[]{this.dval(10, 15), this.dval(20, 25), this.dval(30, 35), this.dval(40, 45), this.line.charAt(46)};
                        }
                    }
                    var10_10 = MinObject.getKey(var9_9, var5_5, var6_6, var7_7, var8_8);
                    var3_3.put(var10_10, var4_4);
                    if (!Logger.debugging) continue block35;
                    Logger.debug(String.valueOf(MinObject.decodeKey(var10_10)) + " " + (var4_4 instanceof Float != false ? var4_4 : Escape.eAD((double[])var4_4)));
                }
            }
        } while (!(this.line = var1_1.readLine()).startsWith("$"));
    }

    private int ival(int n, int n2) {
        return PT.parseInt(this.line.substring(n, n2).trim());
    }

    private float fval(int n, int n2) {
        return PT.fVal(this.line.substring(n, n2).trim());
    }

    private double dval(int n, int n2) {
        return PT.dVal(this.line.substring(n, n2).trim());
    }

    private void getAtomTypes() throws JmolAsyncException {
        String string = "MMFF94-smarts.txt";
        Lst<AtomType> lst = new Lst<AtomType>();
        try {
            BufferedReader bufferedReader = this.getBufferedReader(string);
            lst.addLast(new AtomType(0, 0, 0, 0.0f, 1, "H or NOT FOUND", ""));
            while ((this.line = bufferedReader.readLine()) != null) {
                if (this.line.length() == 0 || this.line.startsWith("#")) continue;
                int n = this.ival(3, 5);
                int n2 = this.ival(6, 8);
                int n3 = this.ival(9, 11);
                float f = this.fval(12, 15) / 12.0f;
                int n4 = this.ival(16, 18);
                String string2 = this.line.substring(19, 44).trim();
                String string3 = this.line.substring(45).trim();
                AtomType atomType = new AtomType(n, n2, n3, f, n4, string2, string3);
                lst.addLast(atomType);
                ForceFieldMMFF.setFlags(atomType);
            }
            bufferedReader.close();
        }
        catch (JmolAsyncException jmolAsyncException) {
            throw new JmolAsyncException(jmolAsyncException.getFileName());
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception.toString() + " in getResource " + string + " line=" + this.line);
        }
        Logger.info(String.valueOf(lst.size() - 1) + " SMARTS-based atom types read");
        atomTypes = lst;
    }

    private static void setFlags(AtomType atomType) {
        switch (atomType.mmType) {
            case 32: 
            case 35: 
            case 72: {
                atomType.fcadj = 0.5f;
                break;
            }
            case 62: 
            case 76: {
                atomType.fcadj = 0.25f;
            }
        }
        switch (atomType.mmType) {
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 58: 
            case 59: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 78: 
            case 79: 
            case 81: 
            case 82: {
                atomType.arom = true;
            }
        }
        switch (atomType.mmType) {
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 30: 
            case 37: 
            case 39: 
            case 54: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 67: 
            case 75: 
            case 78: 
            case 80: 
            case 81: {
                atomType.sbmb = true;
            }
        }
        switch (atomType.mmType) {
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 32: 
            case 35: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 59: 
            case 62: 
            case 70: 
            case 72: 
            case 76: {
                atomType.pilp = true;
            }
        }
        switch (atomType.mmType) {
            case 10: 
            case 32: 
            case 35: 
            case 39: 
            case 41: 
            case 44: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 69: 
            case 72: 
            case 81: 
            case 82: {
                atomType.mltb = 1;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 16: 
            case 17: 
            case 30: 
            case 37: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 51: 
            case 53: 
            case 54: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 80: {
                atomType.mltb = 2;
                break;
            }
            case 4: 
            case 42: 
            case 60: 
            case 61: {
                atomType.mltb = 3;
            }
        }
    }

    public static float[] calculatePartialCharges(Bond[] bondArray, int[] nArray, Atom[] atomArray, int[] nArray2, BS bS, boolean bl) {
        float[] fArray = new float[atomArray.length];
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            fArray[n] = ((AtomType)ForceFieldMMFF.atomTypes.get((int)Math.max((int)0, (int)nArray2[n]))).formalCharge;
            n = bS.nextSetBit(n + 1);
        }
        Atom atom = null;
        int n2 = nArray.length;
        while (--n2 >= 0) {
            float f;
            atom = bondArray[n2].atom1;
            Atom atom2 = bondArray[n2].atom2;
            boolean bl2 = bS.get(atom.i);
            boolean bl3 = bS.get(atom2.i);
            if (!bl2 && !bl3) continue;
            int n3 = nArray2[atom.i];
            AtomType atomType = (AtomType)atomTypes.get(Math.max(0, n3));
            int n4 = n3 < 0 ? -n3 : atomType.mmType;
            n3 = nArray2[atom2.i];
            AtomType atomType2 = (AtomType)atomTypes.get(Math.max(0, n3));
            int n5 = n3 < 0 ? -n3 : atomType2.mmType;
            try {
                float f2;
                String string;
                int n6 = nArray[n2];
                float f3 = n4 < n5 ? -1 : 1;
                Integer n7 = MinObject.getKey(n6, f3 == 1.0f ? n5 : n4, f3 == 1.0f ? n4 : n5, 127, 124);
                Float f4 = (Float)ffParams.get(n7);
                String string2 = string = Logger.debugging ? atom + "/" + atom2 + " mmTypes=" + n4 + "/" + n5 + " formalCharges=" + atomType.formalCharge + "/" + atomType2.formalCharge + " bci = " : null;
                if (f4 == null) {
                    float f5 = ((Float)ffParams.get(MinObject.getKey(0, n4, 127, 127, 127))).floatValue();
                    float f6 = ((Float)ffParams.get(MinObject.getKey(0, n5, 127, 127, 127))).floatValue();
                    f2 = f5 - f6;
                    if (Logger.debugging) {
                        string = String.valueOf(string) + f5 + " - " + f6 + " = ";
                    }
                } else {
                    f2 = f3 * f4.floatValue();
                }
                if (Logger.debugging) {
                    string = String.valueOf(string) + f2;
                    Logger.debug(string);
                }
                f = atomType2.fcadj * atomType2.formalCharge - atomType.fcadj * atomType.formalCharge + f2;
            }
            catch (Exception exception) {
                f = Float.NaN;
            }
            if (bl2) {
                int n8 = atom.i;
                fArray[n8] = fArray[n8] + f;
            }
            if (!bl3) continue;
            int n9 = atom2.i;
            fArray[n9] = fArray[n9] - f;
        }
        if (bl) {
            float f = 0.0f;
            int n10 = fArray.length;
            while (--n10 >= 0) {
                fArray[n10] = (float)Math.round(fArray[n10] * 1000.0f) / 1000.0f;
                f += Math.abs(fArray[n10]);
            }
            if (f == 0.0f && atom != null) {
                fArray[atom.i] = -0.0f;
            }
        }
        return fArray;
    }

    private static boolean isBondType1(AtomType atomType, AtomType atomType2) {
        return atomType.sbmb && atomType2.sbmb || atomType.arom && atomType2.arom;
    }

    private int getBondType(Bond bond, AtomType atomType, AtomType atomType2, int n, int n2) {
        return ForceFieldMMFF.isBondType1(atomType, atomType2) && bond.getCovalentOrder() == 1 && !this.isAromaticBond(n, n2) ? 1 : 0;
    }

    private boolean isAromaticBond(int n, int n2) {
        if (this.vRings[3] != null) {
            int n3 = this.vRings[3].size();
            while (--n3 >= 0) {
                BS bS = (BS)this.vRings[3].get(n3);
                if (!bS.get(n) || !bS.get(n2)) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] getAtomTypeDescs(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        int n = nArray.length;
        while (--n >= 0) {
            stringArray[n] = String.valueOf(nArray[n] < 0 ? -nArray[n] : ((AtomType)ForceFieldMMFF.atomTypes.get((int)nArray[n])).mmType);
        }
        return stringArray;
    }

    private static int[] setAtomTypes(Atom[] atomArray, BS bS, SmilesMatcherInterface smilesMatcherInterface, Lst<BS>[] lstArray, boolean bl) {
        int n;
        Object object;
        Lst<BS> lst = new Lst<BS>();
        String[] stringArray = new String[atomTypes.size()];
        int[] nArray = new int[atomArray.length];
        BS bS2 = new BS();
        BS bS3 = new BS();
        BS bS4 = BSUtil.copy(bS);
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            Atom atom = atomArray[n2];
            object = atom.bonds;
            if (object != null) {
                int n3 = ((Bond[])object).length;
                while (--n3 >= 0) {
                    if (!object[n3].isCovalent()) continue;
                    bS4.set(object[n3].getOtherAtom((Atom)atom).i);
                }
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        n2 = bS4.nextSetBit(0);
        while (n2 >= 0) {
            int n4 = atomArray[n2].getElementNumber();
            switch (n4) {
                case 1: {
                    bS3.set(n2);
                    break;
                }
                default: {
                    bS2.set(n4);
                }
            }
            n2 = bS4.nextSetBit(n2 + 1);
        }
        n2 = 0;
        int n5 = 1;
        while (n5 < atomTypes.size()) {
            object = (AtomType)atomTypes.get(n5);
            if (bS2.get(object.elemNo)) {
                stringArray[n5] = object.smartsCode;
                ++n2;
            }
            ++n5;
        }
        Logger.info(String.valueOf(n2) + " SMARTS matches used");
        try {
            smilesMatcherInterface.getMMFF94AtomTypes(stringArray, atomArray, atomArray.length, bS4, lst, lstArray);
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
        }
        BS bS5 = new BS();
        int n6 = 0;
        while (n6 < lst.size()) {
            BS bS6 = (BS)lst.get(n6);
            if (bS6 != null) {
                bS6.andNot(bS5);
                n = bS6.nextSetBit(0);
                while (n >= 0) {
                    nArray[n] = n6;
                    n = bS6.nextSetBit(n + 1);
                }
                bS5.or(bS6);
            }
            ++n6;
        }
        n6 = bS3.nextSetBit(0);
        while (n6 >= 0) {
            Bond[] bondArray = atomArray[n6].bonds;
            if (bondArray != null) {
                n = nArray[bondArray[0].getOtherAtom((Atom)atomArray[n6]).i];
                if (n != 0) {
                    bS5.set(n6);
                }
                nArray[n6] = -((AtomType)ForceFieldMMFF.atomTypes.get((int)n)).hType;
            }
            n6 = bS3.nextSetBit(n6 + 1);
        }
        if (Logger.debugging) {
            n6 = bS4.nextSetBit(0);
            while (n6 >= 0) {
                Logger.debug("atom " + atomArray[n6] + "\ttype " + (nArray[n6] < 0 ? "" + -nArray[n6] : String.valueOf(((AtomType)ForceFieldMMFF.atomTypes.get((int)nArray[n6])).mmType) + "\t" + ((AtomType)ForceFieldMMFF.atomTypes.get((int)nArray[n6])).smartsCode + "\t" + ((AtomType)ForceFieldMMFF.atomTypes.get((int)nArray[n6])).descr));
                n6 = bS4.nextSetBit(n6 + 1);
            }
        }
        if (!bl && bS5.cardinality() != bS4.cardinality()) {
            return null;
        }
        return nArray;
    }

    private int[] setBondTypes(Bond[] bondArray, int n, BS bS) {
        int[] nArray = new int[n];
        int n2 = n;
        while (--n2 >= 0) {
            Atom atom = bondArray[n2].atom1;
            Atom atom2 = bondArray[n2].atom2;
            boolean bl = bS.get(atom.i);
            boolean bl2 = bS.get(atom2.i);
            if (!bl && !bl2) continue;
            int n3 = this.rawAtomTypes[atom.i];
            AtomType atomType = (AtomType)atomTypes.get(Math.max(0, n3));
            n3 = this.rawAtomTypes[atom2.i];
            AtomType atomType2 = (AtomType)atomTypes.get(Math.max(0, n3));
            nArray[n2] = this.getBondType(bondArray[n2], atomType, atomType2, atom.i, atom2.i);
        }
        return nArray;
    }

    private boolean fixTypes() {
        Object object;
        int n = this.minAtomCount;
        while (--n >= 0) {
            int n2;
            object = this.minAtoms[n];
            int n3 = ((MinAtom)object).atom.i;
            int n4 = this.rawAtomTypes[n3];
            ((MinAtom)object).ffAtomType = (AtomType)atomTypes.get(Math.max(0, n4));
            ((MinAtom)object).ffType = n2 = n4 < 0 ? -n4 : ((AtomType)ForceFieldMMFF.atomTypes.get((int)n4)).mmType;
            ((MinAtom)object).vdwKey = MinObject.getKey(0, n2, 127, 127, 122);
            ((MinAtom)object).partialCharge = this.rawMMFF94Charges[n3];
        }
        n = this.minBonds.length;
        while (--n >= 0) {
            object = this.minBonds[n];
            ((MinBond)object).type = this.rawBondTypes[((MinBond)object).rawIndex];
            ((MinBond)object).key = this.getKey(object, ((MinBond)object).type, 3);
            if (((MinBond)object).key != null) continue;
            return false;
        }
        n = this.minAngles.length;
        while (--n >= 0) {
            object = this.minAngles[n];
            ((MinAngle)object).key = this.getKey(object, ((MinAngle)object).type, 5);
            ((MinAngle)object).sbKey = this.getKey(object, ((MinAngle)object).sbType, 21);
        }
        n = this.minTorsions.length;
        while (--n >= 0) {
            object = this.minTorsions[n];
            ((MinTorsion)object).key = this.getKey(object, ((MinTorsion)object).type, 9);
        }
        return true;
    }

    private int setAngleType(MinAngle minAngle) {
        minAngle.type = this.minBonds[minAngle.data[3]].type + this.minBonds[minAngle.data[4]].type;
        if (this.checkRings(this.vRings[0], minAngle.data, 3)) {
            minAngle.type = minAngle.type + (minAngle.type == 0 ? 3 : 4);
        } else if (this.checkRings(this.vRings[1], minAngle.data, 3)) {
            minAngle.type = minAngle.type + (minAngle.type == 0 ? 4 : 6);
        }
        minAngle.sbType = sbMap[minAngle.type];
        switch (minAngle.type) {
            case 1: 
            case 5: 
            case 7: {
                minAngle.sbType += this.minBonds[minAngle.data[4]].type;
            }
        }
        return minAngle.type;
    }

    private int setTorsionType(MinTorsion minTorsion) {
        if (this.checkRings(this.vRings[1], minTorsion.data, 4)) {
            minTorsion.type = 4;
            return 4;
        }
        int n = this.minBonds[minTorsion.data[5]].type == 1 ? 1 : (minTorsion.type = this.minBonds[minTorsion.data[4]].type == 0 && this.minBonds[minTorsion.data[6]].type == 0 ? 0 : 2);
        if (minTorsion.type == 0 && this.checkRings(this.vRings[2], minTorsion.data, 4)) {
            minTorsion.type = 5;
        }
        return minTorsion.type;
    }

    private int typeOf(int n) {
        return this.minAtoms[n].ffType;
    }

    private boolean checkRings(Lst<BS> lst, int[] nArray, int n) {
        if (lst != null) {
            int n2 = lst.size();
            while (--n2 >= 0) {
                BS bS = (BS)lst.get(n2);
                if (!bS.get(this.minAtoms[nArray[0]].atom.i) || !bS.get(this.minAtoms[nArray[1]].atom.i) || n >= 3 && !bS.get(this.minAtoms[nArray[2]].atom.i) || n >= 4 && !bS.get(this.minAtoms[nArray[3]].atom.i)) continue;
                return true;
            }
        }
        return false;
    }

    private Integer getKey(Object object, int n, int n2) {
        MinObject minObject = object instanceof MinObject ? (MinObject)object : null;
        int[] nArray = minObject == null ? (int[])object : minObject.data;
        int n3 = 4;
        switch (n2) {
            case 3: {
                this.fixOrder(nArray, 0, 1);
                n3 = 2;
                break;
            }
            case 5: {
                if (this.fixOrder(nArray, 0, 2) == -1) {
                    ForceFieldMMFF.swap(nArray, 3, 4);
                }
                n = this.setAngleType((MinAngle)minObject);
                n3 = 3;
                break;
            }
            case 21: {
                n3 = 3;
                break;
            }
            case 9: {
                switch (this.fixOrder(nArray, 1, 2)) {
                    case 1: {
                        break;
                    }
                    case -1: {
                        ForceFieldMMFF.swap(nArray, 0, 3);
                        ForceFieldMMFF.swap(nArray, 4, 6);
                        break;
                    }
                    case 0: {
                        if (this.fixOrder(nArray, 0, 3) != -1) break;
                        ForceFieldMMFF.swap(nArray, 4, 6);
                    }
                }
                n = this.setTorsionType((MinTorsion)minObject);
            }
        }
        Integer n4 = null;
        int n5 = 0;
        while (n5 < 4) {
            this.typeData[n5] = n5 < n3 ? this.typeOf(nArray[n5]) : 127;
            ++n5;
        }
        switch (n2) {
            case 21: {
                this.typeData[3] = 125;
                break;
            }
            case 13: {
                ForceFieldMMFF.sortOop(this.typeData);
            }
        }
        n4 = MinObject.getKey(n, this.typeData[0], this.typeData[1], this.typeData[2], this.typeData[3]);
        double[] dArray = (double[])ffParams.get(n4);
        switch (n2) {
            case 3: {
                return dArray != null && dArray[0] > 0.0 ? n4 : this.applyEmpiricalRules(minObject, dArray, 3);
            }
            case 5: {
                if (dArray == null || dArray[0] == 0.0) break;
                return n4;
            }
            case 9: {
                if (dArray == null) {
                    n4 = this.getTorsionKey(n, 0, 2);
                    if (!(ffParams.containsKey(n4) || ffParams.containsKey(n4 = this.getTorsionKey(n, 2, 0)) || ffParams.containsKey(n4 = this.getTorsionKey(n, 2, 2)))) {
                        n4 = this.getTorsionKey(0, 2, 2);
                    }
                    dArray = (double[])ffParams.get(n4);
                }
                return dArray != null ? n4 : this.applyEmpiricalRules(minObject, dArray, 9);
            }
            case 21: {
                if (dArray != null) {
                    return n4;
                }
                int n6 = this.getRowFor(nArray[0]);
                int n7 = this.getRowFor(nArray[1]);
                int n8 = this.getRowFor(nArray[2]);
                return MinObject.getKey(0, n6, n7, n8, 126);
            }
            case 13: {
                if (dArray == null) break;
                return n4;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        int n9 = 0;
        while (n9 < 3 && !bl2) {
            int n10 = 0;
            int n11 = 1;
            while (n10 < n3) {
                if ((n2 & n11) == n11) {
                    this.typeData[n10] = ForceFieldMMFF.getEquivalentType(this.typeOf(nArray[n10]), n9);
                }
                ++n10;
                n11 <<= 1;
            }
            switch (n2) {
                case 3: {
                    bl = ForceFieldMMFF.fixTypeOrder(this.typeData, 0, 1);
                    break;
                }
                case 5: {
                    bl = ForceFieldMMFF.fixTypeOrder(this.typeData, 0, 2);
                    break;
                }
                case 13: {
                    ForceFieldMMFF.sortOop(this.typeData);
                }
            }
            n4 = MinObject.getKey(n, this.typeData[0], this.typeData[1], this.typeData[2], this.typeData[3]);
            bl2 = ffParams.containsKey(n4);
            ++n9;
        }
        if (bl2) {
            if (bl) {
                switch (n2) {
                    case 5: {
                        ForceFieldMMFF.swap(nArray, 0, 2);
                        ForceFieldMMFF.swap(nArray, 3, 4);
                        this.setAngleType((MinAngle)minObject);
                    }
                }
            }
        } else if (n != 0 && n2 == 5) {
            n4 = n4 ^ 0xFF;
        }
        dArray = (double[])ffParams.get(n4);
        switch (n2) {
            case 5: {
                return dArray != null && dArray[0] != 0.0 ? n4 : this.applyEmpiricalRules(minObject, dArray, 5);
            }
        }
        return n4;
    }

    private Integer getTorsionKey(int n, int n2, int n3) {
        return MinObject.getKey(n, ForceFieldMMFF.getEquivalentType(this.typeData[0], n2), this.typeData[1], this.typeData[2], ForceFieldMMFF.getEquivalentType(this.typeData[3], n3));
    }

    private Integer applyEmpiricalRules(MinObject minObject, double[] dArray, int n) {
        double d = 0.0;
        switch (n) {
            case 3: {
                MinAtom minAtom = this.minAtoms[minObject.data[0]];
                MinAtom minAtom2 = this.minAtoms[minObject.data[1]];
                int n2 = minAtom.atom.getElementNumber();
                int n3 = minAtom2.atom.getElementNumber();
                Integer n4 = MinObject.getKey(0, Math.min(n2, n3), Math.max(n2, n3), 127, 123);
                dArray = (double[])ffParams.get(n4);
                if (dArray == null) {
                    return null;
                }
                double d2 = dArray[0];
                double d3 = dArray[1];
                double d4 = ForceFieldMMFF.getRuleBondLength(minAtom, minAtom2, ((MinBond)minObject).order, this.isAromaticBond(minObject.data[0], minObject.data[1]));
                if (d4 == 0.0) {
                    return null;
                }
                double d5 = d3 / d4;
                double d6 = d5 * d5;
                double d7 = d6 * d6;
                double d8 = d7 * d6;
                double d9 = d2 * d8;
                minObject.ddata = new double[]{d9, d4};
                return -1;
            }
            case 5: {
                double d10;
                if (dArray == null || (d10 = dArray[1]) == 0.0) {
                    MinAtom minAtom = this.minAtoms[minObject.data[1]];
                    Atom atom = minAtom.atom;
                    int n5 = atom.getElementNumber();
                    block5 : switch (minObject.type) {
                        case 3: 
                        case 5: 
                        case 6: {
                            d10 = 60.0;
                            d *= 0.05;
                            break;
                        }
                        case 4: 
                        case 7: 
                        case 8: {
                            d10 = 90.0;
                            break;
                        }
                        default: {
                            d10 = 120.0;
                            int n6 = atom.getCovalentBondCount();
                            switch (n6) {
                                case 2: {
                                    if (MinAtom.isLinear(minAtom)) {
                                        d10 = 180.0;
                                        break block5;
                                    }
                                    if (n5 == 8) {
                                        d10 = 105.0;
                                        break block5;
                                    }
                                    if (n5 <= 10) break block5;
                                    d10 = 95.0;
                                    break block5;
                                }
                                case 3: {
                                    if (minAtom.ffAtomType.mltb != 0 || minAtom.ffAtomType.val != 3) break block5;
                                    d10 = n5 == 7 ? 107 : 92;
                                    break block5;
                                }
                                case 4: {
                                    d10 = 109.45;
                                }
                            }
                        }
                    }
                }
                d = 1.75;
                switch (minObject.type) {
                    case 3: 
                    case 5: 
                    case 6: {
                        d *= 0.05;
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 8: {
                        d *= 0.85;
                    }
                }
                double d11 = ForceFieldMMFF.getZParam(this.minAtoms[minObject.data[0]].atom.getElementNumber());
                double d12 = ForceFieldMMFF.getCParam(this.minAtoms[minObject.data[1]].atom.getElementNumber());
                double d13 = ForceFieldMMFF.getZParam(this.minAtoms[minObject.data[2]].atom.getElementNumber());
                double d14 = ForceFieldMMFF.getR0(this.minBonds[minObject.data[3]]);
                double d15 = ForceFieldMMFF.getR0(this.minBonds[minObject.data[4]]);
                double d16 = d14 + d15;
                double d17 = d16 * d16;
                double d18 = (d14 - d15) / d17;
                double d19 = d10 * (Math.PI / 180);
                d19 *= d19;
                double d20 = d * d11 * d12 * d13 * Math.exp(-2.0 * d18) / (d16 * d19);
                minObject.ddata = new double[]{d20, d10};
                return -1;
            }
            case 9: {
                int n7 = minObject.data[1];
                int n8 = minObject.data[2];
                MinAtom minAtom = this.minAtoms[n7];
                MinAtom minAtom3 = this.minAtoms[n8];
                if (MinAtom.isLinear(minAtom) || MinAtom.isLinear(minAtom3)) {
                    return null;
                }
                MinBond minBond = this.minBonds[minObject.data[5]];
                int n9 = minAtom.atom.getElementNumber();
                int n10 = minAtom3.atom.getElementNumber();
                double d21 = ForceFieldMMFF.getUParam(n9);
                double d22 = ForceFieldMMFF.getUParam(n10);
                double d23 = ForceFieldMMFF.getVParam(n9);
                double d24 = ForceFieldMMFF.getVParam(n10);
                double d25 = 0.0;
                double d26 = 0.0;
                double d27 = 0.0;
                double d28 = -1.0;
                double d29 = -1.0;
                double d30 = -1.0;
                double d31 = 0.0;
                int n11 = minAtom.ffAtomType.val;
                int n12 = minAtom3.ffAtomType.val;
                boolean bl = minAtom.ffAtomType.pilp;
                boolean bl2 = minAtom3.ffAtomType.pilp;
                int n13 = minAtom.ffAtomType.mltb;
                int n14 = minAtom3.ffAtomType.mltb;
                if (this.isAromaticBond(n7, n8)) {
                    d28 = bl || bl2 ? 0.3 : 0.5;
                    d = n11 + n12 == 7 ? 3 : 6;
                } else if (minBond.order == 2) {
                    d = 6.0;
                    d28 = n13 == 2 && n14 == 2 ? 1.0 : 0.4;
                } else {
                    int n15 = minAtom.atom.getCovalentBondCount();
                    int n16 = minAtom3.atom.getCovalentBondCount();
                    if (n15 == 4 && n16 == 4) {
                        d23 = ForceFieldMMFF.getVParam(n9);
                        d24 = ForceFieldMMFF.getVParam(n10);
                        d29 = 9.0;
                    } else {
                        boolean bl3;
                        if (n15 != 4 && (n11 > n15 || n13 > 0) || n16 != 4 && (n12 > n16 || n14 > 0)) {
                            return null;
                        }
                        boolean bl4 = bl && n14 > 0;
                        boolean bl5 = bl3 = bl2 && n13 > 0;
                        if (minBond.order == 1 && (n13 > 0 && n14 > 0 || bl4 || bl3)) {
                            if (bl && bl2) {
                                return null;
                            }
                            d = 6.0;
                            d28 = bl4 ? (n14 == 1 ? 0.5 : (n9 <= 10 && n10 <= 10 ? 0.3 : 0.15)) : (bl3 ? (n13 == 1 ? 0.5 : (n9 <= 10 && n10 <= 10 ? 0.3 : 0.15)) : (!(n13 != 1 && n14 != 1 || n9 != 6 && n10 != 6) ? 0.4 : 0.15));
                        } else {
                            switch (n9 << 8 + n10) {
                                case 2056: {
                                    d31 = 2.0;
                                    d30 = 2.0;
                                    break;
                                }
                                case 2064: {
                                    d30 = 2.0;
                                    d31 = 8.0;
                                    break;
                                }
                                case 4104: {
                                    d30 = 8.0;
                                    d31 = 2.0;
                                    break;
                                }
                                case 4112: {
                                    d31 = 8.0;
                                    d30 = 8.0;
                                    break;
                                }
                                default: {
                                    d29 = n15 * n16;
                                }
                            }
                        }
                    }
                }
                if (d28 > 0.0) {
                    d26 = d * d28 * Math.sqrt(d21 * d22);
                } else if (d29 > 0.0) {
                    d27 = Math.sqrt(d23 * d24) / d29;
                } else if (d30 != 0.0) {
                    d26 = -Math.sqrt(d30 * d31);
                }
                minObject.ddata = new double[]{d25, d26, d27};
                return -1;
            }
        }
        return null;
    }

    private static double getR0(MinBond minBond) {
        return (minBond.ddata == null ? (double[])ffParams.get(minBond.key) : minBond.ddata)[1];
    }

    private int getRowFor(int n) {
        int n2 = this.minAtoms[n].atom.getElementNumber();
        return n2 < 3 ? 0 : (n2 < 11 ? 1 : (n2 < 19 ? 2 : (n2 < 37 ? 3 : 4)));
    }

    double getOutOfPlaneParameter(int[] nArray) {
        double[] dArray = (double[])ffParams.get(this.getKey(nArray, 6, 13));
        return dArray == null ? 0.0 : dArray[0];
    }

    private static void sortOop(int[] nArray) {
        ForceFieldMMFF.fixTypeOrder(nArray, 0, 2);
        ForceFieldMMFF.fixTypeOrder(nArray, 0, 3);
        ForceFieldMMFF.fixTypeOrder(nArray, 2, 3);
    }

    private static boolean fixTypeOrder(int[] nArray, int n, int n2) {
        if (nArray[n] > nArray[n2]) {
            ForceFieldMMFF.swap(nArray, n, n2);
            return true;
        }
        return false;
    }

    private int fixOrder(int[] nArray, int n, int n2) {
        int n3 = this.typeOf(nArray[n2]) - this.typeOf(nArray[n]);
        if (n3 < 0) {
            ForceFieldMMFF.swap(nArray, n, n2);
        }
        return n3 < 0 ? -1 : (n3 > 0 ? 1 : 0);
    }

    private static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private static int getEquivalentType(int n, int n2) {
        return n == 0 ? 0 : (n == 70 || n > 82 ? n : (n2 == 2 ? 0 : equivalentTypes[(n - 1 << 1) + n2]));
    }

    private static double getZParam(int n) {
        switch (n) {
            case 1: {
                return 1.395;
            }
            case 6: {
                return 2.494;
            }
            case 7: {
                return 2.711;
            }
            case 8: {
                return 3.045;
            }
            case 9: {
                return 2.847;
            }
            case 14: {
                return 2.35;
            }
            case 15: {
                return 2.35;
            }
            case 16: {
                return 2.98;
            }
            case 17: {
                return 2.909;
            }
            case 35: {
                return 3.017;
            }
            case 53: {
                return 3.086;
            }
        }
        return 0.0;
    }

    private static double getCParam(int n) {
        switch (n) {
            case 5: {
                return 0.704;
            }
            case 6: {
                return 1.016;
            }
            case 7: {
                return 1.113;
            }
            case 8: {
                return 1.337;
            }
            case 14: {
                return 0.811;
            }
            case 15: {
                return 1.068;
            }
            case 16: {
                return 1.249;
            }
            case 17: {
                return 1.078;
            }
            case 33: {
                return 0.825;
            }
        }
        return 0.0;
    }

    private static double getUParam(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: {
                return 2.0;
            }
            case 14: 
            case 15: 
            case 16: {
                return 1.25;
            }
        }
        return 0.0;
    }

    private static double getVParam(int n) {
        switch (n) {
            case 6: {
                return 2.12;
            }
            case 7: {
                return 1.5;
            }
            case 8: {
                return 0.2;
            }
            case 14: {
                return 1.22;
            }
            case 15: {
                return 2.4;
            }
            case 16: {
                return 0.49;
            }
        }
        return 0.0;
    }

    private static double getCovalentRadius(int n) {
        switch (n) {
            case 1: {
                return 0.33;
            }
            case 5: {
                return 0.81;
            }
            case 6: {
                return 0.77;
            }
            case 7: {
                return 0.73;
            }
            case 8: {
                return 0.72;
            }
            case 9: {
                return 0.74;
            }
            case 13: {
                return 1.22;
            }
            case 14: {
                return 1.15;
            }
            case 15: {
                return 1.09;
            }
            case 16: {
                return 1.03;
            }
            case 17: {
                return 1.01;
            }
            case 31: {
                return 1.19;
            }
            case 32: {
                return 1.2;
            }
            case 33: {
                return 1.2;
            }
            case 34: {
                return 1.16;
            }
            case 35: {
                return 1.15;
            }
            case 44: {
                return 1.46;
            }
            case 50: {
                return 1.4;
            }
            case 51: {
                return 1.41;
            }
            case 52: {
                return 1.35;
            }
            case 53: {
                return 1.33;
            }
            case 81: {
                return 1.51;
            }
            case 82: {
                return 1.53;
            }
            case 83: {
                return 1.55;
            }
        }
        return Elements.getBondingRadius(n, 0);
    }

    private static double getRuleBondLength(MinAtom minAtom, MinAtom minAtom2, int n, boolean bl) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                return 0.0;
            }
        }
        int n2 = minAtom.atom.getElementNumber();
        int n3 = minAtom2.atom.getElementNumber();
        double d = ForceFieldMMFF.getCovalentRadius(n2);
        double d2 = ForceFieldMMFF.getCovalentRadius(n3);
        double d3 = Elements.getAllredRochowElectroNeg(n2);
        double d4 = Elements.getAllredRochowElectroNeg(n3);
        double d5 = n2 == 1 || n3 == 1 ? 0.05 : 0.085;
        double d6 = 1.4;
        double d7 = d + d2;
        if (bl) {
            n = minAtom.ffAtomType.pilp || minAtom2.ffAtomType.pilp ? 5 : 4;
        } else {
            switch (minAtom.ffAtomType.mltb << 4 + minAtom2.ffAtomType.mltb) {
                case 17: {
                    n = 4;
                    break;
                }
                case 18: 
                case 33: {
                    n = 5;
                }
            }
        }
        block8 : switch (n) {
            case 1: {
                switch (minAtom.ffAtomType.mltb) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                switch (minAtom2.ffAtomType.mltb) {
                    case 0: {
                        break block8;
                    }
                    case 1: 
                    case 2: {
                        break block8;
                    }
                }
                break;
            }
        }
        return d7 -= d5 * Math.pow(Math.abs(d3 - d4), d6);
    }
}

