/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.c.PAL;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.script.SV;
import org.jmol.shape.AtomShape;
import org.jmol.shapespecial.Polyhedron;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Logger;
import org.jmol.util.MeshCapper;
import org.jmol.util.Normix;

public class Polyhedra
extends AtomShape
implements Comparator<Object[]> {
    private static final float DEFAULT_FACECENTEROFFSET = 0.25f;
    private static final int EDGES_NONE = 0;
    public static final int EDGES_ALL = 1;
    public static final int EDGES_FRONT = 2;
    public static final int EDGES_ONLY = 3;
    private static final int MAX_VERTICES = 250;
    private static final int FACE_COUNT_MAX = 247;
    private static final int MAX_OTHER = 498;
    private P3[] otherAtoms = new P3[498];
    private V3[] normalsT = new V3[251];
    private int[][] planesT = AU.newInt2(250);
    private static final P3 randomPoint = P3.new3(3141.0f, 2718.0f, 1414.0f);
    private static final int MODE_BONDING = 1;
    private static final int MODE_POINTS = 2;
    private static final int MODE_RADIUS = 3;
    private static final int MODE_BITSET = 4;
    private static final int MODE_UNITCELL = 5;
    private static final int MODE_INFO = 6;
    private static final float DEFAULT_PLANAR_PARAM = 0.98f;
    private static final float CONVEX_HULL_MAX = 0.05f;
    public int polyhedronCount;
    public Polyhedron[] polyhedrons = new Polyhedron[32];
    public int drawEdges;
    private float radius;
    private float radiusMin;
    private float pointScale;
    private int nVertices;
    float faceCenterOffset;
    boolean isCollapsed;
    boolean isFull;
    private boolean iHaveCenterBitSet;
    private boolean bondedOnly;
    private boolean haveBitSetVertices;
    private BS centers;
    private String thisID;
    private P3 center;
    private BS bsVertices;
    private BS bsVertexCount;
    private boolean useUnitCell;
    private int nPoints;
    private float planarParam;
    private Map<String, Object> info;
    private float distanceRef;
    private int modelIndex;
    private boolean isAuto;
    private int[][] explicitFaces;
    private BS bsPolys = new BS();
    private final V3 vAB = new V3();
    private final V3 vAC = new V3();
    private final V3 vBC = new V3();
    private static float MAX_DISTANCE_TO_PLANE = 0.1f;

    @Override
    public int compare(Object[] objectArray, Object[] objectArray2) {
        float f;
        float f2 = objectArray[0] == null ? Float.MAX_VALUE : ((Float)objectArray[0]).floatValue();
        float f3 = f = objectArray2[0] == null ? Float.MAX_VALUE : ((Float)objectArray2[0]).floatValue();
        return f2 < f ? -1 : (f2 > f ? 1 : 0);
    }

    @Override
    public void setProperty(String string, Object object, BS bS) {
        int n;
        Object object2;
        int n2;
        if (this.thisID != null) {
            bS = new BS();
        }
        if ("init" == string) {
            this.faceCenterOffset = 0.25f;
            this.planarParam = Float.NaN;
            this.pointScale = 0.0f;
            this.radiusMin = 0.0f;
            this.radius = 0.0f;
            this.nPoints = 0;
            this.nVertices = 0;
            this.modelIndex = -1;
            this.bsVertices = null;
            this.thisID = null;
            this.center = null;
            this.centers = null;
            this.info = null;
            this.bsVertexCount = new BS();
            this.haveBitSetVertices = false;
            this.isAuto = false;
            this.useUnitCell = false;
            this.iHaveCenterBitSet = false;
            this.isFull = false;
            this.isCollapsed = false;
            this.bondedOnly = false;
            if (Boolean.TRUE == object) {
                this.drawEdges = 0;
            }
            return;
        }
        if ("definedFaces" == string) {
            this.setDefinedFaces((P3[])((Object[])object)[1], (int[][])((Object[])object)[0]);
            return;
        }
        if ("generate" == string) {
            if (!this.iHaveCenterBitSet && bS != null && !bS.isEmpty()) {
                this.centers = bS;
                this.iHaveCenterBitSet = true;
            }
            this.deletePolyhedra();
            this.buildPolyhedra();
            return;
        }
        if ("thisID" == string) {
            this.thisID = (String)object;
            return;
        }
        if ("center" == string) {
            this.center = (P3)object;
            return;
        }
        if ("offset" == string) {
            if (this.thisID != null) {
                this.offsetPolyhedra((P3)object);
            }
            return;
        }
        if ("scale" == string) {
            if (this.thisID != null) {
                this.scalePolyhedra(((Float)object).floatValue());
            }
            return;
        }
        if ("model" == string) {
            this.modelIndex = (Integer)object;
            return;
        }
        if ("collapsed" == string) {
            this.isCollapsed = true;
            return;
        }
        if ("full" == string) {
            this.isFull = true;
            return;
        }
        if ("nVertices" == string) {
            int n3 = (Integer)object;
            if (n3 < 0) {
                if (-n3 >= this.nVertices) {
                    this.bsVertexCount.setBits(this.nVertices, 1 - n3);
                    this.nVertices = -n3;
                }
            } else {
                this.nVertices = n3;
                this.bsVertexCount.set(this.nVertices);
            }
            return;
        }
        if ("centers" == string) {
            this.centers = (BS)object;
            this.iHaveCenterBitSet = true;
            return;
        }
        if ("unitCell" == string) {
            this.useUnitCell = true;
            return;
        }
        if ("to" == string) {
            this.bsVertices = (BS)object;
            return;
        }
        if ("toBitSet" == string) {
            this.bsVertices = (BS)object;
            this.haveBitSetVertices = true;
            return;
        }
        if ("toVertices" == string) {
            P3[] p3Array = (P3[])object;
            int n4 = this.nPoints = Math.min(p3Array.length, 250);
            while (--n4 >= 0) {
                this.otherAtoms[n4] = p3Array[n4];
            }
            return;
        }
        if ("faceCenterOffset" == string) {
            this.faceCenterOffset = ((Float)object).floatValue();
            return;
        }
        if ("distanceFactor" == string) {
            return;
        }
        if ("planarParam" == string) {
            this.planarParam = ((Float)object).floatValue();
            return;
        }
        if ("bonds" == string) {
            this.bondedOnly = true;
            return;
        }
        if ("info" == string) {
            this.info = (Map)object;
            this.centers = this.info.containsKey("center") ? null : BSUtil.newAndSetBit(((SV)this.info.get((Object)"atomIndex")).intValue);
            this.iHaveCenterBitSet = this.centers != null;
            return;
        }
        if ("delete" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.deletePolyhedra();
            return;
        }
        if ("on" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.setVisible(true);
            return;
        }
        if ("off" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.setVisible(false);
            return;
        }
        if ("noedges" == string) {
            this.drawEdges = 0;
            return;
        }
        if ("edges" == string) {
            this.drawEdges = 1;
            return;
        }
        if ("edgesOnly" == string) {
            this.drawEdges = 3;
            return;
        }
        if ("frontedges" == string) {
            this.drawEdges = 2;
            return;
        }
        if (string.indexOf("color") == 0) {
            bS = "colorThis" == string && this.iHaveCenterBitSet ? this.centers : this.andBitSet(bS);
            n2 = "colorPhase" == string ? 1 : 0;
            object2 = n2 != 0 ? ((Object[])object)[1] : object;
            short s = n2 != 0 ? C.getColix((Integer)((Object[])object)[0]) : (short)0;
            n = C.getColixO(n2 != 0 ? object2 : object);
            BS bS2 = this.findPolyBS(bS);
            int n5 = bS2.nextSetBit(0);
            while (n5 >= 0) {
                Polyhedron polyhedron = this.polyhedrons[n5];
                if (polyhedron.id == null) {
                    polyhedron.colixEdge = s;
                } else {
                    polyhedron.colixEdge = s;
                    polyhedron.colix = (short)n;
                }
                n5 = bS2.nextSetBit(n5 + 1);
            }
            if (this.thisID != null) {
                return;
            }
            object = object2;
            string = "color";
        }
        if (string.indexOf("translucency") == 0) {
            n2 = object.equals("translucent");
            if (this.thisID != null) {
                object2 = this.findPolyBS(bS);
                n = ((BS)object2).nextSetBit(0);
                while (n >= 0) {
                    Polyhedron polyhedron = this.polyhedrons[n];
                    polyhedron.colix = C.getColixTranslucent3(polyhedron.colix, n2 != 0, this.translucentLevel);
                    if (polyhedron.colixEdge != 0) {
                        polyhedron.colixEdge = C.getColixTranslucent3(polyhedron.colixEdge, n2 != 0, this.translucentLevel);
                    }
                    n = ((BS)object2).nextSetBit(n + 1);
                }
                return;
            }
            BS bS3 = bS = "translucentThis".equals(object) && this.iHaveCenterBitSet ? this.centers : this.andBitSet(bS);
            if (object.equals("translucentThis")) {
                object = "translucent";
            }
        }
        if ("radius" == string) {
            float f = ((Float)object).floatValue();
            if (f <= 0.0f) {
                this.isAuto = true;
                f = f == 0.0f ? 6.0f : -f;
            }
            this.radius = f;
            return;
        }
        if ("radius1" == string) {
            this.radiusMin = this.radius;
            this.radius = ((Float)object).floatValue();
            return;
        }
        if ("points" == string) {
            this.pointScale = ((Float)object).floatValue();
            this.pointsPolyhedra(bS, this.pointScale);
            return;
        }
        if (string == "deleteModelAtoms") {
            n2 = ((int[])((Object[])object)[2])[0];
            int n6 = this.polyhedronCount;
            while (--n6 >= 0) {
                Polyhedron polyhedron = this.polyhedrons[n6];
                polyhedron.info = null;
                if (polyhedron.modelIndex > n2) {
                    --polyhedron.modelIndex;
                    continue;
                }
                if (polyhedron.modelIndex != n2) continue;
                --this.polyhedronCount;
                this.polyhedrons = (Polyhedron[])AU.deleteElements(this.polyhedrons, n6, 1);
            }
        }
        this.setPropAS(string, object, bS);
    }

    private void setDefinedFaces(P3[] p3Array, int[][] nArray) {
        int n;
        BS bS = new BS();
        int n2 = nArray.length;
        while (--n2 >= 0) {
            int[] nArray2 = nArray[n2];
            n = nArray2.length;
            while (--n >= 0) {
                bS.set(nArray2[n]);
            }
        }
        BS bS2 = BSUtil.newBitSet2(0, bS.length());
        bS2.andNot(bS);
        int n3 = bS2.cardinality();
        if (n3 > 0) {
            n = p3Array.length;
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n) {
                if (!bS2.get(n5)) {
                    nArray4[n4] = n5;
                    nArray3[n5] = n4++;
                }
                ++n5;
            }
            P3[] p3Array2 = new P3[n4];
            int n6 = 0;
            while (n6 < n4) {
                p3Array2[n6] = p3Array[nArray4[n6]];
                ++n6;
            }
            p3Array = p3Array2;
            n6 = nArray.length;
            while (--n6 >= 0) {
                int[] nArray5 = nArray[n6];
                int n7 = nArray5.length;
                while (--n7 >= 0) {
                    nArray5[n7] = nArray3[nArray5[n7]];
                }
            }
        }
        n = this.nPoints = p3Array.length;
        this.center = new P3();
        this.otherAtoms = new P3[n + 1];
        if (n > 0) {
            this.otherAtoms[n] = this.center;
            int n8 = 0;
            while (n8 < n) {
                this.otherAtoms[n8] = p3Array[n8];
                this.center.add(this.otherAtoms[n8]);
                ++n8;
            }
            this.center.scale(1.0f / (float)n);
        }
        this.explicitFaces = nArray;
    }

    private void pointsPolyhedra(BS bS, float f) {
        bS = this.findPolyBS(this.thisID == null ? bS : null);
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            this.polyhedrons[n].pointScale = f;
            n = bS.nextSetBit(n + 1);
        }
    }

    private void scalePolyhedra(float f) {
        BS bS = this.findPolyBS(null);
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            this.polyhedrons[n].scale = f;
            n = bS.nextSetBit(n + 1);
        }
    }

    private void offsetPolyhedra(P3 p3) {
        BS bS = this.findPolyBS(null);
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            this.polyhedrons[n].setOffset(P3.newP(p3));
            n = bS.nextSetBit(n + 1);
        }
    }

    @Override
    public int getIndexFromName(String string) {
        if (string != null) {
            int n = this.polyhedronCount;
            while (--n >= 0) {
                if (!string.equalsIgnoreCase(this.polyhedrons[n].id)) continue;
                return n;
            }
        }
        return -1;
    }

    @Override
    public Object getProperty(String string, int n) {
        Map<String, Object> map = this.polyhedrons[n].getInfo(this.vwr, string);
        return string.equalsIgnoreCase("info") ? map : map.get(string);
    }

    @Override
    public boolean getPropertyData(String string, Object[] objectArray) {
        String string2;
        int n = objectArray[0] instanceof Integer ? (Integer)objectArray[0] : Integer.MIN_VALUE;
        String string3 = string2 = objectArray[0] instanceof String ? (String)objectArray[0] : null;
        if (string == "index") {
            int n2 = this.getIndexFromName(string2);
            if (n2 >= 0) {
                objectArray[1] = n2;
            }
            return n2 >= 0;
        }
        if (string == "checkID") {
            return this.checkID(string2);
        }
        if (string == "getAtomsWithin") {
            Polyhedron polyhedron = this.findPoly(string2, n, true);
            if (polyhedron == null) {
                return false;
            }
            objectArray[2] = this.getAtomsWithin(polyhedron, ((Float)objectArray[1]).floatValue());
            return true;
        }
        if (string == "info") {
            Polyhedron polyhedron = this.findPoly(string2, n, true);
            if (polyhedron == null) {
                return false;
            }
            objectArray[1] = polyhedron.getInfo(this.vwr, "info");
            return true;
        }
        if (string == "points") {
            Polyhedron polyhedron = this.findPoly(string2, n, false);
            if (polyhedron == null) {
                return false;
            }
            objectArray[1] = polyhedron.vertices;
            return true;
        }
        if (string == "symmetry") {
            BS bS = (BS)objectArray[2];
            String string4 = "";
            int n3 = 0;
            while (n3 < this.polyhedronCount) {
                Polyhedron polyhedron = this.polyhedrons[n3];
                if (!(polyhedron.id == null ? string2 != null || bS != null && !bS.get(polyhedron.centralAtom.i) : string2 != null && !PT.isLike(polyhedron.id, string2))) {
                    string4 = String.valueOf(string4) + (n3 + 1) + "\t" + polyhedron.getSymmetry(this.vwr, true) + "\n";
                }
                ++n3;
            }
            objectArray[1] = string4;
            return true;
        }
        if (string == "move") {
            M4 m4 = (M4)objectArray[1];
            if (m4 == null) {
                return false;
            }
            BS bS = (BS)objectArray[0];
            BS bS2 = this.findPolyBS(bS);
            int n4 = bS2.nextSetBit(0);
            while (n4 >= 0) {
                this.polyhedrons[n4].move(m4, bS);
                n4 = bS2.nextSetBit(n4 + 1);
            }
            return true;
        }
        if (string == "getCenters") {
            int n5;
            SmilesMatcherInterface smilesMatcherInterface;
            String string5 = (String)objectArray[1];
            BS bS = (BS)objectArray[2];
            SmilesMatcherInterface smilesMatcherInterface2 = smilesMatcherInterface = string5 == null ? null : this.vwr.getSmilesMatcher();
            if (smilesMatcherInterface != null) {
                string5 = smilesMatcherInterface.cleanSmiles(string5);
            }
            int n6 = n5 = string5 != null ? PT.countChar(string5, '*') : n;
            if (n5 == 0) {
                n5 = Integer.MIN_VALUE;
            }
            BS bS3 = new BS();
            if (string5 == null || smilesMatcherInterface != null) {
                int n7 = this.polyhedronCount;
                while (--n7 >= 0) {
                    Polyhedron polyhedron = this.polyhedrons[n7];
                    if (polyhedron.id != null || n5 != (n5 > 0 ? polyhedron.nVertices : (n5 > Integer.MIN_VALUE ? -polyhedron.faces.length : n5))) continue;
                    n = polyhedron.centralAtom.i;
                    if (bS != null && !bS.get(n)) continue;
                    if (string5 == null) {
                        bS3.set(n);
                        continue;
                    }
                    polyhedron.getSymmetry(this.vwr, false);
                    String string6 = polyhedron.polySmiles;
                    try {
                        if (smilesMatcherInterface.areEqual(string5, string6) <= 0) continue;
                        bS3.set(n);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            objectArray[1] = bS3;
            return true;
        }
        if (string == "allInfo") {
            Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
            int n8 = this.polyhedronCount;
            while (--n8 >= 0) {
                lst.addLast(this.polyhedrons[n8].getInfo(this.vwr, "info"));
            }
            objectArray[1] = lst;
            return true;
        }
        return this.getPropShape(string, objectArray);
    }

    private BS getAtomsWithin(Polyhedron polyhedron, float f) {
        P3 p3;
        int[][] nArray = polyhedron.faces;
        P3[] p3Array = polyhedron.vertices;
        P3 p32 = p3 = polyhedron.center == null ? polyhedron.centralAtom : polyhedron.center;
        if (polyhedron.planes == null) {
            V3 v3 = new V3();
            V3 v32 = new V3();
            polyhedron.planes = new P4[nArray.length];
            int n = nArray.length;
            while (--n >= 0) {
                P4 p4 = polyhedron.planes[n] = new P4();
                Measure.getPlaneThroughPoints(p3Array[nArray[n][0]], p3Array[nArray[n][1]], p3Array[nArray[n][2]], v3, v32, p4);
            }
        }
        float f2 = 0.0f;
        int n = polyhedron.nVertices;
        while (--n >= 0) {
            float f3 = p3Array[n].distance(p3);
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        BS bS = BSUtil.copy(this.vwr.getAtomsNearPt(f2 + f, p3));
        Atom[] atomArray = this.vwr.ms.at;
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            int n3 = nArray.length;
            while (--n3 >= 0) {
                System.out.println(Measure.distanceToPlane(polyhedron.planes[n3], atomArray[n2]));
                if (!(Measure.distanceToPlane(polyhedron.planes[n3], atomArray[n2]) > f + 0.001f)) continue;
                bS.clear(n2);
                break;
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        return bS;
    }

    private boolean checkID(String string) {
        this.thisID = string;
        return this.findPolyBS(null).cardinality() > 0;
    }

    private Polyhedron findPoly(String string, int n, boolean bl) {
        int n2 = this.polyhedronCount;
        while (--n2 >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n2];
            if (!(polyhedron.id == null ? polyhedron.centralAtom.i == n : polyhedron.id.equalsIgnoreCase(string))) continue;
            return bl || !this.polyhedrons[n2].collapsed ? this.polyhedrons[n2] : null;
        }
        return null;
    }

    private BS findPolyBS(BS bS) {
        BS bS2 = this.bsPolys;
        bS2.clearAll();
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (!(polyhedron.id == null ? bS != null && bS.get(polyhedron.centralAtom.i) : this.isMatch(polyhedron.id))) continue;
            bS2.set(n);
        }
        return bS2;
    }

    private boolean isMatch(String string) {
        return this.thisID != null && PT.isMatch(string.toLowerCase(), this.thisID.toLowerCase(), true, true);
    }

    @Override
    public Object getShapeDetail() {
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        int n = 0;
        while (n < this.polyhedronCount) {
            lst.addLast(this.polyhedrons[n].getInfo(this.vwr, "info"));
            ++n;
        }
        return lst;
    }

    private BS andBitSet(BS bS) {
        BS bS2 = new BS();
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (polyhedron.id != null) continue;
            bS2.set(polyhedron.centralAtom.i);
        }
        bS2.and(bS);
        return bS2;
    }

    private void deletePolyhedra() {
        int n = 0;
        byte by = PAL.pidOf(null);
        BS bS = this.findPolyBS(this.centers);
        int n2 = 0;
        while (n2 < this.polyhedronCount) {
            Polyhedron polyhedron = this.polyhedrons[n2];
            if (bS.get(n2)) {
                if (this.colixes != null && polyhedron.id == null) {
                    this.setColixAndPalette((short)0, by, polyhedron.centralAtom.i);
                }
            } else {
                this.polyhedrons[n++] = polyhedron;
            }
            ++n2;
        }
        n2 = n;
        while (n2 < this.polyhedronCount) {
            this.polyhedrons[n2] = null;
            ++n2;
        }
        this.polyhedronCount = n;
    }

    private void setVisible(boolean bl) {
        BS bS = this.findPolyBS(this.centers);
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            polyhedron.visible = bl;
            if (polyhedron.centralAtom != null) {
                this.atoms[polyhedron.centralAtom.i].setShapeVisibility(this.vf, bl);
            }
            n = bS.nextSetBit(n + 1);
        }
    }

    private void buildPolyhedra() {
        boolean bl;
        Polyhedron polyhedron = null;
        if (this.thisID != null) {
            if (PT.isWild(this.thisID)) {
                return;
            }
            if (this.center != null) {
                if (this.nPoints == 0) {
                    this.setPointsFromBitset();
                }
                polyhedron = this.validatePolyhedron(this.center, this.nPoints);
            }
        } else if (this.info != null && this.info.containsKey("id")) {
            Object object = this.info.get("id");
            this.thisID = object instanceof SV ? ((SV)object).asString() : object.toString();
            polyhedron = new Polyhedron().setInfo(this.vwr, this.info, this.vwr.ms.at);
        }
        if (polyhedron != null) {
            this.addPolyhedron(polyhedron);
            return;
        }
        boolean bl2 = bl = this.radius == 0.0f || this.bondedOnly;
        int n = this.info != null ? 6 : (this.nPoints > 0 ? 2 : (this.haveBitSetVertices ? 4 : (this.useUnitCell ? 5 : (bl ? 1 : 3))));
        AtomIndexIterator atomIndexIterator = n == 3 ? this.ms.getSelectedAtomIterator(null, false, false, false, false) : null;
        int n2 = this.centers.nextSetBit(0);
        while (n2 >= 0) {
            Atom atom = this.atoms[n2];
            polyhedron = null;
            switch (n) {
                case 4: {
                    polyhedron = this.constructBitSetPolyhedron(atom);
                    break;
                }
                case 5: {
                    polyhedron = this.constructUnitCellPolygon(atom, bl);
                    break;
                }
                case 1: {
                    polyhedron = this.constructBondsPolyhedron(atom, 0);
                    break;
                }
                case 3: {
                    this.vwr.setIteratorForAtom(atomIndexIterator, n2, this.radius);
                    polyhedron = this.constructRadiusPolyhedron(atom, atomIndexIterator);
                    break;
                }
                case 6: {
                    polyhedron = new Polyhedron().setInfo(this.vwr, this.info, this.vwr.ms.at);
                    break;
                }
                case 2: {
                    polyhedron = this.validatePolyhedron(atom, this.nPoints);
                }
            }
            if (polyhedron != null) {
                this.addPolyhedron(polyhedron);
            }
            if (this.haveBitSetVertices) break;
            n2 = this.centers.nextSetBit(n2 + 1);
        }
        if (atomIndexIterator != null) {
            atomIndexIterator.release();
        }
    }

    private void setPointsFromBitset() {
        if (this.bsVertices != null) {
            int n = this.bsVertices.nextSetBit(0);
            while (n >= 0 && this.nPoints < 250) {
                this.otherAtoms[this.nPoints++] = this.atoms[n];
                n = this.bsVertices.nextSetBit(n + 1);
            }
        }
    }

    private void addPolyhedron(Polyhedron polyhedron) {
        if (this.polyhedronCount == this.polyhedrons.length) {
            this.polyhedrons = (Polyhedron[])AU.doubleLength(this.polyhedrons);
        }
        this.polyhedrons[this.polyhedronCount++] = polyhedron;
    }

    private Polyhedron constructBondsPolyhedron(Atom atom, int n) {
        this.distanceRef = 0.0f;
        if (n == 0) {
            Bond[] bondArray = atom.bonds;
            if (bondArray == null) {
                return null;
            }
            float f = this.radius * this.radius;
            float f2 = this.radiusMin * this.radiusMin;
            int n2 = bondArray.length;
            while (--n2 >= 0) {
                float f3;
                Bond bond = bondArray[n2];
                if (!bond.isCovalent()) continue;
                Atom atom2 = bond.getOtherAtom(atom);
                if (this.bsVertices != null && !this.bsVertices.get(atom2.i) || this.radius > 0.0f && ((f3 = atom2.distanceSquared(atom)) > f || f3 < f2)) continue;
                this.otherAtoms[n++] = atom2;
                if (n < 250) continue;
                return null;
            }
        }
        if (this.isAuto) {
            n = this.setGap(atom, n);
        }
        return n < 3 || this.nVertices > 0 && !this.bsVertexCount.get(n) ? null : this.validatePolyhedron(atom, n);
    }

    private Polyhedron constructUnitCellPolygon(Atom atom, boolean bl) {
        SymmetryInterface symmetryInterface = this.vwr.ms.getUnitCellForAtom(atom.i);
        if (symmetryInterface == null) {
            return null;
        }
        BS bS = BSUtil.copy(this.vwr.getModelUndeletedAtomsBitSet(atom.mi));
        if (this.bsVertices != null) {
            bS.and(this.bsVertices);
        }
        if (bS.isEmpty()) {
            return null;
        }
        AtomIndexIterator atomIndexIterator = symmetryInterface.getIterator(this.vwr, atom, this.atoms, bS, bl ? 5.0f : this.radius);
        if (!bl) {
            return this.constructRadiusPolyhedron(atom, atomIndexIterator);
        }
        float f = atom.getBondingRadius();
        if (f == 0.0f) {
            return null;
        }
        float f2 = this.vwr.getFloat(0x22000004);
        float f3 = this.radiusMin == 0.0f ? this.vwr.getFloat(570425364) : this.radiusMin;
        float f4 = f3 * f3;
        int n = 0;
        block0: while (atomIndexIterator.hasNext()) {
            P3 p3;
            float f5;
            Atom atom2 = this.atoms[atomIndexIterator.next()];
            float f6 = atom2.getBondingRadius();
            if (!this.vwr.ms.isBondable(f, f6, f5 = atom.distanceSquared(p3 = atomIndexIterator.getPosition()), f4, f2)) continue;
            int n2 = 0;
            while (n2 < n) {
                if (this.otherAtoms[n2].distanceSquared(p3) < 0.01f) continue block0;
                ++n2;
            }
            this.otherAtoms[n++] = p3;
            if (n < 250) continue;
            return null;
        }
        return this.constructBondsPolyhedron(atom, n);
    }

    private Polyhedron constructBitSetPolyhedron(Atom atom) {
        this.bsVertices.clear(atom.i);
        if (this.bsVertices.cardinality() >= 250) {
            return null;
        }
        int n = 0;
        this.distanceRef = 0.0f;
        int n2 = this.bsVertices.nextSetBit(0);
        while (n2 >= 0) {
            this.otherAtoms[n++] = this.atoms[n2];
            n2 = this.bsVertices.nextSetBit(n2 + 1);
        }
        return this.validatePolyhedron(atom, n);
    }

    private Polyhedron constructRadiusPolyhedron(Atom atom, AtomIndexIterator atomIndexIterator) {
        int n = 0;
        this.distanceRef = this.radius;
        float f = this.radius * this.radius;
        float f2 = this.radiusMin * this.radiusMin;
        block0: while (atomIndexIterator.hasNext()) {
            Atom atom2 = this.atoms[atomIndexIterator.next()];
            P3 p3 = atomIndexIterator.getPosition();
            if (p3 == null) {
                p3 = atom2;
                if (this.bsVertices != null && !this.bsVertices.get(atom2.i)) continue;
            }
            float f3 = atom.distanceSquared(p3);
            if (atom2.altloc != atom.altloc && atom2.altloc != '\u0000' && atom.altloc != '\u0000' || f3 > f || f3 < f2) continue;
            if (n == 250) break;
            int n2 = 0;
            while (n2 < n) {
                if (this.otherAtoms[n2].distanceSquared(p3) < 0.01f) continue block0;
                ++n2;
            }
            this.otherAtoms[n++] = p3;
        }
        if (this.isAuto) {
            n = this.setGap(atom, n);
        }
        return n < 3 || this.nVertices > 0 && !this.bsVertexCount.get(n) ? null : this.validatePolyhedron(atom, n);
    }

    private int setGap(P3 p3, int n) {
        if (n < 4) {
            return n;
        }
        Object[][] objectArray = new Object[250][2];
        int n2 = 0;
        while (n2 < n) {
            P3 p32 = this.otherAtoms[n2];
            objectArray[n2][1] = p32;
            objectArray[n2][0] = Float.valueOf(p3.distance(p32));
            ++n2;
        }
        Arrays.sort(objectArray, this);
        float f = 0.0f;
        int n3 = 0;
        int n4 = n;
        float f2 = ((Float)objectArray[0][0]).floatValue();
        this.otherAtoms[0] = (P3)objectArray[0][1];
        int n5 = 1;
        while (n5 < n4) {
            float f3 = ((Float)objectArray[n5][0]).floatValue();
            float f4 = f3 - f2;
            this.otherAtoms[n5] = (P3)objectArray[n5][1];
            if (Logger.debugging) {
                Logger.info("polyhedron d=" + f3 + " " + this.otherAtoms[n5]);
            }
            if (f4 > f) {
                if (Logger.debugging) {
                    Logger.info("polyhedron maxGap=" + f4 + " for i=" + n5 + " d=" + f3 + " " + this.otherAtoms[n5]);
                }
                f = f4;
                n3 = n5;
            }
            f2 = f3;
            ++n5;
        }
        return n3 == 0 ? n : n3;
    }

    private Polyhedron validatePolyhedron(P3 p3, int n) {
        int[][] nArray;
        V3[] v3Array;
        int[][] nArray2;
        P3[] p3Array = this.otherAtoms;
        int[][] nArray3 = this.explicitFaces;
        boolean bl = this.isCollapsed;
        int n2 = 0;
        BS bS = new BS();
        if (nArray3 != null) {
            bl = false;
            nArray2 = AU.newInt2(nArray3.length);
            v3Array = new V3[nArray3.length];
            int n3 = nArray3.length;
            while (--n3 >= 0) {
                nArray3[n3] = this.fixExplicitFaceWinding(nArray3[n3], n3, p3Array, v3Array);
            }
            nArray = ((MeshCapper)Interface.getInterface("org.jmol.util.MeshCapper", this.vwr, "script")).set(null).triangulateFaces(nArray3, p3Array, nArray2);
            n2 = nArray.length;
        } else {
            int n4;
            this.nPoints = n + 1;
            int n5 = n - 2;
            int n6 = n - 1;
            float f = Float.isNaN(this.planarParam) ? 0.98f : this.planarParam;
            p3Array[n] = p3;
            P3 p32 = P3.newP(p3);
            int n7 = 0;
            while (n7 < n) {
                p32.add(p3Array[n7]);
                ++n7;
            }
            p32.scale(1.0f / (float)(n + 1));
            P3 p33 = P3.newP(p32);
            BS bS2 = new BS();
            if (this.thisID == null) {
                int n8 = 0;
                int n9 = 0;
                while (n9 < n5) {
                    int n10 = n9 + 1;
                    while (n10 < n6) {
                        n4 = n10 + 1;
                        while (n4 < n) {
                            if (this.isPlanar(p3Array[n9], p3Array[n10], p3Array[n4], p33)) {
                                bS2.set(n8);
                            }
                            ++n4;
                            ++n8;
                        }
                        ++n10;
                    }
                    ++n9;
                }
            }
            nArray = this.planesT;
            P4 p4 = new P4();
            V3 v3 = new V3();
            float f2 = this.faceCenterOffset;
            n4 = 247;
            int n11 = 250;
            BS bS3 = Normix.newVertexBitSet();
            v3Array = this.normalsT;
            Hashtable<Integer, Object[]> hashtable = new Hashtable<Integer, Object[]>();
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            Lst<int[]> lst = this.isFull ? new Lst<int[]>() : null;
            Object[] objectArray = new Object[3];
            V3 v32 = this.vAC;
            int n12 = 0;
            int n13 = 0;
            while (n12 < n5) {
                int n14 = n12 + 1;
                while (n14 < n6) {
                    int n15 = n14 + 1;
                    while (n15 < n) {
                        if (n2 >= n4) {
                            Logger.error("Polyhedron error: maximum face(" + n4 + ") -- reduce RADIUS");
                            return null;
                        }
                        if (this.nPoints >= n11) {
                            Logger.error("Polyhedron error: maximum vertex count(" + n11 + ") -- reduce RADIUS");
                            return null;
                        }
                        boolean bl2 = bS2.get(n13);
                        P3 p34 = bl2 ? randomPoint : p32;
                        V3 v33 = new V3();
                        boolean bl3 = Measure.getNormalFromCenter(p34, p3Array[n12], p3Array[n14], p3Array[n15], !bl2, v33, v32);
                        int[] nArray4 = new int[]{bl3 ? n12 : n14, bl3 ? n14 : n12, n15, -7};
                        float f3 = this.checkFacet(p3Array, n, nArray4, n2, v33, p4, v3, v32, hashtable, hashtable2, f, bS3, objectArray);
                        if (f3 != 0.0f) {
                            if (this.isFull && f3 != Float.MAX_VALUE && f3 < 0.5f) {
                                nArray4[3] = (int)(f3 * 100.0f);
                                lst.addLast(nArray4);
                            }
                        } else {
                            v3Array[n2] = v33;
                            nArray[n2] = nArray4;
                            if (bl2) {
                                bS.set(n2++);
                            } else if (bl) {
                                p3Array[this.nPoints] = new P3();
                                p3Array[this.nPoints].scaleAdd2(f2, v33, p3);
                                p33.setT(p3Array[this.nPoints]);
                                this.addFacet(n12, n14, n15, p33, p3Array, v3Array, nArray, n2++, this.nPoints, bl3, v32);
                                this.addFacet(n15, n12, n14, p33, p3Array, v3Array, nArray, n2++, this.nPoints, bl3, v32);
                                this.addFacet(n14, n15, n12, p33, p3Array, v3Array, nArray, n2++, this.nPoints, bl3, v32);
                                ++this.nPoints;
                            } else {
                                ++n2;
                            }
                        }
                        ++n15;
                        ++n13;
                    }
                    ++n14;
                }
                ++n12;
            }
            --this.nPoints;
            if (Logger.debugging) {
                Logger.info("Polyhedron planeCount=" + n2 + " nPoints=" + this.nPoints);
                n12 = 0;
                while (n12 < n2) {
                    Logger.info("Polyhedron " + PT.toJSON("face[" + n12 + "]", nArray[n12]));
                    ++n12;
                }
            }
            nArray3 = this.getFaces(nArray, n2, hashtable);
            nArray2 = this.getFaceTriangles(nArray3.length, hashtable, n2);
        }
        return new Polyhedron().set(this.thisID, this.modelIndex, p3, p3Array, this.nPoints, n, nArray, n2, nArray3, nArray2, v3Array, bS, bl, this.distanceRef, this.pointScale);
    }

    private int[] fixExplicitFaceWinding(int[] nArray, int n, P3[] p3Array, V3[] v3Array) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n2 - 2;
        while (n3 < n4) {
            P3 p3 = p3Array[nArray[n3]];
            P3 p32 = p3Array[nArray[(n3 + 1) % n2]];
            P3 p33 = p3Array[nArray[(n3 + 2) % n2]];
            if (Measure.computeAngleABC(p3, p32, p33, true) < 178.0f) {
                v3Array[n] = new V3();
                if (Measure.getNormalFromCenter(this.center, p3, p32, p33, true, v3Array[n], this.vAC)) break;
                nArray = AU.arrayCopyRangeRevI(nArray, 0, -1);
                break;
            }
            ++n3;
        }
        return nArray;
    }

    private int[][] getFaceTriangles(int n, Map<Integer, Object[]> map, int n2) {
        int[][] nArray = AU.newInt2(n);
        if (n2 == n) {
            int n3 = n2;
            while (--n3 >= 0) {
                nArray[n3] = new int[]{n3};
            }
            return nArray;
        }
        int n4 = 0;
        for (Map.Entry<Integer, Object[]> entry : map.entrySet()) {
            Object[] objectArray = entry.getValue();
            if (objectArray[2] != null && objectArray[2] != entry.getKey()) continue;
            Lst lst = (Lst)entry.getValue()[1];
            n = lst.size();
            int[] nArray2 = new int[n];
            int n5 = n;
            while (--n5 >= 0) {
                nArray2[n5] = (Integer)lst.get(n5);
            }
            nArray[n4++] = nArray2;
        }
        return nArray;
    }

    private void addFacet(int n, int n2, int n3, P3 p3, P3[] p3Array, V3[] v3Array, int[][] nArray, int n4, int n5, boolean bl, V3 v3) {
        V3 v32 = new V3();
        int n6 = bl ? n : n2;
        int n7 = bl ? n2 : n;
        Measure.getNormalFromCenter(p3Array[n3], p3, p3Array[n6], p3Array[n7], false, v32, v3);
        v3Array[n4] = v32;
        nArray[n4] = new int[]{n5, n6, n7, -2};
    }

    private float checkFacet(P3[] p3Array, int n, int[] nArray, int n2, V3 v3, P4 p4, V3 v32, V3 v33, Map<Integer, Object[]> map, Map<String, Object> map2, float f, BS bS, Object[] objectArray) {
        Object object;
        Map.Entry<Integer, Object[]> entry2;
        Object object2;
        int n3 = nArray[0];
        Measure.getPlaneThroughPoints(p3Array[n3], p3Array[nArray[1]], p3Array[nArray[2]], v32, v33, p4);
        P3 p3 = p3Array[n3];
        int n4 = 0;
        while (n4 < n) {
            if (n4 != n3) {
                v33.sub2(p3Array[n4], p3);
                v33.normalize();
                float f2 = v33.dot(v32);
                if (f2 > 0.05f) {
                    return f2;
                }
                if (Logger.debugging) {
                    Logger.info("checkFacet " + n4 + " " + f2 + " " + PT.toJSON(null, nArray));
                }
            }
            ++n4;
        }
        Integer n5 = Normix.getNormixV(v3, bS);
        Object[] objectArray2 = map.get(n5);
        if (objectArray2 == null) {
            object2 = Normix.getVertexVectors();
            for (Map.Entry<Integer, Object[]> entry2 : map.entrySet()) {
                object = entry2.getKey();
                if (!(object2[(Integer)object].dot(v3) > f)) continue;
                objectArray2 = (Object[])entry2.getValue();
                objectArray2[2] = object;
                map.put(n5, objectArray2);
                break;
            }
            if (objectArray2 == null) {
                objectArray2 = new Object[]{new Lst(), new Lst(), n5};
                map.put(n5, objectArray2);
            }
        }
        n5 = (Integer)objectArray2[2];
        object2 = (Lst)objectArray2[0];
        entry2 = (Lst)objectArray2[1];
        int n6 = 0;
        while (n6 < 3) {
            objectArray[n6] = this.addEdge((Lst<int[]>)object2, map2, n5, nArray, n6, p3Array);
            if (objectArray[n6] == null) {
                return Float.MAX_VALUE;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < 3) {
            object = objectArray[n6];
            if (object != Boolean.TRUE) {
                Object[] objectArray3 = (Object[])object;
                ((Lst)object2).addLast((int[])objectArray3[2]);
                map2.put((String)objectArray3[3], objectArray3);
            }
            ++n6;
        }
        ((Lst)((Object)entry2)).addLast((Object[])n2);
        return 0.0f;
    }

    private Object addEdge(Lst<int[]> lst, Map<String, Object> map, Integer n, int[] nArray, int n2, P3[] p3Array) {
        int n3 = nArray[n2];
        int n4 = nArray[(n2 + 1) % 3];
        String string = "_" + n4;
        String string2 = "_" + n3;
        String string3 = n + string2 + string;
        if (map.containsKey(string3)) {
            return null;
        }
        String string4 = n + string + string2;
        Object object = map.get(string4);
        if (object == null) {
            P3 p3 = p3Array[n4];
            P3 p32 = p3Array[n3];
            this.vAB.sub2(p3, p32);
            int n5 = lst.size();
            while (--n5 >= 0) {
                int[] nArray2 = (int[])lst.get(n5);
                P3 p33 = p3Array[nArray2[0]];
                P3 p34 = p3Array[nArray2[1]];
                if (p33 == p32 || p33 == p3 || p34 == p32 || p34 == p3 || !this.testDiff(p33, p34, p32, p3) || !this.testDiff(p32, p3, p33, p34)) continue;
                return null;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = nArray;
            objectArray[1] = n2;
            int[] nArray3 = new int[3];
            nArray3[0] = n3;
            nArray3[1] = n4;
            objectArray[2] = nArray3;
            objectArray[3] = string3;
            return objectArray;
        }
        int[] nArray4 = (int[])((Object[])object)[0];
        if (nArray4 == null) {
            return null;
        }
        int n6 = (Integer)((Object[])object)[1];
        nArray4[3] = -(-nArray4[3] ^ 1 << n6);
        nArray[3] = -(-nArray[3] ^ 1 << n2);
        int[] nArray5 = (int[])((Object[])object)[2];
        int n7 = lst.size();
        while (--n7 >= 0) {
            int[] nArray6 = (int[])lst.get(n7);
            if (nArray6[0] != nArray5[0] || nArray6[1] != nArray5[1]) continue;
            nArray6[2] = -1;
            break;
        }
        map.put(string3, new Object[1]);
        map.put(string4, new Object[1]);
        return Boolean.TRUE;
    }

    private boolean testDiff(P3 p3, P3 p32, P3 p33, P3 p34) {
        this.vAB.sub2(p32, p3);
        this.vAC.sub2(p33, p3);
        this.vAC.cross(this.vAC, this.vAB);
        this.vBC.sub2(p34, p3);
        this.vBC.cross(this.vBC, this.vAB);
        return this.vBC.dot(this.vAC) < 0.0f;
    }

    private boolean isPlanar(P3 p3, P3 p32, P3 p33, P3 p34) {
        V3 v3 = new V3();
        float f = Measure.getNormalThroughPoints(p3, p32, p33, v3, this.vAB);
        float f2 = Measure.distanceToPlaneV(v3, f, p34);
        return Math.abs(f2) < MAX_DISTANCE_TO_PLANE;
    }

    private int[][] getFaces(int[][] nArray, int n, Map<Integer, Object[]> map) {
        int n2 = 0;
        for (Map.Entry<Integer, Object[]> object2 : map.entrySet()) {
            Object[] objectArray = object2.getValue();
            if (objectArray[2] != object2.getKey()) continue;
            ++n2;
        }
        int[][] nArray2 = AU.newInt2(n2);
        if (n == n2) {
            int n3 = n;
            while (--n3 >= 0) {
                nArray2[n3] = AU.arrayCopyI(nArray[n3], 3);
            }
            return nArray2;
        }
        int n4 = 0;
        for (Map.Entry<Integer, Object[]> entry : map.entrySet()) {
            Object[] objectArray = entry.getValue();
            if (objectArray[2] != null && objectArray[2] != entry.getKey()) continue;
            Lst lst = (Lst)entry.getValue()[0];
            n2 = lst.size();
            int n3 = 0;
            int n5 = lst.size();
            while (--n5 >= 0) {
                if (((int[])lst.get(n5))[2] < 0) continue;
                ++n3;
            }
            int n6 = n4++;
            int[] nArray3 = new int[n3];
            nArray2[n6] = nArray3;
            int[] nArray4 = nArray3;
            if (n2 < 2) continue;
            int[] nArray5 = null;
            int n7 = 0;
            do {
                nArray5 = (int[])lst.get(n7);
            } while (n7++ < n3 && nArray5[2] == -1);
            nArray4[0] = nArray5[0];
            nArray4[1] = nArray5[1];
            n7 = 2;
            int n8 = 1;
            int n9 = -1;
            block5: while (n7 < n3 && n9 != n7) {
                n9 = n7;
                int n10 = n8;
                while (n10 < n2) {
                    nArray5 = (int[])lst.get(n10);
                    if (nArray5[2] != -1 && nArray5[0] == nArray4[n7 - 1]) {
                        nArray4[n7++] = nArray5[1];
                        if (n10 != n8) continue block5;
                        ++n8;
                        continue block5;
                    }
                    ++n10;
                }
            }
        }
        return nArray2;
    }

    @Override
    public void setModelVisibilityFlags(BS bS) {
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (polyhedron.id == null) {
                int n2 = polyhedron.centralAtom.i;
                if (this.ms.at[n2].isDeleted()) {
                    polyhedron.isValid = false;
                }
                polyhedron.visibilityFlags = polyhedron.visible && bS.get(polyhedron.modelIndex) && !this.ms.isAtomHidden(n2) && !this.ms.at[n2].isDeleted() ? this.vf : 0;
                this.atoms[n2].setShapeVisibility(this.vf, polyhedron.visibilityFlags != 0);
                continue;
            }
            int n3 = polyhedron.visibilityFlags = polyhedron.visible && (polyhedron.modelIndex < 0 || bS.get(polyhedron.modelIndex)) ? this.vf : 0;
        }
    }

    @Override
    public String getShapeState() {
        if (this.polyhedronCount == 0) {
            return "";
        }
        SB sB = new SB();
        int n = 0;
        while (n < this.polyhedronCount) {
            if (this.polyhedrons[n].isValid) {
                sB.append(this.polyhedrons[n].getState(this.vwr));
            }
            ++n;
        }
        if (this.drawEdges == 2) {
            Polyhedra.appendCmd(sB, "polyhedra frontedges");
        } else if (this.drawEdges == 1) {
            Polyhedra.appendCmd(sB, "polyhedra edges");
        } else if (this.drawEdges == 3) {
            Polyhedra.appendCmd(sB, "polyhedra edgesOnly");
        }
        sB.append(this.vwr.getStateCreator().getAtomShapeState(this));
        int n2 = 0;
        while (n2 < this.polyhedronCount) {
            Polyhedron polyhedron = this.polyhedrons[n2];
            if (polyhedron.isValid && polyhedron.id == null && polyhedron.colixEdge != 0 && this.bsColixSet.get(n = polyhedron.centralAtom.i)) {
                Polyhedra.appendCmd(sB, "select ({" + n + "}); color polyhedra " + (C.isColixTranslucent(this.colixes[n]) ? "translucent " : "") + C.getHexCode(this.colixes[n]) + " " + C.getHexCode(polyhedron.colixEdge));
            }
            ++n2;
        }
        return sB.toString();
    }
}

