"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var serviceManager_1 = require("../serviceManager");
var EventLoopInspector = require("event-loop-inspector");
var Debug = require("debug");
var EventLoopInspectorConfig = (function () {
    function EventLoopInspectorConfig() {
    }
    return EventLoopInspectorConfig;
}());
var EventLoopInspectorFeature = (function () {
    function EventLoopInspectorFeature() {
        this.logger = Debug('axm:features:actions:eventloop');
    }
    EventLoopInspectorFeature.prototype.init = function (config) {
        var _this = this;
        if (config === false)
            return;
        if (config === undefined)
            return;
        if (config === true) {
            config = { enabled: true };
        }
        if (config.enabled === false)
            return;
        this.actionService = serviceManager_1.ServiceManager.get('actions');
        if (this.actionService === undefined) {
            return this.logger('cannot expose actions as action service isnt available');
        }
        this.eventLoopInspector = EventLoopInspector(false);
        this.actionService.registerAction('km:event-loop-dump', function (cb) {
            return cb({
                success: true,
                dump: _this.eventLoopInspector.dump()
            });
        });
    };
    EventLoopInspectorFeature.prototype.destroy = function () {
        this.logger('destroy');
    };
    return EventLoopInspectorFeature;
}());
exports.EventLoopInspectorFeature = EventLoopInspectorFeature;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXZlbnRMb29wSW5zcGVjdG9yLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2ZlYXR1cmVzL2V2ZW50TG9vcEluc3BlY3Rvci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUNBLG9EQUFrRDtBQUVsRCx5REFBMEQ7QUFDMUQsNkJBQThCO0FBRTlCO0lBQUE7SUFFQSxDQUFDO0lBQUQsK0JBQUM7QUFBRCxDQUFDLEFBRkQsSUFFQztBQUVEO0lBQUE7UUFHVSxXQUFNLEdBQWEsS0FBSyxDQUFDLGdDQUFnQyxDQUFDLENBQUE7SUE2QnBFLENBQUM7SUExQkMsd0NBQUksR0FBSixVQUFNLE1BQTJDO1FBQWpELGlCQXFCQztRQXBCQyxJQUFJLE1BQU0sS0FBSyxLQUFLO1lBQUUsT0FBTTtRQUM1QixJQUFJLE1BQU0sS0FBSyxTQUFTO1lBQUUsT0FBTTtRQUNoQyxJQUFJLE1BQU0sS0FBSyxJQUFJLEVBQUU7WUFDbkIsTUFBTSxHQUFHLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxDQUFBO1NBQzNCO1FBQ0QsSUFBSSxNQUFNLENBQUMsT0FBTyxLQUFLLEtBQUs7WUFBRSxPQUFNO1FBRXBDLElBQUksQ0FBQyxhQUFhLEdBQUcsK0JBQWMsQ0FBQyxHQUFHLENBQUMsU0FBUyxDQUFDLENBQUE7UUFDbEQsSUFBSSxJQUFJLENBQUMsYUFBYSxLQUFLLFNBQVMsRUFBRTtZQUNwQyxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsd0RBQXdELENBQUMsQ0FBQTtTQUM3RTtRQUVELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsQ0FBQTtRQUVuRCxJQUFJLENBQUMsYUFBYSxDQUFDLGNBQWMsQ0FBQyxvQkFBb0IsRUFBRSxVQUFDLEVBQUU7WUFDekQsT0FBTyxFQUFFLENBQUM7Z0JBQ1IsT0FBTyxFQUFFLElBQUk7Z0JBQ2IsSUFBSSxFQUFFLEtBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLEVBQUU7YUFDckMsQ0FBQyxDQUFBO1FBQ0osQ0FBQyxDQUFDLENBQUE7SUFDSixDQUFDO0lBRUQsMkNBQU8sR0FBUDtRQUNFLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLENBQUE7SUFDeEIsQ0FBQztJQUNILGdDQUFDO0FBQUQsQ0FBQyxBQWhDRCxJQWdDQztBQWhDWSw4REFBeUIifQ==