"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var Debug = require("debug");
var eventemitter2_1 = require("eventemitter2");
var cluster = require("cluster");
var EventLoopInspector = require("event-loop-inspector");
var IPCTransport = (function (_super) {
    tslib_1.__extends(IPCTransport, _super);
    function IPCTransport() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.initiated = false;
        _this.logger = Debug('axm:transport:ipc');
        _this.eventLoopInspector = EventLoopInspector(false);
        return _this;
    }
    IPCTransport.prototype.init = function (config) {
        var _this = this;
        this.logger('Init new transport service');
        if (this.initiated === true) {
            console.error("Trying to re-init the transport, please avoid");
            return this;
        }
        this.initiated = true;
        this.logger('Agent launched');
        this.onMessage = function (data) {
            _this.logger("Received reverse message from IPC");
            _this.emit('data', data);
        };
        process.on('message', this.onMessage);
        if (cluster.isWorker === false) {
            this.autoExitHook();
        }
        return this;
    };
    IPCTransport.prototype.autoExitHook = function () {
        var _this = this;
        this.autoExitHandle = setInterval(function () {
            var dump = _this.eventLoopInspector.dump();
            var requests = Object.keys(dump.requests);
            var handles = Object.keys(dump.handles);
            var sockets = dump.handles.Socket;
            var pipes = dump.handles.Pipe;
            var hasStdOut = sockets && sockets.find(function (sock) { return sock.fd === 1; }) !== undefined;
            var hasStdErr = sockets && sockets.find(function (sock) { return sock.fd === 2; }) !== undefined;
            var isSocketStds = sockets && sockets.length === 2 && hasStdErr && hasStdOut;
            var isOnlySocketStds = handles.length === 1 && isSocketStds;
            var isStdsWithIPC = isSocketStds && pipes && pipes.length === 1 && handles.length === 2;
            var shouldStillExit = isStdsWithIPC || isOnlySocketStds;
            if ((handles.length > 0 || requests.length > 0) && shouldStillExit === false) {
                return _this.logger('no need to exit, there are handles/requests in uv', JSON.stringify(dump));
            }
            _this.logger("Nothing found in uv, removing the IPC listener");
            process.removeListener('message', _this.onMessage);
            var tmp = setTimeout(function (_) {
                _this.logger("Still alive, listen back to IPC");
                process.on('message', _this.onMessage);
            }, 200);
            tmp.unref();
        }, 5000);
        this.autoExitHandle.unref();
    };
    IPCTransport.prototype.setMetrics = function (metrics) {
        var serializedMetric = metrics.reduce(function (object, metric) {
            if (typeof metric.name !== 'string')
                return object;
            object[metric.name] = {
                historic: metric.historic,
                unit: metric.unit,
                type: metric.id,
                value: metric.value
            };
            return object;
        }, {});
        this.send('axm:monitor', serializedMetric);
    };
    IPCTransport.prototype.addAction = function (action) {
        this.logger("Add action: " + action.name + ":" + action.type);
        this.send('axm:action', {
            action_name: action.name,
            action_type: action.type,
            arity: action.arity,
            opts: action.opts
        });
    };
    IPCTransport.prototype.setOptions = function (options) {
        this.logger("Set options: [" + Object.keys(options).join(',') + "]");
        return this.send('axm:option:configuration', options);
    };
    IPCTransport.prototype.send = function (channel, payload) {
        if (typeof process.send !== 'function')
            return -1;
        try {
            process.send({ type: channel, data: payload });
        }
        catch (err) {
            this.logger('Process disconnected from parent !');
            this.logger(err);
            return process.exit(1);
        }
    };
    IPCTransport.prototype.destroy = function () {
        if (this.onMessage !== undefined) {
            process.removeListener('message', this.onMessage);
        }
        if (this.autoExitHandle !== undefined) {
            clearInterval(this.autoExitHandle);
        }
        this.logger('destroy');
    };
    return IPCTransport;
}(eventemitter2_1.EventEmitter2));
exports.IPCTransport = IPCTransport;
//# sourceMappingURL=data:application/json;base64,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