"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var semver = require("semver");
var debug_1 = require("debug");
var eventemitter2_1 = require("eventemitter2");
var transactionAggregator_1 = require("../utils/transactionAggregator");
var SerializedAction = (function () {
    function SerializedAction() {
    }
    return SerializedAction;
}());
var ProcessMetadata = (function () {
    function ProcessMetadata() {
    }
    return ProcessMetadata;
}());
exports.ProcessMetadata = ProcessMetadata;
var WebsocketTransport = (function (_super) {
    tslib_1.__extends(WebsocketTransport, _super);
    function WebsocketTransport() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.initiated = false;
        _this.logger = debug_1.default('axm:transport:websocket');
        return _this;
    }
    WebsocketTransport.prototype.init = function (config) {
        var _this = this;
        if (!semver.satisfies(process.version, '>= 6.0.0')) {
            console.error('[STANDALONE MODE] Unable to set standalone mode with node < 6.0.0');
            return process.exit(1);
        }
        if (this.initiated === true) {
            console.error("Trying to re-init the transport, please avoid");
            return this;
        }
        this.initiated = true;
        var AgentNode = require('@pm2/agent-node');
        this.logger('Init new transport service');
        this.config = config;
        this.process = {
            axm_actions: [],
            axm_options: {},
            axm_monitor: {}
        };
        this.agent = new AgentNode(this.config, this.process);
        if (this.agent instanceof Error) {
            throw this.agent;
        }
        this.agent.sendLogs = config.sendLogs || false;
        this.traceAggregator = new transactionAggregator_1.TransactionAggregator();
        this.traceAggregator.init();
        this.traceAggregator.on('packet', function (packet) {
            _this.send('axm:transaction', packet);
        });
        this.agent.start();
        this.agent.transport.on('**', function (data) {
            _this.logger("Received reverse message from websocket transport");
            _this.emit('data', data);
        });
        this.logger('Agent launched');
        return this;
    };
    WebsocketTransport.prototype.setMetrics = function (metrics) {
        return this.process.axm_monitor = metrics.reduce(function (object, metric) {
            if (typeof metric.name !== 'string')
                return object;
            object[metric.name] = {
                historic: metric.historic,
                unit: metric.unit,
                type: metric.id,
                value: metric.value
            };
            return object;
        }, {});
    };
    WebsocketTransport.prototype.addAction = function (action) {
        this.logger("Add action: " + action.name + ":" + action.type);
        var serializedAction = {
            action_name: action.name,
            action_type: action.type,
            arity: action.arity,
            opts: action.opts
        };
        this.process.axm_actions.push(serializedAction);
    };
    WebsocketTransport.prototype.setOptions = function (options) {
        this.logger("Set options: [" + Object.keys(options).join(',') + "]");
        return this.process.axm_options = Object.assign(this.process.axm_options, options);
    };
    WebsocketTransport.prototype.getFormattedPayload = function (channel, payload) {
        switch (channel) {
            case 'axm:reply':
                return { data: payload };
            case 'process:exception':
                return { data: payload };
            case 'human:event': {
                var name = payload.__name;
                payload.__name = undefined;
                return { name: name, data: payload };
            }
        }
        return payload;
    };
    WebsocketTransport.prototype.send = function (channel, payload) {
        if (channel === 'axm:trace' && this.traceAggregator !== undefined) {
            return this.traceAggregator.aggregate(payload);
        }
        return this.agent.send(channel, this.getFormattedPayload(channel, payload)) ? 0 : -1;
    };
    WebsocketTransport.prototype.destroy = function () {
        this.agent.transport.disconnect();
        if (this.traceAggregator !== undefined) {
            this.traceAggregator.destroy();
        }
        this.logger('destroy');
    };
    WebsocketTransport.prototype.removeListener = function () {
        return this.agent.transport.removeListener.apply(this, arguments);
    };
    WebsocketTransport.prototype.removeAllListeners = function () {
        return this.agent.transport.removeAllListeners.apply(this, arguments);
    };
    WebsocketTransport.prototype.on = function () {
        return this.agent.transport.on.apply(this, arguments);
    };
    return WebsocketTransport;
}(eventemitter2_1.EventEmitter2));
exports.WebsocketTransport = WebsocketTransport;
//# sourceMappingURL=data:application/json;base64,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