"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var BinaryHeap = (function () {
    function BinaryHeap(options) {
        options = options || {};
        this._elements = options.elements || [];
        this._score = options.score || this._score;
    }
    BinaryHeap.prototype.add = function () {
        for (var i = 0; i < arguments.length; i++) {
            var element = arguments[i];
            this._elements.push(element);
            this._bubble(this._elements.length - 1);
        }
    };
    BinaryHeap.prototype.first = function () {
        return this._elements[0];
    };
    BinaryHeap.prototype.removeFirst = function () {
        var root = this._elements[0];
        var last = this._elements.pop();
        if (this._elements.length > 0) {
            this._elements[0] = last;
            this._sink(0);
        }
        return root;
    };
    BinaryHeap.prototype.clone = function () {
        return new BinaryHeap({
            elements: this.toArray(),
            score: this._score
        });
    };
    BinaryHeap.prototype.toSortedArray = function () {
        var array = [];
        var clone = this.clone();
        while (true) {
            var element = clone.removeFirst();
            if (element === undefined)
                break;
            array.push(element);
        }
        return array;
    };
    BinaryHeap.prototype.toArray = function () {
        return [].concat(this._elements);
    };
    BinaryHeap.prototype.size = function () {
        return this._elements.length;
    };
    BinaryHeap.prototype._bubble = function (bubbleIndex) {
        var bubbleElement = this._elements[bubbleIndex];
        var bubbleScore = this._score(bubbleElement);
        while (bubbleIndex > 0) {
            var parentIndex = this._parentIndex(bubbleIndex);
            var parentElement = this._elements[parentIndex];
            var parentScore = this._score(parentElement);
            if (bubbleScore <= parentScore)
                break;
            this._elements[parentIndex] = bubbleElement;
            this._elements[bubbleIndex] = parentElement;
            bubbleIndex = parentIndex;
        }
    };
    BinaryHeap.prototype._sink = function (sinkIndex) {
        var sinkElement = this._elements[sinkIndex];
        var sinkScore = this._score(sinkElement);
        var length = this._elements.length;
        while (true) {
            var swapIndex = void 0;
            var swapScore = void 0;
            var swapElement = null;
            var childIndexes = this._childIndexes(sinkIndex);
            for (var i = 0; i < childIndexes.length; i++) {
                var childIndex = childIndexes[i];
                if (childIndex >= length)
                    break;
                var childElement = this._elements[childIndex];
                var childScore = this._score(childElement);
                if (childScore > sinkScore) {
                    if (swapScore === undefined || swapScore < childScore) {
                        swapIndex = childIndex;
                        swapScore = childScore;
                        swapElement = childElement;
                    }
                }
            }
            if (swapIndex === undefined)
                break;
            this._elements[swapIndex] = sinkElement;
            this._elements[sinkIndex] = swapElement;
            sinkIndex = swapIndex;
        }
    };
    BinaryHeap.prototype._parentIndex = function (index) {
        return Math.floor((index - 1) / 2);
    };
    BinaryHeap.prototype._childIndexes = function (index) {
        return [
            2 * index + 1,
            2 * index + 2
        ];
    };
    BinaryHeap.prototype._score = function (element) {
        return element.valueOf();
    };
    return BinaryHeap;
}());
exports.default = BinaryHeap;
//# sourceMappingURL=data:application/json;base64,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