/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryLock;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.MasterControl;
import javax.media.j3d.NioImageBuffer;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.RasterRetained;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.VirtualUniverse;

abstract class ImageComponentRetained
extends NodeComponentRetained {
    static final int IMAGE_CHANGED = 1;
    static final int SUBIMAGE_CHANGED = 2;
    static final int TYPE_BYTE_BGR = 1;
    static final int TYPE_BYTE_RGB = 2;
    static final int TYPE_BYTE_ABGR = 4;
    static final int TYPE_BYTE_RGBA = 8;
    static final int TYPE_BYTE_LA = 16;
    static final int TYPE_BYTE_GRAY = 32;
    static final int TYPE_USHORT_GRAY = 64;
    static final int TYPE_INT_BGR = 128;
    static final int TYPE_INT_RGB = 256;
    static final int TYPE_INT_ARGB = 512;
    static final int IMAGE_SIZE_512X512 = 262144;
    static final int IMAGE_DATA_TYPE_BYTE_ARRAY = 4096;
    static final int IMAGE_DATA_TYPE_INT_ARRAY = 8192;
    static final int IMAGE_DATA_TYPE_BYTE_BUFFER = 16384;
    static final int IMAGE_DATA_TYPE_INT_BUFFER = 32768;
    private int apiFormat;
    int width;
    int height;
    int depth;
    boolean byReference = false;
    boolean yUp = false;
    boolean imageTypeIsSupported;
    boolean abgrSupported = true;
    boolean npotSupported = true;
    private int unitsPerPixel;
    private int numberOfComponents;
    private int imageType;
    private ImageFormatType imageFormatType = ImageFormatType.TYPE_UNKNOWN;
    ImageData imageData;
    private ImageComponent.ImageClass imageClass = ImageComponent.ImageClass.BUFFERED_IMAGE;
    private ImageData imageDataPowerOfTwo;
    private AffineTransformOp powerOfTwoATOp;
    private boolean enforceNonPowerOfTwoSupport = false;
    private boolean usedByOffScreenCanvas = false;
    private Object[] refImage = null;
    Object evaluateExtLock = new Object();
    GeometryLock geomLock = new GeometryLock();
    int tilew = 0;
    int tileh = 0;
    int numXTiles = 0;
    int numYTiles = 0;
    private ArrayList<NodeComponentRetained> userList = new ArrayList();

    ImageComponentRetained() {
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    int getFormat() {
        return this.apiFormat;
    }

    void setFormat(int n) {
        this.apiFormat = n;
    }

    void setByReference(boolean bl) {
        this.byReference = bl;
    }

    boolean isByReference() {
        return this.byReference;
    }

    void setYUp(boolean bl) {
        this.yUp = bl;
    }

    boolean isYUp() {
        return this.yUp;
    }

    int getUnitsPerPixel() {
        return this.unitsPerPixel;
    }

    void setUnitsPerPixel(int n) {
        this.unitsPerPixel = n;
    }

    ImageComponent.ImageClass getImageClass() {
        return this.imageClass;
    }

    void setImageClass(RenderedImage renderedImage) {
        this.imageClass = renderedImage instanceof BufferedImage ? ImageComponent.ImageClass.BUFFERED_IMAGE : ImageComponent.ImageClass.RENDERED_IMAGE;
    }

    void setImageClass(NioImageBuffer nioImageBuffer) {
        this.imageClass = ImageComponent.ImageClass.NIO_IMAGE_BUFFER;
    }

    void setEnforceNonPowerOfTwoSupport(boolean bl) {
        this.enforceNonPowerOfTwoSupport = bl;
    }

    void setUsedByOffScreen(boolean bl) {
        this.usedByOffScreenCanvas = bl;
    }

    boolean getUsedByOffScreen() {
        return this.usedByOffScreenCanvas;
    }

    int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    void setNumberOfComponents(int n) {
        this.numberOfComponents = n;
    }

    int getImageDataTypeIntValue() {
        int n = -1;
        switch (this.imageData.imageDataType) {
            case TYPE_BYTE_ARRAY: {
                n = 4096;
                break;
            }
            case TYPE_INT_ARRAY: {
                n = 8192;
                break;
            }
            case TYPE_BYTE_BUFFER: {
                n = 16384;
                break;
            }
            case TYPE_INT_BUFFER: {
                n = 32768;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return n;
    }

    int getImageFormatTypeIntValue(boolean bl) {
        int n = -1;
        switch (this.imageFormatType) {
            case TYPE_BYTE_BGR: {
                n = 1;
                break;
            }
            case TYPE_BYTE_RGB: {
                n = 2;
                break;
            }
            case TYPE_BYTE_ABGR: {
                n = 4;
                break;
            }
            case TYPE_BYTE_RGBA: {
                if (this.imageDataPowerOfTwo != null && bl) {
                    n = 4;
                    break;
                }
                n = 8;
                break;
            }
            case TYPE_BYTE_LA: {
                n = 16;
                break;
            }
            case TYPE_BYTE_GRAY: {
                n = 32;
                break;
            }
            case TYPE_USHORT_GRAY: {
                n = 64;
                break;
            }
            case TYPE_INT_BGR: {
                n = 128;
                break;
            }
            case TYPE_INT_RGB: {
                n = 256;
                break;
            }
            case TYPE_INT_ARGB: {
                n = 512;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return n;
    }

    int getImageType() {
        return this.imageType;
    }

    void setImageFormatType(ImageFormatType imageFormatType) {
        this.imageFormatType = imageFormatType;
    }

    ImageFormatType getImageFormatType() {
        return this.imageFormatType;
    }

    void setRefImage(Object object, int n) {
        this.refImage[n] = object;
    }

    Object getRefImage(int n) {
        return this.refImage[n];
    }

    ImageData getImageData(boolean bl) {
        if (bl) {
            assert (this.enforceNonPowerOfTwoSupport);
            if (this.imageDataPowerOfTwo != null) {
                return this.imageDataPowerOfTwo;
            }
        }
        return this.imageData;
    }

    boolean useBilinearFilter() {
        return this.imageDataPowerOfTwo != null;
    }

    boolean isImageTypeSupported() {
        return this.imageTypeIsSupported;
    }

    void processParams(int n, int n2, int n3, int n4) {
        if (n2 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained0"));
        }
        if (n3 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained1"));
        }
        if (n4 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained2"));
        }
        switch (n) {
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                this.numberOfComponents = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                this.numberOfComponents = 4;
                break;
            }
            case 7: 
            case 8: {
                this.numberOfComponents = 2;
                break;
            }
            case 10: {
                this.numberOfComponents = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained3"));
            }
        }
        this.setFormat(n);
        this.width = n2;
        this.height = n3;
        this.depth = n4;
        this.refImage = new Object[n4];
    }

    int evaluateImageType(RenderedImage renderedImage) {
        int n = 0;
        if (renderedImage instanceof BufferedImage) {
            n = ((BufferedImage)renderedImage).getType();
            if (n != 0) {
                return n;
            }
        } else {
            return n;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = colorSpace.getType();
        boolean bl = colorModel.isAlphaPremultiplied();
        if (n2 == 6 && colorModel instanceof ComponentColorModel) {
            if (sampleModel.getDataType() == 0) {
                n = 10;
            } else if (sampleModel.getDataType() == 1) {
                n = 11;
            }
        } else if (n2 == 5) {
            int n3 = 0;
            int n4 = sampleModel.getDataType();
            if (n4 == 0) {
                n3 = 8;
            } else if (n4 == 3) {
                n3 = 32;
            }
            if (n3 != 0) {
                int n5 = sampleModel.getNumBands();
                if (colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
                    PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
                    int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
                    ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
                    int[] nArray2 = componentColorModel.getComponentSize();
                    boolean bl2 = true;
                    for (int i = 0; i < n5; ++i) {
                        if (nArray2[i] == n3) continue;
                        bl2 = false;
                        break;
                    }
                    if (n3 == 8) {
                        if (bl2 && nArray[0] == n5 - 1 && nArray[1] == n5 - 2 && nArray[2] == n5 - 3) {
                            if (n5 == 3) {
                                n = 5;
                            } else if (nArray[3] == 0) {
                                n = bl ? 7 : 6;
                            }
                        }
                    } else if (bl2) {
                        if (n5 == 3) {
                            if (nArray[0] == n5 - 1 && nArray[1] == n5 - 2 && nArray[2] == n5 - 3) {
                                n = 4;
                            } else if (nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                                n = 1;
                            }
                        } else if (nArray[0] == 3 && nArray[1] == 0 && nArray[2] == 1 && nArray[3] == 2) {
                            n = bl ? 3 : 2;
                        }
                    }
                }
            }
        }
        return n;
    }

    boolean is3ByteRGB(RenderedImage renderedImage) {
        int n;
        boolean bl = false;
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl2 = colorModel.isAlphaPremultiplied();
        int n2 = colorSpace.getType();
        if (n2 == 5 && (n = sampleModel.getNumBands()) == 3 && sampleModel.getDataType() == 0 && colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
            int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
            ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
            int[] nArray2 = componentColorModel.getComponentSize();
            boolean bl3 = true;
            for (int i = 0; i < n; ++i) {
                if (nArray2[i] == 8) continue;
                bl3 = false;
                break;
            }
            if (bl3 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                bl = true;
            }
        }
        return bl;
    }

    boolean is4ByteRGBA(RenderedImage renderedImage) {
        int n;
        boolean bl = false;
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl2 = colorModel.isAlphaPremultiplied();
        int n2 = colorSpace.getType();
        if (n2 == 5 && (n = sampleModel.getNumBands()) == 4 && sampleModel.getDataType() == 0 && colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
            int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
            ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
            int[] nArray2 = componentColorModel.getComponentSize();
            boolean bl3 = true;
            for (int i = 0; i < n; ++i) {
                if (nArray2[i] == 8) continue;
                bl3 = false;
                break;
            }
            if (bl3 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2 && nArray[3] == 3 && !bl2) {
                bl = true;
            }
        }
        return bl;
    }

    boolean isSubImageTypeEqual(RenderedImage renderedImage) {
        int n = this.evaluateImageType(renderedImage);
        return this.imageType == n;
    }

    void createBlankImageData() {
        assert (this.imageData == null);
        switch (this.numberOfComponents) {
            case 4: {
                this.imageType = 2;
                this.imageFormatType = ImageFormatType.TYPE_INT_ARGB;
                this.unitsPerPixel = 1;
                break;
            }
            case 3: {
                this.imageType = 1;
                this.imageFormatType = ImageFormatType.TYPE_INT_RGB;
                this.unitsPerPixel = 1;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.imageTypeIsSupported = true;
        this.imageData = this.createRenderedImageDataObject(null);
    }

    boolean isImageTypeSupported(NioImageBuffer nioImageBuffer) {
        boolean bl = true;
        NioImageBuffer.ImageType imageType = nioImageBuffer.getImageType();
        block0 : switch (this.numberOfComponents) {
            case 4: {
                switch (imageType) {
                    case TYPE_4BYTE_ABGR: {
                        if (this.abgrSupported) {
                            this.imageFormatType = ImageFormatType.TYPE_BYTE_ABGR;
                        } else {
                            this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                            bl = false;
                        }
                        this.unitsPerPixel = 4;
                        break block0;
                    }
                    case TYPE_4BYTE_RGBA: {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                        this.unitsPerPixel = 4;
                        break block0;
                    }
                    case TYPE_INT_ARGB: {
                        this.imageFormatType = ImageFormatType.TYPE_INT_ARGB;
                        this.unitsPerPixel = 1;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent5"));
            }
            case 3: {
                switch (imageType) {
                    case TYPE_3BYTE_BGR: {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_BGR;
                        this.unitsPerPixel = 3;
                        break block0;
                    }
                    case TYPE_3BYTE_RGB: {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_RGB;
                        this.unitsPerPixel = 3;
                        break block0;
                    }
                    case TYPE_INT_BGR: {
                        this.imageFormatType = ImageFormatType.TYPE_INT_BGR;
                        this.unitsPerPixel = 1;
                        break block0;
                    }
                    case TYPE_INT_RGB: {
                        this.imageFormatType = ImageFormatType.TYPE_INT_RGB;
                        this.unitsPerPixel = 1;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent5"));
            }
            case 2: {
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent5"));
            }
            case 1: {
                if (imageType == NioImageBuffer.ImageType.TYPE_BYTE_GRAY) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_GRAY;
                    this.unitsPerPixel = 1;
                    break;
                }
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent5"));
            }
            default: {
                throw new AssertionError();
            }
        }
        return bl;
    }

    boolean isImageTypeSupported(RenderedImage renderedImage) {
        boolean bl = true;
        this.imageType = this.evaluateImageType(renderedImage);
        switch (this.numberOfComponents) {
            case 4: {
                if (this.imageType == 6) {
                    if (this.abgrSupported) {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_ABGR;
                    } else {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                        bl = false;
                    }
                    this.unitsPerPixel = 4;
                    break;
                }
                if (this.imageType == 2) {
                    this.imageFormatType = ImageFormatType.TYPE_INT_ARGB;
                    this.unitsPerPixel = 1;
                    break;
                }
                if (this.is4ByteRGBA(renderedImage)) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                    this.unitsPerPixel = 4;
                    break;
                }
                this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                bl = false;
                this.unitsPerPixel = 4;
                break;
            }
            case 3: {
                if (this.imageType == 5) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_BGR;
                    this.unitsPerPixel = 3;
                    break;
                }
                if (this.imageType == 4) {
                    this.imageFormatType = ImageFormatType.TYPE_INT_BGR;
                    this.unitsPerPixel = 1;
                    break;
                }
                if (this.imageType == 1) {
                    this.imageFormatType = ImageFormatType.TYPE_INT_RGB;
                    this.unitsPerPixel = 1;
                    break;
                }
                if (this.is3ByteRGB(renderedImage)) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_RGB;
                    this.unitsPerPixel = 3;
                    break;
                }
                this.imageFormatType = ImageFormatType.TYPE_BYTE_RGB;
                bl = false;
                this.unitsPerPixel = 3;
                break;
            }
            case 2: {
                this.imageFormatType = ImageFormatType.TYPE_BYTE_LA;
                bl = false;
                this.unitsPerPixel = 2;
                break;
            }
            case 1: {
                if (this.imageType == 10) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_GRAY;
                    this.unitsPerPixel = 1;
                    break;
                }
                this.imageFormatType = ImageFormatType.TYPE_BYTE_GRAY;
                bl = false;
                this.unitsPerPixel = 1;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return bl;
    }

    ImageData createNioImageBufferDataObject(NioImageBuffer nioImageBuffer) {
        switch (this.imageFormatType) {
            case TYPE_BYTE_BGR: 
            case TYPE_BYTE_RGB: 
            case TYPE_BYTE_ABGR: 
            case TYPE_BYTE_RGBA: 
            case TYPE_BYTE_LA: 
            case TYPE_BYTE_GRAY: {
                if (nioImageBuffer != null) {
                    return new ImageData(ImageDataType.TYPE_BYTE_BUFFER, this.width * this.height * this.depth * this.unitsPerPixel, this.width, this.height, nioImageBuffer);
                }
                return new ImageData(ImageDataType.TYPE_BYTE_BUFFER, this.width * this.height * this.depth * this.unitsPerPixel, this.width, this.height);
            }
            case TYPE_INT_BGR: 
            case TYPE_INT_RGB: 
            case TYPE_INT_ARGB: {
                return new ImageData(ImageDataType.TYPE_INT_BUFFER, this.width * this.height * this.depth * this.unitsPerPixel, this.width, this.height, nioImageBuffer);
            }
        }
        throw new AssertionError();
    }

    ImageData createRenderedImageDataObject(RenderedImage renderedImage, int n, int n2) {
        switch (this.imageFormatType) {
            case TYPE_BYTE_BGR: 
            case TYPE_BYTE_RGB: 
            case TYPE_BYTE_ABGR: 
            case TYPE_BYTE_RGBA: 
            case TYPE_BYTE_LA: 
            case TYPE_BYTE_GRAY: {
                if (renderedImage != null) {
                    return new ImageData(ImageDataType.TYPE_BYTE_ARRAY, n * n2 * this.depth * this.unitsPerPixel, n, n2, renderedImage);
                }
                return new ImageData(ImageDataType.TYPE_BYTE_ARRAY, n * n2 * this.depth * this.unitsPerPixel, n, n2);
            }
            case TYPE_INT_BGR: 
            case TYPE_INT_RGB: 
            case TYPE_INT_ARGB: {
                if (renderedImage != null) {
                    return new ImageData(ImageDataType.TYPE_INT_ARRAY, n * n2 * this.depth * this.unitsPerPixel, n, n2, renderedImage);
                }
                return new ImageData(ImageDataType.TYPE_INT_ARRAY, n * n2 * this.depth * this.unitsPerPixel, n, n2);
            }
        }
        throw new AssertionError();
    }

    private void updateImageDataPowerOfTwo(int n) {
        assert (this.enforceNonPowerOfTwoSupport);
        BufferedImage bufferedImage = this.imageData.createBufferedImage(n);
        BufferedImage bufferedImage2 = this.powerOfTwoATOp.filter(bufferedImage, null);
        this.copySupportedImageToImageData(bufferedImage2, 0, this.imageDataPowerOfTwo);
    }

    ImageData createRenderedImageDataObject(RenderedImage renderedImage) {
        return this.createRenderedImageDataObject(renderedImage, this.width, this.height);
    }

    void copySupportedImageToImageData(RenderedImage renderedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, ImageData imageData) {
        int n8;
        int n9;
        int n10;
        assert (imageData != null);
        ColorModel colorModel = renderedImage.getColorModel();
        int n11 = renderedImage.getTileGridXOffset();
        int n12 = renderedImage.getTileGridYOffset();
        int n13 = renderedImage.getMinTileX();
        int n14 = renderedImage.getMinTileY();
        this.tilew = renderedImage.getTileWidth();
        this.tileh = renderedImage.getTileHeight();
        float f = (float)(n - n11) / (float)this.tilew;
        n13 = f < 0.0f ? (int)(f - 1.0f) : (int)f;
        f = (float)(n2 - n12) / (float)this.tileh;
        n14 = f < 0.0f ? (int)(f - 1.0f) : (int)f;
        int n15 = n13 * this.tilew + n11;
        int n16 = n14 * this.tileh + n12;
        int n17 = n15 + this.tilew - n;
        int n18 = n16 + this.tileh - n2;
        if (n17 > n6) {
            n17 = n6;
        }
        if (n18 > n7) {
            n18 = n7;
        }
        int n19 = n17;
        int n20 = n6;
        int n21 = n7;
        int n22 = n - n15;
        int n23 = n2 - n16;
        this.numXTiles = (n6 + n22) / this.tilew;
        this.numYTiles = (n7 + n23) / this.tileh;
        if ((float)(n6 + n22) % (float)this.tilew > 0.0f) {
            ++this.numXTiles;
        }
        if ((float)(n7 + n23) % (float)this.tileh > 0.0f) {
            ++this.numYTiles;
        }
        Object object = null;
        byte[] byArray = null;
        int[] nArray = null;
        switch (imageData.getType()) {
            case TYPE_BYTE_ARRAY: {
                byArray = imageData.getAsByteArray();
                break;
            }
            case TYPE_INT_ARRAY: {
                nArray = imageData.getAsIntArray();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        int n24 = imageData.dataWidth;
        int n25 = imageData.dataHeight;
        int n26 = n24 * this.unitsPerPixel;
        if (this.yUp) {
            n10 = (n5 * n24 * n25 + n4 * n24 + n3) * this.unitsPerPixel;
            n9 = 1;
            n8 = n26;
        } else {
            n10 = (n5 * n24 * n25 + (n25 - n4 - 1) * n24 + n3) * this.unitsPerPixel;
            n9 = -1;
            n8 = -n26;
        }
        Raster raster = renderedImage.getTile(n13, n14);
        object = ImageComponentRetained.getDataElementBuffer(raster);
        int n27 = this.tilew * this.unitsPerPixel;
        for (int i = n14; i < n14 + this.numYTiles; ++i) {
            int n28 = n10;
            n20 = n6;
            n17 = n19;
            n22 = n - n15;
            for (int j = n13; j < n13 + this.numXTiles; ++j) {
                raster = renderedImage.getTile(j, i);
                int n29 = (n23 * this.tilew + n22) * this.unitsPerPixel;
                int n30 = n28;
                int n31 = n17 * this.unitsPerPixel;
                switch (imageData.getType()) {
                    case TYPE_BYTE_ARRAY: {
                        int n32;
                        byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                        for (n32 = 0; n32 < n18; ++n32) {
                            System.arraycopy(byArray2, n29, byArray, n30, n31);
                            n29 += n27;
                            n30 += n8;
                        }
                        break;
                    }
                    case TYPE_INT_ARRAY: {
                        int n32;
                        int[] nArray2 = ((DataBufferInt)raster.getDataBuffer()).getData();
                        for (n32 = 0; n32 < n18; ++n32) {
                            System.arraycopy(nArray2, n29, nArray, n30, n31);
                            n29 += n27;
                            n30 += n8;
                        }
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                n28 += n17 * this.unitsPerPixel;
                n22 = 0;
                n17 = (n20 -= n17) < this.tilew ? n20 : this.tilew;
            }
            n10 += n24 * this.unitsPerPixel * n18 * n9;
            n23 = 0;
            n18 = (n21 -= n18) < this.tileh ? n21 : this.tileh;
        }
        if (this.imageData == imageData && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(n5);
        }
    }

    void copyImageLineByLine(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, ImageData imageData) {
        int n8;
        assert (imageData != null);
        int n9 = imageData.dataWidth;
        int n10 = imageData.dataHeight;
        int n11 = n9 * this.unitsPerPixel;
        int n12 = n2;
        if (this.yUp) {
            n8 = (n5 * n9 * n10 + n4 * n9 + n3) * this.unitsPerPixel;
        } else {
            n8 = (n5 * n9 * n10 + (n10 - n4 - 1) * n9 + n3) * this.unitsPerPixel;
            n11 = -1 * n11;
        }
        int n13 = n6 * this.unitsPerPixel;
        int n14 = bufferedImage.getWidth();
        int n15 = n14 * this.unitsPerPixel;
        int n16 = (n12 * n14 + n) * this.unitsPerPixel;
        switch (imageData.getType()) {
            case TYPE_BYTE_ARRAY: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                byte[] byArray2 = imageData.getAsByteArray();
                for (int i = 0; i < n7; ++i) {
                    System.arraycopy(byArray, n16, byArray2, n8, n13);
                    n8 += n11;
                    n16 += n15;
                }
                break;
            }
            case TYPE_INT_ARRAY: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int[] nArray2 = imageData.getAsIntArray();
                for (int i = 0; i < n7; ++i) {
                    System.arraycopy(nArray, n16, nArray2, n8, n13);
                    n8 += n11;
                    n16 += n15;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.imageData == imageData && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(n5);
        }
    }

    void copyImageByBlock(BufferedImage bufferedImage, int n, ImageData imageData) {
        assert (imageData != null && this.yUp);
        int n2 = imageData.dataWidth;
        int n3 = imageData.dataHeight;
        int n4 = n * n2 * n3 * this.unitsPerPixel;
        switch (this.imageData.getType()) {
            case TYPE_BYTE_ARRAY: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                byte[] byArray2 = imageData.getAsByteArray();
                System.arraycopy(byArray, 0, byArray2, n4, n2 * n3 * this.unitsPerPixel);
                break;
            }
            case TYPE_INT_ARRAY: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int[] nArray2 = imageData.getAsIntArray();
                System.arraycopy(nArray, 0, nArray2, n4, n2 * n3 * this.unitsPerPixel);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.imageData == imageData && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(n);
        }
    }

    void copySupportedImageToImageData(RenderedImage renderedImage, int n, ImageData imageData) {
        if (renderedImage instanceof BufferedImage) {
            if (this.yUp) {
                this.copyImageByBlock((BufferedImage)renderedImage, n, imageData);
            } else {
                this.copyImageLineByLine((BufferedImage)renderedImage, 0, 0, 0, 0, n, imageData.dataWidth, imageData.dataHeight, imageData);
            }
        } else {
            this.copySupportedImageToImageData(renderedImage, renderedImage.getMinX(), renderedImage.getMinY(), 0, 0, n, imageData.dataWidth, imageData.dataHeight, imageData);
        }
    }

    void copyUnsupportedNioImageToImageData(NioImageBuffer nioImageBuffer, int n, int n2, int n3, int n4, int n5, int n6, ImageData imageData) {
        if (MasterControl.isDevLoggable(Level.INFO)) {
            MasterControl.getDevLogger().info("ImageComponent - Copying Unsupported NioImage, use a different image type");
        }
        assert (imageData.getType() == ImageDataType.TYPE_BYTE_BUFFER);
        assert (this.getImageFormatType() == ImageFormatType.TYPE_BYTE_RGBA);
        int n7 = n5 * n6;
        ByteBuffer byteBuffer = (ByteBuffer)nioImageBuffer.getDataBuffer();
        byteBuffer.rewind();
        ByteBuffer byteBuffer2 = imageData.getAsByteBuffer();
        byteBuffer2.rewind();
        for (int i = 0; i < n7; i += 4) {
            byteBuffer2.put(i, byteBuffer.get(i + 3));
            byteBuffer2.put(i + 1, byteBuffer.get(i + 2));
            byteBuffer2.put(i + 2, byteBuffer.get(i + 1));
            byteBuffer2.put(i + 3, byteBuffer.get(i));
        }
    }

    void copyUnsupportedImageToImageData(RenderedImage renderedImage, int n, ImageData imageData) {
        assert (imageData.getType() == ImageDataType.TYPE_BYTE_ARRAY);
        if (MasterControl.isDevLoggable(Level.INFO)) {
            MasterControl.getDevLogger().info("ImageComponent - Copying Unsupported Image, use a different image type");
        }
        if (renderedImage instanceof BufferedImage) {
            this.copyUnsupportedImageToImageData((BufferedImage)renderedImage, 0, 0, 0, 0, n, imageData.dataWidth, imageData.dataHeight, imageData);
        } else {
            this.copyUnsupportedImageToImageData(renderedImage, renderedImage.getMinX(), renderedImage.getMinY(), 0, 0, n, imageData.dataWidth, imageData.dataHeight, imageData);
        }
    }

    void copyUnsupportedImageToImageData(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, ImageData imageData) {
        int n8;
        int n9 = n2;
        int n10 = 1;
        assert (imageData != null);
        int n11 = imageData.dataWidth;
        int n12 = imageData.dataHeight;
        int n13 = n11 * this.unitsPerPixel;
        if (this.yUp) {
            n8 = (n5 * n11 * n12 + n4 * n11 + n3) * this.unitsPerPixel;
        } else {
            n8 = (n5 * n11 * n12 + (n12 - n4 - 1) * n11 + n3) * this.unitsPerPixel;
            n13 = -1 * n13;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        Object object = ImageComponentRetained.getDataElementBuffer(writableRaster);
        byte[] byArray = imageData.getAsByteArray();
        switch (this.numberOfComponents) {
            case 4: {
                int n14 = n9;
                int n15 = 0;
                while (n15 < n7) {
                    int n16 = n8;
                    for (int i = n; i < n6 + n; ++i) {
                        writableRaster.getDataElements(i, n14, object);
                        byArray[n16++] = (byte)colorModel.getRed(object);
                        byArray[n16++] = (byte)colorModel.getGreen(object);
                        byArray[n16++] = (byte)colorModel.getBlue(object);
                        byArray[n16++] = (byte)colorModel.getAlpha(object);
                    }
                    n8 += n13;
                    ++n15;
                    n14 += n10;
                }
                break;
            }
            case 3: {
                int n17 = n9;
                int n18 = 0;
                while (n18 < n7) {
                    int n19 = n8;
                    for (int i = n; i < n6 + n; ++i) {
                        writableRaster.getDataElements(i, n17, object);
                        byArray[n19++] = (byte)colorModel.getRed(object);
                        byArray[n19++] = (byte)colorModel.getGreen(object);
                        byArray[n19++] = (byte)colorModel.getBlue(object);
                    }
                    n8 += n13;
                    ++n18;
                    n17 += n10;
                }
                break;
            }
            case 2: {
                int n20 = n9;
                int n21 = 0;
                while (n21 < n7) {
                    int n22 = n8;
                    for (int i = n; i < n6 + n; ++i) {
                        writableRaster.getDataElements(i, n20, object);
                        byArray[n22++] = (byte)colorModel.getRed(object);
                        byArray[n22++] = (byte)colorModel.getAlpha(object);
                    }
                    n8 += n13;
                    ++n21;
                    n20 += n10;
                }
                break;
            }
            case 1: {
                int n23 = n9;
                int n24 = 0;
                while (n24 < n7) {
                    int n25 = n8;
                    for (int i = n; i < n6 + n; ++i) {
                        writableRaster.getDataElements(i, n23, object);
                        byArray[n25++] = (byte)colorModel.getRed(object);
                    }
                    n8 += n13;
                    ++n24;
                    n23 += n10;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.imageData == imageData && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(n5);
        }
    }

    void copyUnsupportedImageToImageData(RenderedImage renderedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, ImageData imageData) {
        int n8;
        int n9;
        int n10;
        Object object = null;
        ColorModel colorModel = renderedImage.getColorModel();
        int n11 = renderedImage.getTileGridXOffset();
        int n12 = renderedImage.getTileGridYOffset();
        int n13 = renderedImage.getMinTileX();
        int n14 = renderedImage.getMinTileY();
        this.tilew = renderedImage.getTileWidth();
        this.tileh = renderedImage.getTileHeight();
        float f = (float)(n - n11) / (float)this.tilew;
        n13 = f < 0.0f ? (int)(f - 1.0f) : (int)f;
        f = (float)(n2 - n12) / (float)this.tileh;
        n14 = f < 0.0f ? (int)(f - 1.0f) : (int)f;
        int n15 = n13 * this.tilew + n11;
        int n16 = n14 * this.tileh + n12;
        int n17 = n15 + this.tilew - n;
        int n18 = n16 + this.tileh - n2;
        if (n17 > n6) {
            n17 = n6;
        }
        if (n18 > n7) {
            n18 = n7;
        }
        int n19 = n17;
        int n20 = n6;
        int n21 = n7;
        int n22 = n - n15;
        int n23 = n2 - n16;
        this.numXTiles = (n6 + n22) / this.tilew;
        this.numYTiles = (n7 + n23) / this.tileh;
        if ((float)(n6 + n22) % (float)this.tilew > 0.0f) {
            ++this.numXTiles;
        }
        if ((float)(n7 + n23) % (float)this.tileh > 0.0f) {
            ++this.numYTiles;
        }
        assert (imageData != null);
        int n24 = imageData.dataWidth;
        int n25 = imageData.dataHeight;
        int n26 = n24 * this.unitsPerPixel;
        if (this.yUp) {
            n10 = (n5 * n24 * n25 + n4 * n24 + n3) * this.unitsPerPixel;
            n9 = 1;
            n8 = n26;
        } else {
            n10 = (n5 * n24 * n25 + (n25 - n4 - 1) * n24 + n3) * this.unitsPerPixel;
            n9 = -1;
            n8 = -n26;
        }
        Raster raster = renderedImage.getTile(n13, n14);
        object = ImageComponentRetained.getDataElementBuffer(raster);
        byte[] byArray = this.imageData.getAsByteArray();
        switch (this.numberOfComponents) {
            case 4: {
                for (int i = n14; i < n14 + this.numYTiles; ++i) {
                    int n27 = n10;
                    n20 = n6;
                    n17 = n19;
                    n22 = n - n15;
                    for (int j = n13; j < n13 + this.numXTiles; ++j) {
                        raster = renderedImage.getTile(j, i);
                        int n28 = n27;
                        int n29 = 0;
                        for (int k = n23; k < n23 + n18; ++k) {
                            for (int i2 = n22; i2 < n22 + n17; ++i2) {
                                raster.getDataElements(i2, k, object);
                                byArray[n28++] = (byte)colorModel.getRed(object);
                                byArray[n28++] = (byte)colorModel.getGreen(object);
                                byArray[n28++] = (byte)colorModel.getBlue(object);
                                byArray[n28++] = (byte)colorModel.getAlpha(object);
                            }
                            n28 = n27 + (n29 += n8);
                        }
                        n27 += n17 * this.unitsPerPixel;
                        n22 = 0;
                        n17 = (n20 -= n17) < this.tilew ? n20 : this.tilew;
                    }
                    n10 += n24 * this.unitsPerPixel * n18 * n9;
                    n23 = 0;
                    n18 = (n21 -= n18) < this.tileh ? n21 : this.tileh;
                }
                break;
            }
            case 3: {
                for (int i = n14; i < n14 + this.numYTiles; ++i) {
                    int n30 = n10;
                    n20 = n6;
                    n17 = n19;
                    n22 = n - n15;
                    for (int j = n13; j < n13 + this.numXTiles; ++j) {
                        raster = renderedImage.getTile(j, i);
                        int n31 = n30;
                        int n32 = 0;
                        for (int k = n23; k < n23 + n18; ++k) {
                            for (int i3 = n22; i3 < n22 + n17; ++i3) {
                                raster.getDataElements(i3, k, object);
                                byArray[n31++] = (byte)colorModel.getRed(object);
                                byArray[n31++] = (byte)colorModel.getGreen(object);
                                byArray[n31++] = (byte)colorModel.getBlue(object);
                            }
                            n31 = n30 + (n32 += n8);
                        }
                        n30 += n17 * this.unitsPerPixel;
                        n22 = 0;
                        n17 = (n20 -= n17) < this.tilew ? n20 : this.tilew;
                    }
                    n10 += n24 * this.unitsPerPixel * n18 * n9;
                    n23 = 0;
                    n18 = (n21 -= n18) < this.tileh ? n21 : this.tileh;
                }
                break;
            }
            case 2: {
                for (int i = n14; i < n14 + this.numYTiles; ++i) {
                    int n33 = n10;
                    n20 = n6;
                    n17 = n19;
                    n22 = n - n15;
                    for (int j = n13; j < n13 + this.numXTiles; ++j) {
                        raster = renderedImage.getTile(j, i);
                        int n34 = n33;
                        int n35 = 0;
                        for (int k = n23; k < n23 + n18; ++k) {
                            for (int i4 = n22; i4 < n22 + n17; ++i4) {
                                raster.getDataElements(i4, k, object);
                                byArray[n34++] = (byte)colorModel.getRed(object);
                                byArray[n34++] = (byte)colorModel.getAlpha(object);
                            }
                            n34 = n33 + (n35 += n8);
                        }
                        n33 += n17 * this.unitsPerPixel;
                        n22 = 0;
                        n17 = (n20 -= n17) < this.tilew ? n20 : this.tilew;
                    }
                    n10 += n24 * this.unitsPerPixel * n18 * n9;
                    n23 = 0;
                    n18 = (n21 -= n18) < this.tileh ? n21 : this.tileh;
                }
                break;
            }
            case 1: {
                for (int i = n14; i < n14 + this.numYTiles; ++i) {
                    int n36 = n10;
                    n20 = n6;
                    n17 = n19;
                    n22 = n - n15;
                    for (int j = n13; j < n13 + this.numXTiles; ++j) {
                        raster = renderedImage.getTile(j, i);
                        int n37 = n36;
                        int n38 = 0;
                        for (int k = n23; k < n23 + n18; ++k) {
                            for (int i5 = n22; i5 < n22 + n17; ++i5) {
                                raster.getDataElements(i5, k, object);
                                byArray[n37++] = (byte)colorModel.getRed(object);
                            }
                            n37 = n36 + (n38 += n8);
                        }
                        n36 += n17 * this.unitsPerPixel;
                        n22 = 0;
                        n17 = (n20 -= n17) < this.tilew ? n20 : this.tilew;
                    }
                    n10 += n24 * this.unitsPerPixel * n18 * n9;
                    n23 = 0;
                    n18 = (n21 -= n18) < this.tileh ? n21 : this.tileh;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.imageData == imageData && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evaluateExtensions(Canvas3D canvas3D) {
        Object object = this.evaluateExtLock;
        synchronized (object) {
            this.evaluateExtABGR(canvas3D.extensionsSupported);
            this.evaluateExtNonPowerOfTwo(canvas3D.textureExtendedFeatures);
        }
    }

    void evaluateExtABGR(int n) {
        if (!this.abgrSupported) {
            return;
        }
        if (this.getImageFormatType() != ImageFormatType.TYPE_BYTE_ABGR) {
            return;
        }
        if ((n & 2) != 0) {
            return;
        }
        this.abgrSupported = false;
        this.convertImageDataFromABGRToRGBA();
    }

    private int getClosestPowerOf2(int n) {
        if (n < 1) {
            return n;
        }
        int n2 = 1;
        while (n >= (n2 *= 2)) {
        }
        int n3 = n2 / 2;
        if (n2 - n > n - n3) {
            return n3;
        }
        return n2;
    }

    private int getCeilPowerOf2(int n) {
        if (n < 1) {
            return n;
        }
        int n2 = 1;
        while (n > (n2 *= 2)) {
        }
        return n2;
    }

    void evaluateExtNonPowerOfTwo(int n) {
        int n2;
        int n3;
        if (!this.enforceNonPowerOfTwoSupport) {
            return;
        }
        if (!this.npotSupported) {
            return;
        }
        if (this.imageData == null && !this.isByReference()) {
            return;
        }
        if ((n & 0x8000) != 0) {
            return;
        }
        this.npotSupported = false;
        if (this.width * this.height < 262144) {
            n3 = this.getCeilPowerOf2(this.width);
            n2 = this.getCeilPowerOf2(this.height);
        } else {
            n3 = this.getClosestPowerOf2(this.width);
            n2 = this.getClosestPowerOf2(this.height);
        }
        float f = (float)n3 / (float)this.width;
        float f2 = (float)n2 / (float)this.height;
        if (f != 1.0f || f2 != 1.0f) {
            Object object;
            RenderedImage renderedImage;
            if (this.imageData == null) {
                renderedImage = (RenderedImage)this.getRefImage(0);
                assert (!(renderedImage instanceof BufferedImage));
                ColorModel colorModel = renderedImage.getColorModel();
                object = renderedImage.copyData(null);
                renderedImage = new BufferedImage(colorModel, (WritableRaster)object, colorModel.isAlphaPremultiplied(), null);
                this.imageData = this.createRenderedImageDataObject(null);
                this.copySupportedImageToImageData(renderedImage, 0, this.imageData);
            }
            assert (this.imageData != null);
            renderedImage = this.imageData.createBufferedImage(0);
            int n4 = ((BufferedImage)renderedImage).getType();
            object = new BufferedImage(n3, n2, n4);
            AffineTransform affineTransform = AffineTransform.getScaleInstance(f, f2);
            this.powerOfTwoATOp = new AffineTransformOp(affineTransform, 2);
            this.powerOfTwoATOp.filter((BufferedImage)renderedImage, (BufferedImage)object);
            this.imageDataPowerOfTwo = this.createRenderedImageDataObject(null, n3, n2);
            this.copySupportedImageToImageData((RenderedImage)object, 0, this.imageDataPowerOfTwo);
        } else {
            this.imageDataPowerOfTwo = null;
        }
    }

    void convertImageDataFromABGRToRGBA() {
        this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
        this.imageTypeIsSupported = false;
        this.imageData.convertFromABGRToRGBA();
    }

    void copyToRefImage(int n) {
        int n2;
        assert (this.refImage[n] != null);
        assert (this.refImage[n] instanceof BufferedImage);
        BufferedImage bufferedImage = (BufferedImage)this.refImage[n];
        int n3 = this.width * this.unitsPerPixel;
        int n4 = 0;
        if (this.yUp) {
            n2 = n * this.width * this.height * this.unitsPerPixel;
        } else {
            n2 = (n * this.width * this.height + (this.height - 1) * this.width) * this.unitsPerPixel;
            n3 = -1 * n3;
        }
        int n5 = this.width * this.unitsPerPixel;
        int n6 = n4 * this.width * this.unitsPerPixel;
        switch (this.imageData.getType()) {
            case TYPE_BYTE_ARRAY: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                byte[] byArray2 = this.imageData.getAsByteArray();
                for (int i = 0; i < this.height; ++i) {
                    System.arraycopy(byArray2, n6, byArray, n2, n5);
                    n2 += n3;
                    n6 += n5;
                }
                break;
            }
            case TYPE_INT_ARRAY: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int[] nArray2 = this.imageData.getAsIntArray();
                for (int i = 0; i < this.height; ++i) {
                    System.arraycopy(nArray2, n6, nArray, n2, n5);
                    n2 += n3;
                    n6 += n5;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void copyToRefImageWithFormatConversion(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        assert (this.refImage[n] != null);
        assert (this.refImage[n] instanceof BufferedImage);
        BufferedImage bufferedImage = (BufferedImage)this.refImage[n];
        int n6 = bufferedImage.getType();
        byte[] byArray = this.imageData.getAsByteArray();
        if (!this.yUp) {
            n5 = -1 * this.width;
            n4 = (this.height - 1) * this.width;
            n3 = this.height - 1;
            n2 = -1;
        } else {
            n5 = this.width;
            n4 = 0;
            n3 = 0;
            n2 = 1;
        }
        block0 : switch (n6) {
            case 2: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n7 = 0;
                switch (this.imageFormatType) {
                    case TYPE_BYTE_RGBA: {
                        int n8 = 0;
                        while (n8 < this.height) {
                            int n9 = n4;
                            int n10 = 0;
                            while (n10 < this.width) {
                                nArray[n9] = (byArray[n7 + 3] & 0xFF) << 24 | (byArray[n7] & 0xFF) << 16 | (byArray[n7 + 1] & 0xFF) << 8 | byArray[n7 + 2] & 0xFF;
                                ++n10;
                                n7 += 4;
                                ++n9;
                            }
                            ++n8;
                            n4 += n5;
                        }
                        break block0;
                    }
                    case TYPE_BYTE_RGB: {
                        int n11 = 0;
                        while (n11 < this.height) {
                            int n12 = n4;
                            int n13 = 0;
                            while (n13 < this.width) {
                                nArray[n12] = 0xFF000000 | (byArray[n7] & 0xFF) << 16 | (byArray[n7 + 1] & 0xFF) << 8 | byArray[n7 + 2] & 0xFF;
                                ++n13;
                                n7 += 3;
                                ++n12;
                            }
                            ++n11;
                            n4 += n5;
                        }
                        break block0;
                    }
                    default: {
                        assert (false);
                        break block0;
                    }
                }
            }
            case 1: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n14 = 0;
                int n15 = 0;
                while (n15 < this.height) {
                    int n16 = n4;
                    int n17 = 0;
                    while (n17 < this.width) {
                        nArray[n16] = 0xFF000000 | (byArray[n14] & 0xFF) << 16 | (byArray[n14 + 1] & 0xFF) << 8 | byArray[n14 + 2] & 0xFF;
                        ++n17;
                        n14 += 4;
                        ++n16;
                    }
                    ++n15;
                    n4 += n5;
                }
                break;
            }
            case 6: {
                byte[] byArray2 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n18 = 0;
                n4 <<= 2;
                switch (this.imageFormatType) {
                    case TYPE_BYTE_RGBA: {
                        int n19 = 0;
                        while (n19 < this.height) {
                            int n20 = n4;
                            int n21 = 0;
                            while (n21 < this.width) {
                                byArray2[n20++] = byArray[n18 + 3];
                                byArray2[n20++] = byArray[n18 + 2];
                                byArray2[n20++] = byArray[n18 + 1];
                                byArray2[n20++] = byArray[n18];
                                ++n21;
                                n18 += 4;
                            }
                            ++n19;
                            n4 += n5 << 2;
                        }
                        break block0;
                    }
                    case TYPE_BYTE_RGB: {
                        int n22 = 0;
                        while (n22 < this.height) {
                            int n23 = n4;
                            int n24 = 0;
                            while (n24 < this.width) {
                                byArray2[n23++] = -1;
                                byArray2[n23++] = byArray[n18 + 2];
                                byArray2[n23++] = byArray[n18 + 1];
                                byArray2[n23++] = byArray[n18];
                                ++n24;
                                n18 += 3;
                            }
                            ++n22;
                            n4 += n5 << 2;
                        }
                        break block0;
                    }
                    default: {
                        assert (false);
                        break block0;
                    }
                }
            }
            case 4: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n25 = 0;
                int n26 = 0;
                while (n26 < this.height) {
                    int n27 = n4;
                    int n28 = 0;
                    while (n28 < this.width) {
                        nArray[n27] = 0xFF000000 | byArray[n25] & 0xFF | (byArray[n25 + 1] & 0xFF) << 8 | (byArray[n25 + 2] & 0xFF) << 16;
                        ++n28;
                        n25 += 4;
                        ++n27;
                    }
                    ++n26;
                    n4 += n5;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    synchronized void addUser(NodeComponentRetained nodeComponentRetained) {
        this.userList.add(nodeComponentRetained);
    }

    synchronized void removeUser(NodeComponentRetained nodeComponentRetained) {
        int n = this.userList.indexOf(nodeComponentRetained);
        if (n >= 0) {
            this.userList.remove(n);
        }
    }

    @Override
    void setLive(boolean bl, int n) {
        if (this.getUsedByOffScreen()) {
            throw new IllegalSharingException(J3dI18N.getString("ImageComponent3"));
        }
        super.setLive(bl, n);
    }

    @Override
    synchronized void updateMirrorObject(int n, Object object) {
        if ((n & 1) == 0 && (n & 2) == 0) {
            return;
        }
        for (int i = this.userList.size() - 1; i >= 0; --i) {
            NodeComponentRetained nodeComponentRetained = this.userList.get(i);
            if (nodeComponentRetained == null) continue;
            if (nodeComponentRetained instanceof TextureRetained) {
                ((TextureRetained)nodeComponentRetained).notifyImageComponentImageChanged(this, (ImageComponentUpdateInfo)object);
                continue;
            }
            if (!(nodeComponentRetained instanceof RasterRetained)) continue;
            ((RasterRetained)nodeComponentRetained).notifyImageComponentImageChanged(this, (ImageComponentUpdateInfo)object);
        }
    }

    final void sendMessage(int n, Object object) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1152;
        j3dMessage.type = 54;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    @Override
    void handleFrequencyChange(int n) {
        if (n == 3) {
            this.setFrequencyChangeMask(3, 1);
        }
    }

    static Object getDataElementBuffer(Raster raster) {
        int n = raster.getNumDataElements();
        switch (raster.getTransferType()) {
            case 3: {
                return new int[n];
            }
            case 0: {
                return new byte[n];
            }
            case 1: 
            case 2: {
                return new short[n];
            }
            case 4: {
                return new float[n];
            }
            case 5: {
                return new double[n];
            }
        }
        return null;
    }

    class ImageData {
        private Object data = null;
        private ImageDataType imageDataType = ImageDataType.TYPE_NULL;
        private int length = 0;
        private boolean dataIsByRef = false;
        private int dataWidth;
        private int dataHeight;

        ImageData(ImageDataType imageDataType, int n, int n2, int n3) {
            this.imageDataType = imageDataType;
            this.length = n;
            this.dataWidth = n2;
            this.dataHeight = n3;
            this.dataIsByRef = false;
            switch (imageDataType) {
                case TYPE_BYTE_ARRAY: {
                    this.data = new byte[n];
                    break;
                }
                case TYPE_INT_ARRAY: {
                    this.data = new int[n];
                    break;
                }
                case TYPE_BYTE_BUFFER: {
                    ByteOrder byteOrder = ByteOrder.nativeOrder();
                    this.data = ByteBuffer.allocateDirect(n).order(byteOrder);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        ImageData(ImageDataType imageDataType, int n, int n2, int n3, Object object) {
            this.imageDataType = imageDataType;
            this.length = n;
            this.dataWidth = n2;
            this.dataHeight = n3;
            this.dataIsByRef = true;
            switch (imageDataType) {
                case TYPE_BYTE_ARRAY: {
                    BufferedImage bufferedImage = (BufferedImage)object;
                    this.data = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                    break;
                }
                case TYPE_INT_ARRAY: {
                    BufferedImage bufferedImage = (BufferedImage)object;
                    this.data = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                    break;
                }
                case TYPE_BYTE_BUFFER: 
                case TYPE_INT_BUFFER: {
                    NioImageBuffer nioImageBuffer = (NioImageBuffer)object;
                    this.data = nioImageBuffer.getDataBuffer();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        ImageData(Object object, boolean bl) {
            this.data = object;
            this.dataIsByRef = bl;
            this.dataWidth = ((ImageData)object).dataWidth;
            this.dataHeight = ((ImageData)object).dataHeight;
            if (object == null) {
                this.imageDataType = ImageDataType.TYPE_NULL;
                this.length = 0;
            } else if (object instanceof byte[]) {
                this.imageDataType = ImageDataType.TYPE_BYTE_ARRAY;
                this.length = ((byte[])object).length;
            } else if (object instanceof int[]) {
                this.imageDataType = ImageDataType.TYPE_INT_ARRAY;
                this.length = ((int[])object).length;
            } else if (object instanceof ByteBuffer) {
                this.imageDataType = ImageDataType.TYPE_BYTE_BUFFER;
                this.length = ((ByteBuffer)object).limit();
            } else if (object instanceof IntBuffer) {
                this.imageDataType = ImageDataType.TYPE_INT_BUFFER;
                this.length = ((IntBuffer)object).limit();
            } else assert (false);
        }

        ImageDataType getType() {
            return this.imageDataType;
        }

        int length() {
            return this.length;
        }

        int getWidth() {
            return this.dataWidth;
        }

        int getHeight() {
            return this.dataHeight;
        }

        Object get() {
            return this.data;
        }

        boolean isDataByRef() {
            return this.dataIsByRef;
        }

        byte[] getAsByteArray() {
            return (byte[])this.data;
        }

        int[] getAsIntArray() {
            return (int[])this.data;
        }

        ByteBuffer getAsByteBuffer() {
            return (ByteBuffer)this.data;
        }

        IntBuffer getAsIntBuffer() {
            return (IntBuffer)this.data;
        }

        void copyByLineAndExpand(BufferedImage bufferedImage, int n) {
            int n2;
            int n3;
            assert (ImageComponentRetained.this.imageData.getType() == ImageDataType.TYPE_BYTE_ARRAY);
            assert (ImageComponentRetained.this.imageFormatType == ImageFormatType.TYPE_BYTE_LA);
            int n4 = n3 = ImageComponentRetained.this.width * ImageComponentRetained.this.unitsPerPixel;
            if (ImageComponentRetained.this.yUp) {
                n2 = n * ImageComponentRetained.this.width * ImageComponentRetained.this.height * ImageComponentRetained.this.unitsPerPixel;
            } else {
                n2 = (n * ImageComponentRetained.this.width * ImageComponentRetained.this.height + (ImageComponentRetained.this.height - 1) * ImageComponentRetained.this.width) * ImageComponentRetained.this.unitsPerPixel;
                n3 = -1 * n3;
            }
            int n5 = 0;
            int n6 = ImageComponentRetained.this.width * 4;
            byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            byte[] byArray2 = ImageComponentRetained.this.imageData.getAsByteArray();
            for (int i = 0; i < ImageComponentRetained.this.height; ++i) {
                int n7 = 0;
                int n8 = 0;
                while (n8 < n4) {
                    byArray[n5 + n7] = byArray2[n2 + n8 + 1];
                    byArray[n5 + n7 + 1] = 0;
                    byArray[n5 + n7 + 2] = 0;
                    byArray[n5 + n7 + 3] = byArray2[n2 + n8];
                    n8 += ImageComponentRetained.this.unitsPerPixel;
                    n7 += 4;
                }
                n5 += n6;
                n2 += n3;
            }
        }

        void copyByLine(BufferedImage bufferedImage, int n, boolean bl) {
            int n2;
            int n3;
            int n4 = n3 = ImageComponentRetained.this.width * ImageComponentRetained.this.unitsPerPixel;
            if (ImageComponentRetained.this.yUp) {
                n2 = n * ImageComponentRetained.this.width * ImageComponentRetained.this.height * ImageComponentRetained.this.unitsPerPixel;
            } else {
                n2 = (n * ImageComponentRetained.this.width * ImageComponentRetained.this.height + (ImageComponentRetained.this.height - 1) * ImageComponentRetained.this.width) * ImageComponentRetained.this.unitsPerPixel;
                n3 = -1 * n3;
            }
            int n5 = 0;
            switch (ImageComponentRetained.this.imageData.getType()) {
                case TYPE_BYTE_ARRAY: {
                    byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                    byte[] byArray2 = ImageComponentRetained.this.imageData.getAsByteArray();
                    for (int i = 0; i < ImageComponentRetained.this.height; ++i) {
                        int n6;
                        if (!bl) {
                            System.arraycopy(byArray2, n2, byArray, n5, n4);
                        } else if (ImageComponentRetained.this.imageFormatType == ImageFormatType.TYPE_BYTE_RGB) {
                            assert (ImageComponentRetained.this.unitsPerPixel == 3);
                            for (n6 = 0; n6 < n4; n6 += ImageComponentRetained.this.unitsPerPixel) {
                                byArray[n5 + n6] = byArray2[n2 + n6 + 2];
                                byArray[n5 + n6 + 1] = byArray2[n2 + n6 + 1];
                                byArray[n5 + n6 + 2] = byArray2[n2 + n6];
                            }
                        } else if (ImageComponentRetained.this.imageFormatType == ImageFormatType.TYPE_BYTE_RGBA) {
                            assert (ImageComponentRetained.this.unitsPerPixel == 4);
                            for (n6 = 0; n6 < n4; n6 += ImageComponentRetained.this.unitsPerPixel) {
                                byArray[n5 + n6] = byArray2[n2 + n6 + 3];
                                byArray[n5 + n6 + 1] = byArray2[n2 + n6 + 2];
                                byArray[n5 + n6 + 2] = byArray2[n2 + n6 + 1];
                                byArray[n5 + n6 + 3] = byArray2[n2 + n6];
                            }
                        } else assert (false);
                        n5 += n4;
                        n2 += n3;
                    }
                    break;
                }
                case TYPE_INT_ARRAY: {
                    assert (!bl);
                    int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                    int[] nArray2 = ImageComponentRetained.this.imageData.getAsIntArray();
                    for (int i = 0; i < ImageComponentRetained.this.height; ++i) {
                        System.arraycopy(nArray2, n2, nArray, n5, n4);
                        n5 += n4;
                        n2 += n3;
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        void copyByBlock(BufferedImage bufferedImage, int n) {
            int n2 = n * ImageComponentRetained.this.width * ImageComponentRetained.this.height * ImageComponentRetained.this.unitsPerPixel;
            switch (ImageComponentRetained.this.imageData.getType()) {
                case TYPE_BYTE_ARRAY: {
                    byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                    byte[] byArray2 = ImageComponentRetained.this.imageData.getAsByteArray();
                    System.arraycopy(byArray2, n2, byArray, 0, ImageComponentRetained.this.height * ImageComponentRetained.this.width * ImageComponentRetained.this.unitsPerPixel);
                    break;
                }
                case TYPE_INT_ARRAY: {
                    int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                    int[] nArray2 = ImageComponentRetained.this.imageData.getAsIntArray();
                    System.arraycopy(nArray2, n2, nArray, 0, ImageComponentRetained.this.height * ImageComponentRetained.this.width * ImageComponentRetained.this.unitsPerPixel);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        BufferedImage createBufferedImage(int n) {
            if (this.data != null) {
                int n2 = 0;
                boolean bl = false;
                switch (ImageComponentRetained.this.imageFormatType) {
                    case TYPE_BYTE_BGR: {
                        n2 = 5;
                        break;
                    }
                    case TYPE_BYTE_RGB: {
                        n2 = 5;
                        bl = true;
                        break;
                    }
                    case TYPE_BYTE_ABGR: {
                        n2 = 6;
                        break;
                    }
                    case TYPE_BYTE_RGBA: {
                        n2 = 6;
                        bl = true;
                        break;
                    }
                    case TYPE_BYTE_LA: {
                        n2 = 6;
                        break;
                    }
                    case TYPE_BYTE_GRAY: {
                        n2 = 10;
                        break;
                    }
                    case TYPE_INT_BGR: {
                        n2 = 4;
                        break;
                    }
                    case TYPE_INT_RGB: {
                        n2 = 1;
                        break;
                    }
                    case TYPE_INT_ARGB: {
                        n2 = 2;
                        break;
                    }
                    case TYPE_USHORT_GRAY: {
                        n2 = 11;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                BufferedImage bufferedImage = new BufferedImage(ImageComponentRetained.this.width, ImageComponentRetained.this.height, n2);
                if (!bl && ImageComponentRetained.this.imageFormatType != ImageFormatType.TYPE_BYTE_LA) {
                    if (ImageComponentRetained.this.yUp) {
                        this.copyByBlock(bufferedImage, n);
                    } else {
                        this.copyByLine(bufferedImage, n, false);
                    }
                } else if (bl) {
                    this.copyByLine(bufferedImage, n, bl);
                } else if (ImageComponentRetained.this.imageFormatType == ImageFormatType.TYPE_BYTE_LA) {
                    this.copyByLineAndExpand(bufferedImage, n);
                } else assert (false);
                return bufferedImage;
            }
            return null;
        }

        void convertFromABGRToRGBA() {
            if (this.imageDataType == ImageDataType.TYPE_BYTE_ARRAY) {
                byte[] byArray = this.getAsByteArray();
                if (this.dataIsByRef) {
                    byte[] byArray2 = new byte[this.length];
                    for (int i = 0; i < this.length; i += 4) {
                        byArray2[i] = byArray[i + 3];
                        byArray2[i + 1] = byArray[i + 2];
                        byArray2[i + 2] = byArray[i + 1];
                        byArray2[i + 3] = byArray[i];
                    }
                    this.data = byArray2;
                    this.dataIsByRef = false;
                } else {
                    for (int i = 0; i < this.length; i += 4) {
                        byte by = byArray[i];
                        byte by2 = byArray[i + 1];
                        byArray[i] = byArray[i + 3];
                        byArray[i + 1] = byArray[i + 2];
                        byArray[i + 2] = by2;
                        byArray[i + 3] = by;
                    }
                }
            } else if (this.imageDataType == ImageDataType.TYPE_BYTE_BUFFER) {
                assert (this.dataIsByRef);
                ByteBuffer byteBuffer = this.getAsByteBuffer();
                byteBuffer.rewind();
                ByteOrder byteOrder = ByteOrder.nativeOrder();
                ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.length).order(byteOrder);
                byteBuffer2.rewind();
                for (int i = 0; i < this.length; i += 4) {
                    byteBuffer2.put(i, byteBuffer.get(i + 3));
                    byteBuffer2.put(i + 1, byteBuffer.get(i + 2));
                    byteBuffer2.put(i + 2, byteBuffer.get(i + 1));
                    byteBuffer2.put(i + 3, byteBuffer.get(i));
                }
                this.dataIsByRef = false;
            }
        }
    }

    static enum ImageDataType {
        TYPE_NULL,
        TYPE_BYTE_ARRAY,
        TYPE_INT_ARRAY,
        TYPE_BYTE_BUFFER,
        TYPE_INT_BUFFER;

    }

    static enum ImageFormatType {
        TYPE_UNKNOWN,
        TYPE_BYTE_BGR,
        TYPE_BYTE_RGB,
        TYPE_BYTE_ABGR,
        TYPE_BYTE_RGBA,
        TYPE_BYTE_LA,
        TYPE_BYTE_GRAY,
        TYPE_USHORT_GRAY,
        TYPE_INT_BGR,
        TYPE_INT_RGB,
        TYPE_INT_ARGB;

    }
}

