/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Pattern;
import org.apache.maven.shared.utils.xml.XmlStreamReaderException;

public class XmlStreamReader
extends Reader {
    private final org.apache.commons.io.input.XmlStreamReader reader;
    private static String staticDefaultEncoding = null;
    static final Pattern ENCODING_PATTERN = Pattern.compile("<\\?xml.*encoding[\\s]*=[\\s]*((?:\".[^\"]*\")|(?:'.[^']*'))", 8);

    public static void setDefaultEncoding(String encoding2) {
        staticDefaultEncoding = encoding2;
    }

    public static String getDefaultEncoding() {
        return staticDefaultEncoding;
    }

    public XmlStreamReader(File file2) throws IOException {
        this(new FileInputStream(file2));
    }

    public XmlStreamReader(InputStream is2) throws IOException {
        this(is2, true);
    }

    public XmlStreamReader(InputStream is2, boolean lenient) throws IOException, XmlStreamReaderException {
        this.reader = new org.apache.commons.io.input.XmlStreamReader(is2, lenient, staticDefaultEncoding);
    }

    public XmlStreamReader(URL url) throws IOException {
        this(url.openConnection());
    }

    public XmlStreamReader(URLConnection conn) throws IOException {
        this.reader = new org.apache.commons.io.input.XmlStreamReader(conn, staticDefaultEncoding);
    }

    public XmlStreamReader(InputStream is2, String httpContentType) throws IOException {
        this(is2, httpContentType, true);
    }

    public XmlStreamReader(InputStream is2, String httpContentType, boolean lenient, String defaultEncoding) throws IOException, XmlStreamReaderException {
        this.reader = new org.apache.commons.io.input.XmlStreamReader(is2, httpContentType, lenient, defaultEncoding == null ? staticDefaultEncoding : defaultEncoding);
    }

    public XmlStreamReader(InputStream is2, String httpContentType, boolean lenient) throws IOException, XmlStreamReaderException {
        this(is2, httpContentType, lenient, null);
    }

    public String getEncoding() {
        return this.reader.getEncoding();
    }

    @Override
    public int read(char[] buf, int offset, int len) throws IOException {
        return this.reader.read(buf, offset, len);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

