/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.build.aws.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.springframework.build.aws.maven.NullProtectingProxyInfoProvider;
import org.springframework.build.aws.maven.SessionListenerSupport;
import org.springframework.build.aws.maven.StandardSessionListenerSupport;
import org.springframework.build.aws.maven.StandardTransferListenerSupport;
import org.springframework.build.aws.maven.StandardTransferProgress;
import org.springframework.build.aws.maven.TransferListenerSupport;
import org.springframework.build.aws.maven.TransferProgress;

abstract class AbstractWagon
implements Wagon {
    private int connectionTimeout = 60000;
    private boolean interactive = false;
    private int readTimeout = 1800000;
    private Repository repository = null;
    private final boolean supportsDirectoryCopy;
    private final SessionListenerSupport sessionListenerSupport;
    private final TransferListenerSupport transferListenerSupport;

    protected AbstractWagon(boolean supportsDirectoryCopy) {
        this.supportsDirectoryCopy = supportsDirectoryCopy;
        this.sessionListenerSupport = new StandardSessionListenerSupport(this);
        this.transferListenerSupport = new StandardTransferListenerSupport(this);
    }

    protected AbstractWagon(boolean supportsDirectoryCopy, SessionListenerSupport sessionListenerSupport, TransferListenerSupport transferListenerSupport) {
        this.supportsDirectoryCopy = supportsDirectoryCopy;
        this.sessionListenerSupport = sessionListenerSupport;
        this.transferListenerSupport = transferListenerSupport;
    }

    @Override
    public final void addSessionListener(SessionListener sessionListener) {
        this.sessionListenerSupport.addSessionListener(sessionListener);
    }

    @Override
    public final boolean hasSessionListener(SessionListener sessionListener) {
        return this.sessionListenerSupport.hasSessionListener(sessionListener);
    }

    @Override
    public final void removeSessionListener(SessionListener sessionListener) {
        this.sessionListenerSupport.removeSessionListener(sessionListener);
    }

    @Override
    public final void addTransferListener(TransferListener transferListener) {
        this.transferListenerSupport.addTransferListener(transferListener);
    }

    @Override
    public final boolean hasTransferListener(TransferListener transferListener) {
        return this.transferListenerSupport.hasTransferListener(transferListener);
    }

    @Override
    public final void removeTransferListener(TransferListener transferListener) {
        this.transferListenerSupport.removeTransferListener(transferListener);
    }

    @Override
    public final Repository getRepository() {
        return this.repository;
    }

    @Override
    public final boolean isInteractive() {
        return this.interactive;
    }

    @Override
    public final void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    @Override
    public final void connect(Repository source2) throws ConnectionException, AuthenticationException {
        this.connect(source2, null, (ProxyInfoProvider)null);
    }

    @Override
    public final void connect(Repository source2, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.connect(source2, null, proxyInfo);
    }

    @Override
    public final void connect(Repository source2, AuthenticationInfo authenticationInfo) throws ConnectionException, AuthenticationException {
        this.connect(source2, authenticationInfo, (ProxyInfoProvider)null);
    }

    @Override
    public final void connect(Repository source2, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.connect(source2, null, proxyInfoProvider);
    }

    @Override
    public final void connect(Repository source2, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.connect(source2, authenticationInfo, new NullProtectingProxyInfoProvider(proxyInfo));
    }

    @Override
    public final void connect(Repository source2, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.repository = source2;
        this.sessionListenerSupport.fireSessionOpening();
        try {
            this.connectToRepository(source2, authenticationInfo, proxyInfoProvider);
            this.sessionListenerSupport.fireSessionLoggedIn();
            this.sessionListenerSupport.fireSessionOpened();
        }
        catch (ConnectionException | AuthenticationException e2) {
            this.sessionListenerSupport.fireSessionConnectionRefused();
            throw e2;
        }
    }

    @Override
    public final void disconnect() throws ConnectionException {
        this.sessionListenerSupport.fireSessionDisconnecting();
        try {
            this.disconnectFromRepository();
            this.sessionListenerSupport.fireSessionLoggedOff();
            this.sessionListenerSupport.fireSessionDisconnected();
        }
        catch (ConnectionException e2) {
            this.sessionListenerSupport.fireSessionConnectionRefused();
            throw e2;
        }
    }

    @Override
    public final void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource2 = new Resource(resourceName);
        this.transferListenerSupport.fireTransferInitiated(resource2, 5);
        this.transferListenerSupport.fireTransferStarted(resource2, 5);
        try {
            this.getResource(resourceName, destination, new StandardTransferProgress(resource2, 5, this.transferListenerSupport));
            this.transferListenerSupport.fireTransferCompleted(resource2, 5);
        }
        catch (ResourceDoesNotExistException | TransferFailedException | AuthorizationException e2) {
            this.transferListenerSupport.fireTransferError(resource2, 5, e2);
            throw e2;
        }
    }

    @Override
    public final List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            return this.listDirectory(destinationDirectory);
        }
        catch (ResourceDoesNotExistException | TransferFailedException | AuthorizationException e2) {
            this.transferListenerSupport.fireTransferError(new Resource(destinationDirectory), 5, e2);
            throw e2;
        }
    }

    @Override
    public final boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource2 = new Resource(resourceName);
        try {
            if (this.isRemoteResourceNewer(resourceName, timestamp)) {
                this.get(resourceName, destination);
                return true;
            }
            return false;
        }
        catch (ResourceDoesNotExistException | TransferFailedException | AuthorizationException e2) {
            this.transferListenerSupport.fireTransferError(resource2, 5, e2);
            throw e2;
        }
    }

    @Override
    public final void openConnection() {
    }

    @Override
    public final void put(File source2, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource2 = new Resource(destination);
        this.transferListenerSupport.fireTransferInitiated(resource2, 6);
        this.transferListenerSupport.fireTransferStarted(resource2, 6);
        try {
            this.putResource(source2, destination, new StandardTransferProgress(resource2, 6, this.transferListenerSupport));
            this.transferListenerSupport.fireTransferCompleted(resource2, 6);
        }
        catch (ResourceDoesNotExistException | TransferFailedException | AuthorizationException e2) {
            this.transferListenerSupport.fireTransferError(resource2, 6, e2);
            throw e2;
        }
    }

    @Override
    public final void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File[] files = sourceDirectory.listFiles();
        if (files != null) {
            for (File f : files) {
                this.put(f, destinationDirectory + "/" + f.getName());
            }
        }
    }

    @Override
    public final boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        try {
            return this.doesRemoteResourceExist(resourceName);
        }
        catch (TransferFailedException | AuthorizationException e2) {
            this.transferListenerSupport.fireTransferError(new Resource(resourceName), 5, e2);
            throw e2;
        }
    }

    @Override
    public final boolean supportsDirectoryCopy() {
        return this.supportsDirectoryCopy;
    }

    @Override
    public final int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public final void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public final int getTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public final void setTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    protected abstract void connectToRepository(Repository var1, AuthenticationInfo var2, ProxyInfoProvider var3) throws ConnectionException, AuthenticationException;

    protected abstract boolean doesRemoteResourceExist(String var1) throws TransferFailedException, AuthorizationException;

    protected abstract void disconnectFromRepository() throws ConnectionException;

    protected abstract void getResource(String var1, File var2, TransferProgress var3) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    protected abstract boolean isRemoteResourceNewer(String var1, long var2) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    protected abstract List<String> listDirectory(String var1) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    protected abstract void putResource(File var1, String var2, TransferProgress var3) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;
}

