/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#ifdef __cplusplus
extern "C" {
#endif




#ifndef _ORBIT_H_
#define _ORBIT_H_

#ifndef _CARAT_TYPEDEF_H_
#include"typedef.h"
#endif

#ifdef __STDC__
/*-------------------------------------------------------------*\
| FILE: orb_division.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *orbit_representatives(matrix_TYP **M, int Manz,
     bravais_TYP *G, int *option, int *orbit_no, int is_sorted);

/*-------------------------------------------------------------*\
| FILE: orb_alg.c 
\*-------------------------------------------------------------*/
extern int *make_orbit_options();
extern matrix_TYP **orbit_alg(matrix_TYP *M, bravais_TYP *G, bravais_TYP *S,
     int *option, int *length);
extern void free_baum(struct baum *p);
struct baum *hash_addbaum(matrix_TYP *mat,
                          matrix_TYP **L,
                          int anz,
                          struct baum *verz,
                          int *schonda,
                          int hashnumber,
                          int *hashverz);
/*-------------------------------------------------------------*\
| FILE: orbit_subdivision.c 
\*-------------------------------------------------------------*/
extern int *orbit_subdivision(matrix_TYP *vecs, bravais_TYP *G, int *orbit_no);

/*-------------------------------------------------------------*\
| FILE: vec_orbit_division.c 
\*-------------------------------------------------------------*/
extern int *vec_orbit_division( int **V, int V_no, bravais_TYP *G,
     int orbit_no);

/*-------------------------------------------------------------*\
| FILE: row_spin.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *row_spin(matrix_TYP *x,matrix_TYP **G,int no,int option);
extern bravais_TYP *representation_on_lattice(matrix_TYP *x,bravais_TYP *G,
                                       int option);
matrix_TYP *translation_lattice(matrix_TYP **G,int number,matrix_TYP *P);

#else
/*-------------------------------------------------------------*\
| FILE: orb_division.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *orbit_representatives();

/*-------------------------------------------------------------*\
| FILE: orb_alg.c 
\*-------------------------------------------------------------*/
extern int *make_orbit_options();
extern matrix_TYP **orbit_alg();
extern void free_baum();
struct baum *hash_addbaum();

/*-------------------------------------------------------------*\
| FILE: orbit_subdivision.c 
\*-------------------------------------------------------------*/
extern int *orbit_subdivision();

/*-------------------------------------------------------------*\
| FILE: vec_orbit_division.c 
\*-------------------------------------------------------------*/
extern int *vec_orbit_division();

/*-------------------------------------------------------------*\
| FILE: row_spin.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *row_spin();
extern bravais_TYP *representation_on_lattice();
matrix_TYP *translation_lattice();

#endif
#endif


#ifdef __cplusplus
}
#endif

