/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import javax.swing.JTable;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;

public class TaginfoAction
extends JosmAction {
    final transient StringProperty TAGINFO_URL_PROP = new StringProperty("taginfo.url", "https://taginfo.openstreetmap.org/");
    private final JTable tagTable;
    private final IntFunction<String> tagKeySupplier;
    private final IntFunction<Map<String, Integer>> tagValuesSupplier;
    private final JTable membershipTable;
    private final IntFunction<IRelation<?>> memberValueSupplier;

    public TaginfoAction(JTable tagTable, IntFunction<String> tagKeySupplier, IntFunction<Map<String, Integer>> tagValuesSupplier, JTable membershipTable, IntFunction<IRelation<?>> memberValueSupplier) {
        super(I18n.tr("Go to Taginfo", new Object[0]), "dialogs/taginfo", I18n.tr("Launch browser with Taginfo statistics for selected object", new Object[0]), null, false);
        this.tagTable = Objects.requireNonNull(tagTable);
        this.tagKeySupplier = Objects.requireNonNull(tagKeySupplier);
        this.tagValuesSupplier = Objects.requireNonNull(tagValuesSupplier);
        this.membershipTable = membershipTable;
        this.memberValueSupplier = memberValueSupplier;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String url;
        if (this.tagTable.getSelectedRowCount() == 1) {
            int row = this.tagTable.getSelectedRow();
            String key = Utils.encodeUrl(this.tagKeySupplier.apply(row)).replaceAll("\\+", "%20");
            Map<String, Integer> values = this.tagValuesSupplier.apply(row);
            url = values.size() == 1 ? this.TAGINFO_URL_PROP.get() + "tags/" + key + '=' + Utils.encodeUrl(values.keySet().iterator().next()).replaceAll("\\+", "%20") : this.TAGINFO_URL_PROP.get() + "keys/" + key;
        } else if (this.membershipTable != null && this.membershipTable.getSelectedRowCount() == 1) {
            String type = this.memberValueSupplier.apply(this.membershipTable.getSelectedRow()).get("type");
            url = this.TAGINFO_URL_PROP.get() + "relations/" + type;
        } else {
            return;
        }
        OpenBrowser.displayUrl(url);
    }
}

