/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.ACL;
import com.sun.mail.imap.AppendUID;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.MessageLiteral;
import com.sun.mail.imap.Rights;
import com.sun.mail.imap.Utility;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.MessageSet;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Quota;
import javax.mail.ReadOnlyFolderException;
import javax.mail.StoreClosedException;
import javax.mail.UIDFolder;
import javax.mail.internet.MimeMessage;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

public class IMAPFolder
extends Folder
implements UIDFolder,
ResponseHandler {
    protected String fullName;
    protected String name;
    protected int type;
    protected char separator;
    protected Flags availableFlags;
    protected Flags permanentFlags;
    protected boolean exists = false;
    protected boolean isNamespace = false;
    protected String[] attributes;
    protected IMAPProtocol protocol;
    protected Vector messageCache;
    protected Object messageCacheLock;
    protected Hashtable uidTable;
    protected static final char UNKNOWN_SEPARATOR = '\uffff';
    private boolean opened = false;
    private boolean reallyClosed = true;
    private static final int RUNNING = 0;
    private static final int IDLE = 1;
    private static final int ABORTING = 2;
    private int idleState = 0;
    private int total = -1;
    private int recent = -1;
    private int realTotal = -1;
    private long uidvalidity = -1L;
    private long uidnext = -1L;
    private boolean doExpungeNotification = true;
    private Status cachedStatus = null;
    private long cachedStatusTime = 0L;
    private boolean debug = false;
    private PrintStream out;
    private boolean connectionPoolDebug;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$mail$imap$IMAPFolder;
    static /* synthetic */ Class class$javax$mail$Flags;

    protected IMAPFolder(String string, char c, IMAPStore iMAPStore) {
        super(iMAPStore);
        int n;
        if (string == null) {
            throw new NullPointerException("Folder name is null");
        }
        this.fullName = string;
        this.separator = c;
        this.messageCacheLock = new Object();
        this.debug = iMAPStore.getSession().getDebug();
        this.connectionPoolDebug = iMAPStore.getConnectionPoolDebug();
        this.out = iMAPStore.getSession().getDebugOut();
        if (this.out == null) {
            this.out = System.out;
        }
        this.isNamespace = false;
        if (c != '\uffff' && c != '\u0000' && (n = this.fullName.indexOf(c)) > 0 && n == this.fullName.length() - 1) {
            this.fullName = this.fullName.substring(0, n);
            this.isNamespace = true;
        }
    }

    protected IMAPFolder(String string, char c, IMAPStore iMAPStore, boolean bl) {
        this(string, c, iMAPStore);
        this.isNamespace = bl;
    }

    protected IMAPFolder(ListInfo listInfo, IMAPStore iMAPStore) {
        this(listInfo.name, listInfo.separator, iMAPStore);
        if (listInfo.hasInferiors) {
            this.type |= 2;
        }
        if (listInfo.canOpen) {
            this.type |= 1;
        }
        this.exists = true;
        this.attributes = listInfo.attrs;
    }

    private void checkExists() throws MessagingException {
        if (!this.exists && !this.exists()) {
            throw new FolderNotFoundException(this, this.fullName + " not found");
        }
    }

    private void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder");
        }
    }

    private void checkOpened() throws FolderClosedException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!this.opened) {
            if (this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            throw new FolderClosedException(this, "Lost folder connection to server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRange(int n) throws MessagingException {
        if (n < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (n <= this.total) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(false);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (n > this.total) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkFlags(Flags flags) throws MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.mode != 2) {
            throw new IllegalStateException("Cannot change flags on READ_ONLY folder: " + this.fullName);
        }
    }

    public synchronized String getName() {
        if (this.name == null) {
            try {
                this.name = this.fullName.substring(this.fullName.lastIndexOf(this.getSeparator()) + 1);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        return this.name;
    }

    public synchronized String getFullName() {
        return this.fullName;
    }

    public synchronized Folder getParent() throws MessagingException {
        char c = this.getSeparator();
        int n = this.fullName.lastIndexOf(c);
        if (n != -1) {
            return new IMAPFolder(this.fullName.substring(0, n), c, (IMAPStore)this.store);
        }
        return new DefaultFolder((IMAPStore)this.store);
    }

    public synchronized boolean exists() throws MessagingException {
        ListInfo[] listInfoArray = null;
        final String string = this.isNamespace && this.separator != '\u0000' ? this.fullName + this.separator : this.fullName;
        listInfoArray = (ListInfo[])this.doCommand(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                return iMAPProtocol.list("", string);
            }
        });
        if (listInfoArray != null) {
            int n = this.findName(listInfoArray, string);
            this.fullName = listInfoArray[n].name;
            this.separator = listInfoArray[n].separator;
            int n2 = this.fullName.length();
            if (this.separator != '\u0000' && n2 > 0 && this.fullName.charAt(n2 - 1) == this.separator) {
                this.fullName = this.fullName.substring(0, n2 - 1);
            }
            this.type = 0;
            if (listInfoArray[n].hasInferiors) {
                this.type |= 2;
            }
            if (listInfoArray[n].canOpen) {
                this.type |= 1;
            }
            this.exists = true;
            this.attributes = listInfoArray[n].attrs;
        } else {
            this.exists = this.opened;
            this.attributes = null;
        }
        return this.exists;
    }

    private int findName(ListInfo[] listInfoArray, String string) {
        int n = 0;
        while (n < listInfoArray.length) {
            if (listInfoArray[n].name.equals(string)) break;
            ++n;
        }
        if (n >= listInfoArray.length) {
            n = 0;
        }
        return n;
    }

    public Folder[] list(String string) throws MessagingException {
        return this.doList(string, false);
    }

    public Folder[] listSubscribed(String string) throws MessagingException {
        return this.doList(string, true);
    }

    private synchronized Folder[] doList(final String string, final boolean bl) throws MessagingException {
        this.checkExists();
        if (!this.isDirectory()) {
            return new Folder[0];
        }
        final char c = this.getSeparator();
        ListInfo[] listInfoArray = (ListInfo[])this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                if (bl) {
                    return iMAPProtocol.lsub("", IMAPFolder.this.fullName + c + string);
                }
                return iMAPProtocol.list("", IMAPFolder.this.fullName + c + string);
            }
        });
        if (listInfoArray == null) {
            return new Folder[0];
        }
        int n = 0;
        if (listInfoArray.length > 0 && listInfoArray[0].name.equals(this.fullName + c)) {
            n = 1;
        }
        Folder[] folderArray = new IMAPFolder[listInfoArray.length - n];
        int n2 = n;
        while (n2 < listInfoArray.length) {
            folderArray[n2 - n] = new IMAPFolder(listInfoArray[n2], (IMAPStore)this.store);
            ++n2;
        }
        return folderArray;
    }

    public synchronized char getSeparator() throws MessagingException {
        if (this.separator == '\uffff') {
            ListInfo[] listInfoArray = null;
            listInfoArray = (ListInfo[])this.doCommand(new ProtocolCommand(){

                public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                    if (iMAPProtocol.isREV1()) {
                        return iMAPProtocol.list(IMAPFolder.this.fullName, "");
                    }
                    return iMAPProtocol.list("", IMAPFolder.this.fullName);
                }
            });
            this.separator = listInfoArray != null ? listInfoArray[0].separator : (char)47;
        }
        return this.separator;
    }

    public synchronized int getType() throws MessagingException {
        if (this.opened) {
            if (this.attributes == null) {
                this.exists();
            }
        } else {
            this.checkExists();
        }
        return this.type;
    }

    public synchronized boolean isSubscribed() {
        ListInfo[] listInfoArray = null;
        final String string = this.isNamespace && this.separator != '\u0000' ? this.fullName + this.separator : this.fullName;
        try {
            listInfoArray = (ListInfo[])this.doProtocolCommand(new ProtocolCommand(){

                public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                    return iMAPProtocol.lsub("", string);
                }
            });
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
        if (listInfoArray != null) {
            int n = this.findName(listInfoArray, string);
            return listInfoArray[n].canOpen;
        }
        return false;
    }

    public synchronized void setSubscribed(final boolean bl) throws MessagingException {
        this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                if (bl) {
                    iMAPProtocol.subscribe(IMAPFolder.this.fullName);
                } else {
                    iMAPProtocol.unsubscribe(IMAPFolder.this.fullName);
                }
                return null;
            }
        });
    }

    public synchronized boolean create(final int n) throws MessagingException {
        char c;
        Object object;
        char c2 = '\u0000';
        if ((n & 1) == 0) {
            c2 = this.getSeparator();
        }
        if ((object = this.doCommandIgnoreFailure(new ProtocolCommand(c = c2){
            private final /* synthetic */ char val$sep;
            {
                this.val$sep = c;
            }

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                if ((n & 1) == 0) {
                    iMAPProtocol.create(IMAPFolder.this.fullName + this.val$sep);
                } else {
                    ListInfo[] listInfoArray;
                    iMAPProtocol.create(IMAPFolder.this.fullName);
                    if ((n & 2) != 0 && (listInfoArray = iMAPProtocol.list("", IMAPFolder.this.fullName)) != null && !listInfoArray[0].hasInferiors) {
                        iMAPProtocol.delete(IMAPFolder.this.fullName);
                        throw new ProtocolException("Unsupported type");
                    }
                }
                return Boolean.TRUE;
            }
        })) == null) {
            return false;
        }
        boolean bl = this.exists();
        if (bl) {
            this.notifyFolderListeners(1);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasNewMessages() throws MessagingException {
        if (this.opened) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    this.keepConnectionAlive(true);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                boolean bl = this.recent > 0;
                return bl;
            }
        }
        ListInfo[] listInfoArray = null;
        final String string = this.isNamespace && this.separator != '\u0000' ? this.fullName + this.separator : this.fullName;
        listInfoArray = (ListInfo[])this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                return iMAPProtocol.list("", string);
            }
        });
        if (listInfoArray == null) {
            throw new FolderNotFoundException(this, this.fullName + " not found");
        }
        int n = this.findName(listInfoArray, string);
        if (listInfoArray[n].changeState == 1) {
            return true;
        }
        if (listInfoArray[n].changeState == 2) {
            return false;
        }
        try {
            Status status = this.getStatus();
            return status.recent > 0;
        }
        catch (BadCommandException badCommandException) {
            return false;
        }
        catch (ConnectionException connectionException) {
            throw new StoreClosedException(this.store, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    public Folder getFolder(String string) throws MessagingException {
        if (this.attributes != null && !this.isDirectory()) {
            throw new MessagingException("Cannot contain subfolders");
        }
        char c = this.getSeparator();
        return new IMAPFolder(this.fullName + c + string, c, (IMAPStore)this.store);
    }

    public synchronized boolean delete(boolean bl) throws MessagingException {
        Object object;
        this.checkClosed();
        if (bl) {
            object = this.list();
            int n = 0;
            while (n < ((Folder[])object).length) {
                object[n].delete(bl);
                ++n;
            }
        }
        if ((object = this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                iMAPProtocol.delete(IMAPFolder.this.fullName);
                return Boolean.TRUE;
            }
        })) == null) {
            return false;
        }
        this.exists = false;
        this.attributes = null;
        this.notifyFolderListeners(2);
        return true;
    }

    public synchronized boolean renameTo(final Folder folder) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if (folder.getStore() != this.store) {
            throw new MessagingException("Can't rename across Stores");
        }
        Object object = this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                iMAPProtocol.rename(IMAPFolder.this.fullName, folder.getFullName());
                return Boolean.TRUE;
            }
        });
        if (object == null) {
            return false;
        }
        this.exists = false;
        this.attributes = null;
        this.notifyFolderRenamedListeners(folder);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void open(int n) throws MessagingException {
        CommandFailedException commandFailedException;
        block22: {
            this.checkClosed();
            MailboxInfo mailboxInfo = null;
            this.protocol = ((IMAPStore)this.store).getProtocol(this);
            commandFailedException = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                this.protocol.addResponseHandler(this);
                try {
                    mailboxInfo = n == 1 ? this.protocol.examine(this.fullName) : this.protocol.select(this.fullName);
                }
                catch (CommandFailedException commandFailedException2) {
                    this.releaseProtocol(true);
                    this.protocol = null;
                    commandFailedException = commandFailedException2;
                    break block22;
                }
                catch (ProtocolException protocolException) {
                    try {
                        try {
                            this.protocol.logout();
                        }
                        catch (ProtocolException protocolException2) {
                            Object var9_11 = null;
                            this.releaseProtocol(false);
                            this.protocol = null;
                            throw new MessagingException(protocolException.getMessage(), protocolException);
                        }
                        Object var9_10 = null;
                        this.releaseProtocol(false);
                        this.protocol = null;
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        this.releaseProtocol(false);
                        this.protocol = null;
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                if (!(mailboxInfo.mode == n || n == 2 && mailboxInfo.mode == 1 && ((IMAPStore)this.store).allowReadOnlySelect())) {
                    try {
                        try {
                            this.protocol.close();
                            this.releaseProtocol(true);
                        }
                        catch (ProtocolException protocolException) {
                            block23: {
                                try {
                                    try {
                                        this.protocol.logout();
                                    }
                                    catch (ProtocolException protocolException3) {
                                        Object var11_19 = null;
                                        this.releaseProtocol(false);
                                        break block23;
                                    }
                                    Object var11_18 = null;
                                    this.releaseProtocol(false);
                                }
                                catch (Throwable throwable) {
                                    Object var11_20 = null;
                                    this.releaseProtocol(false);
                                    throw throwable;
                                }
                            }
                            Object var13_16 = null;
                            this.protocol = null;
                            throw new ReadOnlyFolderException(this, "Cannot open in desired mode");
                        }
                        Object var13_15 = null;
                        this.protocol = null;
                        throw new ReadOnlyFolderException(this, "Cannot open in desired mode");
                    }
                    catch (Throwable throwable) {
                        Object var13_17 = null;
                        this.protocol = null;
                        throw new ReadOnlyFolderException(this, "Cannot open in desired mode");
                    }
                }
                this.opened = true;
                this.reallyClosed = false;
                this.mode = mailboxInfo.mode;
                this.availableFlags = mailboxInfo.availableFlags;
                this.permanentFlags = mailboxInfo.permanentFlags;
                this.total = this.realTotal = mailboxInfo.total;
                this.recent = mailboxInfo.recent;
                this.uidvalidity = mailboxInfo.uidvalidity;
                this.uidnext = mailboxInfo.uidnext;
                this.messageCache = new Vector(this.total);
                int n2 = 0;
                while (n2 < this.total) {
                    this.messageCache.addElement(new IMAPMessage(this, n2 + 1, n2 + 1));
                    ++n2;
                }
            }
        }
        if (commandFailedException == null) {
            this.exists = true;
            this.attributes = null;
            this.type = 1;
            this.notifyConnectionListeners(1);
            return;
        }
        this.checkExists();
        if ((this.type & 1) != 0) throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
        throw new MessagingException("folder cannot contain messages");
    }

    public synchronized void fetch(Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
        this.checkOpened();
        IMAPMessage.fetch(this, messageArray, fetchProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFlags(Message[] messageArray, Flags flags, boolean bl) throws MessagingException {
        this.checkOpened();
        this.checkFlags(flags);
        if (messageArray.length == 0) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                MessageSet[] messageSetArray = Utility.toMessageSet(messageArray, null);
                if (messageSetArray == null) {
                    throw new MessageRemovedException("Messages have been removed");
                }
                iMAPProtocol.storeFlags(messageSetArray, flags, bl);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    public synchronized void close(boolean bl) throws MessagingException {
        this.close(bl, false);
    }

    public synchronized void forceClose() throws MessagingException {
        this.close(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean bl, boolean bl2) throws MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            if (!this.opened && this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            this.reallyClosed = true;
            if (!this.opened) {
                return;
            }
            try {
                block22: {
                    try {
                        block23: {
                            this.waitIfIdle();
                            if (bl2) {
                                if (this.debug) {
                                    this.out.println("DEBUG: forcing folder " + this.fullName + " to close");
                                }
                                if (this.protocol != null) {
                                    this.protocol.disconnect();
                                }
                                break block22;
                            }
                            if (((IMAPStore)this.store).isConnectionPoolFull()) {
                                if (this.debug) {
                                    this.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                                }
                                if (bl) {
                                    this.protocol.close();
                                }
                                if (this.protocol != null) {
                                    this.protocol.logout();
                                }
                                break block22;
                            }
                            if (!bl && this.mode == 2) {
                                try {
                                    MailboxInfo mailboxInfo = this.protocol.examine(this.fullName);
                                }
                                catch (ProtocolException protocolException) {
                                    if (this.protocol == null) break block23;
                                    this.protocol.disconnect();
                                }
                            }
                        }
                        if (this.protocol == null) break block22;
                        this.protocol.close();
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                Object var6_7 = null;
                if (this.opened) {
                    this.cleanup(true);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (this.opened) {
                    this.cleanup(true);
                }
                throw throwable;
            }
        }
    }

    private void cleanup(boolean bl) {
        this.releaseProtocol(bl);
        this.protocol = null;
        this.messageCache = null;
        this.uidTable = null;
        this.exists = false;
        this.attributes = null;
        this.opened = false;
        this.idleState = 0;
        this.notifyConnectionListeners(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isOpen() {
        Object object = this.messageCacheLock;
        synchronized (object) {
            if (this.opened) {
                try {
                    this.keepConnectionAlive(false);
                }
                catch (ProtocolException protocolException) {
                    // empty catch block
                }
            }
        }
        return this.opened;
    }

    public synchronized Flags getPermanentFlags() {
        return (Flags)this.permanentFlags.clone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getMessageCount() throws MessagingException {
        if (!this.opened) {
            this.checkExists();
            try {
                Status status = this.getStatus();
                return status.total;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    try {
                        iMAPProtocol = this.getStoreProtocol();
                        MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                        iMAPProtocol.close();
                        int n = mailboxInfo.total;
                        Object var6_13 = null;
                        this.releaseStoreProtocol(iMAPProtocol);
                        return n;
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_14 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    throw throwable;
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.total;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getNewMessageCount() throws MessagingException {
        if (!this.opened) {
            this.checkExists();
            try {
                Status status = this.getStatus();
                return status.recent;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    try {
                        iMAPProtocol = this.getStoreProtocol();
                        MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                        iMAPProtocol.close();
                        int n = mailboxInfo.recent;
                        Object var6_13 = null;
                        this.releaseStoreProtocol(iMAPProtocol);
                        return n;
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_14 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    throw throwable;
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.recent;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getUnreadMessageCount() throws MessagingException {
        if (!this.opened) {
            this.checkExists();
            try {
                Status status = this.getStatus();
                return status.unseen;
            }
            catch (BadCommandException badCommandException) {
                return -1;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.getProtocol().search(new FlagTerm(flags, false));
                int n = nArray.length;
                return n;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getDeletedMessageCount() throws MessagingException {
        if (!this.opened) {
            this.checkExists();
            return -1;
        }
        Flags flags = new Flags();
        flags.add(Flags.Flag.DELETED);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.getProtocol().search(new FlagTerm(flags, true));
                int n = nArray.length;
                return n;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status getStatus() throws ProtocolException {
        int n = ((IMAPStore)this.store).getStatusCacheTimeout();
        if (n > 0 && this.cachedStatus != null && System.currentTimeMillis() - this.cachedStatusTime < (long)n) {
            return this.cachedStatus;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            iMAPProtocol = this.getStoreProtocol();
            Status status = iMAPProtocol.status(this.fullName, null);
            if (n > 0) {
                this.cachedStatus = status;
                this.cachedStatusTime = System.currentTimeMillis();
            }
            Status status2 = status;
            Object var6_5 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            return status2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public synchronized Message getMessage(int n) throws MessagingException {
        this.checkOpened();
        this.checkRange(n);
        return (Message)this.messageCache.elementAt(n - 1);
    }

    public synchronized void appendMessages(Message[] messageArray) throws MessagingException {
        this.checkExists();
        int n = ((IMAPStore)this.store).getAppendBufferSize();
        int n2 = 0;
        while (n2 < messageArray.length) {
            block5: {
                MessageLiteral messageLiteral;
                Message message = messageArray[n2];
                try {
                    messageLiteral = new MessageLiteral(message, message.getSize() > n ? 0 : n);
                }
                catch (IOException iOException) {
                    throw new MessagingException("IOException while appending messages", iOException);
                }
                catch (MessageRemovedException messageRemovedException) {
                    break block5;
                }
                Date date = message.getReceivedDate();
                if (date == null) {
                    date = message.getSentDate();
                }
                final Date date2 = date;
                final Flags flags = message.getFlags();
                this.doCommand(new ProtocolCommand(){

                    public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                        iMAPProtocol.append(IMAPFolder.this.fullName, flags, date2, messageLiteral);
                        return null;
                    }
                });
            }
            ++n2;
        }
    }

    public synchronized AppendUID[] appendUIDMessages(Message[] messageArray) throws MessagingException {
        this.checkExists();
        int n = ((IMAPStore)this.store).getAppendBufferSize();
        AppendUID[] appendUIDArray = new AppendUID[messageArray.length];
        int n2 = 0;
        while (n2 < messageArray.length) {
            block5: {
                AppendUID appendUID;
                MessageLiteral messageLiteral;
                Message message = messageArray[n2];
                try {
                    messageLiteral = new MessageLiteral(message, message.getSize() > n ? 0 : n);
                }
                catch (IOException iOException) {
                    throw new MessagingException("IOException while appending messages", iOException);
                }
                catch (MessageRemovedException messageRemovedException) {
                    break block5;
                }
                Date date = message.getReceivedDate();
                if (date == null) {
                    date = message.getSentDate();
                }
                final Date date2 = date;
                final Flags flags = message.getFlags();
                appendUIDArray[n2] = appendUID = (AppendUID)this.doCommand(new ProtocolCommand(){

                    public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                        return iMAPProtocol.appenduid(IMAPFolder.this.fullName, flags, date2, messageLiteral);
                    }
                });
            }
            ++n2;
        }
        return appendUIDArray;
    }

    public synchronized Message[] addMessages(Message[] messageArray) throws MessagingException {
        this.checkOpened();
        Message[] messageArray2 = new MimeMessage[messageArray.length];
        AppendUID[] appendUIDArray = this.appendUIDMessages(messageArray);
        int n = 0;
        while (n < appendUIDArray.length) {
            AppendUID appendUID = appendUIDArray[n];
            if (appendUID != null && appendUID.uidvalidity == this.uidvalidity) {
                try {
                    messageArray2[n] = this.getMessageByUID(appendUID.uid);
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
            }
            ++n;
        }
        return messageArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyMessages(Message[] messageArray, Folder folder) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return;
        }
        if (folder.getStore() == this.store) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    IMAPProtocol iMAPProtocol = this.getProtocol();
                    MessageSet[] messageSetArray = Utility.toMessageSet(messageArray, null);
                    if (messageSetArray == null) {
                        throw new MessageRemovedException("Messages have been removed");
                    }
                    iMAPProtocol.copy(messageSetArray, folder.getFullName());
                }
                catch (CommandFailedException commandFailedException) {
                    if (commandFailedException.getMessage().indexOf("TRYCREATE") != -1) {
                        throw new FolderNotFoundException(folder, folder.getFullName() + " does not exist");
                    }
                    throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
        }
        super.copyMessages(messageArray, folder);
    }

    public synchronized Message[] expunge() throws MessagingException {
        return this.expunge(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] expunge(Message[] messageArray) throws MessagingException {
        Object object;
        this.checkOpened();
        Vector<IMAPMessage> vector = new Vector<IMAPMessage>();
        if (messageArray != null) {
            object = new FetchProfile();
            ((FetchProfile)object).add(UIDFolder.FetchProfileItem.UID);
            this.fetch(messageArray, (FetchProfile)object);
        }
        object = this.messageCacheLock;
        synchronized (object) {
            this.doExpungeNotification = false;
            try {
                block15: {
                    try {
                        IMAPProtocol iMAPProtocol = this.getProtocol();
                        if (messageArray != null) {
                            iMAPProtocol.uidexpunge(Utility.toUIDSet(messageArray));
                            break block15;
                        }
                        iMAPProtocol.expunge();
                    }
                    catch (CommandFailedException commandFailedException) {
                        if (this.mode != 2) {
                            throw new IllegalStateException("Cannot expunge READ_ONLY folder: " + this.fullName);
                        }
                        throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
                    }
                    catch (ConnectionException connectionException) {
                        throw new FolderClosedException(this, connectionException.getMessage());
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                Object var8_8 = null;
                this.doExpungeNotification = true;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.doExpungeNotification = true;
                throw throwable;
            }
            int n = 0;
            while (n < this.messageCache.size()) {
                IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(n);
                if (iMAPMessage.isExpunged()) {
                    long l;
                    vector.addElement(iMAPMessage);
                    this.messageCache.removeElementAt(n);
                    if (this.uidTable == null || (l = iMAPMessage.getUID()) == -1L) continue;
                    this.uidTable.remove(new Long(l));
                    continue;
                }
                iMAPMessage.setMessageNumber(iMAPMessage.getSequenceNumber());
                ++n;
            }
        }
        this.total = this.messageCache.size();
        Object[] objectArray = new Message[vector.size()];
        vector.copyInto(objectArray);
        if (objectArray.length > 0) {
            this.notifyMessageRemovedListeners(true, (Message[])objectArray);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm searchTerm) throws MessagingException {
        this.checkOpened();
        try {
            Message[] messageArray = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.getProtocol().search(searchTerm);
                if (nArray != null) {
                    messageArray = new IMAPMessage[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        messageArray[n] = this.getMessageBySeqNumber(nArray[n]);
                        ++n;
                    }
                }
            }
            return messageArray;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm searchTerm, Message[] messageArray) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return messageArray;
        }
        try {
            Message[] messageArray2 = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                MessageSet[] messageSetArray = Utility.toMessageSet(messageArray, null);
                if (messageSetArray == null) {
                    throw new MessageRemovedException("Messages have been removed");
                }
                int[] nArray = iMAPProtocol.search(messageSetArray, searchTerm);
                if (nArray != null) {
                    messageArray2 = new IMAPMessage[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        messageArray2[n] = this.getMessageBySeqNumber(nArray[n]);
                        ++n;
                    }
                }
            }
            return messageArray2;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm, messageArray);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm, messageArray);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    public synchronized long getUIDValidity() throws MessagingException {
        Status status;
        block7: {
            if (this.opened) {
                return this.uidvalidity;
            }
            IMAPProtocol iMAPProtocol = null;
            status = null;
            try {
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    String[] stringArray = new String[]{"UIDVALIDITY"};
                    status = iMAPProtocol.status(this.fullName, stringArray);
                }
                catch (BadCommandException badCommandException) {
                    throw new MessagingException("Cannot obtain UIDValidity", badCommandException);
                }
                catch (ConnectionException connectionException) {
                    this.throwClosedException(connectionException);
                    Object var7_6 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    break block7;
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                Object var7_5 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
        }
        return status.uidvalidity;
    }

    public synchronized long getUIDNext() throws MessagingException {
        Status status;
        block7: {
            if (this.opened) {
                return this.uidnext;
            }
            IMAPProtocol iMAPProtocol = null;
            status = null;
            try {
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    String[] stringArray = new String[]{"UIDNEXT"};
                    status = iMAPProtocol.status(this.fullName, stringArray);
                }
                catch (BadCommandException badCommandException) {
                    throw new MessagingException("Cannot obtain UIDNext", badCommandException);
                }
                catch (ConnectionException connectionException) {
                    this.throwClosedException(connectionException);
                    Object var7_6 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    break block7;
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                Object var7_5 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
        }
        return status.uidnext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Message getMessageByUID(long l) throws MessagingException {
        this.checkOpened();
        IMAPMessage iMAPMessage = null;
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID uID;
                Long l2 = new Long(l);
                if (this.uidTable != null) {
                    iMAPMessage = (IMAPMessage)this.uidTable.get(l2);
                    if (iMAPMessage != null) {
                        return iMAPMessage;
                    }
                } else {
                    this.uidTable = new Hashtable();
                }
                if ((uID = this.getProtocol().fetchSequenceNumber(l)) == null) return iMAPMessage;
                if (uID.seqnum > this.total) return iMAPMessage;
                iMAPMessage = this.getMessageBySeqNumber(uID.seqnum);
                iMAPMessage.setUID(uID.uid);
                this.uidTable.put(l2, iMAPMessage);
                return iMAPMessage;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long l, long l2) throws MessagingException {
        Message[] messageArray;
        this.checkOpened();
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                if (this.uidTable == null) {
                    this.uidTable = new Hashtable();
                }
                UID[] uIDArray = this.getProtocol().fetchSequenceNumbers(l, l2);
                messageArray = new Message[uIDArray.length];
                int n = 0;
                while (n < uIDArray.length) {
                    IMAPMessage iMAPMessage = this.getMessageBySeqNumber(uIDArray[n].seqnum);
                    iMAPMessage.setUID(uIDArray[n].uid);
                    messageArray[n] = iMAPMessage;
                    this.uidTable.put(new Long(uIDArray[n].uid), iMAPMessage);
                    ++n;
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return messageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long[] lArray) throws MessagingException {
        this.checkOpened();
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                Object object2;
                int n;
                Object[] objectArray;
                long[] lArray2 = lArray;
                if (this.uidTable != null) {
                    objectArray = new Vector();
                    n = 0;
                    while (n < lArray.length) {
                        object2 = new Long(lArray[n]);
                        if (!this.uidTable.containsKey(object2)) {
                            objectArray.addElement(object2);
                        }
                        ++n;
                    }
                    int n2 = objectArray.size();
                    lArray2 = new long[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        lArray2[n3] = (Long)objectArray.elementAt(n3);
                        ++n3;
                    }
                } else {
                    this.uidTable = new Hashtable();
                }
                if (lArray2.length > 0) {
                    objectArray = this.getProtocol().fetchSequenceNumbers(lArray2);
                    n = 0;
                    while (n < objectArray.length) {
                        object2 = this.getMessageBySeqNumber(((UID)objectArray[n]).seqnum);
                        ((IMAPMessage)object2).setUID(((UID)objectArray[n]).uid);
                        this.uidTable.put(new Long(((UID)objectArray[n]).uid), object2);
                        ++n;
                    }
                }
                objectArray = new Message[lArray.length];
                int n4 = 0;
                while (n4 < lArray.length) {
                    objectArray[n4] = (Message)this.uidTable.get(new Long(lArray[n4]));
                    ++n4;
                }
                Object[] objectArray2 = objectArray;
                return objectArray2;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getUID(Message message) throws MessagingException {
        if (message.getFolder() != this) {
            throw new NoSuchElementException("Message does not belong to this folder");
        }
        this.checkOpened();
        IMAPMessage iMAPMessage = (IMAPMessage)message;
        long l = iMAPMessage.getUID();
        if (l != -1L) {
            return l;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                iMAPMessage.checkExpunged();
                UID uID = iMAPProtocol.fetchUID(iMAPMessage.getSequenceNumber());
                if (uID != null) {
                    l = uID.uid;
                    iMAPMessage.setUID(l);
                    if (this.uidTable == null) {
                        this.uidTable = new Hashtable();
                    }
                    this.uidTable.put(new Long(l), iMAPMessage);
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        return l;
    }

    public Quota[] getQuota() throws MessagingException {
        return (Quota[])this.doOptionalCommand("QUOTA not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                return iMAPProtocol.getQuotaRoot(IMAPFolder.this.fullName);
            }
        });
    }

    public void setQuota(final Quota quota) throws MessagingException {
        this.doOptionalCommand("QUOTA not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                iMAPProtocol.setQuota(quota);
                return null;
            }
        });
    }

    public ACL[] getACL() throws MessagingException {
        return (ACL[])this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                return iMAPProtocol.getACL(IMAPFolder.this.fullName);
            }
        });
    }

    public void addACL(ACL aCL) throws MessagingException {
        this.setACL(aCL, '\u0000');
    }

    public void removeACL(final String string) throws MessagingException {
        this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                iMAPProtocol.deleteACL(IMAPFolder.this.fullName, string);
                return null;
            }
        });
    }

    public void addRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '+');
    }

    public void removeRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '-');
    }

    public Rights[] listRights(final String string) throws MessagingException {
        return (Rights[])this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                return iMAPProtocol.listRights(IMAPFolder.this.fullName, string);
            }
        });
    }

    public Rights myRights() throws MessagingException {
        return (Rights)this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                return iMAPProtocol.myRights(IMAPFolder.this.fullName);
            }
        });
    }

    private void setACL(final ACL aCL, final char c) throws MessagingException {
        this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                iMAPProtocol.setACL(IMAPFolder.this.fullName, c, aCL);
                return null;
            }
        });
    }

    public String[] getAttributes() throws MessagingException {
        if (this.attributes == null) {
            this.exists();
        }
        return (String[])this.attributes.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void idle() throws MessagingException {
        Object object;
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        IMAPFolder iMAPFolder = this;
        synchronized (iMAPFolder) {
            this.checkOpened();
            object = (Boolean)this.doOptionalCommand("IDLE not supported", new ProtocolCommand(){

                public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                    if (IMAPFolder.this.idleState == 0) {
                        iMAPProtocol.idleStart();
                        IMAPFolder.this.idleState = 1;
                        return Boolean.TRUE;
                    }
                    try {
                        IMAPFolder.this.messageCacheLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return Boolean.FALSE;
                }
            });
            if (!((Boolean)object).booleanValue()) {
                return;
            }
        }
        while (true) {
            object = this.protocol.readIdleResponse();
            try {
                Object object2 = this.messageCacheLock;
                synchronized (object2) {
                    if (object == null || this.protocol == null || !this.protocol.processIdleResponse((Response)object)) {
                        this.idleState = 0;
                        this.messageCacheLock.notifyAll();
                        break;
                    }
                    continue;
                }
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(connectionException);
                continue;
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            break;
        }
        int n = ((IMAPStore)this.store).getMinIdleTime();
        if (n > 0) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void waitIfIdle() throws ProtocolException {
        if (IMAPFolder.$assertionsDisabled || Thread.holdsLock(this.messageCacheLock)) ** GOTO lbl11
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            if (this.idleState == 1) {
                this.protocol.idleAbort();
                this.idleState = 2;
            }
            try {
                this.messageCacheLock.wait();
                continue;
            }
            catch (InterruptedException var1_1) {
                // empty catch block
            }
lbl11:
            // 3 sources

            ** while (this.idleState != 0)
        }
lbl12:
        // 1 sources

    }

    public void handleResponse(Response response) {
        if (!$assertionsDisabled && !Thread.holdsLock(this.messageCacheLock)) {
            throw new AssertionError();
        }
        if (response.isOK() || response.isNO() || response.isBAD() || response.isBYE()) {
            ((IMAPStore)this.store).handleResponseCode(response);
        }
        if (response.isBYE()) {
            if (this.opened) {
                this.cleanup(false);
            }
            return;
        }
        if (response.isOK()) {
            return;
        }
        if (!response.isUnTagged()) {
            return;
        }
        if (!(response instanceof IMAPResponse)) {
            this.out.println("UNEXPECTED RESPONSE : " + response.toString());
            this.out.println("CONTACT javamail@sun.com");
            return;
        }
        IMAPResponse iMAPResponse = (IMAPResponse)response;
        if (iMAPResponse.keyEquals("EXISTS")) {
            int n = iMAPResponse.getNumber();
            if (n <= this.realTotal) {
                return;
            }
            int n2 = n - this.realTotal;
            Message[] messageArray = new Message[n2];
            int n3 = 0;
            while (n3 < n2) {
                IMAPMessage iMAPMessage = new IMAPMessage(this, ++this.total, ++this.realTotal);
                messageArray[n3] = iMAPMessage;
                this.messageCache.addElement(iMAPMessage);
                ++n3;
            }
            this.notifyMessageAddedListeners(messageArray);
        } else if (iMAPResponse.keyEquals("EXPUNGE")) {
            Message[] messageArray;
            IMAPMessage iMAPMessage = this.getMessageBySeqNumber(iMAPResponse.getNumber());
            iMAPMessage.setExpunged(true);
            int n = iMAPMessage.getMessageNumber();
            while (n < this.total) {
                messageArray = (Message[])this.messageCache.elementAt(n);
                if (!messageArray.isExpunged()) {
                    messageArray.setSequenceNumber(messageArray.getSequenceNumber() - 1);
                }
                ++n;
            }
            --this.realTotal;
            if (this.doExpungeNotification) {
                messageArray = new Message[]{iMAPMessage};
                this.notifyMessageRemovedListeners(false, messageArray);
            }
        } else if (iMAPResponse.keyEquals("FETCH")) {
            IMAPMessage iMAPMessage;
            if (!$assertionsDisabled && !(iMAPResponse instanceof FetchResponse)) {
                throw new AssertionError((Object)"!ir instanceof FetchResponse");
            }
            FetchResponse fetchResponse = (FetchResponse)iMAPResponse;
            Flags flags = (Flags)((Object)fetchResponse.getItem(class$javax$mail$Flags == null ? (class$javax$mail$Flags = IMAPFolder.class$("javax.mail.Flags")) : class$javax$mail$Flags));
            if (flags != null && (iMAPMessage = this.getMessageBySeqNumber(fetchResponse.getNumber())) != null) {
                iMAPMessage._setFlags(flags);
                this.notifyMessageChangedListeners(1, iMAPMessage);
            }
        } else if (iMAPResponse.keyEquals("RECENT")) {
            this.recent = iMAPResponse.getNumber();
        }
    }

    void handleResponses(Response[] responseArray) {
        int n = 0;
        while (n < responseArray.length) {
            if (responseArray[n] != null) {
                this.handleResponse(responseArray[n]);
            }
            ++n;
        }
    }

    protected synchronized IMAPProtocol getStoreProtocol() throws ProtocolException {
        if (this.connectionPoolDebug) {
            this.out.println("DEBUG: getStoreProtocol() - borrowing a connection");
        }
        return ((IMAPStore)this.store).getStoreProtocol();
    }

    private synchronized void throwClosedException(ConnectionException connectionException) throws FolderClosedException, StoreClosedException {
        if (this.protocol != null && connectionException.getProtocol() == this.protocol || this.protocol == null && !this.reallyClosed) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        throw new StoreClosedException(this.store, connectionException.getMessage());
    }

    private IMAPProtocol getProtocol() throws ProtocolException {
        if (!$assertionsDisabled && !Thread.holdsLock(this.messageCacheLock)) {
            throw new AssertionError();
        }
        this.waitIfIdle();
        return this.protocol;
    }

    public Object doCommand(ProtocolCommand protocolCommand) throws MessagingException {
        try {
            return this.doProtocolCommand(protocolCommand);
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return null;
    }

    public Object doOptionalCommand(String string, ProtocolCommand protocolCommand) throws MessagingException {
        try {
            return this.doProtocolCommand(protocolCommand);
        }
        catch (BadCommandException badCommandException) {
            throw new MessagingException(string, badCommandException);
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return null;
    }

    public Object doCommandIgnoreFailure(ProtocolCommand protocolCommand) throws MessagingException {
        try {
            return this.doProtocolCommand(protocolCommand);
        }
        catch (CommandFailedException commandFailedException) {
            return null;
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doProtocolCommand(ProtocolCommand protocolCommand) throws ProtocolException {
        IMAPFolder iMAPFolder = this;
        synchronized (iMAPFolder) {
            if (this.opened && !((IMAPStore)this.store).hasSeparateStoreConnection()) {
                Object object = this.messageCacheLock;
                synchronized (object) {
                    Object object2 = protocolCommand.doCommand(this.getProtocol());
                    return object2;
                }
            }
            IMAPProtocol iMAPProtocol = null;
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = protocolCommand.doCommand(iMAPProtocol);
                Object var8_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                return object;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
        }
    }

    protected synchronized void releaseStoreProtocol(IMAPProtocol iMAPProtocol) {
        if (iMAPProtocol != this.protocol) {
            ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
        }
    }

    private void releaseProtocol(boolean bl) {
        if (this.protocol != null) {
            this.protocol.removeResponseHandler(this);
            if (bl) {
                ((IMAPStore)this.store).releaseProtocol(this, this.protocol);
            } else {
                ((IMAPStore)this.store).releaseProtocol(this, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepConnectionAlive(boolean bl) throws ProtocolException {
        if (System.currentTimeMillis() - this.protocol.getTimestamp() > 1000L) {
            this.waitIfIdle();
            this.protocol.noop();
        }
        if (bl && ((IMAPStore)this.store).hasSeparateStoreConnection()) {
            IMAPProtocol iMAPProtocol = null;
            try {
                iMAPProtocol = ((IMAPStore)this.store).getStoreProtocol();
                if (System.currentTimeMillis() - iMAPProtocol.getTimestamp() > 1000L) {
                    iMAPProtocol.noop();
                }
                Object var4_3 = null;
                ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
        }
    }

    IMAPMessage getMessageBySeqNumber(int n) {
        int n2 = n - 1;
        while (n2 < this.total) {
            IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(n2);
            if (iMAPMessage.getSequenceNumber() == n) {
                return iMAPMessage;
            }
            ++n2;
        }
        return null;
    }

    private boolean isDirectory() {
        return (this.type & 2) != 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$mail$imap$IMAPFolder == null ? (class$com$sun$mail$imap$IMAPFolder = IMAPFolder.class$("com.sun.mail.imap.IMAPFolder")) : class$com$sun$mail$imap$IMAPFolder).desiredAssertionStatus();
    }

    public static interface ProtocolCommand {
        public Object doCommand(IMAPProtocol var1) throws ProtocolException;
    }

    public static class FetchProfileItem
    extends FetchProfile.Item {
        public static final FetchProfileItem HEADERS = new FetchProfileItem("HEADERS");
        public static final FetchProfileItem SIZE = new FetchProfileItem("SIZE");

        protected FetchProfileItem(String string) {
            super(string);
        }
    }
}

