"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var serviceManager_1 = require("../serviceManager");
var Debug = require("debug");
var Action = (function () {
    function Action() {
    }
    return Action;
}());
exports.Action = Action;
var ActionService = (function () {
    function ActionService() {
        this.timer = undefined;
        this.transport = undefined;
        this.actions = new Map();
        this.logger = Debug('axm:services:actions');
    }
    ActionService.prototype.listener = function (data) {
        var _this = this;
        this.logger("Received new message from reverse");
        if (!data)
            return false;
        var actionName = data.msg ? data.msg : data.action_name ? data.action_name : data;
        var action = this.actions.get(actionName);
        if (typeof action !== 'object') {
            return this.logger("Received action " + actionName + " but failed to find the implementation");
        }
        if (!action.isScoped) {
            this.logger("Succesfully called custom action " + action.name + " with arity " + action.handler.length);
            if (action.handler.length === 2) {
                var params = {};
                if (typeof data === 'object') {
                    params = data.opts;
                }
                return action.handler(params, action.callback);
            }
            return action.handler(action.callback);
        }
        if (data.uuid === undefined) {
            return this.logger("Received scoped action " + action.name + " but without uuid");
        }
        var stream = {
            send: function (dt) {
                _this.transport.send('axm:scoped_action:stream', {
                    data: dt,
                    uuid: data.uuid,
                    action_name: actionName
                });
            },
            error: function (dt) {
                _this.transport.send('axm:scoped_action:error', {
                    data: dt,
                    uuid: data.uuid,
                    action_name: actionName
                });
            },
            end: function (dt) {
                _this.transport.send('axm:scoped_action:end', {
                    data: dt,
                    uuid: data.uuid,
                    action_name: actionName
                });
            }
        };
        this.logger("Succesfully called scoped action " + action.name);
        return action.handler(data.opts || {}, stream);
    };
    ActionService.prototype.init = function () {
        this.transport = serviceManager_1.ServiceManager.get('transport');
        if (this.transport === undefined) {
            return this.logger("Failed to load transport service");
        }
        this.actions.clear();
        this.transport.on('data', this.listener.bind(this));
    };
    ActionService.prototype.destroy = function () {
        if (this.timer !== undefined) {
            clearInterval(this.timer);
        }
        if (this.transport !== undefined) {
            this.transport.removeListener('data', this.listener.bind(this));
        }
    };
    ActionService.prototype.registerAction = function (actionName, opts, handler) {
        var _this = this;
        if (typeof opts === 'function') {
            handler = opts;
            opts = undefined;
        }
        if (typeof actionName !== 'string') {
            console.error("You must define an name when registering an action");
            return;
        }
        if (typeof handler !== 'function') {
            console.error("You must define an callback when registering an action");
            return;
        }
        if (this.transport === undefined) {
            return this.logger("Failed to load transport service");
        }
        var type = 'custom';
        if (actionName.indexOf('km:') === 0 || actionName.indexOf('internal:') === 0) {
            type = 'internal';
        }
        var reply = function (data) {
            _this.transport.send('axm:reply', {
                at: new Date().getTime(),
                action_name: actionName,
                return: data
            });
        };
        var action = {
            name: actionName,
            callback: reply,
            handler: handler,
            type: type,
            isScoped: false,
            arity: handler.length,
            opts: opts
        };
        this.logger("Succesfully registered custom action " + action.name);
        this.actions.set(actionName, action);
        this.transport.addAction(action);
    };
    ActionService.prototype.scopedAction = function (actionName, handler) {
        if (typeof actionName !== 'string') {
            console.error("You must define an name when registering an action");
            return -1;
        }
        if (typeof handler !== 'function') {
            console.error("You must define an callback when registering an action");
            return -1;
        }
        if (this.transport === undefined) {
            return this.logger("Failed to load transport service");
        }
        var action = {
            name: actionName,
            handler: handler,
            type: 'scoped',
            isScoped: true,
            arity: handler.length,
            opts: null
        };
        this.logger("Succesfully registered scoped action " + action.name);
        this.actions.set(actionName, action);
        this.transport.addAction(action);
    };
    return ActionService;
}());
exports.ActionService = ActionService;
//# sourceMappingURL=data:application/json;base64,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