/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openide.util.NbBundle;

public final class Histogram<T extends Entry> {
    private HashMap<String, T> map = new HashMap();

    public static final Comparator<Entry> sortByCount() {
        return new Comparator<Entry>(){

            @Override
            public int compare(Entry entry, Entry entry2) {
                return entry2.count - entry.count;
            }
        };
    }

    public static final Comparator<Entry> sortBySize() {
        return new Comparator<Entry>(){

            @Override
            public int compare(Entry entry, Entry entry2) {
                return Long.compare(entry2.size, entry.size);
            }
        };
    }

    public SortedMap<String, T> getResults(final Comparator<Entry> comparator) {
        TreeMap<String, T> treeMap = new TreeMap<String, T>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                Entry entry;
                Entry entry2 = (Entry)Histogram.this.map.get(string);
                int n = comparator.compare(entry2, entry = (Entry)Histogram.this.map.get(string2));
                if (n == 0) {
                    n = string.compareTo(string2);
                }
                return n;
            }
        });
        treeMap.putAll(this.map);
        return treeMap;
    }

    public void add(String string, T t) {
        Entry entry = (Entry)this.map.get(string);
        if (entry != null) {
            entry.doAdd((Entry)t);
        } else {
            this.map.put(string, t);
        }
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        long l = 0L;
        int n2 = 0;
        SortedMap<String, T> sortedMap = this.getResults(Histogram.sortBySize());
        for (Map.Entry<String, T> entry : sortedMap.entrySet()) {
            long l2 = ((Entry)entry.getValue()).getSize();
            if (l2 > (long)n) {
                stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue()).append("<br>");
            }
            l += l2;
            n2 += ((Entry)entry.getValue()).getCount();
        }
        stringBuilder.append(NbBundle.getMessage(Histogram.class, (String)"FMT_HistogramSum", (Object)n2, (Object)l));
        return stringBuilder.toString();
    }

    public static class Entry<T extends Entry> {
        private int count = 1;
        private long size;

        public Entry(long l) {
            this.size = l;
        }

        public final int getCount() {
            return this.count;
        }

        public final long getSize() {
            return this.size;
        }

        public String toString() {
            return "#:" + this.getCount() + "/" + this.getSize() + "B\n";
        }

        protected void add(T t) {
        }

        private void doAdd(T t) {
            this.count += ((Entry)t).count;
            this.size += ((Entry)t).size;
            this.add(t);
        }
    }
}

