/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.FieldsBrowserController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.ClassNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.ui.Bundle;
import org.netbeans.modules.profiler.heapwalk.ui.FieldTableCellRenderer;
import org.netbeans.modules.profiler.heapwalk.ui.FieldTreeCellRenderer;
import org.openide.util.Lookup;

public class FieldsBrowserControllerUI
extends JTitledPanel {
    private static Icon ICON_FIELDS = Icons.getIcon((String)"HeapWalkerIcons.Data");
    private static final String DATA = "Data";
    private static final String NO_DATA = "No data";
    private int columnCount;
    private CardLayout contents;
    private ExtendedTreeTableModel fieldsListTableModel;
    private FieldTreeCellRenderer treeCellRenderer = new FieldTreeCellRenderer(false);
    private FieldsBrowserController fieldsBrowserController;
    private FieldsListTreeTableModel realFieldsListTableModel;
    private JMenuItem showClassItem;
    private JMenuItem showInstanceItem;
    private JMenuItem showLoopOriginItem;
    private JMenuItem copyPathFromRootItem;
    private JMenuItem showSourceItem;
    private JPanel dataPanel;
    private JPanel noDataPanel;
    private JPopupMenu cornerPopup;
    private JPopupMenu tablePopup;
    private JTreeTable fieldsListTable;
    private String filterValue = "";
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private int[] columnWidths;
    private boolean internalCornerButtonClick = false;
    private boolean needsUpdate = true;
    private boolean sortingOrder = true;
    private int sortingColumn = 0;
    private boolean retainedSizeSupported;
    private List expandedPaths = null;
    private TreePath selectedPath = null;

    public FieldsBrowserControllerUI(FieldsBrowserController fieldsBrowserController) {
        super(fieldsBrowserController.getRootMode() == 0 ? Bundle.FieldsBrowserControllerUI_ViewTitleFields() : Bundle.FieldsBrowserControllerUI_ViewTitleStaticFields(), ICON_FIELDS, true);
        this.fieldsBrowserController = fieldsBrowserController;
        this.retainedSizeSupported = fieldsBrowserController.getInstancesControllerHandler().getHeapFragmentWalker().getRetainedSizesStatus() != -1;
        this.columnCount = this.retainedSizeSupported ? 6 : 5;
        this.realFieldsListTableModel = new FieldsListTreeTableModel();
        this.fieldsListTableModel = new ExtendedTreeTableModel((AbstractTreeTableModel)this.realFieldsListTableModel);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && FieldsBrowserControllerUI.this.isShowing() && FieldsBrowserControllerUI.this.needsUpdate) {
                    FieldsBrowserControllerUI.this.update();
                }
            }
        });
        this.initColumnsData();
        this.initData();
        this.initComponents();
        fieldsBrowserController.getInstancesControllerHandler().getHeapFragmentWalker().addStateListener(new HeapFragmentWalker.StateListener(){

            @Override
            public void stateChanged(HeapFragmentWalker.StateEvent stateEvent) {
                if (stateEvent.getRetainedSizesStatus() == 3 && stateEvent.isMasterChange()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FieldsBrowserControllerUI.this.fieldsListTableModel.setRealColumnVisibility(5, true);
                            FieldsBrowserControllerUI.this.fieldsListTable.createDefaultColumnsFromModel();
                            FieldsBrowserControllerUI.this.fieldsListTable.updateTreeTableHeader();
                            FieldsBrowserControllerUI.this.setColumnsData();
                        }
                    });
                }
            }
        });
    }

    public void refreshView() {
        if (this.fieldsListTable != null) {
            if (this.expandedPaths != null || this.selectedPath != null) {
                BrowserUtils.restoreState(this.fieldsListTable, this.expandedPaths, this.selectedPath);
                this.expandedPaths = null;
                this.selectedPath = null;
            } else {
                this.fieldsListTable.updateTreeTable();
            }
        }
    }

    public void selectNode(HeapWalkerNode heapWalkerNode) {
        this.fieldsListTable.selectNode((CCTNode)heapWalkerNode, true);
    }

    public List getExpandedPaths() {
        if (!this.showsData()) {
            return null;
        }
        return this.fieldsListTable.getExpandedPaths();
    }

    public TreePath getSelectedRow() {
        if (!this.showsData()) {
            return null;
        }
        return this.fieldsListTable.getTree().getSelectionPath();
    }

    public void restoreState(List list, TreePath treePath) {
        if (this.showsData()) {
            this.expandedPaths = list;
            this.selectedPath = treePath;
        } else {
            this.expandedPaths = null;
            this.selectedPath = null;
        }
    }

    private boolean showsData() {
        Object object = this.fieldsListTableModel.getRoot();
        return object != null && object != FieldsBrowserController.EMPTY_CLASS_NODE && object != FieldsBrowserController.EMPTY_INSTANCE_NODE;
    }

    public void update() {
        if (this.isShowing()) {
            this.initData();
            if (this.contents != null) {
                if (!this.showsData()) {
                    this.contents.show(this.getContentPanel(), NO_DATA);
                } else {
                    this.contents.show(this.getContentPanel(), DATA);
                }
                this.fieldsListTable.resetTreeCellOffsetX();
            }
            this.needsUpdate = false;
        } else {
            this.needsUpdate = true;
        }
    }

    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.realFieldsListTableModel.getColumnCount(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.realFieldsListTableModel.getColumnName(i));
            jCheckBoxMenuItem.setActionCommand(Integer.valueOf(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.fieldsListTable != null) {
                jCheckBoxMenuItem.setState(this.fieldsListTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.cornerPopup.add(jCheckBoxMenuItem);
        }
        this.cornerPopup.pack();
    }

    private void setColumnsData() {
        TableColumnModel tableColumnModel = this.fieldsListTable.getColumnModel();
        this.fieldsListTable.setTreeCellRenderer((EnhancedTreeCellRenderer)this.treeCellRenderer);
        for (int i = 0; i < this.fieldsListTableModel.getColumnCount(); ++i) {
            int n = this.fieldsListTableModel.getRealColumn(i);
            if (n == 0) continue;
            tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private void addMenuItemListener(final JCheckBoxMenuItem jCheckBoxMenuItem) {
        final boolean[] blArray = new boolean[1];
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (blArray[0]) {
                    return;
                }
                final int n = Integer.parseInt(actionEvent.getActionCommand());
                if (n == 5 && !FieldsBrowserControllerUI.this.fieldsListTableModel.isRealColumnVisible(n)) {
                    BrowserUtils.performTask(new Runnable(){

                        @Override
                        public void run() {
                            final int n2 = FieldsBrowserControllerUI.this.fieldsBrowserController.getInstancesControllerHandler().getHeapFragmentWalker().computeRetainedSizes(false, true);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (n2 != 3) {
                                        blArray[0] = true;
                                        jCheckBoxMenuItem.setSelected(!jCheckBoxMenuItem.isSelected());
                                        blArray[0] = false;
                                    } else {
                                        FieldsBrowserControllerUI.this.fieldsListTableModel.setRealColumnVisibility(n, !FieldsBrowserControllerUI.this.fieldsListTableModel.isRealColumnVisible(n));
                                        FieldsBrowserControllerUI.this.fieldsListTable.createDefaultColumnsFromModel();
                                        FieldsBrowserControllerUI.this.fieldsListTable.updateTreeTableHeader();
                                        FieldsBrowserControllerUI.this.setColumnsData();
                                    }
                                }
                            });
                        }
                    });
                } else {
                    FieldsBrowserControllerUI.this.fieldsListTableModel.setRealColumnVisibility(n, !FieldsBrowserControllerUI.this.fieldsListTableModel.isRealColumnVisible(n));
                    FieldsBrowserControllerUI.this.fieldsListTable.createDefaultColumnsFromModel();
                    FieldsBrowserControllerUI.this.fieldsListTable.updateTreeTableHeader();
                    FieldsBrowserControllerUI.this.setColumnsData();
                }
            }
        });
    }

    private JButton createHeaderPopupCornerButton(final JPopupMenu jPopupMenu) {
        final JButton jButton = new JButton(Icons.getIcon((String)"GeneralIcons.HideColumn"));
        jButton.setToolTipText(Bundle.FieldsBrowserControllerUI_ShowHideColumnsString());
        jButton.setDefaultCapable(false);
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 2));
        } else if (UIUtils.isWindowsXPLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 0, 1));
        } else if (UIUtils.isMetalLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 1));
        }
        jButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    FieldsBrowserControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (jPopupMenu.isVisible()) {
                    FieldsBrowserControllerUI.this.internalCornerButtonClick = true;
                    jButton.getModel().setArmed(false);
                } else {
                    FieldsBrowserControllerUI.this.internalCornerButtonClick = false;
                    if (mouseEvent.getModifiers() == 4) {
                        FieldsBrowserControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16 && !FieldsBrowserControllerUI.this.internalCornerButtonClick) {
                    FieldsBrowserControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        return jButton;
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.showInstanceItem = new JMenuItem(this.fieldsBrowserController.getRootMode() == 0 ? Bundle.FieldsBrowserControllerUI_ShowInstanceItemText() : Bundle.FieldsBrowserControllerUI_ShowInInstancesItemText());
        this.showInstanceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FieldsBrowserControllerUI.this.performDefaultAction();
            }
        });
        this.showInstanceItem.setFont(jPopupMenu.getFont().deriveFont(1));
        this.showClassItem = new JMenuItem(this.fieldsBrowserController.getRootMode() == 0 ? Bundle.FieldsBrowserControllerUI_ShowInClassesItemText() : Bundle.FieldsBrowserControllerUI_ShowClassItemText());
        this.showClassItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeapWalkerNode heapWalkerNode;
                int n = FieldsBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                if (n != -1 && (heapWalkerNode = (HeapWalkerNode)((Object)FieldsBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent())) instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)((Object)heapWalkerNode)).hasInstance()) {
                    if (FieldsBrowserControllerUI.this.fieldsBrowserController.getRootMode() == 1) {
                        FieldsBrowserControllerUI.this.fieldsBrowserController.createNavigationHistoryPoint();
                    }
                    HeapWalkerInstanceNode heapWalkerInstanceNode = (HeapWalkerInstanceNode)((Object)heapWalkerNode);
                    FieldsBrowserControllerUI.this.fieldsBrowserController.navigateToClass(heapWalkerInstanceNode.getInstance().getJavaClass());
                }
            }
        });
        this.copyPathFromRootItem = new JMenuItem(Bundle.FieldsBrowserControllerUI_CopyPathFromRoot());
        this.copyPathFromRootItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FieldsBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                if (n != -1) {
                    TreePath treePath = FieldsBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(n);
                    BrowserUtils.copyPathFromRoot(treePath);
                }
            }
        });
        this.showLoopOriginItem = new JMenuItem(Bundle.FieldsBrowserControllerUI_ShowLoopItemText());
        this.showLoopOriginItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeapWalkerNode heapWalkerNode;
                int n = FieldsBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                if (n != -1 && (heapWalkerNode = (HeapWalkerNode)((Object)FieldsBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent())) instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)((Object)heapWalkerNode)).isLoop()) {
                    FieldsBrowserControllerUI.this.selectNode(((HeapWalkerInstanceNode)((Object)heapWalkerNode)).getLoopTo());
                }
            }
        });
        if (GoToSource.isAvailable()) {
            this.showSourceItem = new JMenuItem(Bundle.FieldsBrowserControllerUI_GoToSourceItemText());
            this.showSourceItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = FieldsBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                    if (n != -1) {
                        HeapWalkerNode heapWalkerNode = (HeapWalkerNode)((Object)FieldsBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent());
                        String string = BrowserUtils.getArrayBaseType(heapWalkerNode.getType());
                        Lookup.Provider provider = FieldsBrowserControllerUI.this.fieldsBrowserController.getInstancesControllerHandler().getHeapFragmentWalker().getHeapDumpProject();
                        GoToSource.openSource((Lookup.Provider)provider, (String)string, null, null);
                    }
                }
            });
        }
        jPopupMenu.add(this.showInstanceItem);
        jPopupMenu.add(this.showClassItem);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.copyPathFromRootItem);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.showLoopOriginItem);
        if (this.showSourceItem != null) {
            jPopupMenu.add(this.showSourceItem);
        }
        return jPopupMenu;
    }

    private void initColumnsData() {
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnToolTips = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnNames[0] = Bundle.FieldsBrowserControllerUI_FieldColumnName();
        this.columnToolTips[0] = Bundle.FieldsBrowserControllerUI_FieldColumnDescr();
        this.columnNames[1] = Bundle.FieldsBrowserControllerUI_TypeColumnName();
        this.columnToolTips[1] = Bundle.FieldsBrowserControllerUI_TypeColumnDescr();
        this.columnNames[2] = Bundle.FieldsBrowserControllerUI_FullTypeColumnName();
        this.columnToolTips[2] = Bundle.FieldsBrowserControllerUI_FullTypeColumnDescr();
        this.columnNames[3] = Bundle.FieldsBrowserControllerUI_ValueColumnName();
        this.columnToolTips[3] = Bundle.FieldsBrowserControllerUI_ValueColumnDescr();
        this.columnNames[4] = Bundle.FieldsBrowserControllerUI_SizeColumnName();
        this.columnToolTips[4] = Bundle.FieldsBrowserControllerUI_SizeColumnDescr();
        if (this.retainedSizeSupported) {
            this.columnNames[5] = Bundle.FieldsBrowserControllerUI_RetainedSizeColumnName();
            this.columnToolTips[5] = Bundle.FieldsBrowserControllerUI_RetainedSizeColumnDescr();
        }
        int n = this.getFontMetrics(this.getFont()).charWidth('W');
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(10);
        LabelTableCellRenderer labelTableCellRenderer2 = new LabelTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = n * 18;
        this.columnRenderers[1] = labelTableCellRenderer;
        this.columnWidths[1] = n * 28;
        this.columnRenderers[2] = labelTableCellRenderer;
        this.columnWidths[2] = n * 20;
        this.columnRenderers[3] = new FieldTableCellRenderer();
        this.columnWidths[3] = n * 7;
        this.columnRenderers[4] = labelTableCellRenderer2;
        if (this.retainedSizeSupported) {
            this.columnWidths[4] = n * 7;
            this.columnRenderers[5] = labelTableCellRenderer2;
        }
    }

    private void initComponents() {
        this.treeCellRenderer.setLeafIcon(null);
        this.treeCellRenderer.setClosedIcon(null);
        this.treeCellRenderer.setOpenIcon(null);
        this.fieldsListTableModel.setRealColumnVisibility(2, false);
        this.fieldsListTableModel.setRealColumnVisibility(4, false);
        if (this.retainedSizeSupported) {
            this.fieldsListTableModel.setRealColumnVisibility(5, this.fieldsBrowserController.getInstancesControllerHandler().getHeapFragmentWalker().getRetainedSizesStatus() == 3);
        }
        this.fieldsListTable = new JTreeTable((AbstractTreeTableModel)this.fieldsListTableModel){

            public void doLayout() {
                int n = 0;
                int n2 = -1;
                TableColumnModel tableColumnModel = this.getColumnModel();
                for (int i = 0; i < FieldsBrowserControllerUI.this.fieldsListTableModel.getColumnCount(); ++i) {
                    if (FieldsBrowserControllerUI.this.fieldsListTableModel.getRealColumn(i) == 0) {
                        n2 = i;
                        continue;
                    }
                    n += tableColumnModel.getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    tableColumnModel.getColumn(n2).setPreferredWidth(this.getWidth() - n);
                }
                super.doLayout();
            }
        };
        this.fieldsListTable.setSelectionMode(0);
        this.fieldsListTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.fieldsListTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.fieldsListTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.fieldsListTable.setShowHorizontalLines(false);
        this.fieldsListTable.setShowVerticalLines(true);
        this.fieldsListTable.setRowMargin(0);
        this.fieldsListTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.fieldsListTable.getTree().setLargeModel(true);
        this.fieldsListTable.getTree().setToggleClickCount(0);
        this.fieldsListTable.getColumnModel().getColumn(0).setMinWidth(150);
        this.fieldsListTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.fieldsListTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FieldsBrowserControllerUI.this.performDefaultAction();
            }
        });
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>(this.fieldsListTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.fieldsListTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet(this.fieldsListTable.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.fieldsListTable.setFocusTraversalKeys(1, hashSet);
        this.setColumnsData();
        this.tablePopup = this.createTablePopup();
        this.cornerPopup = new JPopupMenu();
        JTreeTablePanel jTreeTablePanel = new JTreeTablePanel(this.fieldsListTable);
        jTreeTablePanel.setCorner("UPPER_RIGHT_CORNER", (Component)this.createHeaderPopupCornerButton(this.cornerPopup));
        this.dataPanel = new JPanel(new BorderLayout());
        this.dataPanel.add((Component)jTreeTablePanel, "Center");
        this.noDataPanel = new JPanel(new BorderLayout());
        this.noDataPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        HTMLTextArea hTMLTextArea = new HTMLTextArea();
        hTMLTextArea.setBorder(BorderFactory.createEmptyBorder(10, 8, 8, 8));
        String string = Icons.getResource((String)"HeapWalkerIcons.Instances");
        String string2 = Icons.getResource((String)"HeapWalkerIcons.Classes");
        String string3 = this.fieldsBrowserController.getRootMode() == 0 ? Bundle.FieldsBrowserControllerUI_NoInstanceSelectedMsg("<img border='0' align='bottom' src='nbresloc:/" + string + "'>") : Bundle.FieldsBrowserControllerUI_NoClassSelectedMsg("<img border='0' align='bottom' src='nbresloc:/" + string2 + "'>");
        hTMLTextArea.setText(string3);
        this.noDataPanel.add((Component)hTMLTextArea, "Center");
        this.contents = new CardLayout();
        this.setLayout(this.contents);
        this.add(this.noDataPanel, NO_DATA);
        this.add(this.dataPanel, DATA);
        this.fieldsListTable.addMouseListener((MouseListener)new FieldsListTableMouseListener());
        this.fieldsListTable.addKeyListener((KeyListener)new FieldsListTableKeyListener());
    }

    private void initData() {
        this.fieldsListTableModel.setRoot((Object)this.fieldsBrowserController.getFilteredSortedFields(this.filterValue, this.sortingColumn, this.sortingOrder));
        this.refreshView();
    }

    private void navigateToInstance(Instance instance) {
        this.fieldsBrowserController.navigateToInstance(instance);
    }

    private void performDefaultAction() {
        HeapWalkerNode heapWalkerNode;
        int n = this.fieldsListTable.getSelectedRow();
        if (n != -1 && !(heapWalkerNode = (HeapWalkerNode)((Object)this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent())).isRoot() && heapWalkerNode instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)((Object)heapWalkerNode)).hasInstance()) {
            if (this.fieldsBrowserController.getRootMode() == 0) {
                this.fieldsBrowserController.createNavigationHistoryPoint();
            }
            HeapWalkerInstanceNode heapWalkerInstanceNode = (HeapWalkerInstanceNode)((Object)heapWalkerNode);
            this.fieldsBrowserController.navigateToInstance(heapWalkerInstanceNode.getInstance());
        }
    }

    private void saveColumnsData() {
        TableColumnModel tableColumnModel = this.fieldsListTable.getColumnModel();
        for (int i = 0; i < this.fieldsListTableModel.getColumnCount(); ++i) {
            int n = this.fieldsListTableModel.getRealColumn(i);
            if (n == 0) continue;
            this.columnWidths[n - 1] = tableColumnModel.getColumn(i).getPreferredWidth();
        }
    }

    private void showColumnSelectionPopup(JPopupMenu jPopupMenu, JButton jButton) {
        this.initColumnSelectorItems();
        jPopupMenu.show(jButton, jButton.getWidth() - jPopupMenu.getPreferredSize().width, jButton.getHeight());
    }

    private void showPopupMenu(int n, int n2, int n3) {
        Object object;
        if (n == -1) {
            return;
        }
        HeapWalkerNode heapWalkerNode = (HeapWalkerNode)((Object)this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent());
        if (heapWalkerNode instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)((Object)heapWalkerNode)).isLoop()) {
            this.showLoopOriginItem.setVisible(true);
        } else {
            this.showLoopOriginItem.setVisible(false);
        }
        if (heapWalkerNode != null && heapWalkerNode.isRoot()) {
            this.showInstanceItem.setEnabled(false);
            this.copyPathFromRootItem.setEnabled(false);
        } else {
            this.showInstanceItem.setEnabled(heapWalkerNode instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)((Object)heapWalkerNode)).hasInstance());
            this.copyPathFromRootItem.setEnabled(heapWalkerNode != null);
        }
        this.showClassItem.setEnabled(heapWalkerNode instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)((Object)heapWalkerNode)).hasInstance());
        if (this.showSourceItem != null) {
            HeapWalkerInstanceNode heapWalkerInstanceNode;
            object = null;
            if (heapWalkerNode instanceof ClassNode) {
                object = ((ClassNode)heapWalkerNode).getJavaClass().getName();
            } else if (heapWalkerNode instanceof HeapWalkerInstanceNode && (heapWalkerInstanceNode = (HeapWalkerInstanceNode)((Object)heapWalkerNode)).hasInstance()) {
                object = heapWalkerInstanceNode.getInstance().getJavaClass().getName();
            }
            this.showSourceItem.setEnabled(object != null && !VMUtils.isPrimitiveType((String)BrowserUtils.getArrayBaseType((String)object)));
        }
        if (n2 == -1 || n3 == -1) {
            object = this.fieldsListTable.getCellRect(n, 0, true);
            if (n2 == -1) {
                n2 = ((Rectangle)object).x + ((Rectangle)object).width / 2;
            }
            if (n3 == -1) {
                n3 = ((Rectangle)object).y + ((Rectangle)object).height / 2;
            }
        }
        this.tablePopup.show((Component)this.fieldsListTable, n2, n3);
    }

    private class FieldsListTreeTableModel
    extends AbstractTreeTableModel {
        private FieldsListTreeTableModel() {
            super((CCTNode)(FieldsBrowserControllerUI.this.fieldsBrowserController.getRootMode() == 0 ? FieldsBrowserController.EMPTY_INSTANCE_NODE : FieldsBrowserController.EMPTY_CLASS_NODE));
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            return Object.class;
        }

        public int getColumnCount() {
            return FieldsBrowserControllerUI.this.columnCount;
        }

        public String getColumnName(int n) {
            return FieldsBrowserControllerUI.this.columnNames[n];
        }

        public String getColumnToolTipText(int n) {
            return FieldsBrowserControllerUI.this.columnToolTips[n];
        }

        public boolean isLeaf(Object object) {
            return ((HeapWalkerNode)((Object)object)).isLeaf();
        }

        public Object getValueAt(Object object, int n) {
            HeapWalkerNode heapWalkerNode = (HeapWalkerNode)((Object)object);
            switch (n) {
                case 0: {
                    return heapWalkerNode;
                }
                case 1: {
                    return heapWalkerNode.getSimpleType();
                }
                case 2: {
                    return heapWalkerNode.getType();
                }
                case 3: {
                    return heapWalkerNode;
                }
                case 4: {
                    return heapWalkerNode.getSize();
                }
                case 5: {
                    return heapWalkerNode.getRetainedSize();
                }
            }
            return null;
        }
    }

    private class FieldsListTableMouseListener
    extends MouseAdapter {
        private FieldsListTableMouseListener() {
        }

        private void updateSelection(int n) {
            FieldsBrowserControllerUI.this.fieldsListTable.requestFocusInWindow();
            if (n != -1) {
                FieldsBrowserControllerUI.this.fieldsListTable.setRowSelectionInterval(n, n);
            } else {
                FieldsBrowserControllerUI.this.fieldsListTable.clearSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = FieldsBrowserControllerUI.this.fieldsListTable.rowAtPoint(mouseEvent.getPoint());
            this.updateSelection(n);
            if (mouseEvent.isPopupTrigger()) {
                FieldsBrowserControllerUI.this.showPopupMenu(n, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = FieldsBrowserControllerUI.this.fieldsListTable.rowAtPoint(mouseEvent.getPoint());
            this.updateSelection(n);
            if (mouseEvent.isPopupTrigger()) {
                FieldsBrowserControllerUI.this.showPopupMenu(n, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                HeapWalkerNode heapWalkerNode;
                int n = FieldsBrowserControllerUI.this.fieldsListTable.rowAtPoint(mouseEvent.getPoint());
                if (mouseEvent.getX() >= ((FieldsBrowserControllerUI)FieldsBrowserControllerUI.this).fieldsListTable.getTree().getRowBounds((int)n).x - FieldsBrowserControllerUI.this.fieldsListTable.getTreeCellOffsetX() && n != -1 && (heapWalkerNode = (HeapWalkerNode)((Object)FieldsBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent())) instanceof HeapWalkerInstanceNode) {
                    FieldsBrowserControllerUI.this.performDefaultAction();
                }
            }
        }
    }

    private class FieldsListTableKeyListener
    extends KeyAdapter {
        private FieldsListTableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = FieldsBrowserControllerUI.this.fieldsListTable.getSelectedRow()) != -1) {
                FieldsBrowserControllerUI.this.showPopupMenu(n, -1, -1);
            }
        }
    }
}

