/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import com.sun.java.swing.plaf.windows.WindowsSliderUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class JRangeSlider
extends JSlider {
    public JRangeSlider() {
    }

    public JRangeSlider(int min, int max) {
        super(min, max);
    }

    @Override
    public void updateUI() {
        Object uiv = UIManager.getUI(this);
        uiv = uiv instanceof WindowsSliderUI ? new JRangeSliderWindowsUI(this) : new JRangeSliderBasicUI(this);
        this.setUI((ComponentUI)uiv);
        this.updateLabelUIs();
    }

    @Override
    public int getValue() {
        return super.getValue();
    }

    @Override
    public void setValue(int value) {
        int oldValue = this.getValue();
        if (oldValue == value) {
            return;
        }
        int oldExtent = this.getExtent();
        int newValue = Math.min(Math.max(this.getMinimum(), value), oldValue + oldExtent);
        int newExtent = oldExtent + oldValue - newValue;
        this.getModel().setRangeProperties(newValue, newExtent, this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
    }

    public int getUpperValue() {
        return this.getValue() + this.getExtent();
    }

    public void setUpperValue(int value) {
        int lowerValue = this.getValue();
        int newExtent = Math.min(Math.max(0, value - lowerValue), this.getMaximum() - lowerValue);
        this.setExtent(newExtent);
    }

    public void setValues(int low, int high) {
        boolean changeHigh;
        boolean changeLow = low != this.getValue();
        boolean bl = changeHigh = high != this.getUpperValue();
        if (changeHigh || changeLow) {
            int extent = this.getExtent();
            extent = Math.min(Math.max(0, high - low), this.getMaximum() - low);
            int oldExtent = this.getExtent();
            int newValue = Math.min(Math.max(this.getMinimum(), low), this.getValue() + oldExtent);
            this.getModel().setRangeProperties(newValue, extent, this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
        }
    }

    private static class JRangeSliderBasicUI
    extends BasicSliderUI {
        private Color rangeColor = new Color(49, 220, 251, 178);
        private Rectangle upperThumbRect;
        private boolean upperThumbSelected;
        private transient boolean lowerDragging;
        private transient boolean upperDragging;

        public JRangeSliderBasicUI(JSlider slider) {
            super(slider);
        }

        @Override
        public void installUI(JComponent c) {
            this.upperThumbRect = new Rectangle();
            super.installUI(c);
        }

        @Override
        protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
            return new RangeTrackListener();
        }

        @Override
        protected ChangeListener createChangeListener(JSlider slider) {
            return new ChangeHandler();
        }

        @Override
        protected void calculateThumbSize() {
            super.calculateThumbSize();
            this.upperThumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
        }

        @Override
        protected void calculateThumbLocation() {
            int upperPosition;
            super.calculateThumbLocation();
            if (this.slider.getSnapToTicks()) {
                int upperValue;
                int snappedValue = upperValue = this.slider.getValue() + this.slider.getExtent();
                int majorTickSpacing = this.slider.getMajorTickSpacing();
                int minorTickSpacing = this.slider.getMinorTickSpacing();
                int tickSpacing = 0;
                if (minorTickSpacing > 0) {
                    tickSpacing = minorTickSpacing;
                } else if (majorTickSpacing > 0) {
                    tickSpacing = majorTickSpacing;
                }
                if (tickSpacing != 0) {
                    if ((upperValue - this.slider.getMinimum()) % tickSpacing != 0) {
                        float temp = (float)(upperValue - this.slider.getMinimum()) / (float)tickSpacing;
                        int whichTick = Math.round(temp);
                        snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                    }
                    if (snappedValue != upperValue) {
                        this.slider.setExtent(snappedValue - this.slider.getValue());
                    }
                }
            }
            if (this.slider.getOrientation() == 0) {
                upperPosition = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
                this.upperThumbRect.x = upperPosition - this.upperThumbRect.width / 2;
                this.upperThumbRect.y = this.trackRect.y;
            } else {
                upperPosition = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
                this.upperThumbRect.x = this.trackRect.x;
                this.upperThumbRect.y = upperPosition - this.upperThumbRect.height / 2;
            }
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            Rectangle r = this.thumbRect;
            this.thumbRect = this.upperThumbRect;
            this.paintThumb(g);
            this.thumbRect = r;
        }

        @Override
        public void paintTrack(Graphics g) {
            super.paintTrack(g);
            Rectangle trackBounds = this.trackRect;
            if (this.slider.getOrientation() == 0) {
                int lowerX = this.thumbRect.x + this.thumbRect.width / 2;
                int upperX = this.upperThumbRect.x + this.upperThumbRect.width / 2;
                int cy = trackBounds.height / 2 - 2;
                Color oldColor = g.getColor();
                g.translate(trackBounds.x, trackBounds.y + cy);
                g.setColor(this.rangeColor);
                for (int y = 0; y <= 3; ++y) {
                    g.drawLine(lowerX - trackBounds.x, y, upperX - trackBounds.x, y);
                }
                g.translate(-trackBounds.x, -(trackBounds.y + cy));
                g.setColor(oldColor);
            } else {
                int lowerY = this.thumbRect.y + this.thumbRect.height / 2;
                int upperY = this.upperThumbRect.y + this.upperThumbRect.height / 2;
                int cx = trackBounds.width / 2 - 2;
                Color oldColor = g.getColor();
                g.translate(trackBounds.x + cx, trackBounds.y);
                g.setColor(this.rangeColor);
                for (int x = 0; x <= 3; ++x) {
                    g.drawLine(x, lowerY - trackBounds.y, x, upperY - trackBounds.y);
                }
                g.translate(-(trackBounds.x + cx), -trackBounds.y);
                g.setColor(oldColor);
            }
        }

        private void paintLowerThumb(Graphics g) {
            Rectangle knobBounds = this.thumbRect;
            int w = knobBounds.width;
            int h = knobBounds.height;
            Graphics2D g2d = (Graphics2D)g.create();
            Shape thumbShape = this.createThumbShape(w - 1, h - 1);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.translate(knobBounds.x, knobBounds.y);
            g2d.setColor(Color.CYAN);
            g2d.fill(thumbShape);
            g2d.setColor(Color.BLUE);
            g2d.draw(thumbShape);
            g2d.dispose();
        }

        private void paintUpperThumb(Graphics g) {
            Rectangle knobBounds = this.upperThumbRect;
            int w = knobBounds.width;
            int h = knobBounds.height;
            Graphics2D g2d = (Graphics2D)g.create();
            Shape thumbShape = this.createThumbShape(w - 1, h - 1);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.translate(knobBounds.x, knobBounds.y);
            g2d.setColor(Color.PINK);
            g2d.fill(thumbShape);
            g2d.setColor(Color.RED);
            g2d.draw(thumbShape);
            g2d.dispose();
        }

        private Shape createThumbShape(int width, int height) {
            Ellipse2D.Double shape = new Ellipse2D.Double(0.0, 0.0, width, height);
            return shape;
        }

        private void setUpperThumbLocation(int x, int y) {
            Rectangle upperUnionRect = new Rectangle();
            upperUnionRect.setBounds(this.upperThumbRect);
            this.upperThumbRect.setLocation(x, y);
            SwingUtilities.computeUnion(this.upperThumbRect.x, this.upperThumbRect.y, this.upperThumbRect.width, this.upperThumbRect.height, upperUnionRect);
            this.slider.repaint(upperUnionRect.x, upperUnionRect.y, upperUnionRect.width, upperUnionRect.height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scrollByBlock(int direction) {
            JSlider jSlider = this.slider;
            synchronized (jSlider) {
                int blockIncrement = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
                if (blockIncrement <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                    blockIncrement = 1;
                }
                int delta = blockIncrement * (direction > 0 ? 1 : -1);
                if (this.upperThumbSelected) {
                    int oldValue = ((JRangeSlider)this.slider).getUpperValue();
                    ((JRangeSlider)this.slider).setUpperValue(oldValue + delta);
                } else {
                    int oldValue = this.slider.getValue();
                    this.slider.setValue(oldValue + delta);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scrollByUnit(int direction) {
            JSlider jSlider = this.slider;
            synchronized (jSlider) {
                int delta = 1 * (direction > 0 ? 1 : -1);
                if (this.upperThumbSelected) {
                    int oldValue = ((JRangeSlider)this.slider).getUpperValue();
                    ((JRangeSlider)this.slider).setUpperValue(oldValue + delta);
                } else {
                    int oldValue = this.slider.getValue();
                    this.slider.setValue(oldValue + delta);
                }
            }
        }

        public class RangeTrackListener
        extends BasicSliderUI.TrackListener {
            public RangeTrackListener() {
                super(JRangeSliderBasicUI.this);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!JRangeSliderBasicUI.this.slider.isEnabled()) {
                    return;
                }
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                if (JRangeSliderBasicUI.this.slider.isRequestFocusEnabled()) {
                    JRangeSliderBasicUI.this.slider.requestFocus();
                }
                boolean lowerPressed = false;
                boolean upperPressed = false;
                if (JRangeSliderBasicUI.this.upperThumbSelected) {
                    if (JRangeSliderBasicUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                        upperPressed = true;
                    } else if (JRangeSliderBasicUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                        lowerPressed = true;
                    }
                } else if (JRangeSliderBasicUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    lowerPressed = true;
                } else if (JRangeSliderBasicUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    upperPressed = true;
                }
                if (lowerPressed) {
                    switch (JRangeSliderBasicUI.this.slider.getOrientation()) {
                        case 1: {
                            this.offset = this.currentMouseY - ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).thumbRect.y;
                            break;
                        }
                        case 0: {
                            this.offset = this.currentMouseX - ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).thumbRect.x;
                        }
                    }
                    JRangeSliderBasicUI.this.upperThumbSelected = false;
                    JRangeSliderBasicUI.this.lowerDragging = true;
                    return;
                }
                JRangeSliderBasicUI.this.lowerDragging = false;
                if (upperPressed) {
                    switch (JRangeSliderBasicUI.this.slider.getOrientation()) {
                        case 1: {
                            this.offset = this.currentMouseY - ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).upperThumbRect.y;
                            break;
                        }
                        case 0: {
                            this.offset = this.currentMouseX - ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).upperThumbRect.x;
                        }
                    }
                    JRangeSliderBasicUI.this.upperThumbSelected = true;
                    JRangeSliderBasicUI.this.upperDragging = true;
                    return;
                }
                JRangeSliderBasicUI.this.upperDragging = false;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JRangeSliderBasicUI.this.lowerDragging = false;
                JRangeSliderBasicUI.this.upperDragging = false;
                JRangeSliderBasicUI.this.slider.setValueIsAdjusting(false);
                super.mouseReleased(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!JRangeSliderBasicUI.this.slider.isEnabled()) {
                    return;
                }
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                if (JRangeSliderBasicUI.this.lowerDragging) {
                    JRangeSliderBasicUI.this.slider.setValueIsAdjusting(true);
                    this.moveLowerThumb();
                } else if (JRangeSliderBasicUI.this.upperDragging) {
                    JRangeSliderBasicUI.this.slider.setValueIsAdjusting(true);
                    this.moveUpperThumb();
                }
            }

            @Override
            public boolean shouldScroll(int direction) {
                return false;
            }

            private void moveLowerThumb() {
                int thumbMiddle = 0;
                switch (JRangeSliderBasicUI.this.slider.getOrientation()) {
                    case 1: {
                        int halfThumbHeight = ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).thumbRect.height / 2;
                        int thumbTop = this.currentMouseY - this.offset;
                        int trackTop = ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).trackRect.y;
                        int trackBottom = ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).trackRect.y + (((JRangeSliderBasicUI)JRangeSliderBasicUI.this).trackRect.height - 1);
                        int vMax = JRangeSliderBasicUI.this.yPositionForValue(JRangeSliderBasicUI.this.slider.getValue() + JRangeSliderBasicUI.this.slider.getExtent());
                        if (JRangeSliderBasicUI.this.drawInverted()) {
                            trackBottom = vMax;
                        } else {
                            trackTop = vMax;
                        }
                        thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                        thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                        JRangeSliderBasicUI.this.setThumbLocation(((JRangeSliderBasicUI)JRangeSliderBasicUI.this).thumbRect.x, thumbTop);
                        thumbMiddle = thumbTop + halfThumbHeight;
                        JRangeSliderBasicUI.this.slider.setValue(JRangeSliderBasicUI.this.valueForYPosition(thumbMiddle));
                        break;
                    }
                    case 0: {
                        int halfThumbWidth = ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).thumbRect.width / 2;
                        int thumbLeft = this.currentMouseX - this.offset;
                        int trackLeft = ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).trackRect.x;
                        int trackRight = ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).trackRect.x + (((JRangeSliderBasicUI)JRangeSliderBasicUI.this).trackRect.width - 1);
                        int hMax = JRangeSliderBasicUI.this.xPositionForValue(JRangeSliderBasicUI.this.slider.getValue() + JRangeSliderBasicUI.this.slider.getExtent());
                        if (JRangeSliderBasicUI.this.drawInverted()) {
                            trackLeft = hMax;
                        } else {
                            trackRight = hMax;
                        }
                        thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                        thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                        JRangeSliderBasicUI.this.setThumbLocation(thumbLeft, ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).thumbRect.y);
                        thumbMiddle = thumbLeft + halfThumbWidth;
                        JRangeSliderBasicUI.this.slider.setValue(JRangeSliderBasicUI.this.valueForXPosition(thumbMiddle));
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }

            private void moveUpperThumb() {
                int thumbMiddle = 0;
                switch (JRangeSliderBasicUI.this.slider.getOrientation()) {
                    case 1: {
                        int halfThumbHeight = ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).thumbRect.height / 2;
                        int thumbTop = this.currentMouseY - this.offset;
                        int trackTop = ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).trackRect.y;
                        int trackBottom = ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).trackRect.y + (((JRangeSliderBasicUI)JRangeSliderBasicUI.this).trackRect.height - 1);
                        int vMin = JRangeSliderBasicUI.this.yPositionForValue(JRangeSliderBasicUI.this.slider.getValue());
                        if (JRangeSliderBasicUI.this.drawInverted()) {
                            trackTop = vMin;
                        } else {
                            trackBottom = vMin;
                        }
                        thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                        thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                        JRangeSliderBasicUI.this.setUpperThumbLocation(((JRangeSliderBasicUI)JRangeSliderBasicUI.this).thumbRect.x, thumbTop);
                        thumbMiddle = thumbTop + halfThumbHeight;
                        JRangeSliderBasicUI.this.slider.setExtent(JRangeSliderBasicUI.this.valueForYPosition(thumbMiddle) - JRangeSliderBasicUI.this.slider.getValue());
                        break;
                    }
                    case 0: {
                        int halfThumbWidth = ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).thumbRect.width / 2;
                        int thumbLeft = this.currentMouseX - this.offset;
                        int trackLeft = ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).trackRect.x;
                        int trackRight = ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).trackRect.x + (((JRangeSliderBasicUI)JRangeSliderBasicUI.this).trackRect.width - 1);
                        int hMin = JRangeSliderBasicUI.this.xPositionForValue(JRangeSliderBasicUI.this.slider.getValue());
                        if (JRangeSliderBasicUI.this.drawInverted()) {
                            trackRight = hMin;
                        } else {
                            trackLeft = hMin;
                        }
                        thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                        thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                        JRangeSliderBasicUI.this.setUpperThumbLocation(thumbLeft, ((JRangeSliderBasicUI)JRangeSliderBasicUI.this).thumbRect.y);
                        thumbMiddle = thumbLeft + halfThumbWidth;
                        JRangeSliderBasicUI.this.slider.setExtent(JRangeSliderBasicUI.this.valueForXPosition(thumbMiddle) - JRangeSliderBasicUI.this.slider.getValue());
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }

        public class ChangeHandler
        implements ChangeListener {
            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (!JRangeSliderBasicUI.this.lowerDragging && !JRangeSliderBasicUI.this.upperDragging) {
                    JRangeSliderBasicUI.this.calculateThumbLocation();
                    JRangeSliderBasicUI.this.slider.repaint();
                }
            }
        }
    }

    private static class JRangeSliderWindowsUI
    extends WindowsSliderUI {
        private final Color rangeColor = new Color(49, 220, 251, 178);
        private Rectangle upperThumbRect;
        private boolean upperThumbSelected;
        private transient boolean lowerDragging;
        private transient boolean upperDragging;

        public JRangeSliderWindowsUI(JSlider slider) {
            super(slider);
        }

        public void installUI(JComponent c) {
            this.upperThumbRect = new Rectangle();
            super.installUI(c);
        }

        protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
            return new RangeTrackListener();
        }

        protected ChangeListener createChangeListener(JSlider slider) {
            return new ChangeHandler();
        }

        protected void calculateThumbSize() {
            super.calculateThumbSize();
            this.upperThumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
        }

        protected void calculateThumbLocation() {
            int upperPosition;
            super.calculateThumbLocation();
            if (this.slider.getSnapToTicks()) {
                int upperValue;
                int snappedValue = upperValue = this.slider.getValue() + this.slider.getExtent();
                int majorTickSpacing = this.slider.getMajorTickSpacing();
                int minorTickSpacing = this.slider.getMinorTickSpacing();
                int tickSpacing = 0;
                if (minorTickSpacing > 0) {
                    tickSpacing = minorTickSpacing;
                } else if (majorTickSpacing > 0) {
                    tickSpacing = majorTickSpacing;
                }
                if (tickSpacing != 0) {
                    if ((upperValue - this.slider.getMinimum()) % tickSpacing != 0) {
                        float temp = (float)(upperValue - this.slider.getMinimum()) / (float)tickSpacing;
                        int whichTick = Math.round(temp);
                        snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                    }
                    if (snappedValue != upperValue) {
                        this.slider.setExtent(snappedValue - this.slider.getValue());
                    }
                }
            }
            if (this.slider.getOrientation() == 0) {
                upperPosition = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
                this.upperThumbRect.x = upperPosition - this.upperThumbRect.width / 2;
                this.upperThumbRect.y = this.trackRect.y;
            } else {
                upperPosition = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
                this.upperThumbRect.x = this.trackRect.x;
                this.upperThumbRect.y = upperPosition - this.upperThumbRect.height / 2;
            }
        }

        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            Rectangle r = this.thumbRect;
            this.thumbRect = this.upperThumbRect;
            this.paintThumb(g);
            this.thumbRect = r;
        }

        public void paintTrack(Graphics g) {
            super.paintTrack(g);
            Rectangle trackBounds = this.trackRect;
            if (this.slider.getOrientation() == 0) {
                int lowerX = this.thumbRect.x + this.thumbRect.width / 2;
                int upperX = this.upperThumbRect.x + this.upperThumbRect.width / 2;
                int cy = trackBounds.height / 2 - 2;
                Color oldColor = g.getColor();
                g.translate(trackBounds.x, trackBounds.y + cy);
                g.setColor(this.rangeColor);
                for (int y = 0; y <= 3; ++y) {
                    g.drawLine(lowerX - trackBounds.x, y, upperX - trackBounds.x, y);
                }
                g.translate(-trackBounds.x, -(trackBounds.y + cy));
                g.setColor(oldColor);
            } else {
                int lowerY = this.thumbRect.y + this.thumbRect.height / 2;
                int upperY = this.upperThumbRect.y + this.upperThumbRect.height / 2;
                int cx = trackBounds.width / 2 - 2;
                Color oldColor = g.getColor();
                g.translate(trackBounds.x + cx, trackBounds.y);
                g.setColor(this.rangeColor);
                for (int x = 0; x <= 3; ++x) {
                    g.drawLine(x, lowerY - trackBounds.y, x, upperY - trackBounds.y);
                }
                g.translate(-(trackBounds.x + cx), -trackBounds.y);
                g.setColor(oldColor);
            }
        }

        private void paintLowerThumb(Graphics g) {
            Rectangle knobBounds = this.thumbRect;
            int w = knobBounds.width;
            int h = knobBounds.height;
            Graphics2D g2d = (Graphics2D)g.create();
            Shape thumbShape = this.createThumbShape(w - 1, h - 1);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.translate(knobBounds.x, knobBounds.y);
            g2d.setColor(Color.CYAN);
            g2d.fill(thumbShape);
            g2d.setColor(Color.BLUE);
            g2d.draw(thumbShape);
            g2d.dispose();
        }

        private void paintUpperThumb(Graphics g) {
            Rectangle knobBounds = this.upperThumbRect;
            int w = knobBounds.width;
            int h = knobBounds.height;
            Graphics2D g2d = (Graphics2D)g.create();
            Shape thumbShape = this.createThumbShape(w - 1, h - 1);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.translate(knobBounds.x, knobBounds.y);
            g2d.setColor(Color.PINK);
            g2d.fill(thumbShape);
            g2d.setColor(Color.RED);
            g2d.draw(thumbShape);
            g2d.dispose();
        }

        private Shape createThumbShape(int width, int height) {
            Ellipse2D.Double shape = new Ellipse2D.Double(0.0, 0.0, width, height);
            return shape;
        }

        private void setUpperThumbLocation(int x, int y) {
            Rectangle upperUnionRect = new Rectangle();
            upperUnionRect.setBounds(this.upperThumbRect);
            this.upperThumbRect.setLocation(x, y);
            SwingUtilities.computeUnion(this.upperThumbRect.x, this.upperThumbRect.y, this.upperThumbRect.width, this.upperThumbRect.height, upperUnionRect);
            this.slider.repaint(upperUnionRect.x, upperUnionRect.y, upperUnionRect.width, upperUnionRect.height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scrollByBlock(int direction) {
            JSlider jSlider = this.slider;
            synchronized (jSlider) {
                int blockIncrement = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
                if (blockIncrement <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                    blockIncrement = 1;
                }
                int delta = blockIncrement * (direction > 0 ? 1 : -1);
                if (this.upperThumbSelected) {
                    int oldValue = ((JRangeSlider)this.slider).getUpperValue();
                    ((JRangeSlider)this.slider).setUpperValue(oldValue + delta);
                } else {
                    int oldValue = this.slider.getValue();
                    this.slider.setValue(oldValue + delta);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scrollByUnit(int direction) {
            JSlider jSlider = this.slider;
            synchronized (jSlider) {
                int delta = 1 * (direction > 0 ? 1 : -1);
                if (this.upperThumbSelected) {
                    int oldValue = ((JRangeSlider)this.slider).getUpperValue();
                    ((JRangeSlider)this.slider).setUpperValue(oldValue + delta);
                } else {
                    int oldValue = this.slider.getValue();
                    this.slider.setValue(oldValue + delta);
                }
            }
        }

        public class RangeTrackListener
        extends BasicSliderUI.TrackListener {
            public RangeTrackListener() {
                super((BasicSliderUI)((Object)JRangeSliderWindowsUI.this));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!JRangeSliderWindowsUI.this.slider.isEnabled()) {
                    return;
                }
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                if (JRangeSliderWindowsUI.this.slider.isRequestFocusEnabled()) {
                    JRangeSliderWindowsUI.this.slider.requestFocus();
                }
                boolean lowerPressed = false;
                boolean upperPressed = false;
                if (JRangeSliderWindowsUI.this.upperThumbSelected) {
                    if (JRangeSliderWindowsUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                        upperPressed = true;
                    } else if (JRangeSliderWindowsUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                        lowerPressed = true;
                    }
                } else if (JRangeSliderWindowsUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    lowerPressed = true;
                } else if (JRangeSliderWindowsUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    upperPressed = true;
                }
                if (lowerPressed) {
                    switch (JRangeSliderWindowsUI.this.slider.getOrientation()) {
                        case 1: {
                            this.offset = this.currentMouseY - ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).thumbRect.y;
                            break;
                        }
                        case 0: {
                            this.offset = this.currentMouseX - ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).thumbRect.x;
                        }
                    }
                    JRangeSliderWindowsUI.this.upperThumbSelected = false;
                    JRangeSliderWindowsUI.this.lowerDragging = true;
                    return;
                }
                JRangeSliderWindowsUI.this.lowerDragging = false;
                if (upperPressed) {
                    switch (JRangeSliderWindowsUI.this.slider.getOrientation()) {
                        case 1: {
                            this.offset = this.currentMouseY - ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).upperThumbRect.y;
                            break;
                        }
                        case 0: {
                            this.offset = this.currentMouseX - ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).upperThumbRect.x;
                        }
                    }
                    JRangeSliderWindowsUI.this.upperThumbSelected = true;
                    JRangeSliderWindowsUI.this.upperDragging = true;
                    return;
                }
                JRangeSliderWindowsUI.this.upperDragging = false;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JRangeSliderWindowsUI.this.lowerDragging = false;
                JRangeSliderWindowsUI.this.upperDragging = false;
                JRangeSliderWindowsUI.this.slider.setValueIsAdjusting(false);
                super.mouseReleased(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!JRangeSliderWindowsUI.this.slider.isEnabled()) {
                    return;
                }
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                if (JRangeSliderWindowsUI.this.lowerDragging) {
                    JRangeSliderWindowsUI.this.slider.setValueIsAdjusting(true);
                    this.moveLowerThumb();
                } else if (JRangeSliderWindowsUI.this.upperDragging) {
                    JRangeSliderWindowsUI.this.slider.setValueIsAdjusting(true);
                    this.moveUpperThumb();
                }
            }

            @Override
            public boolean shouldScroll(int direction) {
                return false;
            }

            private void moveLowerThumb() {
                int thumbMiddle = 0;
                switch (JRangeSliderWindowsUI.this.slider.getOrientation()) {
                    case 1: {
                        int halfThumbHeight = ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).thumbRect.height / 2;
                        int thumbTop = this.currentMouseY - this.offset;
                        int trackTop = ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).trackRect.y;
                        int trackBottom = ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).trackRect.y + (((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).trackRect.height - 1);
                        int vMax = JRangeSliderWindowsUI.this.yPositionForValue(JRangeSliderWindowsUI.this.slider.getValue() + JRangeSliderWindowsUI.this.slider.getExtent());
                        if (JRangeSliderWindowsUI.this.drawInverted()) {
                            trackBottom = vMax;
                        } else {
                            trackTop = vMax;
                        }
                        thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                        thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                        JRangeSliderWindowsUI.this.setThumbLocation(((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).thumbRect.x, thumbTop);
                        thumbMiddle = thumbTop + halfThumbHeight;
                        JRangeSliderWindowsUI.this.slider.setValue(JRangeSliderWindowsUI.this.valueForYPosition(thumbMiddle));
                        break;
                    }
                    case 0: {
                        int halfThumbWidth = ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).thumbRect.width / 2;
                        int thumbLeft = this.currentMouseX - this.offset;
                        int trackLeft = ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).trackRect.x;
                        int trackRight = ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).trackRect.x + (((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).trackRect.width - 1);
                        int hMax = JRangeSliderWindowsUI.this.xPositionForValue(JRangeSliderWindowsUI.this.slider.getValue() + JRangeSliderWindowsUI.this.slider.getExtent());
                        if (JRangeSliderWindowsUI.this.drawInverted()) {
                            trackLeft = hMax;
                        } else {
                            trackRight = hMax;
                        }
                        thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                        thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                        JRangeSliderWindowsUI.this.setThumbLocation(thumbLeft, ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).thumbRect.y);
                        thumbMiddle = thumbLeft + halfThumbWidth;
                        JRangeSliderWindowsUI.this.slider.setValue(JRangeSliderWindowsUI.this.valueForXPosition(thumbMiddle));
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }

            private void moveUpperThumb() {
                int thumbMiddle = 0;
                switch (JRangeSliderWindowsUI.this.slider.getOrientation()) {
                    case 1: {
                        int halfThumbHeight = ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).thumbRect.height / 2;
                        int thumbTop = this.currentMouseY - this.offset;
                        int trackTop = ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).trackRect.y;
                        int trackBottom = ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).trackRect.y + (((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).trackRect.height - 1);
                        int vMin = JRangeSliderWindowsUI.this.yPositionForValue(JRangeSliderWindowsUI.this.slider.getValue());
                        if (JRangeSliderWindowsUI.this.drawInverted()) {
                            trackTop = vMin;
                        } else {
                            trackBottom = vMin;
                        }
                        thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                        thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                        JRangeSliderWindowsUI.this.setUpperThumbLocation(((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).thumbRect.x, thumbTop);
                        thumbMiddle = thumbTop + halfThumbHeight;
                        JRangeSliderWindowsUI.this.slider.setExtent(JRangeSliderWindowsUI.this.valueForYPosition(thumbMiddle) - JRangeSliderWindowsUI.this.slider.getValue());
                        break;
                    }
                    case 0: {
                        int halfThumbWidth = ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).thumbRect.width / 2;
                        int thumbLeft = this.currentMouseX - this.offset;
                        int trackLeft = ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).trackRect.x;
                        int trackRight = ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).trackRect.x + (((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).trackRect.width - 1);
                        int hMin = JRangeSliderWindowsUI.this.xPositionForValue(JRangeSliderWindowsUI.this.slider.getValue());
                        if (JRangeSliderWindowsUI.this.drawInverted()) {
                            trackRight = hMin;
                        } else {
                            trackLeft = hMin;
                        }
                        thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                        thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                        JRangeSliderWindowsUI.this.setUpperThumbLocation(thumbLeft, ((JRangeSliderWindowsUI)JRangeSliderWindowsUI.this).thumbRect.y);
                        thumbMiddle = thumbLeft + halfThumbWidth;
                        JRangeSliderWindowsUI.this.slider.setExtent(JRangeSliderWindowsUI.this.valueForXPosition(thumbMiddle) - JRangeSliderWindowsUI.this.slider.getValue());
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }

        public class ChangeHandler
        implements ChangeListener {
            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (!JRangeSliderWindowsUI.this.lowerDragging && !JRangeSliderWindowsUI.this.upperDragging) {
                    JRangeSliderWindowsUI.this.calculateThumbLocation();
                    JRangeSliderWindowsUI.this.slider.repaint();
                }
            }
        }
    }
}

