/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Identity;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.NoEndpointException;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.Router;
import com.zeroc.Ice.RouterPrx;
import com.zeroc.Ice.UnknownException;
import com.zeroc.Ice._ObjectPrxI;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.Reference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class RouterInfo {
    private final RouterPrx _router;
    private EndpointI[] _clientEndpoints;
    private ObjectAdapter _adapter;
    private Set<Identity> _identities = new HashSet<Identity>();
    private List<Identity> _evictedIdentities = new ArrayList<Identity>();
    private boolean _hasRoutingTable;

    RouterInfo(RouterPrx router) {
        this._router = router;
        assert (this._router != null);
    }

    public synchronized void destroy() {
        this._clientEndpoints = new EndpointI[0];
        this._adapter = null;
        this._identities.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RouterInfo) {
            return this._router.equals(((RouterInfo)obj)._router);
        }
        return false;
    }

    public int hashCode() {
        return this._router.hashCode();
    }

    public RouterPrx getRouter() {
        return this._router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointI[] getClientEndpoints() {
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            if (this._clientEndpoints != null) {
                return this._clientEndpoints;
            }
        }
        Router.GetClientProxyResult r = this._router.getClientProxy();
        return this.setClientEndpoints(r.returnValue, r.hasRoutingTable.orElse(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getClientEndpoints(GetClientEndpointsCallback callback) {
        EndpointI[] clientEndpoints = null;
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            clientEndpoints = this._clientEndpoints;
        }
        if (clientEndpoints != null) {
            callback.setEndpoints(clientEndpoints);
            return;
        }
        this._router.getClientProxyAsync().whenComplete((r, ex) -> {
            if (ex != null) {
                if (ex instanceof LocalException) {
                    callback.setException((LocalException)ex);
                } else {
                    callback.setException(new UnknownException((Throwable)ex));
                }
            } else {
                callback.setEndpoints(this.setClientEndpoints(r.returnValue, r.hasRoutingTable.orElse(true)));
            }
        });
    }

    public EndpointI[] getServerEndpoints() {
        ObjectPrx serverProxy = this._router.getServerProxy();
        if (serverProxy == null) {
            throw new NoEndpointException();
        }
        serverProxy = serverProxy.ice_router(null);
        return ((_ObjectPrxI)serverProxy)._getReference().getEndpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addProxy(ObjectPrx proxy, AddProxyCallback callback) {
        assert (proxy != null);
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            if (!this._hasRoutingTable) {
                return true;
            }
            if (this._identities.contains(proxy.ice_getIdentity())) {
                return true;
            }
        }
        this._router.addProxiesAsync(new ObjectPrx[]{proxy}).whenComplete((evictedProxies, ex) -> {
            if (ex != null) {
                if (ex instanceof LocalException) {
                    callback.setException((LocalException)ex);
                } else {
                    callback.setException(new UnknownException((Throwable)ex));
                }
            } else {
                this.addAndEvictProxies(proxy, (ObjectPrx[])evictedProxies);
                callback.addedProxy();
            }
        });
        return false;
    }

    public synchronized void setAdapter(ObjectAdapter adapter) {
        this._adapter = adapter;
    }

    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }

    public synchronized void clearCache(Reference ref) {
        this._identities.remove(ref.getIdentity());
    }

    private synchronized EndpointI[] setClientEndpoints(ObjectPrx clientProxy, boolean hasRoutingTable) {
        if (this._clientEndpoints == null) {
            this._hasRoutingTable = hasRoutingTable;
            if (clientProxy == null) {
                this._clientEndpoints = ((_ObjectPrxI)((Object)this._router))._getReference().getEndpoints();
            } else {
                clientProxy = clientProxy.ice_router(null);
                if (this._router.ice_getConnection() != null) {
                    clientProxy = clientProxy.ice_timeout(this._router.ice_getConnection().timeout());
                }
                this._clientEndpoints = ((_ObjectPrxI)clientProxy)._getReference().getEndpoints();
            }
        }
        return this._clientEndpoints;
    }

    private synchronized void addAndEvictProxies(ObjectPrx proxy, ObjectPrx[] evictedProxies) {
        int index = this._evictedIdentities.indexOf(proxy.ice_getIdentity());
        if (index >= 0) {
            this._evictedIdentities.remove(index);
        } else {
            this._identities.add(proxy.ice_getIdentity());
        }
        for (ObjectPrx p : evictedProxies) {
            if (this._identities.remove(p.ice_getIdentity())) continue;
            this._evictedIdentities.add(p.ice_getIdentity());
        }
    }

    static interface AddProxyCallback {
        public void addedProxy();

        public void setException(LocalException var1);
    }

    static interface GetClientEndpointsCallback {
        public void setEndpoints(EndpointI[] var1);

        public void setException(LocalException var1);
    }
}

