/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.List;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSelectionManager;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;

public class XChartSelectionOverlay
extends ChartOverlay {
    private static final boolean FORCE_SPEED = Utils.forceSpeed();
    private ChartComponent chart;
    private int selectionMode;
    private Rectangle selectionBounds;
    private Rectangle oldSelectionBounds;
    private SelectionListener selectionListener;
    private ConfigurationListener configurationListener;
    private boolean renderingOptimized;
    private Paint linePaint;
    private Stroke lineStroke;
    private int lineWidth = -1;
    private Paint fillPaint;
    private Stroke oddPerfStroke;
    private Stroke evenPerfStroke;
    private boolean drawTop;
    private boolean drawBottom;
    private boolean drawLeft;
    private boolean drawRight;
    private final TimelineSupport support;

    public XChartSelectionOverlay(TimelineSupport timelineSupport) {
        this.support = timelineSupport;
        this.selectionListener = new SelectionListener();
        this.configurationListener = new ConfigurationListener();
        this.initDefaultValues();
    }

    public final void registerChart(ChartComponent chartComponent) {
        this.unregisterListener();
        this.chart = chartComponent;
        this.selectionMode = chartComponent.getSelectionModel().getSelectionMode();
        this.registerListener();
    }

    public final void unregisterChart(ChartComponent chartComponent) {
        this.unregisterListener();
        this.chart = null;
    }

    public final void setRenderingOptimized(boolean bl) {
        this.renderingOptimized = bl;
    }

    public final boolean isRenderingOptimized() {
        return this.renderingOptimized;
    }

    public final void setLineStroke(Stroke stroke) {
        this.lineStroke = stroke;
        this.lineWidth = -1;
    }

    public final Stroke getLineStroke() {
        return this.lineStroke;
    }

    public final void setLinePaint(Paint paint) {
        this.linePaint = paint;
    }

    public final Paint getLinePaint() {
        return this.linePaint;
    }

    public final void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    public final Paint getFillPaint() {
        return this.fillPaint;
    }

    public final void setLineMode(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.drawTop = bl;
        this.drawLeft = bl2;
        this.drawBottom = bl3;
        this.drawRight = bl4;
    }

    private void registerListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.getSelectionModel().addSelectionListener((ChartSelectionListener)this.selectionListener);
        this.chart.addConfigurationListener((ChartConfigurationListener)this.configurationListener);
    }

    private void unregisterListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.getSelectionModel().removeSelectionListener((ChartSelectionListener)this.selectionListener);
        this.chart.removeConfigurationListener((ChartConfigurationListener)this.configurationListener);
    }

    private void initDefaultValues() {
        this.setRenderingOptimized(true);
        Color color = Utils.getSystemSelection();
        this.setLineStroke(new BasicStroke(1.0f));
        this.setLinePaint(color);
        this.setFillPaint(new Color(color.getRed(), color.getGreen(), color.getBlue(), 80));
        this.oddPerfStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{6.0f, 6.0f}, 6.0f);
        this.evenPerfStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{6.0f, 6.0f}, 0.0f);
        this.setLineMode(true, true, true, true);
    }

    private int getLineWidth() {
        if (this.lineWidth == -1) {
            this.lineWidth = FORCE_SPEED ? 1 : (int)Math.ceil(Utils.getStrokeWidth((Stroke)this.lineStroke));
        }
        return this.lineWidth;
    }

    private Rectangle normalizeRect(Rectangle rectangle, int n) {
        if (rectangle.width < 0) {
            rectangle.x += rectangle.width;
            rectangle.width = 0 - rectangle.width;
        }
        rectangle.y = 0;
        rectangle.height = this.getHeight();
        rectangle.grow(n, n);
        return rectangle;
    }

    public void paint(Graphics graphics) {
        if (this.selectionBounds == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = this.normalizeRect(new Rectangle(this.selectionBounds), 0);
        if (this.selectionBounds.width != 0) {
            if (rectangle.width == 0 || rectangle.height == 0 || this.chart.fitsWidth() && this.chart.fitsHeight()) {
                return;
            }
            if (this.fillPaint != null && !FORCE_SPEED) {
                Rectangle rectangle2 = graphics.getClipBounds();
                if (rectangle2 == null) {
                    rectangle2 = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                }
                graphics2D.setPaint(this.fillPaint);
                graphics2D.fill(rectangle2.intersection(rectangle));
            }
            if (!FORCE_SPEED && this.linePaint != null && this.lineStroke != null) {
                graphics2D.setPaint(this.linePaint);
                graphics2D.setStroke(this.lineStroke);
                this.drawRect(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else if (FORCE_SPEED) {
                graphics2D.setPaint(Color.BLACK);
                graphics2D.setStroke(this.evenPerfStroke);
                this.drawRect(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics2D.setPaint(Color.WHITE);
                graphics2D.setStroke(this.oddPerfStroke);
                this.drawRect(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else if (!FORCE_SPEED) {
            graphics2D.setPaint(this.selectionMode == 4 ? this.fillPaint : this.linePaint);
            graphics2D.setStroke(this.lineStroke);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        } else if (FORCE_SPEED) {
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(this.evenPerfStroke);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.setStroke(this.oddPerfStroke);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        }
    }

    private void drawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.drawTop) {
            graphics.drawLine(n, n2, n + n3 - 1, n2);
        }
        if (this.drawLeft) {
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
        }
        if (this.drawRight) {
            graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2);
        }
        if (this.drawBottom) {
            graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n, n2 + n4 - 1);
        }
    }

    private void updateSelection() {
        this.oldSelectionBounds = this.selectionBounds;
        this.selectionBounds = this.getCurrentBounds();
        if (this.selectionMode == 4) {
            this.rectBoundsChanged(this.selectionBounds, this.oldSelectionBounds, this.getLineWidth());
        }
    }

    private Rectangle getCurrentBounds() {
        int n;
        TimelineSelectionManager timelineSelectionManager = (TimelineSelectionManager)this.chart.getSelectionModel();
        int n2 = timelineSelectionManager.getStartIndex();
        if (n2 > (n = timelineSelectionManager.getEndIndex())) {
            n = n2;
            n2 = timelineSelectionManager.getEndIndex();
        }
        if (n2 == -1) {
            return null;
        }
        if (n2 == n) {
            ChartContext chartContext = this.chart.getChartContext();
            long l = this.support.getTimestamp(n2);
            int n3 = Utils.checkedInt((double)chartContext.getViewX((double)l));
            return new Rectangle(n3, 0, 0, this.chart.getHeight());
        }
        ChartContext chartContext = this.chart.getChartContext();
        long l = this.support.getTimestamp(n2);
        long l2 = this.support.getTimestamp(n);
        int n4 = Utils.checkedInt((double)chartContext.getViewX((double)l));
        int n5 = Utils.checkedInt((double)chartContext.getViewX((double)l2));
        return new Rectangle(n4, 0, n5 - n4, this.chart.getHeight());
    }

    private void rectBoundsChanged(Rectangle rectangle, Rectangle rectangle2, int n) {
        if (Objects.equals(rectangle, rectangle2)) {
            return;
        }
        if (rectangle != null && rectangle2 != null) {
            if (this.renderingOptimized) {
                if (rectangle.x == rectangle2.x) {
                    int n2 = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
                    int n3 = Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
                    this.paintRect(n2, 0, n3 - n2, this.getHeight(), n);
                } else if (rectangle.x + rectangle.width == rectangle2.x + rectangle2.width) {
                    int n4 = Math.min(rectangle.x, rectangle2.x);
                    int n5 = Math.max(rectangle.x, rectangle2.x);
                    this.paintRect(n4, 0, n5 - n4, this.getHeight(), n);
                } else {
                    int n6 = Math.min(rectangle.x, rectangle2.x);
                    int n7 = Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
                    this.paintRect(n6, 0, n7 - n6, this.getHeight(), n);
                }
            } else {
                int n8 = Math.min(rectangle.x, rectangle2.x);
                int n9 = Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
                this.paintRect(n8, 0, n9 - n8, this.getHeight(), n);
            }
        } else if (rectangle2 != null) {
            this.paintRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, n);
        } else if (rectangle != null) {
            this.paintRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
        }
    }

    private void paintRect(int n, int n2, int n3, int n4, int n5) {
        if (n3 != 0 && n4 != 0) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            rectangle.grow(n5, n5);
            this.paintImmediately(rectangle);
        }
    }

    private class ConfigurationListener
    extends ChartConfigurationListener.Adapter {
        private ConfigurationListener() {
        }

        public void contentsUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4, int n, int n2) {
            if (l3 != l || d3 != d || d4 != d2) {
                XChartSelectionOverlay.this.updateSelection();
            }
        }
    }

    private class SelectionListener
    implements ChartSelectionListener {
        private boolean modeChanged = false;

        private SelectionListener() {
        }

        public void selectionModeChanged(int n, int n2) {
            XChartSelectionOverlay.this.selectionMode = n;
            this.modeChanged = true;
        }

        public void selectionBoundsChanged(Rectangle rectangle, Rectangle rectangle2) {
            if (this.modeChanged) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelectionListener.this.modeChanged = false;
                        XChartSelectionOverlay.this.oldSelectionBounds = XChartSelectionOverlay.this.selectionBounds;
                        XChartSelectionOverlay.this.selectionBounds = XChartSelectionOverlay.this.getCurrentBounds();
                        int n = XChartSelectionOverlay.this.getLineWidth();
                        Rectangle rectangle = XChartSelectionOverlay.this.normalizeRect(new Rectangle(XChartSelectionOverlay.this.oldSelectionBounds == null ? XChartSelectionOverlay.this.getBounds() : XChartSelectionOverlay.this.oldSelectionBounds), n);
                        XChartSelectionOverlay.this.paintImmediately(rectangle);
                        if (XChartSelectionOverlay.this.selectionBounds != null) {
                            rectangle = XChartSelectionOverlay.this.normalizeRect(new Rectangle(XChartSelectionOverlay.this.selectionBounds), n);
                            XChartSelectionOverlay.this.paintImmediately(rectangle);
                        }
                    }
                });
            } else {
                XChartSelectionOverlay.this.updateSelection();
            }
        }

        public void highlightedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
        }

        public void selectedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
        }
    }
}

