/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.util.Collection;
import java.util.List;
import org.jruby.ext.openssl.x509store.Name;

public abstract class X509Object
implements Comparable<X509Object> {
    public static int indexBySubject(List<? extends X509Object> list, int type, Name name2) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            X509Object obj = list.get(i2);
            if (type != obj.type() || !obj.isName(name2)) continue;
            return i2;
        }
        return -1;
    }

    public static X509Object retrieveBySubject(Collection<? extends X509Object> list, int type, Name name2) {
        for (X509Object x509Object : list) {
            if (type != x509Object.type() || !x509Object.isName(name2)) continue;
            return x509Object;
        }
        return null;
    }

    public static X509Object retrieveMatch(Collection<? extends X509Object> list, X509Object x) {
        for (X509Object x509Object : list) {
            if (!x509Object.matches(x)) continue;
            return x509Object;
        }
        return null;
    }

    public boolean isName(Name nm) {
        return false;
    }

    public boolean matches(X509Object o) {
        return false;
    }

    public abstract int type();

    @Override
    public int compareTo(X509Object other) {
        return this.type() - other.type();
    }
}

